/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.goplanit.osm.converter.OsmNodeData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneGroupHelper;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.osm.util.OsmRelationUtils;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.functionalinterface.TriConsumer;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Envelope;

public class OsmZoningMainProcessingHandler
extends OsmZoningHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningMainProcessingHandler.class.getCanonicalName());
    private boolean firstOsmWay = true;

    private void registerIfPreregistered(OsmNode osmNode) {
        OsmNodeData osmNodeData = this.getZoningReaderData().getOsmData().getOsmNodeData();
        if (osmNodeData.containsPreregisteredOsmNode(osmNode.getId()) && !osmNodeData.containsOsmNode(osmNode.getId())) {
            osmNodeData.registerEligibleOsmNode(osmNode);
        }
    }

    private void pruneUnavailablePreregisteredOsmNodes() {
        this.getZoningReaderData().getOsmData().getOsmNodeData().removeRegisteredOsmNodesIf(e -> e.getValue() == null);
    }

    private void registerPtv2StopAreaPlatformOnGroup(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember member, boolean suppressLogging) {
        OsmRelationMember internalMember;
        EntityType type = member.getType();
        long osmId = member.getId();
        if (member.getType().equals((Object)EntityType.Relation) && (internalMember = OsmRelationUtils.findFirstOsmRelationMemberWithRole(osmRelation, "outer")) != null) {
            if (this.getZoningReaderData().getOsmData().hasOuterRoleOsmWay(internalMember.getId())) {
                OsmWay osmWay = this.getZoningReaderData().getOsmData().getOuterRoleOsmWay(internalMember.getId());
                type = EntityType.Way;
                osmId = osmWay.getId();
            } else if (!suppressLogging) {
                LOGGER.severe("Identified platform as multi-polygon/relation, however its `outer role` member is not available or converted into a transfer zone");
            }
        }
        this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmId, type, transferZoneGroup, suppressLogging);
    }

    private boolean isPtv2StopAreaWronglyTaggedStopRole(OsmRelationMember member) {
        boolean wronglyTaggedRole = false;
        if (member.getType() == EntityType.Node) {
            OsmNode osmNode = this.getZoningReaderData().getOsmData().getOsmNodeData().getRegisteredOsmNode(member.getId());
            if (osmNode == null) {
                return false;
            }
            Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmNode);
            if (!OsmPtv2Tags.hasPublicTransportKeyTag(tags) || !((String)tags.get("public_transport")).equals("stop_position")) {
                wronglyTaggedRole = true;
            }
        } else {
            wronglyTaggedRole = true;
        }
        return wronglyTaggedRole;
    }

    private boolean salvageWronglyTaggedStopRolePtv2StopAreaRelation(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember member) {
        boolean suppressLogging = this.getSettings().isSuppressOsmRelationStopAreaLogging(osmRelation.getId());
        if (member.getType() == EntityType.Node && this.getZoningReaderData().getOsmData().getUnprocessedPtv1FerryTerminal(member.getId()) != null) {
            return false;
        }
        Pair<OsmPtVersionScheme, OsmEntity> unprocessedStationPair = this.getZoningReaderData().getOsmData().getUnprocessedStation(member.getType(), member.getId());
        if (unprocessedStationPair != null) {
            if (!suppressLogging) {
                LOGGER.info(String.format("SALVAGED: Stop_area %s member %d with stop role identified as station", transferZoneGroup.getExternalId(), member.getId()));
            }
            TransferZoneGroupHelper.updateTransferZoneGroupName(transferZoneGroup, (OsmEntity)unprocessedStationPair.second(), OsmModelUtil.getTagsAsMap((OsmEntity)((OsmEntity)unprocessedStationPair.second())));
            return true;
        }
        if (this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(member.getType(), member.getId()) != null) {
            if (!suppressLogging) {
                LOGGER.info(String.format("SALVAGED: stop_area %s member %d incorrectly given stop role...identified as platform", transferZoneGroup.getExternalId(), member.getId()));
            }
            this.registerPtv2StopAreaPlatformOnGroup(transferZoneGroup, osmRelation, member, suppressLogging);
            return true;
        }
        if (!suppressLogging) {
            LOGGER.warning(String.format("DISCARD: stop_area %s member %d incorrectly given stop role...remains unidentified", transferZoneGroup.getExternalId(), member.getId()));
        }
        return true;
    }

    private void processPtv2StopAreaMemberNodePtv1HighwayWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags, boolean suppressLogging) {
        String ptv1ValueTag = tags.get("highway");
        if (ptv1ValueTag == null) {
            if (suppressLogging) {
                LOGGER.severe(String.format("Highway tag not present for alleged Ptv1 highway %d on stop_area %d, this should not happen ignored", osmNode.getId(), osmRelation.getId()));
            }
            return;
        }
        if ("bus_stop".equals(ptv1ValueTag)) {
            this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmNode, tags, transferZoneGroup, suppressLogging);
        } else if ("platform".equals(ptv1ValueTag)) {
            this.getProfiler().incrementOsmPtv1TagCounter(ptv1ValueTag);
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes((OsmEntity)osmNode, tags, TransferZoneType.PLATFORM, "bus", this.getGeoUtils());
        } else {
            LOGGER.warning(String.format("Unsupported Ptv1 highway=%s tag encountered, ignored", ptv1ValueTag));
        }
    }

    private void processPtv2StopAreaMemberNodePtv1RailwayWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags, boolean suppressLogging) {
        String ptv1ValueTag = tags.get("railway");
        if (ptv1ValueTag == null) {
            if (suppressLogging) {
                LOGGER.severe(String.format("Railway tag not present for alleged Ptv1 railway %d on stop_area %d, this should not happen ignored", osmNode.getId(), osmRelation.getId()));
            }
            return;
        }
        if (this.getNetworkToZoningData().getNetworkSettings().isRailwayParserActive() && this.getNetworkToZoningData().getNetworkSettings().getRailwaySettings().hasActivatedOsmModeOtherThan("tram")) {
            if (OsmTagUtils.matchesAnyValueTag(ptv1ValueTag, "station", "halt")) {
                TransferZoneGroupHelper.updateTransferZoneGroupName(transferZoneGroup, (OsmEntity)osmNode, tags);
                this.getProfiler().incrementOsmPtv1TagCounter(ptv1ValueTag);
            } else if ("platform".equals(ptv1ValueTag)) {
                this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmNode, tags, transferZoneGroup, suppressLogging);
            }
        }
        if ("tram_stop".equals(ptv1ValueTag)) {
            this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmNode, tags, transferZoneGroup, suppressLogging);
        }
        if (!"subway_entrance".equals(ptv1ValueTag) || this.getNetworkToZoningData().getNetworkSettings().getHighwaySettings().isOsmModeActivated("foot")) {
            // empty if block
        }
    }

    private void processPtv2StopAreaMemberNodePtv1WithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags, boolean suppressLogging) {
        if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
            this.processPtv2StopAreaMemberNodePtv1RailwayWithoutRole(transferZoneGroup, osmRelation, osmNode, tags, suppressLogging);
        } else if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            this.processPtv2StopAreaMemberNodePtv1HighwayWithoutRole(transferZoneGroup, osmRelation, osmNode, tags, suppressLogging);
        } else if (!OsmPtv1Tags.isFerryTerminal(tags) || this.getNetworkToZoningData().getNetworkSettings().isWaterwayParserActive()) {
            // empty if block
        }
    }

    private void processPtv2StopAreaMemberNodePtv2WithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags, boolean suppressLogging) {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("station")) {
            TransferZoneGroupHelper.updateTransferZoneGroupName(transferZoneGroup, (OsmEntity)osmNode, tags);
            this.getProfiler().incrementOsmPtv2TagCounter("station");
        }
    }

    private void processPtv2StopAreaMemberNodeWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, boolean suppressLogging) {
        Map osmNodeTags = OsmModelUtil.getTagsAsMap((OsmEntity)osmNode);
        OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(osmNodeTags);
        switch (ptVersion) {
            case VERSION_2: {
                this.processPtv2StopAreaMemberNodePtv2WithoutRole(transferZoneGroup, osmRelation, osmNode, osmNodeTags, suppressLogging);
                break;
            }
            case VERSION_1: {
                this.processPtv2StopAreaMemberNodePtv1WithoutRole(transferZoneGroup, osmRelation, osmNode, osmNodeTags, suppressLogging);
            }
        }
    }

    private void processPtv2StopAreaMemberStation(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmEntity osmStation) {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmStation);
        TransferZoneGroupHelper.updateTransferZoneGroupName(transferZoneGroup, osmStation, tags);
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember transferZoneMember = osmRelation.getMember(index);
            TransferZone transferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(transferZoneMember.getType(), osmStation.getId());
            if (transferZone == null) continue;
            PlanitTransferZoneUtils.updateTransferZoneStationName(transferZone, tags);
        }
        OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
        this.getZoningReaderData().getOsmData().removeUnproccessedStation(ptVersion, osmStation);
        this.getProfiler().incrementOsmTagCounter(ptVersion, "station");
    }

    private void processPtv2StopAreaMemberWayWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember osmWayMember, boolean suppressLogging) {
        TransferZone transferZone;
        boolean unidentified = false;
        Pair<OsmPtVersionScheme, OsmEntity> osmWayPair = this.getZoningReaderData().getOsmData().getUnprocessedStation(EntityType.Way, osmWayMember.getId());
        if (osmWayPair != null) {
            this.processPtv2StopAreaMemberStation(transferZoneGroup, osmRelation, (OsmEntity)osmWayPair.second());
            unidentified = false;
        }
        if (unidentified && (transferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(EntityType.Way, osmWayMember.getId())) != null) {
            this.registerPtv2StopAreaPlatformOnGroup(transferZoneGroup, osmRelation, osmWayMember, suppressLogging);
            unidentified = false;
        }
        if (unidentified && !suppressLogging) {
            LOGGER.warning(String.format("DISCARD: unable to collect OSM way %d referenced in stop_area %d", osmWayMember.getId(), osmRelation.getId()));
        }
    }

    private void processPtv2StopAreaMemberWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember member) {
        boolean suppressLogging = this.getSettings().isSuppressOsmRelationStopAreaLogging(osmRelation.getId());
        if (member.getType() == EntityType.Node) {
            OsmNode osmNode = this.getZoningReaderData().getOsmData().getOsmNodeData().getRegisteredOsmNode(member.getId());
            if (osmNode == null) {
                if (!this.getSettings().hasBoundingPolygon() && !suppressLogging) {
                    LOGGER.warning(String.format("DISCARD: OSM node %d (without role tag) referenced in stop_area %d not available, expected to reside outside bounding box, if not verify correctness", member.getId(), osmRelation.getId()));
                }
                return;
            }
            this.processPtv2StopAreaMemberNodeWithoutRole(transferZoneGroup, osmRelation, osmNode, suppressLogging);
        } else if (member.getType() == EntityType.Way) {
            this.processPtv2StopAreaMemberWayWithoutRole(transferZoneGroup, osmRelation, member, suppressLogging);
        } else if (suppressLogging) {
            LOGGER.info(String.format("DISCARD: stop_area (%d) member without a role found (%d) that is not a node or way", osmRelation.getId(), member.getId()));
        }
    }

    private boolean extractPtv2Ptv1StopPosition(OsmNode osmNode, Map<String, String> tags, Collection<PredefinedModeType> planitModeTypes) {
        boolean DISCARD = true;
        if (this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
            this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode);
            return !DISCARD;
        }
        if (OsmPtv1Tags.isTramStop(tags)) {
            if (!this.isNearNetworkBoundingBox(osmNode)) {
                LOGGER.warning(String.format("DISCARD: Ptv2 stop_position with railway=tram_stop (%d) resides on discarded(out of bounds) OSM way, or it does not reside on an OSM way", osmNode.getId()));
            }
            return DISCARD;
        }
        if (OsmPtv1Tags.isFerryTerminal(tags)) {
            this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode);
            return !DISCARD;
        }
        double searchRadius = this.getSettings().getStopToWaitingAreaSearchRadiusMeters();
        if (OsmPtv1Tags.isHalt(tags) || OsmPtv1Tags.isRailwayStation(tags, true)) {
            searchRadius = this.getSettings().getStationToParallelTracksSearchRadiusMeters();
        }
        Envelope searchBoundingBox = OsmBoundingAreaUtils.createBoundingBox(osmNode, searchRadius, this.getGeoUtils());
        Collection<MacroscopicLink> spatiallyMatchedLinks = this.getZoningReaderData().getPlanitData().findLinksSpatially(searchBoundingBox);
        spatiallyMatchedLinks = this.getPtModeHelper().filterModeCompatibleLinks(this.getNetworkToZoningData().getNetworkSettings().getMappedOsmModes(planitModeTypes), spatiallyMatchedLinks, false);
        if (spatiallyMatchedLinks == null || spatiallyMatchedLinks.isEmpty()) {
            LOGGER.info(String.format("DISCARD: Ptv2 stop_position %d on deactivated/non-existent infrastructure (Ptv1 tag conversion infeasible, no nearby compatible infrastructure)", osmNode.getId()));
            return DISCARD;
        }
        if (OsmPtv1Tags.isBusStop(tags)) {
            LOGGER.info(String.format("SALVAGED: Ptv2 public_transport=stop_position also tagged as Ptv1 bus_stop (%d), yet does not reside on parsed road infrastructure, attempt to parse as pole instead", osmNode.getId()));
        } else if (OsmPtv1Tags.isHalt(tags)) {
            LOGGER.info(String.format("SALVAGED: Ptv2 public_transport=stop_position also tagged as Ptv1 halt (%d), yet it does not reside on parsed road infrastructure, attempt to parse as small station instead", osmNode.getId()));
        } else if (OsmPtv1Tags.isRailwayStation(tags, true)) {
            LOGGER.info(String.format("SALVAGED: Ptv2 public_transport=stop_position also tagged as Ptv1 station (%d), yet it does not reside on parsed road infrastructure, attempt to parse as Ptv1 station instead", osmNode.getId()));
        } else {
            LOGGER.warning(String.format("DISCARD: Expected additional Ptv1 tagging for Ptv2 public_transport=stop_location on node %d but found none, while not residing on parsed road infrastructure, possible tagging error and/or dangling node", osmNode.getId()));
            return DISCARD;
        }
        this.extractTransferInfrastructurePtv1(osmNode, tags, this.getGeoUtils());
        return !DISCARD;
    }

    private void processPtv2StopPosition(OsmNode osmNode, Map<String, String> tags) {
        boolean discarded = false;
        String ptv1DefaultMode = OsmModeUtils.identifyPtv1DefaultMode(osmNode.getId(), tags, true);
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity((OsmEntity)osmNode, tags, ptv1DefaultMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            discarded = true;
        } else if (ptv1DefaultMode != null) {
            discarded = this.extractPtv2Ptv1StopPosition(osmNode, tags, (Collection)modeResult.second());
        } else {
            this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode);
        }
        if (discarded) {
            this.getZoningReaderData().getOsmData().addIgnoreStopAreaStopPosition(EntityType.Node, osmNode.getId());
        }
    }

    private void processPtv2Station(OsmNode osmNode, Map<String, String> tags) {
        this.getZoningReaderData().getOsmData().addUnprocessedPtv2Station((OsmEntity)osmNode);
        this.getProfiler().incrementOsmPtv2TagCounter("station");
    }

    private void processPtv2Platform(OsmNode osmNode, Map<String, String> tags) {
        boolean notYetButToBeAttachedToNetwork;
        this.getProfiler().incrementOsmPtv2TagCounter("platform");
        boolean platformOnNetwork = this.hasNetworkLayersWithActiveOsmNode(osmNode.getId());
        boolean bl = notYetButToBeAttachedToNetwork = OsmPtv1Tags.isFerryTerminal(tags) && this.getSettings().isConnectDanglingFerryStopToNearbyFerryRoute();
        if (platformOnNetwork || notYetButToBeAttachedToNetwork) {
            this.processPtv2StopPosition(osmNode, tags);
            if (notYetButToBeAttachedToNetwork) {
                this.getZoningReaderData().getOsmData().getOsmNodeData().preRegisterEligibleOsmNode(osmNode.getId());
            }
        } else {
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes((OsmEntity)osmNode, tags, TransferZoneType.PLATFORM, OsmModeUtils.identifyPtv1DefaultMode(osmNode.getId(), tags, true), this.getGeoUtils());
        }
    }

    private void extractPtv1RailwayPlatform(OsmEntity osmEntity, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        this.getProfiler().incrementOsmPtv1TagCounter("platform");
        String defaultMode = OsmModeUtils.identifyPtv1DefaultMode(osmEntity.getId(), tags);
        if (!defaultMode.equals("train")) {
            LOGGER.warning(String.format("unexpected osm mode identified for Ptv1 railway platform %s,", defaultMode));
        }
        this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmEntity, tags, TransferZoneType.PLATFORM, defaultMode, geoUtils);
    }

    private void extractPtv1StandAloneHalt(OsmNode osmNode, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        this.getProfiler().incrementOsmPtv1TagCounter("halt");
        String expectedDefaultMode = "train";
        String defaultMode = OsmModeUtils.identifyPtv1DefaultMode(osmNode.getId(), tags);
        if (!defaultMode.equals(expectedDefaultMode)) {
            LOGGER.warning(String.format("Unexpected osm mode identified for Ptv1 halt %s", defaultMode));
        }
        this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes((OsmEntity)osmNode, tags, TransferZoneType.SMALL_STATION, defaultMode, geoUtils);
    }

    private void extractTransferInfrastructurePtv1HighwayPlatform(OsmEntity osmEntity, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult;
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(osmEntity.getId(), tags);
        if (!defaultOsmMode.equals("bus")) {
            LOGGER.warning(String.format("Unexpected OSM mode identified for Ptv1 highway platform %s,", defaultOsmMode));
        }
        if (OsmModeUtils.hasMappedPlanitMode(modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmEntity, tags, defaultOsmMode))) {
            this.getProfiler().incrementOsmPtv1TagCounter("platform");
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(osmEntity, tags, TransferZoneType.PLATFORM, (SortedSet)modeResult.first(), geoUtils);
        }
    }

    private void extractTransferInfrastructurePtv1HighwayBusStop(OsmEntity osmEntity, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        Pair<SortedSet<String>, SortedSet<PredefinedModeType>> modeResult;
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(osmEntity.getId(), tags);
        if (!defaultOsmMode.equals("bus")) {
            LOGGER.warning(String.format("Unexpected OSM mode identified for Ptv1 bus_stop %s,", defaultOsmMode));
        }
        if (OsmModeUtils.hasMappedPlanitMode(modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmEntity, tags, defaultOsmMode))) {
            this.getProfiler().incrementOsmPtv1TagCounter("bus_stop");
            if (Osm4JUtils.getEntityType(osmEntity).equals((Object)EntityType.Node) && this.hasNetworkLayersWithActiveOsmNode(osmEntity.getId())) {
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition((OsmNode)osmEntity);
            } else {
                this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(osmEntity, tags, TransferZoneType.POLE, (SortedSet)modeResult.first(), geoUtils);
            }
        }
    }

    private void extractTransferInfrastructurePtv1Highway(OsmWay osmWay, Map<String, String> tags, String ptv1ValueTag) {
        if ("platform".equals(ptv1ValueTag)) {
            this.extractTransferInfrastructurePtv1HighwayPlatform((OsmEntity)osmWay, tags, this.getGeoUtils());
        }
    }

    private void extractTransferInfrastructurePtv1Highway(OsmNode osmNode, Map<String, String> tags, String ptv1ValueTag, PlanitJtsCrsUtils geoUtils) {
        OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
        if (!networkSettings.isHighwayParserActive()) {
            return;
        }
        if ("bus_stop".equals(ptv1ValueTag)) {
            this.extractTransferInfrastructurePtv1HighwayBusStop((OsmEntity)osmNode, tags, geoUtils);
        } else if ("platform".equals(ptv1ValueTag)) {
            this.extractTransferInfrastructurePtv1HighwayPlatform((OsmEntity)osmNode, tags, geoUtils);
        } else {
            LOGGER.warning(String.format("unsupported Ptv1 higway=%s tag encountered, ignored", ptv1ValueTag));
        }
    }

    private void extractTransferInfrastructurePtv1Railway(OsmWay osmWay, Map<String, String> tags, String ptv1ValueTag) {
        OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
        if (!networkSettings.isRailwayParserActive()) {
            return;
        }
        if ("platform_edge".equals(ptv1ValueTag)) {
            this.getProfiler().incrementOsmPtv1TagCounter(ptv1ValueTag);
        }
        if ("platform".equals(ptv1ValueTag)) {
            this.extractPtv1RailwayPlatform((OsmEntity)osmWay, tags, this.getGeoUtils());
        }
        if ("station".equals(ptv1ValueTag) && networkSettings.getRailwaySettings().hasActivatedOsmModeOtherThan("tram")) {
            this.getZoningReaderData().getOsmData().addUnprocessedPtv1Station((OsmEntity)osmWay);
            this.getProfiler().incrementOsmPtv1TagCounter("station");
        }
    }

    private void extractTransferInfrastructurePtv1Railway(OsmNode osmNode, Map<String, String> tags, String ptv1ValueTag, PlanitJtsCrsUtils geoUtils) {
        OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
        if ("tram_stop".equals(ptv1ValueTag) && networkSettings.getRailwaySettings().isOsmModeActivated("tram")) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                LOGGER.info(String.format("DISCARD: Ptv1 railway=tram_stop (%d) does not reside on tram tracks", osmNode.getId()));
            } else {
                this.getProfiler().incrementOsmPtv1TagCounter("tram_stop");
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode);
            }
        }
        if ("platform".equals(ptv1ValueTag)) {
            this.extractPtv1RailwayPlatform((OsmEntity)osmNode, tags, geoUtils);
        }
        if ("halt".equals(ptv1ValueTag) && networkSettings.getRailwaySettings().hasActivatedOsmModeOtherThan("tram")) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                this.extractPtv1StandAloneHalt(osmNode, tags, geoUtils);
            } else {
                this.getProfiler().incrementOsmPtv1TagCounter("halt");
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode);
            }
        }
        if ("station".equals(ptv1ValueTag) && networkSettings.getRailwaySettings().hasActivatedOsmModeOtherThan("tram")) {
            this.getZoningReaderData().getOsmData().addUnprocessedPtv1Station((OsmEntity)osmNode);
        }
    }

    private void extractTransferInfrastructurePtv1Water(OsmNode osmNode, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
        if (OsmPtv1Tags.isFerryTerminal(tags) && networkSettings.getWaterwaySettings().isOsmModeActivated("ferry")) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId()) && !this.getSettings().isConnectDanglingFerryStopToNearbyFerryRoute()) {
                LOGGER.warning(String.format("DISCARD: amenity=ferry_terminal (%d) does not reside on OSM way supporting a ferry route", osmNode.getId()));
                return;
            }
            this.getProfiler().incrementOsmPtv1TagCounter("ferry_terminal");
            this.getZoningReaderData().getOsmData().addUnprocessedPtv1FerryTerminal((OsmEntity)osmNode);
        }
    }

    private void extractTransferInfrastructurePtv2(OsmWay osmWay, Map<String, String> tags) {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags)) {
            String ptv2ValueTag = tags.get("public_transport");
            if ("platform".equals(ptv2ValueTag)) {
                this.getProfiler().incrementOsmPtv2TagCounter(ptv2ValueTag);
                String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(osmWay.getId(), tags, true);
                this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes((OsmEntity)osmWay, tags, TransferZoneType.PLATFORM, defaultOsmMode, this.getGeoUtils());
            }
            if ("stop_position".equals(ptv2ValueTag)) {
                LOGGER.info(String.format("Encountered stop_position on osm way %d, this is not properly tagged, ignored", osmWay.getId()));
            }
            if ("station".equals(ptv2ValueTag)) {
                this.getZoningReaderData().getOsmData().addUnprocessedPtv2Station((OsmEntity)osmWay);
            }
            if ("stop_area".equals(ptv2ValueTag)) {
                LOGGER.info(String.format("Encountered stop_area on OSM way %d, this is not properly tagged, ignored", osmWay.getId()));
            }
        } else {
            throw new PlanItRunTimeException(String.format("Parsing transfer infrastructure (Ptv2) for osm way %s, but no public_transport key tag found", osmWay.getId()));
        }
    }

    private void extractTransferInfrastructurePtv1(OsmWay osmWay, Map<String, String> tags) {
        if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            if (this.getNetworkToZoningData().getNetworkSettings().isHighwayParserActive()) {
                String ptv1ValueTag = tags.get("highway");
                this.extractTransferInfrastructurePtv1Highway(osmWay, tags, ptv1ValueTag);
            }
        } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
            if (this.getNetworkToZoningData().getNetworkSettings().isRailwayParserActive()) {
                String ptv1ValueTag = tags.get("railway");
                this.extractTransferInfrastructurePtv1Railway(osmWay, tags, ptv1ValueTag);
            }
        } else if (OsmPtv1Tags.isFerryTerminal(tags)) {
            if (this.getNetworkToZoningData().getNetworkSettings().isWaterwayParserActive()) {
                LOGGER.warning(String.format("DISCARD: amenity=ferry_terminal only allowed on OSM nodes, not on OSM way (tags: %s)", tags));
            }
        } else {
            throw new PlanItRunTimeException(String.format("Parsing transfer infrastructure (Ptv1) for OSM way %s, but no compatible key tags found", osmWay.getId()));
        }
    }

    private void extractTransferInfrastructurePtv2(OsmNode osmNode, Map<String, String> tags) {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags)) {
            String ptv2ValueTag = tags.get("public_transport");
            if ("platform".equals(ptv2ValueTag)) {
                this.processPtv2Platform(osmNode, tags);
            } else if ("stop_position".equals(ptv2ValueTag)) {
                this.processPtv2StopPosition(osmNode, tags);
            } else if ("station".equals(ptv2ValueTag)) {
                this.processPtv2Station(osmNode, tags);
            } else if ("stop_area".equals(ptv2ValueTag)) {
                LOGGER.info(String.format("DISCARD: Encountered stop_area on OSM node %d, this is not properly tagged, ignored", osmNode.getId()));
            }
        } else {
            throw new PlanItRunTimeException(String.format("Parsing transfer infrastructure (Ptv2) for OSM node %s, but no compatible key tags found", osmNode.getId()));
        }
    }

    private void extractTransferInfrastructurePtv1(OsmNode osmNode, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) {
        if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            if (this.getNetworkToZoningData().getNetworkSettings().isHighwayParserActive()) {
                String ptv1ValueTag = tags.get(OsmHighwayTags.getHighwayKeyTag());
                this.extractTransferInfrastructurePtv1Highway(osmNode, tags, ptv1ValueTag, geoUtils);
            }
        } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
            if (this.getNetworkToZoningData().getNetworkSettings().isRailwayParserActive()) {
                String ptv1ValueTag = tags.get(OsmRailwayTags.getRailwayKeyTag());
                this.extractTransferInfrastructurePtv1Railway(osmNode, tags, ptv1ValueTag, geoUtils);
            }
        } else if (OsmPtv1Tags.isFerryTerminal(tags)) {
            if (this.getNetworkToZoningData().getNetworkSettings().isWaterwayParserActive()) {
                this.extractTransferInfrastructurePtv1Water(osmNode, tags, geoUtils);
            }
        } else {
            throw new PlanItRunTimeException("Parsing transfer infrastructure (Ptv1) for OSM node %s, but no compatible key tags found", new Object[]{osmNode.getId()});
        }
    }

    private void extractPtv2StopAreaRelation(OsmRelation osmRelation, Map<String, String> tags, boolean suppressLogging) {
        TransferZoneGroup transferZoneGroup = this.getTransferZoneGroupHelper().createPopulateAndRegisterTransferZoneGroup(osmRelation, tags);
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember member = osmRelation.getMember(index);
            if (this.skipOsmPtEntity(member)) continue;
            if (member.getRole().equals("platform")) {
                this.registerPtv2StopAreaPlatformOnGroup(transferZoneGroup, osmRelation, member, suppressLogging);
                continue;
            }
            if (member.getRole().equals("stop")) {
                boolean ignoreAfterSalvage;
                if (!this.isPtv2StopAreaWronglyTaggedStopRole(member) || !(ignoreAfterSalvage = this.salvageWronglyTaggedStopRolePtv2StopAreaRelation(transferZoneGroup, osmRelation, member))) continue;
                this.getZoningReaderData().getOsmData().addIgnoreStopAreaStopPosition(member.getType(), member.getId());
                continue;
            }
            if (!member.getRole().equals("")) continue;
            this.processPtv2StopAreaMemberWithoutRole(transferZoneGroup, osmRelation, member);
        }
    }

    private void extractPtv2OuterRolePlatformRelation(OsmRelation osmRelation, OsmRelationMember member, Map<String, String> tags) {
        TransferZone transferZone = this.getZoningReaderData().getPlanitData().getIncompleteTransferZoneByOsmId(EntityType.Way, member.getId());
        if (transferZone == null && this.getZoningReaderData().getOsmData().hasOuterRoleOsmWay(member.getId())) {
            OsmWay unprocessedWay = this.getZoningReaderData().getOsmData().getOuterRoleOsmWay(member.getId());
            if (unprocessedWay == null) {
                LOGGER.severe(String.format("OSM way %d referenced by Ptv2 multipolygon %d not available in parser, this should not happen, relation ignored", member.getId(), osmRelation.getId()));
                return;
            }
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes((OsmEntity)unprocessedWay, tags, TransferZoneType.PLATFORM, OsmModeUtils.identifyPtv1DefaultMode(unprocessedWay.getId(), tags), this.getGeoUtils());
        }
    }

    private void extractPtv2PlatformRelation(OsmRelation osmRelation, Map<String, String> tags) {
        OsmRelationMember member = OsmRelationUtils.findFirstOsmRelationMemberWithRole(osmRelation, "outer");
        if (member != null && !this.skipOsmPtEntity(member)) {
            this.extractPtv2OuterRolePlatformRelation(osmRelation, member, tags);
        }
    }

    protected void extractTransferInfrastructure(OsmNode osmNode, OsmPtVersionScheme ptVersion, Map<String, String> tags) {
        if (ptVersion == OsmPtVersionScheme.VERSION_2) {
            this.extractTransferInfrastructurePtv2(osmNode, tags);
        } else if (ptVersion == OsmPtVersionScheme.VERSION_1) {
            this.extractTransferInfrastructurePtv1(osmNode, tags, this.getGeoUtils());
        }
    }

    protected void extractTransferInfrastructure(OsmWay osmWay, OsmPtVersionScheme ptVersion, Map<String, String> tags) {
        if (ptVersion == OsmPtVersionScheme.VERSION_2) {
            this.extractTransferInfrastructurePtv2(osmWay, tags);
        } else if (ptVersion == OsmPtVersionScheme.VERSION_1) {
            this.extractTransferInfrastructurePtv1(osmWay, tags);
        }
    }

    protected void handlePtOsmWay(OsmWay osmWay, OsmPtVersionScheme ptVersion, Map<String, String> tags) {
        if (ptVersion != OsmPtVersionScheme.NONE) {
            if (!this.isCoveredByZoningBoundingPolygon(osmWay)) {
                return;
            }
            this.extractTransferInfrastructure(osmWay, ptVersion, tags);
        } else if (this.isCoveredByZoningBoundingPolygon(osmWay)) {
            this.getZoningReaderData().getOsmData().addOsmRelationOuterRoleOsmWay(osmWay);
        } else {
            this.getZoningReaderData().getOsmData().removeOsmRelationOuterRoleOsmWay(osmWay.getId());
        }
    }

    protected void handleOsmPtRelation(OsmRelation osmRelation, Map<String, String> tags) {
        String relationType = tags.get("type");
        if (relationType.equals("public_transport") && tags.get("public_transport").equals("stop_area")) {
            this.getProfiler().incrementOsmPtv2TagCounter("stop_area");
            this.extractPtv2StopAreaRelation(osmRelation, tags, this.getSettings().isSuppressOsmRelationStopAreaLogging(osmRelation.getId()));
        } else if (relationType.equals("multipolygon") && tags.get("public_transport").equals("platform")) {
            this.getProfiler().incrementOsmPtv2TagCounter("platform");
            this.extractPtv2PlatformRelation(osmRelation, tags);
        }
    }

    public OsmZoningMainProcessingHandler(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData zoningReaderData, OsmNetworkToZoningReaderData network2ZoningData, PlanitOsmNetwork referenceNetwork, Zoning zoningToPopulate, OsmZoningHandlerProfiler profiler) {
        super(transferSettings, zoningReaderData, network2ZoningData, referenceNetwork, zoningToPopulate, profiler);
    }

    @Override
    public void initialiseBeforeParsing() {
        this.reset();
        PlanItRunTimeException.throwIf((this.getReferenceNetwork().getTransportLayers() == null || ((MacroscopicNetworkLayers)this.getReferenceNetwork().getTransportLayers()).size() <= 0 ? 1 : 0) != 0, (String)"Network is expected to be populated at start of parsing OSM zoning", (Object[])new Object[0]);
    }

    public void handle(OsmNode osmNode) {
        if (osmNode.getId() == 7053939943L) {
            int n = 4;
        }
        this.wrapHandlePtOsmNode(osmNode, (TriConsumer<OsmNode, OsmPtVersionScheme, Map<String, String>>)((TriConsumer)this::extractTransferInfrastructure));
        this.registerIfPreregistered(osmNode);
    }

    public void handle(OsmWay osmWay) {
        if (this.firstOsmWay) {
            this.pruneUnavailablePreregisteredOsmNodes();
            this.firstOsmWay = false;
        }
        if (osmWay.getId() == 459973944L) {
            int n = 4;
        }
        super.wrapHandlePtOsmWay(osmWay, (TriConsumer<OsmWay, OsmPtVersionScheme, Map<String, String>>)((TriConsumer)this::handlePtOsmWay));
    }

    public void handle(OsmRelation osmRelation) {
        this.wrapHandlePtOsmRelation(osmRelation, this::handleOsmPtRelation);
    }

    public void complete() throws IOException {
        LOGGER.fine(" OSM transfer zone group parsing...DONE");
    }

    @Override
    public void reset() {
        this.firstOsmWay = true;
    }
}

