/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.zoning.Zoning;

public class OsmZoningHandlerProfiler {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningHandlerProfiler.class.getCanonicalName());
    private final Map<String, LongAdder> counterByPtv1Tag = new HashMap<String, LongAdder>();
    private final Map<String, LongAdder> counterByPtv2Tag = new HashMap<String, LongAdder>();
    private final LongAdder multiPolygonCount = new LongAdder();
    private final LongAdder platformRelationCount = new LongAdder();
    private long moduloLoggingTransferZones = 500L;
    private long moduloLoggingConnectoids = 500L;
    private long moduloLoggingTransferZoneGroups = 500L;

    public void incrementMultiPolygonPlatformCounter() {
        this.multiPolygonCount.increment();
    }

    public void incrementPlatformRelationCounter() {
        this.platformRelationCount.increment();
    }

    public void incrementOsmPtv1TagCounter(String tagType) {
        this.counterByPtv1Tag.putIfAbsent(tagType, new LongAdder());
        this.counterByPtv1Tag.get(tagType).increment();
    }

    public void incrementOsmPtv2TagCounter(String tagType) {
        this.counterByPtv2Tag.putIfAbsent(tagType, new LongAdder());
        this.counterByPtv2Tag.get(tagType).increment();
    }

    public void incrementOsmTagCounter(OsmPtVersionScheme version, String tagType) {
        if (version == OsmPtVersionScheme.VERSION_1) {
            this.incrementOsmPtv1TagCounter(tagType);
        } else if (version == OsmPtVersionScheme.VERSION_2) {
            this.incrementOsmPtv2TagCounter(tagType);
        } else {
            LOGGER.severe("Unknown pt version");
        }
    }

    public void logProcessingStats(OsmZoningReaderData planitOsmZoningReaderData, Zoning zoning) {
        long count;
        if (this.multiPolygonCount.longValue() > 0L) {
            LOGGER.info(String.format("[STATS] identified %d multipolygons as PT platforms", this.multiPolygonCount.longValue()));
        }
        if (this.platformRelationCount.longValue() > 0L) {
            LOGGER.info(String.format("[STATS] identified %d platforms tagged as relations ", this.platformRelationCount.longValue()));
        }
        for (Map.Entry<String, LongAdder> entry : this.counterByPtv1Tag.entrySet()) {
            count = entry.getValue().longValue();
            LOGGER.info(String.format("[STATS] [Ptv1] processed %s count:%d", entry.getKey(), count));
        }
        for (Map.Entry<String, LongAdder> entry : this.counterByPtv2Tag.entrySet()) {
            count = entry.getValue().longValue();
            LOGGER.info(String.format("[STATS] [Ptv2] processed %s count:%d", entry.getKey(), count));
        }
        LOGGER.info(String.format("[STATS] created PLANit %d transfer zone groups", zoning.getTransferZoneGroups().size()));
        LOGGER.info(String.format("[STATS] created PLANit %d transfer zones", zoning.getTransferZones().size()));
        LOGGER.info(String.format("[STATS] created PLANit %d transfer connectoids", zoning.getTransferConnectoids().size()));
    }

    public void logTransferZoneStatus(long numberOfTransferZones) {
        if (numberOfTransferZones >= this.moduloLoggingTransferZones) {
            LOGGER.info(String.format("Created %d transfer zones out of OSM nodes/ways", this.moduloLoggingTransferZones));
            this.moduloLoggingTransferZones *= 2L;
        }
    }

    public void logConnectoidStatus(int numberOfConnectoids) {
        if ((long)numberOfConnectoids >= this.moduloLoggingConnectoids) {
            LOGGER.info(String.format("Created %d connectoids out of OSM nodes/ways", this.moduloLoggingConnectoids));
            this.moduloLoggingConnectoids *= 2L;
        }
    }

    public void logTransferZoneGroupStatus(int numberOfTransferZoneGroups) {
        if ((long)numberOfTransferZoneGroups >= this.moduloLoggingTransferZoneGroups) {
            LOGGER.info(String.format("Created %d transfer zone groups out of OSM stop_areas", this.moduloLoggingTransferZoneGroups));
            this.moduloLoggingTransferZoneGroups *= 2L;
        }
    }

    public void reset() {
        this.counterByPtv1Tag.clear();
        this.counterByPtv2Tag.clear();
        this.multiPolygonCount.reset();
    }
}

