/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.access.DefaultOsmHandler;
import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.OsmConnectoidHelper;
import org.goplanit.osm.converter.zoning.handler.helper.OsmPublicTransportModeConversion;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneGroupHelper;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneHelper;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.osm.util.OsmPtVersionSchemeUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.functionalinterface.TriConsumer;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Geometry;

public abstract class OsmZoningHandlerBase
extends DefaultOsmHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningHandlerBase.class.getCanonicalName());
    private final Zoning zoning;
    private final PlanitOsmNetwork referenceNetwork;
    private final OsmPublicTransportReaderSettings transferSettings;
    private final OsmZoningReaderData zoningReaderData;
    private final OsmNetworkToZoningReaderData network2ZoningData;
    private final OsmZoningHandlerProfiler profiler;
    private final PlanitJtsCrsUtils geoUtils;
    private final TransferZoneHelper transferZoneHelper;
    private final TransferZoneGroupHelper transferZoneGroupHelper;
    private final OsmPublicTransportModeConversion publicTransportModeHelper;
    private final OsmConnectoidHelper connectoidHelper;

    private boolean skipOsmPtEntity(EntityType entityType, long osmId) {
        return entityType.equals((Object)EntityType.Node) && this.getSettings().isExcludedOsmNode(osmId) || entityType.equals((Object)EntityType.Way) && this.getSettings().isExcludedOsmWay(osmId);
    }

    protected PlanitOsmNetwork getReferenceNetwork() {
        return this.referenceNetwork;
    }

    protected boolean skipOsmPtEntity(OsmRelationMember member) {
        return this.skipOsmPtEntity(member.getType(), member.getId());
    }

    protected boolean skipOsmNode(OsmNode osmNode) {
        return this.skipOsmPtEntity(EntityType.Node, osmNode.getId());
    }

    protected boolean skipOsmWay(OsmWay osmWay) {
        return this.skipOsmPtEntity(EntityType.Way, osmWay.getId());
    }

    protected boolean isCoveredByZoningBoundingPolygon(OsmNode osmNode) {
        if (!this.getSettings().hasBoundingPolygon()) {
            return true;
        }
        return OsmBoundingAreaUtils.isCoveredByZoningBoundingPolygon(osmNode, this.getSettings().getBoundingPolygon());
    }

    protected boolean isNearNetworkBoundingBox(OsmNode osmNode) {
        if (!this.getSettings().hasBoundingPolygon()) {
            return false;
        }
        return OsmBoundingAreaUtils.isNearNetworkBoundingBox((Geometry)OsmNodeUtils.createPoint(osmNode), this.getSettings().getBoundingPolygon().getEnvelopeInternal(), this.getGeoUtils());
    }

    protected boolean isCoveredByZoningBoundingPolygon(OsmWay osmWay) {
        if (!this.getSettings().hasBoundingPolygon()) {
            return true;
        }
        return OsmBoundingAreaUtils.isCoveredByZoningBoundingPolygon(osmWay, this.zoningReaderData.getOsmData().getOsmNodeData().getRegisteredOsmNodes(), this.getSettings().getBoundingPolygon());
    }

    protected boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId) {
        return PlanitNetworkLayerUtils.hasNetworkLayersWithActiveOsmNode(osmNodeId, this.getReferenceNetwork(), this.getNetworkToZoningData());
    }

    protected OsmPtVersionScheme isActivatedPublicTransportInfrastructure(Map<String, String> tags) {
        if (this.transferSettings.isParserActive()) {
            return OsmPtVersionSchemeUtils.isPublicTransportBasedInfrastructure(tags);
        }
        return OsmPtVersionScheme.NONE;
    }

    protected void logWarningIfNotNearBoundingBox(String message, Geometry geometry) {
        OsmBoundingAreaUtils.logWarningIfNotNearBoundingBox(message, geometry, this.getNetworkToZoningData().getNetworkBoundingBox(), this.geoUtils);
    }

    protected void wrapHandlePtOsmWay(OsmWay osmWay, TriConsumer<OsmWay, OsmPtVersionScheme, Map<String, String>> osmWayConsumer) {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmWay);
        try {
            OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
            if (ptVersion != OsmPtVersionScheme.NONE || this.getZoningReaderData().getOsmData().shouldOsmRelationOuterRoleOsmWayBeKept(osmWay)) {
                if (this.skipOsmWay(osmWay)) {
                    LOGGER.fine(String.format("Skipped OSM way %d, marked for exclusion", osmWay.getId()));
                    return;
                }
                osmWayConsumer.accept((Object)osmWay, (Object)ptVersion, (Object)tags);
            }
        }
        catch (PlanItRunTimeException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM way (id:%d) for public transport (zoning transfer) infrastructure", osmWay.getId()));
        }
    }

    protected void wrapHandlePtOsmRelation(OsmRelation osmRelation, BiConsumer<OsmRelation, Map<String, String>> osmRelationConsumer) {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmRelation);
        try {
            if (this.getSettings().isParserActive() && tags.containsKey("type") && OsmPtv2Tags.hasPublicTransportKeyTag(tags)) {
                String ptv2Type = (String)tags.get("public_transport");
                String relationType = (String)tags.get("type");
                if (relationType.equals("public_transport")) {
                    if (!ptv2Type.equals("stop_area")) {
                        LOGGER.info(String.format("DISCARD: The public_transport relation type `%s` (%d) not (yet) supported", tags.get("public_transport"), osmRelation.getId()));
                        return;
                    }
                } else if (relationType.equals("multipolygon")) {
                    if (!ptv2Type.equals("platform")) {
                        return;
                    }
                } else {
                    return;
                }
                osmRelationConsumer.accept(osmRelation, tags);
            }
        }
        catch (PlanItRunTimeException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM relation (id:%d) for transfer infrastructure", osmRelation.getId()));
        }
    }

    protected void wrapHandlePtOsmNode(OsmNode osmNode, TriConsumer<OsmNode, OsmPtVersionScheme, Map<String, String>> osmNodeConsumer) {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmNode);
        try {
            OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
            if (ptVersion != OsmPtVersionScheme.NONE) {
                if (this.skipOsmNode(osmNode)) {
                    LOGGER.fine(String.format("Skipped osm node %d, marked for exclusion", osmNode.getId()));
                    return;
                }
                if (!this.isCoveredByZoningBoundingPolygon(osmNode)) {
                    return;
                }
                osmNodeConsumer.accept((Object)osmNode, (Object)ptVersion, (Object)tags);
            }
        }
        catch (PlanItRunTimeException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM node (id:%d) for public transport infrastructure", osmNode.getId()));
        }
    }

    protected final PlanitJtsCrsUtils getGeoUtils() {
        return this.geoUtils;
    }

    protected final OsmZoningHandlerProfiler getProfiler() {
        return this.profiler;
    }

    protected final OsmZoningReaderData getZoningReaderData() {
        return this.zoningReaderData;
    }

    protected final Zoning getZoning() {
        return this.zoning;
    }

    protected final OsmNetworkToZoningReaderData getNetworkToZoningData() {
        return this.network2ZoningData;
    }

    protected OsmPublicTransportReaderSettings getSettings() {
        return this.transferSettings;
    }

    protected TransferZoneHelper getTransferZoneHelper() {
        return this.transferZoneHelper;
    }

    protected TransferZoneGroupHelper getTransferZoneGroupHelper() {
        return this.transferZoneGroupHelper;
    }

    protected OsmPublicTransportModeConversion getPtModeHelper() {
        return this.publicTransportModeHelper;
    }

    protected OsmConnectoidHelper getConnectoidHelper() {
        return this.connectoidHelper;
    }

    public OsmZoningHandlerBase(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData zoningReaderData, OsmNetworkToZoningReaderData network2ZoningData, PlanitOsmNetwork referenceNetwork, Zoning zoningToPopulate, OsmZoningHandlerProfiler profiler) {
        this.profiler = profiler;
        this.referenceNetwork = referenceNetwork;
        this.zoning = zoningToPopulate;
        this.transferSettings = transferSettings;
        this.zoningReaderData = zoningReaderData;
        this.network2ZoningData = network2ZoningData;
        this.geoUtils = new PlanitJtsCrsUtils(this.getReferenceNetwork().getCoordinateReferenceSystem());
        this.transferZoneHelper = new TransferZoneHelper(this.getReferenceNetwork(), zoningToPopulate, zoningReaderData, network2ZoningData, transferSettings, profiler);
        this.transferZoneGroupHelper = new TransferZoneGroupHelper(this.getReferenceNetwork(), zoningToPopulate, zoningReaderData, network2ZoningData, transferSettings, profiler);
        this.publicTransportModeHelper = new OsmPublicTransportModeConversion(this.getNetworkToZoningData().getNetworkSettings(), this.getSettings(), (Iterable<Mode>)this.getReferenceNetwork().getModes());
        this.connectoidHelper = new OsmConnectoidHelper(referenceNetwork, zoningToPopulate, zoningReaderData, network2ZoningData, transferSettings, profiler);
    }

    public abstract void initialiseBeforeParsing();

    public abstract void reset();
}

