/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.GeoContainerUtils;
import org.goplanit.utils.geo.PlanitJtsIntersectZoneVisitor;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinks;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.quadtree.Quadtree;

public class OsmZoningReaderPlanitData {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningReaderData.class.getCanonicalName());
    private final Map<EntityType, Map<Long, TransferZone>> transferZonesByOsmEntityId = new TreeMap<EntityType, Map<Long, TransferZone>>();
    private final Map<TransferZone, Integer> transferZonesLayerIndex = new TreeMap<TransferZone, Integer>();
    private final Map<EntityType, Quadtree> transferZonesBySpatialIndex = new TreeMap<EntityType, Quadtree>();
    private final Map<NetworkLayer, Map<Point, List<DirectedConnectoid>>> directedConnectoidsByLocation = new HashMap<NetworkLayer, Map<Point, List<DirectedConnectoid>>>();
    private final Map<TransferZone, List<DirectedConnectoid>> connectoidsByTransferZone = new HashMap<TransferZone, List<DirectedConnectoid>>();
    private final Map<Long, TransferZoneGroup> transferZoneGroupsByOsmId = new HashMap<Long, TransferZoneGroup>();
    private Quadtree spatiallyIndexedPlanitLinks = null;

    protected void initialiseSpatiallyIndexedLinks(PlanitOsmNetwork osmNetwork) {
        ArrayList<MacroscopicLinks> linksCollection = new ArrayList<MacroscopicLinks>();
        for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)osmNetwork.getTransportLayers()) {
            linksCollection.add(layer.getLinks());
        }
        this.spatiallyIndexedPlanitLinks = GeoContainerUtils.toGeoIndexed(linksCollection);
    }

    public TransferZone getIncompleteTransferZoneByOsmId(EntityType entityType, long osmEntityId) {
        TransferZone transferZone = this.getTransferZoneByOsmId(entityType, osmEntityId);
        if (!this.hasConnectoids(transferZone)) {
            return transferZone;
        }
        return null;
    }

    public TransferZone getCompleteTransferZoneByOsmId(EntityType entityType, long osmEntityId) {
        TransferZone transferZone = this.getTransferZoneByOsmId(entityType, osmEntityId);
        if (this.hasConnectoids(transferZone)) {
            return transferZone;
        }
        return null;
    }

    public TransferZone getTransferZoneByOsmId(EntityType type, long osmId) {
        this.transferZonesByOsmEntityId.putIfAbsent(type, new TreeMap());
        return this.transferZonesByOsmEntityId.get(type).get(osmId);
    }

    public SortedSet<TransferZone> getTransferZonesByOsmId(EntityType entityType) {
        this.transferZonesByOsmEntityId.putIfAbsent(entityType, new TreeMap());
        switch (entityType) {
            case Node: 
            case Way: {
                return this.transferZonesByOsmEntityId.get(entityType).values().stream().collect(Collectors.toCollection(() -> new TreeSet()));
            }
        }
        throw new PlanItRunTimeException("Unsupported entity type encountered for transfer zone tracked in zoning reader, this shouldn't happen");
    }

    public Collection<TransferZone> getTransferZonesSpatially(Envelope boundingBox) {
        HashSet correctZones = new HashSet();
        PlanitJtsIntersectZoneVisitor spatialZoneFilterVisitor = new PlanitJtsIntersectZoneVisitor(PlanitJtsUtils.create2DPolygon((Envelope)boundingBox), correctZones);
        for (Map.Entry<EntityType, Quadtree> entry : this.transferZonesBySpatialIndex.entrySet()) {
            this.transferZonesBySpatialIndex.get(entry.getKey()).query(boundingBox, (ItemVisitor)spatialZoneFilterVisitor);
        }
        return spatialZoneFilterVisitor.getResult();
    }

    public TransferZone addTransferZoneByOsmId(EntityType entityType, long osmEntityId, TransferZone transferZone) {
        this.transferZonesByOsmEntityId.putIfAbsent(entityType, new HashMap());
        this.transferZonesBySpatialIndex.putIfAbsent(entityType, new Quadtree());
        Envelope transferZoneBoundingBox = transferZone.getEnvelope();
        if (transferZoneBoundingBox == null) {
            LOGGER.warning(String.format("unable to track transfer zone %d while parsing, unknown spatial features, ignored", osmEntityId));
            return null;
        }
        this.transferZonesBySpatialIndex.get(entityType).insert(transferZone.getEnvelope(), (Object)transferZone);
        return this.transferZonesByOsmEntityId.get(entityType).put(osmEntityId, transferZone);
    }

    public Map<Point, List<DirectedConnectoid>> getDirectedConnectoidsByLocation(MacroscopicNetworkLayer networkLayer) {
        this.directedConnectoidsByLocation.putIfAbsent((NetworkLayer)networkLayer, new HashMap());
        return Collections.unmodifiableMap(this.directedConnectoidsByLocation.get(networkLayer));
    }

    public List<DirectedConnectoid> getDirectedConnectoidsByLocation(Point nodeLocation, MacroscopicNetworkLayer networkLayer) {
        return this.getDirectedConnectoidsByLocation(networkLayer).get(nodeLocation);
    }

    public boolean addDirectedConnectoidByLocation(MacroscopicNetworkLayer networkLayer, Point connectoidLocation, DirectedConnectoid connectoid) {
        this.directedConnectoidsByLocation.putIfAbsent((NetworkLayer)networkLayer, new HashMap());
        Map<Point, List<DirectedConnectoid>> connectoidsForLayer = this.directedConnectoidsByLocation.get(networkLayer);
        connectoidsForLayer.putIfAbsent(connectoidLocation, new ArrayList(1));
        List<DirectedConnectoid> connectoids = connectoidsForLayer.get(connectoidLocation);
        if (!connectoids.contains(connectoid)) {
            return connectoids.add(connectoid);
        }
        return false;
    }

    public boolean hasAnyDirectedConnectoidsForLocation(Point location) {
        for (Map.Entry<NetworkLayer, Map<Point, List<DirectedConnectoid>>> entry : this.directedConnectoidsByLocation.entrySet()) {
            if (!this.hasDirectedConnectoidForLocation(entry.getKey(), location)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDirectedConnectoidForLocation(NetworkLayer networkLayer, Point point) {
        Map<Point, List<DirectedConnectoid>> connectoidsForLayer = this.directedConnectoidsByLocation.get(networkLayer);
        return connectoidsForLayer != null && connectoidsForLayer.get(point) != null && !connectoidsForLayer.get(point).isEmpty();
    }

    public void addConnectoidByTransferZone(TransferZone transferZone, DirectedConnectoid connectoid) {
        this.connectoidsByTransferZone.putIfAbsent(transferZone, new ArrayList(1));
        List<DirectedConnectoid> connectoids = this.connectoidsByTransferZone.get(transferZone);
        if (!connectoids.contains(connectoid)) {
            connectoids.add(connectoid);
        }
    }

    public boolean hasConnectoids(TransferZone transferZone) {
        return this.getConnectoidsByTransferZone(transferZone) != null && !this.getConnectoidsByTransferZone(transferZone).isEmpty();
    }

    public Collection<DirectedConnectoid> getConnectoidsByTransferZone(TransferZone transferZone) {
        if (transferZone == null) {
            return null;
        }
        this.connectoidsByTransferZone.putIfAbsent(transferZone, new ArrayList(1));
        return this.connectoidsByTransferZone.get(transferZone);
    }

    public TransferZoneGroup getTransferZoneGroupByOsmId(long osmId) {
        return this.transferZoneGroupsByOsmId.get(osmId);
    }

    public TransferZoneGroup addTransferZoneGroupByOsmId(long osmId, TransferZoneGroup transferZoneGroup) {
        return this.transferZoneGroupsByOsmId.put(osmId, transferZoneGroup);
    }

    public void reset() {
        this.transferZonesByOsmEntityId.clear();
        this.directedConnectoidsByLocation.clear();
        this.connectoidsByTransferZone.clear();
        this.spatiallyIndexedPlanitLinks = new Quadtree();
    }

    public void removeLinksFromSpatialLinkIndex(Collection<MacroscopicLink> links) {
        if (links != null) {
            links.forEach(link -> this.spatiallyIndexedPlanitLinks.remove(link.createEnvelope(), link));
        }
    }

    public void addLinksToSpatialLinkIndex(Collection<MacroscopicLink> links) {
        if (links != null) {
            links.forEach(link -> this.spatiallyIndexedPlanitLinks.insert(link.createEnvelope(), link));
        }
    }

    public Collection<MacroscopicLink> findLinksSpatially(Envelope searchBoundingBox) {
        return GeoContainerUtils.queryEdgeQuadtree((Quadtree)this.spatiallyIndexedPlanitLinks, (Envelope)searchBoundingBox);
    }

    public void registerTransferZoneVerticalLayerIndex(TransferZone transferZone, OsmEntity osmEntity, Map<String, String> tags) {
        if (this.transferZonesLayerIndex.containsKey(transferZone)) {
            LOGGER.warning(String.format("Layer index already registered for transfer zone %s, this shouldn't happen", transferZone.getIdsAsString()));
        }
        if (!OsmTagUtils.containsAnyKey(tags, "layer")) {
            return;
        }
        Integer layerValue = OsmTagUtils.getValueAsInt(tags, "layer");
        if (layerValue != null) {
            this.transferZonesLayerIndex.put(transferZone, layerValue);
        }
    }

    public Integer getTransferZoneVerticalLayerIndex(TransferZone transferZone) {
        Integer layerIndex = this.transferZonesLayerIndex.get(transferZone);
        return layerIndex;
    }
}

