/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.converter.OsmNodeData;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.utils.misc.Pair;

public class OsmZoningReaderOsmData {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningReaderOsmData.class.getCanonicalName());
    private final SortedMap<Long, OsmNode> unprocessedFerryTerminals = new TreeMap<Long, OsmNode>();
    private final SortedMap<EntityType, SortedMap<Long, OsmEntity>> unprocessedPtv1Stations = new TreeMap<EntityType, SortedMap<Long, OsmEntity>>();
    private final SortedMap<EntityType, SortedMap<Long, OsmEntity>> unprocessedPtv2Stations = new TreeMap<EntityType, SortedMap<Long, OsmEntity>>();
    private final SortedMap<Long, OsmNode> unprocessedStopPositions = new TreeMap<Long, OsmNode>();
    private final Map<Long, OsmWay> osmOuterRoleOsmWaysToKeep = new TreeMap<Long, OsmWay>();
    private final Map<EntityType, Set<Long>> ignoreStopAreaStopPositions = new TreeMap<EntityType, Set<Long>>();
    private final Map<EntityType, Set<Long>> waitingAreaWithoutMappedPlanitMode = new TreeMap<EntityType, Set<Long>>();
    private final OsmNodeData osmNodeData = new OsmNodeData();

    public OsmNodeData getOsmNodeData() {
        return this.osmNodeData;
    }

    public Pair<OsmPtVersionScheme, OsmEntity> getUnprocessedStation(EntityType entityType, long osmId) {
        OsmPtVersionScheme version = OsmPtVersionScheme.NONE;
        OsmEntity osmEntity = (OsmEntity)this.getUnprocessedPtv1Stations(entityType).get(osmId);
        if (osmEntity == null) {
            osmEntity = (OsmEntity)this.getUnprocessedPtv2Stations(entityType).get(osmId);
            version = OsmPtVersionScheme.VERSION_2;
        } else {
            version = OsmPtVersionScheme.VERSION_1;
        }
        return osmEntity == null ? null : Pair.of((Object)((Object)version), (Object)osmEntity);
    }

    public OsmNode getUnprocessedPtv1FerryTerminal(long osmId) {
        return (OsmNode)this.getUnprocessedPtv1FerryTerminals().get(osmId);
    }

    public boolean hasUnprocessedPtv1FerryTerminal(long osmId) {
        return this.getUnprocessedPtv1FerryTerminal(osmId) != null;
    }

    public SortedMap<Long, OsmEntity> getUnprocessedPtv1Stations(EntityType entityType) {
        this.unprocessedPtv1Stations.putIfAbsent(entityType, new TreeMap());
        return Collections.unmodifiableSortedMap((SortedMap)this.unprocessedPtv1Stations.get(entityType));
    }

    public SortedMap<Long, OsmNode> getUnprocessedPtv1FerryTerminals() {
        return Collections.unmodifiableSortedMap(this.unprocessedFerryTerminals);
    }

    public void addUnprocessedPtv1Station(OsmEntity osmEntity) {
        EntityType type = null;
        if (osmEntity instanceof OsmNode) {
            type = EntityType.Node;
        } else if (osmEntity instanceof OsmWay) {
            type = EntityType.Way;
        } else {
            LOGGER.severe(String.format("Unknown entity type when adding unprocessed Ptv1 station wit OSM id %d, ignored", new Object[0]));
        }
        this.unprocessedPtv1Stations.putIfAbsent(type, new TreeMap());
        ((SortedMap)this.unprocessedPtv1Stations.get(type)).put(osmEntity.getId(), osmEntity);
    }

    public void addUnprocessedPtv1FerryTerminal(OsmEntity osmEntity) {
        if (!(osmEntity instanceof OsmNode)) {
            LOGGER.severe(String.format("Ferry terminal should be node, found otherwise (%d), tagging error, ignored", osmEntity.getId()));
        }
        this.unprocessedFerryTerminals.put(osmEntity.getId(), (OsmNode)osmEntity);
    }

    public void addUnprocessedPtv2Station(OsmEntity osmEntity) {
        EntityType type = null;
        if (osmEntity instanceof OsmNode) {
            type = EntityType.Node;
        } else if (osmEntity instanceof OsmWay) {
            type = EntityType.Way;
        } else {
            LOGGER.severe(String.format("Unknown entity type when adding unprocessed Ptv2 station wit OSM id %d, ignored", new Object[0]));
        }
        this.unprocessedPtv2Stations.putIfAbsent(type, new TreeMap());
        ((SortedMap)this.unprocessedPtv2Stations.get(type)).put(osmEntity.getId(), osmEntity);
    }

    public SortedMap<Long, OsmEntity> getUnprocessedPtv2Stations(EntityType entityType) {
        this.unprocessedPtv2Stations.putIfAbsent(entityType, new TreeMap());
        return Collections.unmodifiableSortedMap((SortedMap)this.unprocessedPtv2Stations.get(entityType));
    }

    public SortedMap<Long, OsmNode> getUnprocessedStopPositions() {
        return Collections.unmodifiableSortedMap(this.unprocessedStopPositions);
    }

    public void removeUnprocessedStopPosition(long osmId) {
        this.unprocessedStopPositions.remove(osmId);
    }

    public void removeUnprocessedPtv1FerryTerminal(long osmId) {
        this.unprocessedFerryTerminals.remove(osmId);
    }

    public void addUnprocessedStopPosition(OsmNode osmNode) {
        this.unprocessedStopPositions.put(osmNode.getId(), osmNode);
    }

    public boolean hasUnprocessedStopPosition(long osmId) {
        return this.unprocessedStopPositions.containsKey(osmId);
    }

    public void removeUnproccessedStation(OsmPtVersionScheme ptVersion, OsmEntity osmEntity) {
        EntityType type = Osm4JUtils.getEntityType(osmEntity);
        switch (ptVersion) {
            case VERSION_1: {
                ((SortedMap)this.unprocessedPtv1Stations.get(type)).remove(osmEntity.getId());
                break;
            }
            case VERSION_2: {
                ((SortedMap)this.unprocessedPtv2Stations.get(type)).remove(osmEntity.getId());
                break;
            }
            default: {
                LOGGER.warning(String.format("could not remove station %d from earlier identified unprocessed stations, this should not happen", osmEntity.getId()));
            }
        }
    }

    public void removeAllUnproccessedStations(OsmPtVersionScheme ptVersion) {
        switch (ptVersion) {
            case VERSION_1: {
                this.unprocessedPtv1Stations.clear();
                break;
            }
            case VERSION_2: {
                this.unprocessedPtv2Stations.clear();
                break;
            }
            default: {
                LOGGER.warning(String.format("could not remove stations, invalid pt version provided", new Object[0]));
            }
        }
    }

    public void removeAllUnprocessedPtv1FerryTerminals() {
        this.unprocessedFerryTerminals.clear();
    }

    public void removeAllUnproccessedStations(OsmPtVersionScheme ptVersion, EntityType type) {
        switch (ptVersion) {
            case VERSION_1: {
                this.getUnprocessedPtv1Stations(type).clear();
                break;
            }
            case VERSION_2: {
                this.getUnprocessedPtv2Stations(type).clear();
                break;
            }
            default: {
                LOGGER.warning(String.format("could not remove stations, invalid pt version provided", new Object[0]));
            }
        }
    }

    public void markOsmRelationOuterRoleOsmWayToKeep(long osmWayId) {
        this.osmOuterRoleOsmWaysToKeep.put(osmWayId, null);
    }

    public void removeOsmRelationOuterRoleOsmWay(long osmWayId) {
        this.osmOuterRoleOsmWaysToKeep.remove(osmWayId);
    }

    public boolean shouldOsmRelationOuterRoleOsmWayBeKept(OsmWay osmWay) {
        return this.osmOuterRoleOsmWaysToKeep.containsKey(osmWay.getId());
    }

    public OsmWay addOsmRelationOuterRoleOsmWay(OsmWay osmWay) {
        return this.osmOuterRoleOsmWaysToKeep.put(osmWay.getId(), osmWay);
    }

    public boolean hasOuterRoleOsmWay(long osmWayId) {
        return this.osmOuterRoleOsmWaysToKeep.containsKey(osmWayId);
    }

    public OsmWay getOuterRoleOsmWay(long osmWayId) {
        return this.osmOuterRoleOsmWaysToKeep.get(osmWayId);
    }

    public boolean hasOsmRelationOuterRoleOsmWays() {
        return !this.osmOuterRoleOsmWaysToKeep.isEmpty();
    }

    public long getNumberOfOuterRoleOsmWays() {
        return this.osmOuterRoleOsmWaysToKeep.size();
    }

    public void addIgnoreStopAreaStopPosition(EntityType type, long osmId) {
        this.ignoreStopAreaStopPositions.putIfAbsent(type, new TreeSet());
        this.ignoreStopAreaStopPositions.get(type).add(osmId);
    }

    public boolean isIgnoreStopAreaStopPosition(EntityType type, long osmId) {
        if (type != null) {
            this.ignoreStopAreaStopPositions.putIfAbsent(type, new TreeSet());
            return this.ignoreStopAreaStopPositions.get(type).contains(osmId);
        }
        return false;
    }

    public void addWaitingAreaWithoutMappedPlanitMode(EntityType type, long osmId) {
        this.waitingAreaWithoutMappedPlanitMode.putIfAbsent(type, new TreeSet());
        this.waitingAreaWithoutMappedPlanitMode.get(type).add(osmId);
    }

    public boolean isWaitingAreaWithoutMappedPlanitMode(EntityType type, long osmId) {
        if (type != null) {
            this.waitingAreaWithoutMappedPlanitMode.putIfAbsent(type, new TreeSet());
            return this.waitingAreaWithoutMappedPlanitMode.get(type).contains(osmId);
        }
        return false;
    }

    public void reset() {
        this.removeAllUnproccessedStations(OsmPtVersionScheme.VERSION_1);
        this.removeAllUnproccessedStations(OsmPtVersionScheme.VERSION_2);
        this.removeAllUnprocessedPtv1FerryTerminals();
        this.unprocessedStopPositions.clear();
        this.osmOuterRoleOsmWaysToKeep.clear();
        this.waitingAreaWithoutMappedPlanitMode.clear();
        this.ignoreStopAreaStopPositions.clear();
        this.osmNodeData.reset();
    }
}

