/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import java.net.URL;
import java.nio.file.Paths;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReader;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.zoning.Zoning;

public class OsmZoningReaderFactory {
    public static OsmZoningReader create(String inputFile, String countryName, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        try {
            return OsmZoningReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, referenceNetwork, network2ZoningData);
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to convert input file %s to Url", (Throwable)e, new Object[]{inputFile});
        }
    }

    public static OsmZoningReader create(String inputFile, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        try {
            return OsmZoningReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, zoningToPopulate, referenceNetwork, network2ZoningData);
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to convert input file %s to Url", (Throwable)e, new Object[]{inputFile});
        }
    }

    public static OsmZoningReader create(OsmPublicTransportReaderSettings settings, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        return new OsmZoningReader(settings, zoningToPopulate, referenceNetwork, network2ZoningData);
    }

    public static OsmZoningReader create(URL inputSource, String countryName, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        PlanItRunTimeException.throwIfNull((Object)((Object)referenceNetwork), (String)"No reference network provided to OSM zoning reader factory method");
        return OsmZoningReaderFactory.create(inputSource, countryName, new Zoning(referenceNetwork.getIdGroupingToken(), referenceNetwork.getNetworkGroupingTokenId()), referenceNetwork, network2ZoningData);
    }

    public static OsmZoningReader create(URL inputSource, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        PlanItRunTimeException.throwIfNull((Object)zoningToPopulate, (String)"No zoning instance provided to OSM zoning reader factory method");
        PlanItRunTimeException.throwIfNull((Object)((Object)referenceNetwork), (String)"No reference network provided to OSM zoning reader factory method");
        return new OsmZoningReader(inputSource, countryName, zoningToPopulate, referenceNetwork, network2ZoningData);
    }
}

