/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.access.OsmHandler;
import de.topobyte.osm4j.core.access.OsmInputException;
import de.topobyte.osm4j.core.access.OsmReader;
import java.net.URL;
import java.util.logging.Logger;
import org.goplanit.converter.zoning.ZoningReader;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.OsmZoningMainProcessingHandler;
import org.goplanit.osm.converter.zoning.handler.OsmZoningPostProcessingHandler;
import org.goplanit.osm.converter.zoning.handler.OsmZoningPreProcessingHandler;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.PlanitZoningUtils;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Geometry;

public class OsmZoningReader
implements ZoningReader {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningReader.class.getCanonicalName());
    private OsmZoningPreProcessingHandler osmPreProcessingHandler = null;
    private OsmZoningMainProcessingHandler osmHandler = null;
    private OsmZoningPostProcessingHandler osmPostProcessingHandler = null;
    private final OsmPublicTransportReaderSettings transferSettings;
    private OsmZoningReaderData zoningReaderData;
    private final OsmNetworkToZoningReaderData network2ZoningData;
    private final PlanitOsmNetwork referenceNetwork;
    private Zoning zoning;

    private void logInfo() {
        this.getSettings().logSettings();
    }

    private void validateZoningBoundingPolygon() {
        boolean zoningBoundingPolygonWithinNetworkBoundingPolygon = true;
        if (this.getSettings().hasBoundingPolygon() && this.network2ZoningData.getNetworkSettings().hasBoundingPolygon() && !this.getSettings().getBoundingPolygon().equalsTopo((Geometry)this.network2ZoningData.getNetworkSettings().getBoundingPolygon())) {
            zoningBoundingPolygonWithinNetworkBoundingPolygon = this.getSettings().getBoundingPolygon().within((Geometry)this.network2ZoningData.getNetworkSettings().getBoundingPolygon());
        } else if (!this.getSettings().hasBoundingPolygon() && this.network2ZoningData.getNetworkSettings().hasBoundingPolygon()) {
            zoningBoundingPolygonWithinNetworkBoundingPolygon = false;
        }
        if (!zoningBoundingPolygonWithinNetworkBoundingPolygon) {
            LOGGER.warning("SALVAGE: Bounding polygon for network is more restrictive than public transport, truncating to network bounding polygon");
            this.getSettings().setBoundingPolygon(this.network2ZoningData.getNetworkSettings().getBoundingPolygon());
        }
    }

    private void initialiseBeforeParsing() {
        if (this.zoning == null) {
            this.zoning = new Zoning(this.getReferenceNetwork().getIdGroupingToken(), this.getReferenceNetwork().getNetworkGroupingTokenId());
        }
        this.zoningReaderData = new OsmZoningReaderData(this.getSettings().getCountryName());
        this.zoningReaderData.getPlanitData().initialiseSpatiallyIndexedLinks(this.getReferenceNetwork());
        this.validateZoningBoundingPolygon();
    }

    private void preProcessPlatformRelations(OsmZoningHandlerProfiler profiler) {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("Unable to create OSM reader for pre-processing platforms modelled as polygons, aborting");
        } else {
            this.osmPreProcessingHandler = new OsmZoningPreProcessingHandler(this.getReferenceNetwork(), this.zoning, this.transferSettings, this.zoningReaderData, this.network2ZoningData, OsmZoningPreProcessingHandler.Stage.IDENTIFY_PLATFORM_AS_RELATIONS, profiler);
            this.read(osmReader, this.osmPreProcessingHandler);
        }
    }

    private void preProcessPtNodePreregistration(OsmZoningHandlerProfiler profiler) {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("Unable to create OSM reader for pre-processing public transport node pre-registration, aborting");
        } else {
            this.osmPreProcessingHandler = new OsmZoningPreProcessingHandler(this.getReferenceNetwork(), this.zoning, this.transferSettings, this.zoningReaderData, this.network2ZoningData, OsmZoningPreProcessingHandler.Stage.IDENTIFY_PT_NODES, profiler);
            this.read(osmReader, this.osmPreProcessingHandler);
        }
    }

    private void doPreprocessing(OsmZoningHandlerProfiler profiler) {
        LOGGER.info("Pre-processing: Identifying relations representing public transport platforms");
        this.preProcessPlatformRelations(profiler);
        if (this.zoningReaderData.getOsmData().hasOsmRelationOuterRoleOsmWays()) {
            LOGGER.info(String.format("Identified %d OSM ways that are outer roles of osm relations and eligible to be converted to platforms", this.zoningReaderData.getOsmData().getNumberOfOuterRoleOsmWays()));
        }
        LOGGER.info("Pre-processing: Identifying OSM nodes for public transport");
        this.preProcessPtNodePreregistration(profiler);
    }

    private void doMainProcessing(OsmZoningHandlerProfiler profiler) {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("unable to create OSM reader for zones, aborting");
        } else {
            this.osmHandler = new OsmZoningMainProcessingHandler(this.transferSettings, this.zoningReaderData, this.network2ZoningData, this.getReferenceNetwork(), this.zoning, profiler);
            this.read(osmReader, this.osmHandler);
        }
    }

    private void doPostProcessing(OsmZoningHandlerProfiler profiler) {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.getSettings().getInputSource());
        if (osmReader == null) {
            LOGGER.severe("unable to create OSM reader for post-processing zones, aborting");
        } else {
            this.osmPostProcessingHandler = new OsmZoningPostProcessingHandler(this.transferSettings, this.zoningReaderData, this.network2ZoningData, this.getReferenceNetwork(), this.zoning, profiler);
            this.read(osmReader, this.osmPostProcessingHandler);
        }
    }

    protected PlanitOsmNetwork getReferenceNetwork() {
        return this.referenceNetwork;
    }

    protected void read(OsmReader osmReader, OsmZoningHandlerBase osmHandler) {
        try {
            osmHandler.initialiseBeforeParsing();
            osmReader.setHandler((OsmHandler)osmHandler);
            osmReader.read();
        }
        catch (OsmInputException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Error during parsing of OSMfile", (Throwable)e);
        }
    }

    protected OsmZoningReader(URL inputSource, String countryName, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        this(new OsmPublicTransportReaderSettings(inputSource, countryName), zoningToPopulate, referenceNetwork, network2ZoningData);
    }

    protected OsmZoningReader(OsmPublicTransportReaderSettings settings, Zoning zoningToPopulate, PlanitOsmNetwork referenceNetwork, OsmNetworkToZoningReaderData network2ZoningData) {
        this.transferSettings = settings;
        this.referenceNetwork = referenceNetwork;
        this.zoning = zoningToPopulate;
        this.network2ZoningData = network2ZoningData;
    }

    public Zoning read() {
        PlanItRunTimeException.throwIf((boolean)StringUtils.isNullOrBlank((String)this.getSettings().getCountryName()), (String)"Country not set for OSM zoning reader, unable to proceed", (Object[])new Object[0]);
        PlanItRunTimeException.throwIfNull((Object)this.getSettings().getInputSource(), (String)"Input source not set for OSM zoning reader, unable to proceed");
        PlanItRunTimeException.throwIfNull((Object)((Object)this.getReferenceNetwork()), (String)"Reference network not available when parsing OSM zoning, unable to proceed");
        PlanItRunTimeException.throwIfNull((Object)this.getReferenceNetwork().isEmpty(), (String)"Reference network empty, unable to attach OSM zoning results");
        PlanItRunTimeException.throwIfNull((Object)this.network2ZoningData, (String)"Reference network data (network to zoning data) not available when parsing OSM zoning, unable to proceed until provided via zoning settings");
        this.initialiseBeforeParsing();
        OsmZoningHandlerProfiler handlerProfiler = new OsmZoningHandlerProfiler();
        this.logInfo();
        this.doPreprocessing(handlerProfiler);
        this.doMainProcessing(handlerProfiler);
        this.doPostProcessing(handlerProfiler);
        handlerProfiler.logProcessingStats(this.zoningReaderData, this.zoning);
        if (this.getSettings().isRemoveDanglingZones()) {
            PlanitZoningUtils.removeDanglingZones(this.zoning);
        }
        if (this.getSettings().isRemoveDanglingTransferZoneGroups()) {
            PlanitZoningUtils.removeDanglingTransferZoneGroups(this.zoning);
        }
        LOGGER.info(" OSM zoning parsing...DONE");
        return this.zoning;
    }

    public void reset() {
        this.osmHandler.reset();
        this.osmPreProcessingHandler.reset();
        this.osmPostProcessingHandler.reset();
        this.zoningReaderData.reset();
    }

    public OsmPublicTransportReaderSettings getSettings() {
        return this.transferSettings;
    }
}

