/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.model.iface.EntityType;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.converter.OsmReaderSettings;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.Triple;
import org.goplanit.utils.misc.UrlUtils;

public class OsmPublicTransportReaderSettings
extends OsmReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(OsmPublicTransportReaderSettings.class.getCanonicalName());
    private boolean isParserActive = DEFAULT_TRANSFER_PARSER_ACTIVE;
    private boolean removeDanglingZones = DEFAULT_REMOVE_DANGLING_ZONES;
    private boolean removeDanglingTransferZoneGroups = DEFAULT_REMOVE_DANGLING_TRANSFER_ZONE_GROUPS;
    private double searchRadiusPlatformToStopInMeters = DEFAULT_SEARCH_RADIUS_PLATFORM2STOP_M;
    private double searchRadiusStationToPlatformInMeters = DEFAULT_SEARCH_RADIUS_STATION2PLATFORM_M;
    private double searchRadiusStationToParallelTracksInMeters = DEFAULT_SEARCH_RADIUS_STATION_PARALLEL_TRACKS_M;
    private final Map<EntityType, Set<Long>> excludedPtOsmEntities = new HashMap<EntityType, Set<Long>>();
    private final Map<Long, Pair<EntityType, Long>> overwritePtStopLocation2WaitingAreaMapping = new HashMap<Long, Pair<EntityType, Long>>();
    private final Map<EntityType, Map<Long, Long>> overwritePtWaitingArea2OsmWayMapping = new HashMap<EntityType, Map<Long, Long>>();
    protected final Map<EntityType, Map<Long, SortedSet<String>>> overwriteWaitingAreaModeAccess = new HashMap<EntityType, Map<Long, SortedSet<String>>>(Map.ofEntries(Map.entry(EntityType.Node, new HashMap()), Map.entry(EntityType.Way, new HashMap())));
    private final Set<Long> suppressStopAreaLogging = new HashSet<Long>();
    private boolean connectDanglingFerryStopToNearbyFerryRoute = DEFAULT_CONNECT_DANGLING_FERRY_STOP_TO_FERRY_ROUTE;
    private double searchRadiusFerryStopToFerryRouteMeters = DEFAULT_SEARCH_RADIUS_FERRY_STOP_TO_FERRY_ROUTE_M;
    public static boolean DEFAULT_TRANSFER_PARSER_ACTIVE = true;
    public static boolean DEFAULT_REMOVE_DANGLING_ZONES = true;
    public static boolean DEFAULT_REMOVE_DANGLING_TRANSFER_ZONE_GROUPS = true;
    public static double DEFAULT_SEARCH_RADIUS_PLATFORM2STOP_M = 25.0;
    public static double DEFAULT_SEARCH_RADIUS_STATION2PLATFORM_M;
    public static double DEFAULT_SEARCH_RADIUS_STATION_PARALLEL_TRACKS_M;
    public static double DEFAULT_CLOSEST_EDGE_SEARCH_BUFFER_DISTANCE_M;
    public static boolean DEFAULT_CONNECT_DANGLING_FERRY_STOP_TO_FERRY_ROUTE;
    public static double DEFAULT_SEARCH_RADIUS_FERRY_STOP_TO_FERRY_ROUTE_M;

    public OsmPublicTransportReaderSettings() {
    }

    public OsmPublicTransportReaderSettings(String countryName) {
        super(countryName);
    }

    public OsmPublicTransportReaderSettings(String inputSource, String countryName) {
        this(UrlUtils.createFromLocalPath((Path)Path.of(inputSource, new String[0])), countryName);
    }

    public OsmPublicTransportReaderSettings(URL inputSource, String countryName) {
        super(inputSource, countryName);
    }

    public void reset() {
    }

    public void logSettings() {
        LOGGER.info(String.format("Public transport infrastructure parser activated: %s", this.isParserActive()));
        if (this.isParserActive()) {
            LOGGER.info(String.format("OSM (transfer) zoning input file: %s", this.getInputSource()));
            if (this.hasBoundingPolygon()) {
                LOGGER.info(String.format("Bounding polygon set to: %s", this.getBoundingPolygon().toString()));
            }
            LOGGER.info(String.format("Stop location to waiting area search radius: %.2fm", this.getStopToWaitingAreaSearchRadiusMeters()));
            LOGGER.info(String.format("Station location to waiting area search radius: %.2fm", this.getStationToWaitingAreaSearchRadiusMeters()));
            LOGGER.info(String.format("Station location to parallel tracks search radius: %.2fm", this.getStationToParallelTracksSearchRadiusMeters()));
            LOGGER.info(String.format("Remove dangling transfer zones: %s", this.isRemoveDanglingZones()));
            LOGGER.info(String.format("Remove dangling transfer zone groups: %s", this.isRemoveDanglingTransferZoneGroups()));
            LOGGER.info(String.format("Connect dangling ferry stops to nearby ferry routes (if present): %s", this.connectDanglingFerryStopToNearbyFerryRoute));
            LOGGER.info(String.format("Ferry stop to ferry route search radius: %.2fm", this.getFerryStopToFerryRouteSearchRadiusMeters()));
        }
    }

    public void activateParser(boolean activate) {
        this.isParserActive = activate;
    }

    public boolean isParserActive() {
        return this.isParserActive;
    }

    public void setStopToWaitingAreaSearchRadiusMeters(Number searchRadiusInMeters) {
        this.searchRadiusPlatformToStopInMeters = searchRadiusInMeters.doubleValue();
    }

    public double getStopToWaitingAreaSearchRadiusMeters() {
        return this.searchRadiusPlatformToStopInMeters;
    }

    public void setStationToWaitingAreaSearchRadiusMeters(Number searchRadiusInMeters) {
        this.searchRadiusStationToPlatformInMeters = searchRadiusInMeters.doubleValue();
    }

    public double getStationToWaitingAreaSearchRadiusMeters() {
        return this.searchRadiusStationToPlatformInMeters;
    }

    public void setStationToParallelTracksSearchRadiusMeters(Number searchRadiusInMeters) {
        this.searchRadiusStationToParallelTracksInMeters = searchRadiusInMeters.doubleValue();
    }

    public double getStationToParallelTracksSearchRadiusMeters() {
        return this.searchRadiusStationToParallelTracksInMeters;
    }

    public void excludeOsmNodesById(Number ... osmIds) {
        this.excludeOsmNodesById(Arrays.asList(osmIds));
    }

    public void excludeOsmNodesById(Collection<Number> osmIds) {
        osmIds.forEach(osmId -> this.excludeOsmNodeById((Number)osmId));
    }

    public void excludeOsmNodeById(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Node, new HashSet());
        this.excludedPtOsmEntities.get(EntityType.Node).add(osmId.longValue());
    }

    public void excludeOsmWaysById(Number ... osmIds) {
        this.excludeOsmWaysById(Arrays.asList(osmIds));
    }

    public void excludeOsmWaysById(Collection<Number> osmIds) {
        osmIds.forEach(osmId -> this.excludeOsmWayById((Number)osmId));
    }

    public void excludeOsmWayById(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Way, new HashSet());
        this.excludedPtOsmEntities.get(EntityType.Way).add(osmId.longValue());
    }

    public boolean isExcludedOsmNode(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Node, new HashSet());
        return this.excludedPtOsmEntities.get(EntityType.Node).contains(osmId.longValue());
    }

    public boolean isExcludedOsmWay(Number osmId) {
        this.excludedPtOsmEntities.putIfAbsent(EntityType.Way, new HashSet());
        return this.excludedPtOsmEntities.get(EntityType.Way).contains(osmId.longValue());
    }

    public void overwriteWaitingAreaOfStopLocation(Number stopLocationOsmNodeId, EntityType waitingAreaEntityType, Number waitingAreaOsmId) {
        this.overwritePtStopLocation2WaitingAreaMapping.put(stopLocationOsmNodeId.longValue(), (Pair<EntityType, Long>)Pair.of((Object)waitingAreaEntityType, (Object)waitingAreaOsmId.longValue()));
    }

    public void overwriteWaitingAreaOfStopLocations(Triple<Number, EntityType, Number> ... overwriteTriples) {
        Arrays.stream(overwriteTriples).forEach(t -> this.overwriteWaitingAreaOfStopLocation((Number)t.first(), (EntityType)t.second(), (Number)t.third()));
    }

    public boolean isOverwriteWaitingAreaOfStopLocation(Number stopLocationOsmNodeId) {
        return this.overwritePtStopLocation2WaitingAreaMapping.containsKey(stopLocationOsmNodeId.longValue());
    }

    public Pair<EntityType, Long> getOverwrittenWaitingAreaOfStopLocation(Number stopLocationOsmNodeId) {
        if (stopLocationOsmNodeId == null) {
            return null;
        }
        return this.overwritePtStopLocation2WaitingAreaMapping.get(stopLocationOsmNodeId.longValue());
    }

    public boolean isWaitingAreaOfStopLocationOverwritten(EntityType waitingAreaType, Number osmWaitingAreaId) {
        if (osmWaitingAreaId == null) {
            return false;
        }
        for (Map.Entry<Long, Pair<EntityType, Long>> entry : this.overwritePtStopLocation2WaitingAreaMapping.entrySet()) {
            if (!((EntityType)entry.getValue().first()).equals((Object)waitingAreaType) || !((Long)entry.getValue().second()).equals(osmWaitingAreaId.longValue())) continue;
            return true;
        }
        return false;
    }

    public void overwriteWaitingAreaNominatedOsmWayForStopLocation(Number waitingAreaOsmId, EntityType waitingAreaEntityType, Number osmWayId) {
        if (osmWayId == null || waitingAreaOsmId == null || waitingAreaEntityType == null) {
            LOGGER.severe("unable to overwrite waiting area nominated OsmWay for stop location as one of the parameters is null");
        }
        this.overwritePtWaitingArea2OsmWayMapping.putIfAbsent(waitingAreaEntityType, new HashMap());
        this.overwritePtWaitingArea2OsmWayMapping.get(waitingAreaEntityType).put(waitingAreaOsmId.longValue(), osmWayId.longValue());
    }

    public boolean hasWaitingAreaNominatedOsmWayForStopLocation(Number waitingAreaOsmId, EntityType waitingAreaEntityType) {
        if (waitingAreaOsmId == null || waitingAreaEntityType == null) {
            return false;
        }
        this.overwritePtWaitingArea2OsmWayMapping.putIfAbsent(waitingAreaEntityType, new HashMap());
        return this.overwritePtWaitingArea2OsmWayMapping.get(waitingAreaEntityType).containsKey(waitingAreaOsmId.longValue());
    }

    public Long getWaitingAreaNominatedOsmWayForStopLocation(Number waitingAreaOsmId, EntityType waitingAreaEntityType) {
        if (waitingAreaOsmId == null || waitingAreaEntityType == null) {
            return null;
        }
        this.overwritePtWaitingArea2OsmWayMapping.putIfAbsent(waitingAreaEntityType, new HashMap());
        return this.overwritePtWaitingArea2OsmWayMapping.get(waitingAreaEntityType).get(waitingAreaOsmId.longValue());
    }

    public void setRemoveDanglingZones(boolean removeDanglingZones) {
        this.removeDanglingZones = removeDanglingZones;
    }

    public boolean isRemoveDanglingZones() {
        return this.removeDanglingZones;
    }

    public void setRemoveDanglingTransferZoneGroups(boolean removeDanglingTransferZoneGroups) {
        this.removeDanglingTransferZoneGroups = removeDanglingTransferZoneGroups;
    }

    public boolean isRemoveDanglingTransferZoneGroups() {
        return this.removeDanglingTransferZoneGroups;
    }

    public void suppressOsmRelationStopAreaLogging(Number ... osmStopAreaRelationIds) {
        this.suppressOsmRelationStopAreaLogging(Arrays.asList(osmStopAreaRelationIds));
    }

    public void suppressOsmRelationStopAreaLogging(List<Number> osmStopAreaRelationIds) {
        if (osmStopAreaRelationIds == null) {
            return;
        }
        for (Number osmStopAreaRelationId : osmStopAreaRelationIds) {
            if (osmStopAreaRelationId == null) continue;
            this.suppressStopAreaLogging.add(osmStopAreaRelationId.longValue());
        }
    }

    public boolean isSuppressOsmRelationStopAreaLogging(Number osmStopAreaRelationId) {
        if (osmStopAreaRelationId == null) {
            return false;
        }
        return this.suppressStopAreaLogging.contains(osmStopAreaRelationId.longValue());
    }

    public boolean isConnectDanglingFerryStopToNearbyFerryRoute() {
        return this.connectDanglingFerryStopToNearbyFerryRoute;
    }

    public void setConnectDanglingFerryStopToNearbyFerryRoute(boolean connectDanglingFerryStopToNearbyFerryRoute) {
        this.connectDanglingFerryStopToNearbyFerryRoute = connectDanglingFerryStopToNearbyFerryRoute;
    }

    public double getFerryStopToFerryRouteSearchRadiusMeters() {
        return this.searchRadiusFerryStopToFerryRouteMeters;
    }

    public void setFerryStopToFerryRouteSearchRadiusMeters(Number searchRadiusFerryStopToFerryRouteMeters) {
        if (searchRadiusFerryStopToFerryRouteMeters == null) {
            LOGGER.severe("Unable to set ferry stop to ferry route search radius as parameter is null");
            return;
        }
        this.searchRadiusFerryStopToFerryRouteMeters = searchRadiusFerryStopToFerryRouteMeters.doubleValue();
    }

    public void overwriteWaitingAreaModeAccess(Number osmId, EntityType osmEntityType, String ... osmModes) {
        Map<Long, SortedSet<String>> overwritesByType = this.overwriteWaitingAreaModeAccess.get(osmEntityType);
        if (overwritesByType == null) {
            LOGGER.severe(String.format("IGNORE: Unsupported OSM entity type (%s) for registering overwritten modes access for waiting areas", osmEntityType.toString()));
        }
        overwritesByType.put(osmId.longValue(), new TreeSet<String>(Arrays.asList(osmModes)));
    }

    public boolean isOverwriteWaitingAreaModeAccess(Number osmId, EntityType osmEntityType) {
        Map<Long, SortedSet<String>> overwritesByType = this.overwriteWaitingAreaModeAccess.get(osmEntityType);
        if (overwritesByType == null) {
            return false;
        }
        return overwritesByType.containsKey(osmId.longValue());
    }

    public SortedSet<String> getOverwrittenWaitingAreaModeAccess(Number osmId, EntityType osmEntityType) {
        Map<Long, SortedSet<String>> overwritesByType = this.overwriteWaitingAreaModeAccess.get(osmEntityType);
        if (overwritesByType == null) {
            return null;
        }
        return overwritesByType.get(osmId.longValue());
    }

    static {
        DEFAULT_SEARCH_RADIUS_STATION_PARALLEL_TRACKS_M = DEFAULT_SEARCH_RADIUS_STATION2PLATFORM_M = 35.0;
        DEFAULT_CLOSEST_EDGE_SEARCH_BUFFER_DISTANCE_M = 8.0;
        DEFAULT_CONNECT_DANGLING_FERRY_STOP_TO_FERRY_ROUTE = true;
        DEFAULT_SEARCH_RADIUS_FERRY_STOP_TO_FERRY_ROUTE_M = 100.0;
    }
}

