/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.osm.defaults.OsmInfrastructureConfiguration;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.PredefinedModeType;

public abstract class OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmWaySettings.class.getCanonicalName());
    private OsmSpeedLimitDefaultsCategory speedLimitDefaults;
    private OsmModeAccessDefaultsCategory osmModeAccessDefaults;
    private final OsmInfrastructureConfiguration infrastructureTypeConfiguration;
    private final Map<String, PredefinedModeType> activatedOsmMode2PlanitModeTypeMap = new HashMap<String, PredefinedModeType>();
    private final Map<String, PredefinedModeType> defaultOsmMode2PlanitPredefinedModeTypeMap = new HashMap<String, PredefinedModeType>();
    protected final Map<String, Pair<Double, Double>> overwriteOsmWayTypeCapacityDensityDefaults = new HashMap<String, Pair<Double, Double>>();
    private Boolean isParserActive = null;

    private void excludeOsmWayTypesWithoutModes(String osmWayValue, Collection<String> osmModes) {
        boolean hasMappedMode = false;
        if (osmModes != null) {
            for (String osmMode : osmModes) {
                if (!this.isOsmModeActivated(osmMode)) continue;
                hasMappedMode = true;
                break;
            }
        }
        if (!hasMappedMode) {
            this.deactivateOsmWayType(osmWayValue);
        }
    }

    protected OsmWaySettings(OsmInfrastructureConfiguration infrastructureTypeConfiguration, OsmSpeedLimitDefaultsCategory speedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessDefaults) {
        this.infrastructureTypeConfiguration = infrastructureTypeConfiguration;
        this.speedLimitDefaults = speedLimitDefaults;
        this.osmModeAccessDefaults = osmModeAccessDefaults;
    }

    public void excludeOsmWayTypesWithoutActivatedModes() {
        Map<String, Set<String>> originallySupportedTypes = this.getSetOfActivatedOsmWayLikeTypes();
        Collection<String> activatedOsmModes = this.getAcivatedOsmModes();
        if (originallySupportedTypes != null) {
            for (Map.Entry<String, Set<String>> entry : originallySupportedTypes.entrySet()) {
                for (String supportedKeyValueType : entry.getValue()) {
                    Set<String> allowedOsmModes = this.collectAllowedOsmWayModes(entry.getKey(), supportedKeyValueType, activatedOsmModes);
                    this.excludeOsmWayTypesWithoutModes(supportedKeyValueType, allowedOsmModes);
                }
            }
        }
    }

    protected boolean isOsmWayTypeDeactivated(String osmWayValueType) {
        return !this.isParserActive() || !this.isOsmWayTypeActivated(osmWayValueType);
    }

    protected boolean isOsmWayTypeActivated(String osmWayValue) {
        return this.isParserActive() && this.infrastructureTypeConfiguration.isActivated(osmWayValue);
    }

    protected void deactivateOsmWayType(String osmWayValue) {
        this.infrastructureTypeConfiguration.deactivate(osmWayValue);
    }

    protected void activateOsmWayType(String osmWayValue) {
        this.infrastructureTypeConfiguration.activate(osmWayValue);
        this.activateParser(true);
    }

    protected void activateOsmWayTypes(String ... osmWayValueTypes) {
        this.activateOsmWayTypes(Arrays.asList(osmWayValueTypes));
    }

    protected void activateOsmWayTypes(List<String> osmWayValueTypes) {
        osmWayValueTypes.forEach(type -> this.activateOsmWayType((String)type));
    }

    protected void activateAllOsmWayTypes() {
        this.infrastructureTypeConfiguration.getDeactivatedTypes().values().stream().flatMap(e -> e.stream()).forEach(unsupportedType -> this.activateOsmWayType((String)unsupportedType));
        this.activateParser(true);
    }

    protected void deactivateAllOsmWayTypes() {
        this.infrastructureTypeConfiguration.deactivateAll();
        this.activateParser(false);
    }

    protected void logUnsupportedOsmWayTypes() {
        this.infrastructureTypeConfiguration.logDeactivatedTypes();
    }

    protected void overwriteOsmWayTypeDefaultCapacityMaxDensity(String osmWayKey, String osmWayType, double capacityPerLanePerHour, double maxDensityPerLane) {
        this.overwriteOsmWayTypeCapacityDensityDefaults.put(osmWayType, (Pair<Double, Double>)Pair.of((Object)capacityPerLanePerHour, (Object)maxDensityPerLane));
        LOGGER.info(String.format("Overwriting defaults for OSM road type %s:%s to capacity: %.2f (pcu/h/lane), max density %.2f (pcu/km)", osmWayKey, osmWayType, capacityPerLanePerHour, maxDensityPerLane));
    }

    protected boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(String osmWayType) {
        return this.overwriteOsmWayTypeCapacityDensityDefaults.containsKey(osmWayType);
    }

    protected final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmWayType(String osmWayType) {
        return this.overwriteOsmWayTypeCapacityDensityDefaults.get(osmWayType);
    }

    protected double getDefaultSpeedLimitByOsmTypeValue(String osmWayKey, String osmWayValue) {
        return this.speedLimitDefaults.getSpeedLimit(osmWayKey, osmWayValue);
    }

    protected Double getDefaultSpeedLimitByOsmWayType(String osmWayKey, Map<String, String> tags) {
        if (tags.containsKey(osmWayKey)) {
            return this.getDefaultSpeedLimitByOsmTypeValue(osmWayKey, tags.get(osmWayKey));
        }
        throw new PlanItRunTimeException("No key %s contained in provided osmTags when collecting default speed limit", new Object[]{osmWayKey});
    }

    protected void addDefaultOsmMode2PlanitPredefinedModeTypeMapping(String osmMode, PredefinedModeType planitModeType) {
        this.defaultOsmMode2PlanitPredefinedModeTypeMap.put(osmMode, planitModeType);
    }

    protected void activateOsmMode(String osmMode) {
        this.activatedOsmMode2PlanitModeTypeMap.put(osmMode, this.defaultOsmMode2PlanitPredefinedModeTypeMap.get(osmMode));
    }

    protected void setOsmMode2PlanitModeTypeMapping(String osmMode, PredefinedModeType planitModeType) {
        if (osmMode == null) {
            LOGGER.warning("OSM mode is null, cannot add it to OSM to PLANit mode mapping for OSM mode, ignored");
            return;
        }
        this.activatedOsmMode2PlanitModeTypeMap.put(osmMode, planitModeType);
    }

    protected void deactivateOsmMode(String osmMode) {
        if (osmMode == null) {
            LOGGER.warning("OSM mode is null, cannot deactivate, ignored");
            return;
        }
        LOGGER.fine(String.format("OSM mode %s is deactivated", osmMode));
        this.activatedOsmMode2PlanitModeTypeMap.remove(osmMode);
    }

    protected void deactivateOsmModes(Collection<String> osmModes) {
        for (String osmMode : osmModes) {
            this.deactivateOsmMode(osmMode);
        }
    }

    protected void deactivateAllModesExcept(Collection<String> toBeRemovedModes, List<String> remainingOsmRoadModes) {
        ArrayList remainingRoadModes = remainingOsmRoadModes == null ? new ArrayList() : remainingOsmRoadModes;
        TreeSet<String> finalToBeRemovedModes = new TreeSet<String>(toBeRemovedModes);
        finalToBeRemovedModes.removeAll(remainingRoadModes);
        this.deactivateOsmModes(finalToBeRemovedModes);
    }

    protected PredefinedModeType getPlanitModeTypeIfActivated(String osmMode) {
        if (!this.isParserActive()) {
            return null;
        }
        return this.activatedOsmMode2PlanitModeTypeMap.get(osmMode);
    }

    protected TreeSet<String> getAcivatedOsmModes(PredefinedModeType planitModeType) {
        TreeSet<String> mappedOsmModes = new TreeSet<String>();
        if (!this.isParserActive()) {
            return mappedOsmModes;
        }
        for (Map.Entry<String, PredefinedModeType> entry : this.activatedOsmMode2PlanitModeTypeMap.entrySet()) {
            if (!entry.getValue().equals((Object)planitModeType)) continue;
            mappedOsmModes.add(entry.getKey());
        }
        return mappedOsmModes;
    }

    protected boolean isModeAllowedOnOsmWay(String osmWayKey, String osmWayTypeValue, String osmMode) {
        return this.osmModeAccessDefaults.isAllowed(osmWayKey, osmWayTypeValue, osmMode);
    }

    protected Set<String> collectAllowedOsmWayModes(String osmWayKey, String osmWayValueType, Collection<String> osmModesToCheck) {
        return osmModesToCheck.stream().filter(osmMode -> this.isModeAllowedOnOsmWay(osmWayKey, osmWayValueType, (String)osmMode)).collect(Collectors.toSet());
    }

    protected void addAllowedOsmWayModes(String osmWayKey, String osmWayTypeValue, List<String> osmModes) {
        this.osmModeAccessDefaults.addAllowedModes(osmWayKey, osmWayTypeValue, osmModes);
    }

    public abstract void logSettings();

    public void activateParser(boolean activate) {
        this.isParserActive = activate;
    }

    public boolean isParserActive() {
        return this.isParserActive;
    }

    public boolean isOsmModeActivated(String osmMode) {
        return this.isParserActive() && this.getPlanitModeTypeIfActivated(osmMode) != null;
    }

    public Collection<String> getAcivatedOsmModes() {
        HashSet<String> mappedOsmModes = new HashSet<String>();
        if (!this.isParserActive()) {
            return mappedOsmModes;
        }
        for (Map.Entry<String, PredefinedModeType> entry : this.activatedOsmMode2PlanitModeTypeMap.entrySet()) {
            mappedOsmModes.add(entry.getKey());
        }
        return mappedOsmModes;
    }

    public boolean hasActivatedOsmModeOtherThan(String osmMode) {
        return this.isParserActive() && this.activatedOsmMode2PlanitModeTypeMap.keySet().stream().filter(mode -> !mode.equals(osmMode)).findFirst().isPresent();
    }

    public final Map<String, Set<String>> getSetOfActivatedOsmWayLikeTypes() {
        return this.isParserActive() ? this.infrastructureTypeConfiguration.getActivatedTypes() : null;
    }

    public Stream<PredefinedModeType> getActivatedPlanitModeTypesStream() {
        return this.activatedOsmMode2PlanitModeTypeMap.values().stream().distinct();
    }
}

