/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmWaySettings;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.osm.defaults.OsmWaterwayTypeConfiguration;
import org.goplanit.osm.tags.OsmWaterModeTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmWaterwaySettings
extends OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmWaterwaySettings.class.getCanonicalName());
    public static boolean DEFAULT_WATERWAYS_PARSER_ACTIVE = false;

    protected void initialiseDefaultMappingFromOsmWaterModes2PlanitModes() {
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("ferry", PredefinedModeType.FERRY);
        this.activateOsmMode("ferry");
    }

    public OsmWaterwaySettings(OsmSpeedLimitDefaultsCategory waterwaySpeedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessWaterwayDefaults) {
        super(new OsmWaterwayTypeConfiguration(), waterwaySpeedLimitDefaults, osmModeAccessWaterwayDefaults);
        this.activateParser(DEFAULT_WATERWAYS_PARSER_ACTIVE);
    }

    public boolean isOsmWaterwayTypeDeactivated(String osmWaterWayValue) {
        return this.isOsmWayTypeDeactivated(osmWaterWayValue);
    }

    public boolean isOsmWaterwayTypeActivated(String osmWayValue) {
        return this.isOsmWayTypeActivated(osmWayValue);
    }

    public void deactivateOsmWaterwayType(String osmWayValue) {
        this.deactivateOsmWayType(osmWayValue);
    }

    public void deactivateAllOsmWaterwayTypesExcept(String ... osmWaterwayTypes) {
        this.deactivateAllOsmWaterwayTypesExcept(Arrays.asList(osmWaterwayTypes));
    }

    public void deactivateAllOsmWaterwayTypesExcept(List<String> osmWaterwayTypes) {
        this.deactivateAllOsmWaterwayTypes();
        for (String osmWayType : osmWaterwayTypes) {
            if (!OsmWaterwayTags.hasKeyForValueType(osmWayType) || !OsmWaterwayTags.isWaterBasedWay(OsmWaterwayTags.getKeyForValueType(osmWayType), osmWayType)) continue;
            this.activateOsmWaterwayType(osmWayType);
        }
    }

    public void activateOsmWaterwayType(String osmWayValue) {
        this.activateOsmWayType(osmWayValue);
    }

    public void activateOsmWaterwayTypes(String ... osmWaterwayValueTypes) {
        this.activateOsmWayTypes(osmWaterwayValueTypes);
    }

    public void activateOsmWaterwayTypes(List<String> osmWaterwayValueTypes) {
        this.activateOsmWayTypes(osmWaterwayValueTypes);
    }

    public void activateAllOsmWaterwayTypes() {
        this.activateAllOsmWayTypes();
    }

    public void deactivateAllOsmWaterwayTypes() {
        this.deactivateAllOsmWayTypes();
    }

    public void logUnsupportedOsmWaterwayTypes() {
        this.logUnsupportedOsmWayTypes();
    }

    public void overwriteCapacityMaxDensityDefaults(String osmWaterwayType, Number capacityPcuPerLanePerHour, Number maxDensityPcuPerLane) {
        String keyForType = OsmWaterwayTags.getKeyForValueType(osmWaterwayType);
        if (keyForType == null) {
            LOGGER.warning(String.format("IGNORE: Unsupported waterway type %s encountered, unable to overwrite capacity.max density", osmWaterwayType));
        }
        this.overwriteOsmWayTypeDefaultCapacityMaxDensity(keyForType, osmWaterwayType, capacityPcuPerLanePerHour.doubleValue(), maxDensityPcuPerLane.doubleValue());
    }

    public boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmWaterwayRouteType(String osmWayType) {
        return this.isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(osmWayType);
    }

    public final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmWaterwayRouteType(String osmWayRouteType) {
        return this.getOverwrittenCapacityMaxDensityByOsmWayType(osmWayRouteType);
    }

    public Double getDefaultSpeedLimitByOsmWaterwayType(String waterwayValue) {
        return this.getDefaultSpeedLimitByOsmTypeValue(OsmWaterwayTags.getKeyForValueType(waterwayValue), waterwayValue);
    }

    public void activateOsmWaterMode(String osmWaterMode) {
        if (!OsmWaterModeTags.isWaterModeTag(osmWaterMode)) {
            LOGGER.warning(String.format("OSM water based mode %s is not recognised when adding it to OSM to PLANit mode mapping, ignored", osmWaterMode));
            return;
        }
        this.activateOsmMode(osmWaterMode);
    }

    public void deactivateOsmWaterMode(String osmWaterMode) {
        if (!OsmWaterModeTags.isWaterModeTag(osmWaterMode)) {
            LOGGER.warning(String.format("OSM water mode %s is not recognised when removing it from OSM to PLANit mode mapping, ignored", osmWaterMode));
            return;
        }
        this.deactivateOsmMode(osmWaterMode);
    }

    public void deactivateOsmWaterModes(List<String> osmWaterModes) {
        if (osmWaterModes == null) {
            return;
        }
        osmWaterModes.forEach(osmRailMode -> this.deactivateOsmWaterMode((String)osmRailMode));
    }

    public void deactivateOsmWaterModes(String ... osmWaterModes) {
        this.deactivateOsmWaterModes(Arrays.asList(osmWaterModes));
    }

    public void deactivateAllOsmWaterModes() {
        this.deactivateOsmModes(OsmWaterModeTags.getSupportedWaterModeTags());
    }

    public void deactivateAllOsmWaterModesExcept(String ... remainingOsmWaterModes) {
        this.deactivateAllOsmWaterModesExcept(Arrays.asList(remainingOsmWaterModes));
    }

    public void deactivateAllOsmWaterModesExcept(List<String> remainingOsmWaterModes) {
        Set<String> toBeRemovedModes = OsmWaterModeTags.getSupportedWaterModeTags();
        this.deactivateAllModesExcept(toBeRemovedModes, remainingOsmWaterModes);
    }

    public PredefinedModeType getMappedPlanitWaterMode(String osmMode) {
        if (OsmWaterModeTags.isWaterModeTag(osmMode)) {
            return this.getPlanitModeTypeIfActivated(osmMode);
        }
        return null;
    }

    public final Collection<String> getMappedOsmWaterModes(PredefinedModeType planitModeType) {
        return this.getAcivatedOsmModes(planitModeType);
    }

    public Collection<String> collectAllowedOsmWaterwayModes(String osmWaterwayType) {
        if (!OsmWaterwayTags.hasKeyForValueType(osmWaterwayType)) {
            return Collections.emptyList();
        }
        return this.collectAllowedOsmWayModes(OsmWaterwayTags.getKeyForValueType(osmWaterwayType), osmWaterwayType, OsmWaterModeTags.getSupportedWaterModeTags());
    }

    @Override
    public void logSettings() {
        LOGGER.info(String.format("Waterway parser activated: %s", String.valueOf(this.isParserActive())));
    }
}

