/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmWaySettings;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmRailwayTypeConfiguration;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmRailwaySettings
extends OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmRailwaySettings.class.getCanonicalName());
    public static boolean DEFAULT_RAILWAYS_PARSER_ACTIVE = false;

    protected void initialiseDefaultMappingFromOsmRailModes2PlanitModes() {
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("funicular", PredefinedModeType.TRAM);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("light_rail", PredefinedModeType.LIGHTRAIL);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("monorail", PredefinedModeType.TRAM);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("narrow_gauge", PredefinedModeType.TRAIN);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("train", PredefinedModeType.TRAIN);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("subway", PredefinedModeType.SUBWAY);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("tram", PredefinedModeType.TRAM);
        this.activateOsmMode("funicular");
        this.activateOsmMode("light_rail");
        this.activateOsmMode("monorail");
        this.activateOsmMode("narrow_gauge");
        this.activateOsmMode("train");
        this.activateOsmMode("subway");
        this.activateOsmMode("tram");
    }

    protected Collection<String> collectAllowedOsmWayModes(String osmWayValueType) {
        Set<String> allowedModes = null;
        if (OsmRailwayTags.isRailBasedRailway(osmWayValueType)) {
            allowedModes = this.collectAllowedOsmWayModes(OsmRailwayTags.getRailwayKeyTag(), osmWayValueType, OsmRailModeTags.getSupportedRailModeTags());
        } else {
            LOGGER.warning(String.format("Unrecognised OSM railway %s=%s, no allowed modes can be identified", OsmRailwayTags.getRailwayKeyTag(), osmWayValueType));
        }
        return allowedModes;
    }

    public OsmRailwaySettings(OsmSpeedLimitDefaultsCategory railwaySpeedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessRailwayDefaults) {
        super(new OsmRailwayTypeConfiguration(), railwaySpeedLimitDefaults, osmModeAccessRailwayDefaults);
        this.activateParser(DEFAULT_RAILWAYS_PARSER_ACTIVE);
    }

    public boolean isOsmRailwayTypeDeactivated(String osmRailWayValue) {
        return this.isOsmWayTypeDeactivated(osmRailWayValue);
    }

    public boolean isOsmRailwayTypeActivated(String osmWayValue) {
        return this.isOsmWayTypeActivated(osmWayValue);
    }

    public void deactivateOsmRailwayType(String osmWayValue) {
        this.deactivateOsmWayType(osmWayValue);
    }

    public void deactivateAllOsmRailwayTypesExcept(String ... osmRailwayTypes) {
        this.deactivateAllOsmRailwayTypesExcept(Arrays.asList(osmRailwayTypes));
    }

    public void deactivateAllOsmRailwayTypesExcept(List<String> osmRailwayTypes) {
        this.deactivateAllOsmRailwayTypes();
        for (String osmWayType : osmRailwayTypes) {
            if (!OsmRailwayTags.isRailBasedRailway(osmWayType)) continue;
            this.activateOsmRailwayType(osmWayType);
        }
    }

    public void activateOsmRailwayType(String osmWayValue) {
        this.activateOsmWayType(osmWayValue);
    }

    public void activateOsmRailwayTypes(String ... osmRailwayValueTypes) {
        this.activateOsmWayTypes(osmRailwayValueTypes);
    }

    public void activateOsmRailwayTypes(List<String> osmRailwayValueTypes) {
        this.activateOsmWayTypes(osmRailwayValueTypes);
    }

    public void activateAllOsmRailwayTypes() {
        this.activateAllOsmWayTypes();
    }

    public void deactivateAllOsmRailwayTypes() {
        this.deactivateAllOsmWayTypes();
    }

    public void logUnsupportedOsmRailwayTypes() {
        this.logUnsupportedOsmWayTypes();
    }

    public void overwriteCapacityMaxDensityDefaults(String osmRailwayType, Number capacityPerLanePerHour, Number maxDensityPerLane) {
        this.overwriteOsmWayTypeDefaultCapacityMaxDensity("railway", osmRailwayType, capacityPerLanePerHour.doubleValue(), maxDensityPerLane.doubleValue());
    }

    public boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmRailwayType(String osmWayType) {
        return this.isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(osmWayType);
    }

    public final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmRailwayType(String osmWayType) {
        return this.getOverwrittenCapacityMaxDensityByOsmWayType(osmWayType);
    }

    public double getDefaultSpeedLimitByOsmRailwayType(String osmWayValue) {
        return this.getDefaultSpeedLimitByOsmTypeValue(OsmRailwayTags.getRailwayKeyTag(), osmWayValue);
    }

    public void activateOsmRailMode(String osmRailMode) {
        String convertedOsmMode = OsmRailModeTags.convertModeToRailway(osmRailMode);
        if (!OsmRailwayTags.isRailBasedRailway(convertedOsmMode)) {
            LOGGER.warning(String.format("osm rail mode %s is not recognised when adding it to OSM to PLANit mode mapping, ignored", osmRailMode));
            return;
        }
        this.activateOsmMode(osmRailMode);
    }

    public void deactivateOsmRailMode(String osmRailMode) {
        String convertedOsmMode = OsmRailModeTags.convertModeToRailway(osmRailMode);
        if (!OsmRailwayTags.isRailBasedRailway(convertedOsmMode)) {
            LOGGER.warning(String.format("osm rail mode %s is not recognised when removing it from OSM to PLANit mode mapping, ignored", osmRailMode));
            return;
        }
        this.deactivateOsmMode(osmRailMode);
    }

    public void deactivateOsmRailModes(List<String> osmRailModes) {
        if (osmRailModes == null) {
            return;
        }
        osmRailModes.forEach(osmRailMode -> this.deactivateOsmRailMode((String)osmRailMode));
    }

    public void deactivateOsmRailModes(String ... osmRailModes) {
        this.deactivateOsmRailModes(Arrays.asList(osmRailModes));
    }

    public void deactivateAllOsmRailModes() {
        this.deactivateOsmModes(OsmRailModeTags.getSupportedRailModeTags());
    }

    public void deactivateAllOsmRailModesExcept(String ... remainingOsmRailModes) {
        this.deactivateAllOsmRailModesExcept(Arrays.asList(remainingOsmRailModes));
    }

    public void deactivateAllOsmRailModesExcept(List<String> remainingOsmRailModes) {
        Set<String> toBeRemovedModes = OsmRailModeTags.getSupportedRailModeTags();
        this.deactivateAllModesExcept(toBeRemovedModes, remainingOsmRailModes);
    }

    public PredefinedModeType getMappedPlanitRailMode(String osmMode) {
        if (OsmRailModeTags.isRailModeTag(osmMode)) {
            return this.getPlanitModeTypeIfActivated(osmMode);
        }
        return null;
    }

    public final TreeSet<String> getMappedOsmRailModes(PredefinedModeType planitModeType) {
        return this.getAcivatedOsmModes(planitModeType);
    }

    public Collection<String> collectAllowedOsmRailwayModes(String osmRailwayValueType) {
        return this.collectAllowedOsmWayModes(osmRailwayValueType);
    }

    @Override
    public void logSettings() {
        LOGGER.info(String.format("Railway parser activated: %s", this.isParserActive()));
    }
}

