/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.locationtech.jts.geom.Envelope;

public class OsmNetworkToZoningReaderData {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkToZoningReaderData.class.getCanonicalName());
    private final OsmNetworkReaderSettings networkReaderSettings;
    private final OsmNetworkReaderData networkData;
    private final Map<NetworkLayer, OsmNetworkReaderLayerData> networkLayerData = new HashMap<NetworkLayer, OsmNetworkReaderLayerData>();

    protected void registerLayerData(MacroscopicNetworkLayer networkLayer, OsmNetworkReaderLayerData layerData) {
        this.networkLayerData.put((NetworkLayer)networkLayer, layerData);
    }

    protected OsmNetworkToZoningReaderData(OsmNetworkReaderData networkData, OsmNetworkReaderSettings networkReaderSettings) {
        if (networkData == null) {
            LOGGER.severe("Network data provided to PlanitOsmNetworkToZoningReaderData constructor null");
        }
        if (networkReaderSettings == null) {
            LOGGER.severe("Network reader settings provided to PlanitOsmNetworkToZoningReaderData constructor null");
        }
        this.networkData = networkData;
        this.networkReaderSettings = networkReaderSettings;
    }

    public OsmNetworkReaderLayerData getNetworkLayerData(NetworkLayer networkLayer) {
        OsmNetworkReaderLayerData data = this.networkLayerData.get(networkLayer);
        return data;
    }

    public Envelope getNetworkBoundingBox() {
        return this.networkData.getBoundingBox();
    }

    public OsmNetworkReaderSettings getNetworkSettings() {
        return this.networkReaderSettings;
    }

    public Map<Long, OsmNode> getNetworkOsmNodes() {
        return this.networkData.getOsmNodeData().getRegisteredOsmNodes();
    }

    public void registerNetworkOsmNode(OsmNode osmNode) {
        this.networkData.getOsmNodeData().preRegisterEligibleOsmNode(osmNode.getId());
        this.networkData.getOsmNodeData().registerEligibleOsmNode(osmNode);
    }

    public boolean isOsmWayProcessedAndUnavailable(long osmWayId) {
        return this.networkData.isOsmWayProcessedAndUnavailable(osmWayId);
    }
}

