/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.osm.converter.OsmReaderSettings;
import org.goplanit.osm.converter.network.OsmHighwaySettings;
import org.goplanit.osm.converter.network.OsmRailwaySettings;
import org.goplanit.osm.converter.network.OsmWaterwaySettings;
import org.goplanit.osm.defaults.OsmLaneDefaults;
import org.goplanit.osm.defaults.OsmModeAccessDefaults;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsByCountry;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaults;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsByCountry;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.goplanit.utils.mode.PredefinedModeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OsmNetworkReaderSettings
extends OsmReaderSettings {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkReaderSettings.class.getCanonicalName());
    protected OsmRailwaySettings osmRailwaySettings;
    protected OsmHighwaySettings osmHighwaySettings;
    protected OsmWaterwaySettings osmWaterwaySettings;
    protected final OsmSpeedLimitDefaults speedLimitConfiguration;
    protected final OsmModeAccessDefaults modeAccessConfiguration;
    protected final OsmLaneDefaults laneConfiguration = new OsmLaneDefaults();
    protected final Set<Long> excludedOsmWays = new HashSet<Long>();
    protected final Set<Long> includedOutsideBoundingPolygonOsmWays = new HashSet<Long>();
    protected final Set<Long> includedOutsideBoundingPolygonOsmNodes = new HashSet<Long>();
    protected final Map<Long, Set<String>> overwriteOsmWayModeAccess = new HashMap<Long, Set<String>>();
    protected CoordinateReferenceSystem sourceCRS = PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS;
    protected boolean removeDanglingSubNetworks = DEFAULT_REMOVE_DANGLING_SUBNETWORK;
    protected int discardSubNetworkBelowSize = DEFAULT_MINIMUM_SUBNETWORK_SIZE;
    protected int discardSubNetworkAboveSize = Integer.MAX_VALUE;
    protected boolean alwaysKeepLargestsubNetwork = DEFAULT_ALWAYS_KEEP_LARGEST_SUBNETWORK;
    public static CoordinateReferenceSystem DEFAULT_SOURCE_CRS = PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS;
    public static boolean DEFAULT_REMOVE_DANGLING_SUBNETWORK = true;
    public static int DEFAULT_MINIMUM_SUBNETWORK_SIZE = 20;
    public static boolean DEFAULT_ALWAYS_KEEP_LARGEST_SUBNETWORK = true;

    protected void initialise() {
        this.initialiseDefaultMappingFromOsmModes2PlanitModes();
    }

    protected void initialiseDefaultMappingFromOsmModes2PlanitModes() {
        this.osmHighwaySettings.initialiseDefaultMappingFromOsmRoadModes2PlanitModes();
        this.osmRailwaySettings.initialiseDefaultMappingFromOsmRailModes2PlanitModes();
        this.osmWaterwaySettings.initialiseDefaultMappingFromOsmWaterModes2PlanitModes();
    }

    public OsmNetworkReaderSettings() {
        this("global");
    }

    public OsmNetworkReaderSettings(String countryName) {
        this((URL)null, countryName);
    }

    public OsmNetworkReaderSettings(String inputSource, String countryName) {
        this(UrlUtils.createFromLocalPath((Path)Path.of(inputSource, new String[0])), countryName);
    }

    public OsmNetworkReaderSettings(URL inputSource, String countryName) {
        super(inputSource, countryName);
        this.speedLimitConfiguration = OsmSpeedLimitDefaultsByCountry.create(countryName);
        this.modeAccessConfiguration = OsmModeAccessDefaultsByCountry.create(countryName);
        this.osmHighwaySettings = new OsmHighwaySettings(this.speedLimitConfiguration.getUrbanHighwayDefaults(), this.speedLimitConfiguration.getNonUrbanHighwayDefaults(), this.modeAccessConfiguration.getHighwayModeAccessDefaults());
        this.osmRailwaySettings = new OsmRailwaySettings(this.speedLimitConfiguration.getRailwayDefaults(), this.modeAccessConfiguration.getRailwayModeAccessDefaults());
        this.osmWaterwaySettings = new OsmWaterwaySettings(this.speedLimitConfiguration.getWaterwayDefaults(), this.modeAccessConfiguration.getWaterwayModeAccessDefaults());
        this.initialise();
    }

    public void reset() {
    }

    public void logSettings() {
        LOGGER.info(String.format("OSM network input source: %s", this.getInputSource()));
        LOGGER.info(String.format("Country to base defaults on: %s", this.getCountryName()));
        LOGGER.info(String.format("Setting Coordinate Reference System: %s", this.getSourceCRS().getName()));
        if (this.hasBoundingPolygon()) {
            LOGGER.info(String.format("Bounding polygon set to: %s", this.getBoundingPolygon().toString()));
        }
        this.getHighwaySettings().logSettings();
        this.getRailwaySettings().logSettings();
        this.getWaterwaySettings().logSettings();
    }

    public OsmRailwaySettings activateRailwayParser(boolean activate) {
        this.osmRailwaySettings.activateParser(activate);
        return this.getRailwaySettings();
    }

    public OsmWaterwaySettings activateWaterwayParser(boolean activate) {
        this.osmWaterwaySettings.activateParser(activate);
        return this.getWaterwaySettings();
    }

    public OsmHighwaySettings activateHighwayParser(boolean activate) {
        this.osmHighwaySettings.activateParser(activate);
        return this.getHighwaySettings();
    }

    public boolean isRailwayParserActive() {
        return this.osmRailwaySettings.isParserActive();
    }

    public boolean isHighwayParserActive() {
        return this.osmHighwaySettings.isParserActive();
    }

    public boolean isWaterwayParserActive() {
        return this.osmWaterwaySettings.isParserActive();
    }

    public final CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public void setSourceCRS(CoordinateReferenceSystem sourceCRS) {
        this.sourceCRS = sourceCRS;
    }

    public void excludeOsmWayTypesWithoutActivatedModes() {
        this.osmHighwaySettings.excludeOsmWayTypesWithoutActivatedModes();
        this.osmRailwaySettings.excludeOsmWayTypesWithoutActivatedModes();
        this.osmWaterwaySettings.excludeOsmWayTypesWithoutActivatedModes();
    }

    public void setRemoveDanglingSubnetworks(boolean removeDanglingSubnetworks) {
        this.removeDanglingSubNetworks = removeDanglingSubnetworks;
    }

    public boolean isRemoveDanglingSubnetworks() {
        return this.removeDanglingSubNetworks;
    }

    public OsmLaneDefaults getLaneConfiguration() {
        return this.laneConfiguration;
    }

    public Double getDefaultSpeedLimitByOsmWayType(Map<String, String> tags) {
        if (tags.containsKey(OsmHighwayTags.getHighwayKeyTag())) {
            return this.getHighwaySettings().getDefaultSpeedLimitByOsmHighwayType(tags.get(OsmHighwayTags.getHighwayKeyTag()));
        }
        if (tags.containsKey(OsmRailwayTags.getRailwayKeyTag())) {
            return this.getRailwaySettings().getDefaultSpeedLimitByOsmRailwayType(tags.get(OsmRailwayTags.getRailwayKeyTag()));
        }
        if (OsmWaterwayTags.isWaterBasedWay(tags)) {
            return this.getWaterwaySettings().getDefaultSpeedLimitByOsmWaterwayType(tags.get(OsmWaterwayTags.getUsedKeyTag(tags)));
        }
        throw new PlanItRunTimeException("No default speed limit available, tags do not contain activated highway, railway, or waterway key (tags: %s", new Object[]{tags});
    }

    public Integer getDefaultDirectionalLanesByWayType(String osmWayKey, String osmWayValue) {
        return this.laneConfiguration.getDefaultDirectionalLanesByWayType(osmWayKey, osmWayValue);
    }

    public TreeSet<String> getMappedOsmModes(PredefinedModeType planitModeType) {
        TreeSet<String> theModes = this.osmHighwaySettings.getMappedOsmRoadModes(planitModeType);
        TreeSet<String> theOsmRailModes = this.osmRailwaySettings.getMappedOsmRailModes(planitModeType);
        theModes.addAll(theOsmRailModes);
        Collection<String> theOsmWaterModes = this.osmWaterwaySettings.getMappedOsmWaterModes(planitModeType);
        theModes.addAll(theOsmWaterModes);
        return theModes;
    }

    public Set<String> getMappedOsmModes(Collection<PredefinedModeType> planitModeTypes) {
        TreeSet<String> mappedOsmModes = new TreeSet<String>();
        if (planitModeTypes == null) {
            return mappedOsmModes;
        }
        for (PredefinedModeType planitModeType : planitModeTypes) {
            TreeSet<String> theModes = this.getMappedOsmModes(planitModeType);
            if (theModes == null) continue;
            mappedOsmModes.addAll(theModes);
        }
        return mappedOsmModes;
    }

    public PredefinedModeType getMappedPlanitModeType(String osmMode) {
        PredefinedModeType theMode = this.osmHighwaySettings.getMappedPlanitRoadMode(osmMode);
        if (theMode != null) {
            return theMode;
        }
        theMode = this.osmRailwaySettings.getMappedPlanitRailMode(osmMode);
        if (theMode != null) {
            return theMode;
        }
        return this.osmWaterwaySettings.getMappedPlanitWaterMode(osmMode);
    }

    public SortedSet<PredefinedModeType> getActivatedPlanitModeTypes(Collection<String> osmModes) {
        TreeSet<PredefinedModeType> mappedPlanitModes = new TreeSet<PredefinedModeType>();
        if (osmModes == null) {
            return mappedPlanitModes;
        }
        for (String osmMode : osmModes) {
            PredefinedModeType theMode = this.getMappedPlanitModeType(osmMode);
            if (theMode == null) continue;
            mappedPlanitModes.add(theMode);
        }
        return mappedPlanitModes;
    }

    public SortedSet<PredefinedModeType> getActivatedPlanitModeTypes() {
        Stream highWayModes = this.isHighwayParserActive() ? this.getHighwaySettings().getActivatedPlanitModeTypesStream() : Stream.empty();
        Stream railwayModes = this.isRailwayParserActive() ? this.getRailwaySettings().getActivatedPlanitModeTypesStream() : Stream.empty();
        Stream waterwayModes = this.isWaterwayParserActive() ? this.getWaterwaySettings().getActivatedPlanitModeTypesStream() : Stream.empty();
        return Stream.concat(Stream.concat(highWayModes, railwayModes), waterwayModes).collect(Collectors.toCollection(() -> new TreeSet()));
    }

    public boolean hasMappedPlanitModeType(String osmMode) {
        PredefinedModeType mappedMode = this.osmHighwaySettings.getMappedPlanitRoadMode(osmMode);
        if (mappedMode == null) {
            mappedMode = this.osmRailwaySettings.getMappedPlanitRailMode(osmMode);
        }
        if (mappedMode == null) {
            mappedMode = this.osmWaterwaySettings.getMappedPlanitWaterMode(osmMode);
        }
        return mappedMode != null;
    }

    public boolean hasAnyMappedPlanitModeType(String ... osmModes) {
        for (int index = 0; index < osmModes.length; ++index) {
            if (!this.hasMappedPlanitModeType(osmModes[index])) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyMappedPlanitModeType(Collection<String> osmModes) {
        if (osmModes != null) {
            for (String osmMode : osmModes) {
                if (!this.hasMappedPlanitModeType(osmMode)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDiscardDanglingNetworksBelow(int discardBelow) {
        this.discardSubNetworkBelowSize = discardBelow;
    }

    public void setDiscardDanglingNetworksAbove(int discardAbove) {
        this.discardSubNetworkAboveSize = discardAbove;
    }

    public Integer getDiscardDanglingNetworkBelowSize() {
        return this.discardSubNetworkBelowSize;
    }

    public Integer getDiscardDanglingNetworkAboveSize() {
        return this.discardSubNetworkAboveSize;
    }

    public boolean isAlwaysKeepLargestSubnetwork() {
        return this.alwaysKeepLargestsubNetwork;
    }

    public void setAlwaysKeepLargestSubnetwork(boolean alwaysKeepLargestSubnetwork) {
        this.alwaysKeepLargestsubNetwork = alwaysKeepLargestSubnetwork;
    }

    public void deactivateAllOsmWayTypes() {
        this.osmHighwaySettings.deactivateAllOsmHighwayTypes();
        this.osmRailwaySettings.deactivateAllOsmRailwayTypes();
    }

    public void deactivateAllOsmWayTypesExcept(String ... osmWaytypes) {
        this.deactivateAllOsmWayTypesExcept(Arrays.asList(osmWaytypes));
    }

    public void deactivateAllOsmWayTypesExcept(List<String> osmWaytypes) {
        this.deactivateAllOsmWayTypes();
        for (String osmWayType : osmWaytypes) {
            if (OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayType)) {
                this.osmHighwaySettings.activateOsmHighwayTypes(osmWayType);
                continue;
            }
            if (!OsmRailwayTags.isRailBasedRailway(osmWayType)) continue;
            this.osmRailwaySettings.activateOsmRailwayType(osmWayType);
        }
    }

    public void excludeOsmWayFromParsing(Number osmWayId) {
        if (osmWayId.longValue() <= 0L) {
            LOGGER.warning(String.format("invalid OSM way id provided to be excluded, ignored", osmWayId.longValue()));
            return;
        }
        this.excludedOsmWays.add(osmWayId.longValue());
    }

    public void excludeOsmWaysFromParsing(Number ... osmWayIds) {
        this.excludeOsmWaysFromParsing(Arrays.asList(osmWayIds));
    }

    public void excludeOsmWaysFromParsing(List<Number> osmWayIds) {
        if (osmWayIds == null) {
            LOGGER.warning(String.format("OSM way ids are null, ignored excluding them", new Object[0]));
            return;
        }
        osmWayIds.forEach(osmWayId -> this.excludeOsmWayFromParsing(osmWayId.longValue()));
    }

    public boolean isOsmWayExcluded(Number osmWayId) {
        return this.excludedOsmWays.contains(osmWayId.longValue());
    }

    public void overwriteModeAccessByOsmWayId(Number osmWayId, String ... allowedOsmModes) {
        this.overwriteModeAccessByOsmWayId(osmWayId, Arrays.asList(allowedOsmModes));
    }

    public void overwriteModeAccessByOsmWayId(Number osmWayId, List<String> allowedOsmModes) {
        this.overwriteOsmWayModeAccess.put(osmWayId.longValue(), Set.copyOf(allowedOsmModes));
    }

    public boolean isModeAccessOverwrittenByOsmWayId(Number osmWayId) {
        return this.overwriteOsmWayModeAccess.containsKey(osmWayId.longValue());
    }

    public final Set<String> getModeAccessOverwrittenByOsmWayId(Number osmWayId) {
        return this.overwriteOsmWayModeAccess.get(osmWayId.longValue());
    }

    public void logUnsupportedOsmWayTypes() {
        if (this.isHighwayParserActive()) {
            this.osmHighwaySettings.logUnsupportedOsmHighwayTypes();
        }
        if (this.isRailwayParserActive()) {
            this.osmRailwaySettings.logUnsupportedOsmRailwayTypes();
        }
        if (this.isWaterwayParserActive()) {
            this.osmWaterwaySettings.logUnsupportedOsmWayTypes();
        }
    }

    public OsmRailwaySettings getRailwaySettings() {
        return this.osmRailwaySettings;
    }

    public OsmHighwaySettings getHighwaySettings() {
        return this.osmHighwaySettings;
    }

    public OsmWaterwaySettings getWaterwaySettings() {
        return this.osmWaterwaySettings;
    }

    public void setKeepOsmWaysOutsideBoundingPolygon(Number ... osmWays) {
        this.setKeepOsmWaysOutsideBoundingPolygon(Arrays.asList(osmWays));
    }

    public void setKeepOsmWaysOutsideBoundingPolygon(List<Number> osmWays) {
        this.includedOutsideBoundingPolygonOsmWays.addAll(osmWays.stream().map(Number::longValue).collect(Collectors.toList()));
    }

    public boolean hasKeepOsmWaysOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmWays != null && !this.includedOutsideBoundingPolygonOsmWays.isEmpty();
    }

    public boolean isKeepOsmWayOutsideBoundingPolygon(Number osmWayId) {
        return this.includedOutsideBoundingPolygonOsmWays.contains(osmWayId.longValue());
    }

    public void setKeepOsmNodeOutsideBoundingPolygon(Number osmNodeId) {
        this.includedOutsideBoundingPolygonOsmNodes.add(osmNodeId.longValue());
    }

    public int getNumberOfKeepOsmNodesOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmNodes.size();
    }

    public long getNumberOfKeepOsmWaysOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmWays.size();
    }

    public boolean hasKeepOsmNodesOutsideBoundingPolygon() {
        return this.includedOutsideBoundingPolygonOsmNodes != null && !this.includedOutsideBoundingPolygonOsmNodes.isEmpty();
    }

    public boolean isKeepOsmNodeOutsideBoundingPolygon(Number osmNodeId) {
        return this.includedOutsideBoundingPolygonOsmNodes.contains(osmNodeId.longValue());
    }
}

