/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.net.URL;
import java.nio.file.Paths;
import org.goplanit.osm.converter.network.OsmNetworkReader;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;

public class OsmNetworkReaderFactory {
    public static OsmNetworkReader create() {
        return OsmNetworkReaderFactory.create("global");
    }

    public static OsmNetworkReader create(String countryName) {
        return OsmNetworkReaderFactory.create(new OsmNetworkReaderSettings(countryName));
    }

    public static OsmNetworkReader create(String inputFile, String countryName) throws PlanItException {
        try {
            return OsmNetworkReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, new Object[]{inputFile});
        }
    }

    public static OsmNetworkReader create(String inputFile, String countryName, PlanitOsmNetwork osmNetworkToPopulate) throws PlanItException {
        try {
            return OsmNetworkReaderFactory.create(Paths.get(inputFile, new String[0]).toUri().toURL(), countryName, osmNetworkToPopulate);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to convert input file %s to Url", (Throwable)e, new Object[]{inputFile});
        }
    }

    public static OsmNetworkReader create(URL inputQuery, String countryName) {
        OsmNetworkReader reader = OsmNetworkReaderFactory.create(countryName);
        reader.getSettings().setInputSource(inputQuery);
        return reader;
    }

    public static OsmNetworkReader create(URL inputQuery, String countryName, PlanitOsmNetwork osmNetworkToPopulate) {
        OsmNetworkReader reader = new OsmNetworkReader(countryName, osmNetworkToPopulate);
        reader.getSettings().setInputSource(inputQuery);
        return reader;
    }

    public static OsmNetworkReader create(OsmNetworkReaderSettings settings) {
        return new OsmNetworkReader(settings, new PlanitOsmNetwork(IdGroupingToken.collectGlobalToken()));
    }
}

