/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.network.layer.macroscopic.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.OsmNodeData;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class OsmNetworkReaderData {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkReaderData.class.getCanonicalName());
    private final Map<Long, OsmWay> osmCircularWays = new HashMap<Long, OsmWay>();
    private Envelope networkBoundingBox;
    private OsmNodeData osmNodeData = new OsmNodeData();
    private Set<Long> discardedOsmWays = new HashSet<Long>();
    private final Map<MacroscopicNetworkLayer, OsmNetworkLayerParser> osmLayerParsers = new HashMap<MacroscopicNetworkLayer, OsmNetworkLayerParser>();
    public static final double BOUNDINGBOX_NEARNESS_DISTANCE_METERS = 200.0;

    protected void initialiseLayerParsers(PlanitOsmNetwork network, OsmNetworkReaderSettings settings, PlanitJtsCrsUtils geoUtils) {
        for (MacroscopicNetworkLayer macroNetworkLayer : (MacroscopicNetworkLayers)network.getTransportLayers()) {
            OsmNetworkLayerParser layerHandler = new OsmNetworkLayerParser(macroNetworkLayer, this, settings, geoUtils);
            this.osmLayerParsers.put(macroNetworkLayer, layerHandler);
        }
    }

    public void reset() {
        this.clearOsmCircularWays();
        this.osmNodeData.reset();
        this.osmLayerParsers.forEach((layer, handler) -> handler.reset());
        this.osmLayerParsers.clear();
    }

    public void updateBoundingBox(OsmNode osmNode) {
        Coordinate coordinate = OsmNodeUtils.createCoordinate(osmNode);
        if (this.networkBoundingBox == null) {
            this.networkBoundingBox = new Envelope(coordinate);
        } else {
            this.networkBoundingBox.expandToInclude(coordinate);
        }
    }

    public Envelope getBoundingBox() {
        return this.networkBoundingBox;
    }

    public OsmNodeData getOsmNodeData() {
        return this.osmNodeData;
    }

    public Map<Long, OsmWay> getOsmCircularWays() {
        return Collections.unmodifiableMap(this.osmCircularWays);
    }

    public void addOsmCircularWay(OsmWay osmWay) {
        this.osmCircularWays.put(osmWay.getId(), osmWay);
    }

    public void clearOsmCircularWays() {
        this.osmCircularWays.clear();
    }

    public void registerProcessedOsmWayAsUnavailable(long osmWayId) {
        this.discardedOsmWays.add(osmWayId);
    }

    public boolean isOsmWayProcessedAndUnavailable(long osmWayId) {
        return this.discardedOsmWays.contains(osmWayId);
    }

    public final OsmNetworkLayerParser getLayerParser(MacroscopicNetworkLayerImpl networkLayer) {
        return this.osmLayerParsers.get(networkLayer);
    }

    public final Map<MacroscopicNetworkLayer, OsmNetworkLayerParser> getLayerParsers() {
        return this.osmLayerParsers;
    }
}

