/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.access.DefaultOsmHandler;
import de.topobyte.osm4j.core.access.OsmHandler;
import de.topobyte.osm4j.core.access.OsmInputException;
import de.topobyte.osm4j.core.access.OsmReader;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.converter.network.NetworkReader;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.MacroscopicNetworkLayerConfigurator;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkMainProcessingHandler;
import org.goplanit.osm.converter.network.OsmNetworkPreProcessingHandler;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.modifier.event.handler.UpdateConnectoidsOnVertexRemovalHandler;

public class OsmNetworkReader
implements NetworkReader {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkReader.class.getCanonicalName());
    private final OsmNetworkReaderData networkData;
    private final PlanitOsmNetwork osmNetworkToPopulate;
    private final OsmNetworkReaderSettings settings;

    public void initialiseBeforeParsing() {
        PlanItRunTimeException.throwIf((this.getOsmNetworkToPopulate().getTransportLayers() != null && ((MacroscopicNetworkLayers)this.getOsmNetworkToPopulate().getTransportLayers()).size() > 0 ? 1 : 0) != 0, (String)"Network is expected to be empty at start of parsing OSM network, but it has layers already", (Object[])new Object[0]);
        PlanitJtsCrsUtils geoUtils = new PlanitJtsCrsUtils(this.settings.getSourceCRS());
        try {
            this.getOsmNetworkToPopulate().transform(this.settings.getSourceCRS());
        }
        catch (PlanItException e) {
            LOGGER.severe(String.format("Unable to update network to CRS %s", this.settings.getSourceCRS().getName()));
        }
        this.getOsmNetworkToPopulate().createAndRegisterOsmCompatiblePlanitPredefinedModes(this.getSettings());
        if (this.getOsmNetworkToPopulate().getModes().firstMatch(m -> !m.isPredefinedModeType()) != null) {
            throw new PlanItRunTimeException("OSM based PLANit networks currently support only predefined mode mappings, but found custom PLANit mode, this is not allowed");
        }
        MacroscopicNetworkLayerConfigurator planitInfrastructureLayerConfiguration = MacroscopicNetworkLayerConfigurator.createAllInOneConfiguration((Modes)this.osmNetworkToPopulate.getModes());
        this.getOsmNetworkToPopulate().createAndRegisterLayers(planitInfrastructureLayerConfiguration);
        this.getOsmNetworkToPopulate().createAndRegisterOsmCompatibleLinkSegmentTypes(this.getSettings());
        this.settings.excludeOsmWayTypesWithoutActivatedModes();
        this.settings.logUnsupportedOsmWayTypes();
        this.networkData.initialiseLayerParsers(this.getOsmNetworkToPopulate(), this.settings, geoUtils);
    }

    private void read(OsmReader osmReader, DefaultOsmHandler osmHandler) {
        try {
            osmReader.setHandler((OsmHandler)osmHandler);
            osmReader.read();
        }
        catch (OsmInputException e) {
            String cause = e.getCause() != null ? e.getCause().getMessage() : "";
            LOGGER.severe(e.getMessage() + "cause:" + cause);
            throw new PlanItRunTimeException("Error during parsing of OSM file", (Throwable)e);
        }
    }

    private void logInfo() {
        this.getSettings().logSettings();
    }

    private void doPreprocessing() {
        LOGGER.info("Preprocessing: reducing memory footprint, identifying required OSM nodes");
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.settings.getInputSource());
        if (osmReader == null) {
            LOGGER.severe("Unable to create OSM reader for preprocessing network, aborting");
            return;
        }
        OsmNetworkPreProcessingHandler osmHandler = new OsmNetworkPreProcessingHandler(this.getOsmNetworkToPopulate(), this.networkData, this.settings);
        this.read(osmReader, osmHandler);
    }

    private void doMainProcessing() {
        OsmReader osmReader = Osm4JUtils.createOsm4jReader(this.settings.getInputSource());
        if (osmReader == null) {
            LOGGER.severe("Unable to create OSM reader for network, aborting");
            return;
        }
        OsmNetworkMainProcessingHandler osmHandler = new OsmNetworkMainProcessingHandler(this.getOsmNetworkToPopulate(), this.networkData, this.settings);
        this.read(osmReader, osmHandler);
    }

    protected OsmNetworkReaderData getNetworkReaderData() {
        return this.networkData;
    }

    protected void removeDanglingSubNetworks() {
        this.removeDanglingSubNetworks(null);
    }

    public void removeDanglingSubNetworks(Zoning zoning) {
        if (this.settings.isRemoveDanglingSubnetworks()) {
            Integer discardMinsize = this.settings.getDiscardDanglingNetworkBelowSize();
            Integer discardMaxsize = this.settings.getDiscardDanglingNetworkAboveSize();
            boolean keepLargest = this.settings.isAlwaysKeepLargestSubnetwork();
            MacroscopicNetworkLayers layers = (MacroscopicNetworkLayers)this.getOsmNetworkToPopulate().getTransportLayers();
            LOGGER.info(String.format("Removing dangling subnetworks with less than %s vertices", discardMinsize != Integer.MAX_VALUE ? String.valueOf(discardMinsize) : "infinite"));
            if (discardMaxsize != Integer.MAX_VALUE) {
                LOGGER.info(String.format("Removing dangling subnetworks with more than %s vertices", String.valueOf(discardMaxsize)));
            }
            if (zoning == null) {
                LOGGER.info(String.format("Original number of nodes %d, links %d, link segments %d", layers.getNumberOfNodes(), layers.getNumberOfLinks(), layers.getNumberOfLinkSegments()));
            } else {
                LOGGER.info(String.format("Original number of nodes %d, links %d, link segments %d, connectoids %d", layers.getNumberOfNodes(), layers.getNumberOfLinks(), layers.getNumberOfLinkSegments(), zoning.getTransferConnectoids().size()));
            }
            if (layers.size() != 1) {
                LOGGER.warning("Currently OSM networks only support a single infrastructure layer in PLANit");
            }
            UpdateConnectoidsOnVertexRemovalHandler listener = null;
            if (zoning != null) {
                listener = new UpdateConnectoidsOnVertexRemovalHandler(zoning);
                ((MacroscopicNetworkLayer)layers.getFirst()).getLayerModifier().addListener((GraphModifierListener)listener);
            }
            this.getOsmNetworkToPopulate().removeDanglingSubnetworks(discardMinsize, discardMaxsize, keepLargest);
            if (zoning != null) {
                ((MacroscopicNetworkLayer)layers.getFirst()).getLayerModifier().removeListener((GraphModifierListener)listener);
            }
            if (zoning == null) {
                LOGGER.info(String.format("Remaining number of nodes %d, links %d, link segments %d", layers.getNumberOfNodes(), layers.getNumberOfLinks(), layers.getNumberOfLinkSegments()));
            } else {
                LOGGER.info(String.format("Remaining number of nodes %d, links %d, link segments %d, connectoids %d", layers.getNumberOfNodes(), layers.getNumberOfLinks(), layers.getNumberOfLinkSegments(), zoning.getTransferConnectoids().size()));
            }
        }
    }

    protected PlanitOsmNetwork getOsmNetworkToPopulate() {
        return this.osmNetworkToPopulate;
    }

    protected OsmNetworkReader(PlanitOsmNetwork osmNetwork) {
        this("global", osmNetwork);
    }

    protected OsmNetworkReader(String countryName, PlanitOsmNetwork osmNetwork) {
        this(null, countryName, osmNetwork);
    }

    protected OsmNetworkReader(URL inputSource, String countryName, PlanitOsmNetwork osmNetworkToPopulate) {
        this(new OsmNetworkReaderSettings(inputSource, countryName), osmNetworkToPopulate);
    }

    protected OsmNetworkReader(OsmNetworkReaderSettings settings, PlanitOsmNetwork osmNetworkToPopulate) {
        this.settings = settings;
        this.networkData = new OsmNetworkReaderData();
        this.osmNetworkToPopulate = osmNetworkToPopulate;
    }

    public MacroscopicNetwork read() {
        PlanItRunTimeException.throwIfNull((Object)this.getSettings().getInputSource(), (String)"Input source not set for OSM network to parse");
        PlanItRunTimeException.throwIf((boolean)StringUtils.isNullOrBlank((String)this.getSettings().getCountryName()), (String)"Country name not set for OSM network to parse", (Object[])new Object[0]);
        PlanItRunTimeException.throwIfNull((Object)((Object)this.getOsmNetworkToPopulate()), (String)"PLANit network to populate not set for OSM network to parse");
        this.logInfo();
        this.initialiseBeforeParsing();
        this.doPreprocessing();
        this.doMainProcessing();
        if (this.getSettings().isRemoveDanglingSubnetworks()) {
            this.removeDanglingSubNetworks();
        }
        if (!this.osmNetworkToPopulate.isEmpty()) {
            LOGGER.info(String.format("Bounding box of final network: %s", this.getNetworkReaderData().getBoundingBox().toString()));
        }
        LOGGER.info("OSM full network parsing...DONE");
        return this.osmNetworkToPopulate;
    }

    public OsmNetworkReaderSettings getSettings() {
        return this.settings;
    }

    public void reset() {
    }

    public OsmNetworkToZoningReaderData createNetworkToZoningReaderData() {
        if (((MacroscopicNetworkLayers)this.getOsmNetworkToPopulate().getTransportLayers()).size() == 0 || ((MacroscopicNetworkLayer)((MacroscopicNetworkLayers)this.getOsmNetworkToPopulate().getTransportLayers()).getFirst()).isEmpty()) {
            LOGGER.warning("Can only perform network->zoning data transfer when network has been populated by OSM network reader, i.e., first invoke the read() method before this call");
            return null;
        }
        OsmNetworkToZoningReaderData network2zoningData = new OsmNetworkToZoningReaderData(this.networkData, this.getSettings());
        for (Map.Entry<MacroscopicNetworkLayer, OsmNetworkLayerParser> entry : this.networkData.getLayerParsers().entrySet()) {
            OsmNetworkLayerParser layerHandler = entry.getValue();
            network2zoningData.registerLayerData(entry.getKey(), layerHandler.getLayerData());
        }
        return network2zoningData;
    }
}

