/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkBaseHandler;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;

public class OsmNetworkPreProcessingHandler
extends OsmNetworkBaseHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkPreProcessingHandler.class.getCanonicalName());
    private final LongAdder nodeCounter = new LongAdder();

    protected void handleEligibleOsmWay(OsmWay osmWay, Map<String, String> tags) {
        int index;
        OsmNetworkReaderSettings settings = this.getSettings();
        if (settings.hasBoundingPolygon() && settings.isKeepOsmWayOutsideBoundingPolygon(osmWay.getId())) {
            if (settings.isOsmWayExcluded(osmWay.getId())) {
                LOGGER.warning("OSM way %d is marked for exclusion as well as keeping it, this is conflicting, OSM way exclusion takes precedence");
                return;
            }
            for (index = 0; index < osmWay.getNumberOfNodes(); ++index) {
                settings.setKeepOsmNodeOutsideBoundingPolygon(osmWay.getNodeId(index));
            }
        }
        for (index = 0; index < osmWay.getNumberOfNodes(); ++index) {
            this.getNetworkData().getOsmNodeData().preRegisterEligibleOsmNode(osmWay.getNodeId(index));
        }
    }

    public OsmNetworkPreProcessingHandler(PlanitOsmNetwork networkToPopulate, OsmNetworkReaderData networkData, OsmNetworkReaderSettings settings) {
        super(networkToPopulate, networkData, settings);
    }

    public void handle(OsmNode node) {
        this.nodeCounter.increment();
    }

    public void handle(OsmWay osmWay) {
        this.wrapHandleOsmWay(osmWay, this::handleEligibleOsmWay);
    }

    public void complete() throws IOException {
        super.complete();
        int totalOsmNodes = (int)this.nodeCounter.sum();
        int preRegisteredOsmNodes = this.getNetworkData().getOsmNodeData().getRegisteredOsmNodes().size();
        LOGGER.info(String.format("Total OSM nodes in source: %d", totalOsmNodes));
        LOGGER.info(String.format("Total OSM nodes identified as part of network: %d (%.2f%%)", preRegisteredOsmNodes, (double)preRegisteredOsmNodes / (double)totalOsmNodes));
    }

    @Override
    public void reset() {
        super.reset();
    }
}

