/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.network.layer.macroscopic.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.network.OsmNetworkBaseHandler;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.locationtech.jts.geom.Geometry;

public class OsmNetworkMainProcessingHandler
extends OsmNetworkBaseHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkMainProcessingHandler.class.getCanonicalName());

    private boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId) {
        return PlanitNetworkLayerUtils.hasNetworkLayersWithActiveOsmNode(osmNodeId, this.getNetwork(), this.getNetworkData());
    }

    private void handleRawCircularWay(OsmWay circularOsmWay) throws PlanItException {
        Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)circularOsmWay);
        if (this.isActivatedRoadRailOrWaterwayBasedInfrastructure(tags)) {
            if (!OsmWayUtils.isAllOsmWayNodesAvailable(circularOsmWay, this.getNetworkData().getOsmNodeData().getRegisteredOsmNodes())) {
                return;
            }
            Map<NetworkLayer, Set<MacroscopicLink>> createdLinksByLayer = this.handleRawCircularWay(circularOsmWay, tags, 0);
            if (createdLinksByLayer != null) {
                createdLinksByLayer.entrySet().stream().forEach(entry -> {
                    OsmNetworkReaderLayerData layerData = this.getNetworkData().getLayerParsers().get(entry.getKey()).getLayerData();
                    layerData.updateOsmWaysWithMultiplePlanitLinks(circularOsmWay.getId(), (Set)entry.getValue());
                });
            }
        }
    }

    private Map<NetworkLayer, Set<MacroscopicLink>> handleRawCircularWay(OsmWay circularOsmWay, Map<String, String> osmWayTags, int initialNodeIndex) throws PlanItException {
        Map<NetworkLayer, MacroscopicLink> newLinksByLayer;
        TreeMap<NetworkLayer, Set<MacroscopicLink>> createdLinksByLayer = new TreeMap<NetworkLayer, Set<MacroscopicLink>>();
        int finalNodeIndex = circularOsmWay.getNumberOfNodes() - 1;
        Pair<Integer, Integer> firstCircularIndices = OsmWayUtils.findIndicesOfFirstLoop(circularOsmWay, initialNodeIndex);
        if (firstCircularIndices != null) {
            Map<NetworkLayer, Set<MacroscopicLink>> newLinksByLayer2;
            if ((Integer)firstCircularIndices.first() > initialNodeIndex) {
                Map<NetworkLayer, MacroscopicLink> newLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, initialNodeIndex, (Integer)firstCircularIndices.first(), false);
                if (newLinkByLayer != null) {
                    newLinkByLayer.forEach((layer, link) -> {
                        createdLinksByLayer.putIfAbsent((NetworkLayer)layer, new HashSet());
                        ((Set)createdLinksByLayer.get(layer)).add(link);
                    });
                }
                initialNodeIndex = (Integer)firstCircularIndices.first();
            }
            if ((Integer)firstCircularIndices.second() < finalNodeIndex && (newLinksByLayer2 = this.handleRawCircularWay(circularOsmWay, osmWayTags, (Integer)firstCircularIndices.second())) != null) {
                newLinksByLayer2.forEach((layer, links) -> {
                    createdLinksByLayer.putIfAbsent((NetworkLayer)layer, new HashSet());
                    ((Set)createdLinksByLayer.get(layer)).addAll(links);
                });
            }
            if ((newLinksByLayer2 = this.handlePerfectCircularWay(circularOsmWay, osmWayTags, (Integer)firstCircularIndices.first(), (Integer)firstCircularIndices.second())) != null) {
                newLinksByLayer2.forEach((layer, link) -> {
                    createdLinksByLayer.putIfAbsent((NetworkLayer)layer, new HashSet());
                    ((Set)createdLinksByLayer.get(layer)).addAll(link);
                });
            }
        } else if (initialNodeIndex < finalNodeIndex && (newLinksByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, initialNodeIndex, finalNodeIndex, false)) != null) {
            newLinksByLayer.forEach((layer, link) -> {
                createdLinksByLayer.putIfAbsent((NetworkLayer)layer, new HashSet());
                ((Set)createdLinksByLayer.get(layer)).add(link);
            });
        }
        return createdLinksByLayer;
    }

    private Map<NetworkLayer, Set<MacroscopicLink>> handlePerfectCircularWay(OsmWay circularOsmWay, Map<String, String> osmWayTags, int initialNodeIndex, int finalNodeIndex) {
        Map<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> linkSegmentTypesByLayer;
        HashMap<NetworkLayer, Set<MacroscopicLink>> createdLinksByLayer = new HashMap<NetworkLayer, Set<MacroscopicLink>>();
        int firstPartialLinkStartNodeIndex = -1;
        int partialLinkStartNodeIndex = -1;
        int partialLinkEndNodeIndex = -1;
        int numberOfConsideredNodes = finalNodeIndex - initialNodeIndex;
        boolean partialLinksPartOfCircularWay = true;
        for (int index = initialNodeIndex; index <= finalNodeIndex; ++index) {
            Map<NetworkLayer, MacroscopicLink> createdLinkByLayer;
            long osmNodeId = circularOsmWay.getNodeId(index);
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNodeId)) continue;
            if (partialLinkStartNodeIndex < 0) {
                firstPartialLinkStartNodeIndex = partialLinkStartNodeIndex = index;
                continue;
            }
            if (index == finalNodeIndex && partialLinkStartNodeIndex == firstPartialLinkStartNodeIndex || (createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, index, partialLinksPartOfCircularWay)) == null) continue;
            createdLinkByLayer.forEach((layer, link) -> {
                createdLinksByLayer.putIfAbsent((NetworkLayer)layer, new HashSet());
                ((Set)createdLinksByLayer.get(layer)).add(link);
            });
            partialLinkStartNodeIndex = partialLinkEndNodeIndex = index;
        }
        if (partialLinkStartNodeIndex < 0 && (linkSegmentTypesByLayer = this.extractLinkSegmentTypes(circularOsmWay, osmWayTags)) != null && !linkSegmentTypesByLayer.isEmpty() && linkSegmentTypesByLayer.values().stream().findAny().get().anyIsNotNull()) {
            LOGGER.fine(String.format("circular way %d appears to have no connections to activated OSM way types ", circularOsmWay.getId()));
            partialLinkStartNodeIndex = 0;
        }
        Map<NetworkLayer, MacroscopicLink> createdLinkByLayer = null;
        if (partialLinkStartNodeIndex >= 0) {
            if (partialLinkEndNodeIndex < 0) {
                if (partialLinkStartNodeIndex == initialNodeIndex) {
                    partialLinkEndNodeIndex = partialLinkStartNodeIndex + numberOfConsideredNodes / 2;
                } else {
                    partialLinkEndNodeIndex = partialLinkStartNodeIndex;
                    partialLinkStartNodeIndex = initialNodeIndex;
                }
                createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, partialLinkEndNodeIndex, partialLinksPartOfCircularWay);
                if (createdLinkByLayer != null) {
                    createdLinkByLayer.forEach((layer, link) -> {
                        createdLinksByLayer.putIfAbsent((NetworkLayer)layer, new HashSet());
                        ((Set)createdLinksByLayer.get(layer)).add(link);
                    });
                }
                partialLinkStartNodeIndex = partialLinkEndNodeIndex;
                partialLinkEndNodeIndex = finalNodeIndex;
                createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, partialLinkEndNodeIndex, partialLinksPartOfCircularWay);
            } else if (partialLinkEndNodeIndex != finalNodeIndex) {
                partialLinkEndNodeIndex = firstPartialLinkStartNodeIndex;
                createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, partialLinkEndNodeIndex, partialLinksPartOfCircularWay);
            }
            if (createdLinkByLayer != null) {
                createdLinkByLayer.forEach((layer, link) -> ((Set)createdLinksByLayer.get(layer)).add(link));
            }
        }
        return createdLinksByLayer;
    }

    protected Map<NetworkLayer, MacroscopicLinkSegmentType> getDefaultLinkSegmentTypeByOsmWayType(OsmWay osmWay, Map<String, String> tags) {
        String osmTypeKeyToUse = null;
        boolean isExplicitArea = OsmTags.isArea(tags);
        if (isExplicitArea) {
            return null;
        }
        OsmNetworkReaderSettings settings = this.getSettings();
        Function<String, Boolean> isWayActivatedLambda = osmTypeValueToUse -> false;
        Function<String, Boolean> isTypeConfigurationMissingLambda = osmTypeValueToUse -> false;
        if (OsmHighwayTags.hasHighwayKeyTag(tags) && settings.isHighwayParserActive()) {
            osmTypeKeyToUse = OsmHighwayTags.getHighwayKeyTag();
            isWayActivatedLambda = osmTypeValueToUse -> settings.getHighwaySettings().isOsmHighwayTypeDeactivated((String)osmTypeValueToUse);
            isTypeConfigurationMissingLambda = osmTypeValueToUse -> OsmHighwayTags.isNonRoadBasedHighwayValueTag(osmTypeValueToUse);
        } else if (OsmRailwayTags.hasRailwayKeyTag(tags) && settings.isRailwayParserActive()) {
            osmTypeKeyToUse = OsmRailwayTags.getRailwayKeyTag();
            isWayActivatedLambda = osmTypeValueToUse -> settings.getRailwaySettings().isOsmRailwayTypeDeactivated((String)osmTypeValueToUse);
            isTypeConfigurationMissingLambda = osmTypeValueToUse -> OsmRailwayTags.isNonRailBasedRailway(osmTypeValueToUse);
        } else if (OsmWaterwayTags.isWaterBasedWay(tags) && settings.isWaterwayParserActive()) {
            osmTypeKeyToUse = OsmWaterwayTags.getUsedKeyTag(tags);
            isWayActivatedLambda = osmTypeValueToUse -> settings.getWaterwaySettings().isOsmWaterwayTypeActivated((String)osmTypeValueToUse);
            isTypeConfigurationMissingLambda = osmTypeValueToUse -> true;
        }
        if (osmTypeKeyToUse == null) {
            return null;
        }
        String osmTypeValueToUse2 = tags.get(osmTypeKeyToUse);
        Map<NetworkLayer, MacroscopicLinkSegmentType> linkSegmentTypes = this.getNetwork().getDefaultLinkSegmentTypeByOsmTag(osmTypeKeyToUse, osmTypeValueToUse2);
        if (linkSegmentTypes != null) {
            linkSegmentTypes.forEach((layer, linkSegmentType) -> {
                if (linkSegmentType != null) {
                    this.getNetworkData().getLayerParser((MacroscopicNetworkLayerImpl)layer).getLayerData().getProfiler().incrementOsmTagCounter(osmTypeValueToUse2);
                }
            });
        } else if (isWayActivatedLambda.apply(osmTypeValueToUse2).booleanValue() && isTypeConfigurationMissingLambda.apply(osmTypeValueToUse2).booleanValue()) {
            LOGGER.warning(String.format("No link segment type available for : %s:%s (id:%d) --> ignored. Consider explicitly supporting or unsupporting this type", osmTypeKeyToUse, osmTypeValueToUse2, osmWay.getId()));
        }
        return linkSegmentTypes;
    }

    protected void processCircularWays() {
        LOGGER.info("Converting OSM circular ways into multiple link topologies...");
        this.getNetworkData().getOsmCircularWays().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> {
            try {
                this.handleRawCircularWay((OsmWay)entry.getValue());
            }
            catch (PlanItException e) {
                LOGGER.severe(e.getMessage());
                LOGGER.severe(String.format("Unable to process circular way OSM id: %d", entry.getKey()));
            }
        });
        LOGGER.info(String.format("Processed %d circular ways...DONE", this.getNetworkData().getOsmCircularWays().size()));
        this.getNetworkData().clearOsmCircularWays();
    }

    protected void extractOsmWay(OsmWay osmWay, Map<String, String> tags) {
        this.extractPartialOsmWay(osmWay, tags, 0, osmWay.getNumberOfNodes() - 1, false);
    }

    protected Map<NetworkLayer, MacroscopicLink> extractPartialOsmWay(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean isPartOfCircularWay) {
        HashMap<MacroscopicNetworkLayerImpl, MacroscopicLink> linksByLayer = null;
        Map<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> linkSegmentTypesByLayer = this.extractLinkSegmentTypes(osmWay, tags);
        for (Map.Entry<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> entry : linkSegmentTypesByLayer.entrySet()) {
            MacroscopicNetworkLayerImpl networkLayer = entry.getKey();
            Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes = entry.getValue();
            if (linkSegmentTypes == null || !linkSegmentTypes.anyIsNotNull()) continue;
            OsmNetworkLayerParser layerHandler = this.getNetworkData().getLayerParser(networkLayer);
            if (layerHandler == null) {
                throw new PlanItRunTimeException("Layer handler not available, should have been instantiated in PlanitOsmHandler constructor");
            }
            MacroscopicLink link = layerHandler.extractPartialOsmWay(osmWay, tags, startNodeIndex, endNodeIndex, isPartOfCircularWay, linkSegmentTypes);
            if (link == null) continue;
            if (linksByLayer == null) {
                linksByLayer = new HashMap<MacroscopicNetworkLayerImpl, MacroscopicLink>();
            }
            linksByLayer.put(networkLayer, link);
        }
        return linksByLayer;
    }

    protected void handleOsmWay(OsmWay osmWay, Map<String, String> tags) {
        if (OsmWayUtils.isCircularOsmWay(osmWay, tags, false)) {
            this.getNetworkData().addOsmCircularWay(osmWay);
        } else {
            this.extractOsmWay(osmWay, tags);
        }
    }

    public OsmNetworkMainProcessingHandler(PlanitOsmNetwork networkToPopulate, OsmNetworkReaderData networkData, OsmNetworkReaderSettings settings) {
        super(networkToPopulate, networkData, settings);
    }

    public void handle(OsmNode osmNode) {
        OsmNetworkReaderSettings settings = this.getSettings();
        if (osmNode.getId() == 251451479L) {
            int n = 4;
        }
        boolean keepOutsideBoundingPolygon = settings.isKeepOsmNodeOutsideBoundingPolygon(osmNode.getId());
        if (this.getNetworkData().getOsmNodeData().containsPreregisteredOsmNode(osmNode.getId()) && (!settings.hasBoundingPolygon() || keepOutsideBoundingPolygon || OsmNodeUtils.createPoint(osmNode).within((Geometry)settings.getBoundingPolygon()))) {
            this.getNetworkData().getOsmNodeData().registerEligibleOsmNode(osmNode);
            if (!keepOutsideBoundingPolygon) {
                this.getNetworkData().updateBoundingBox(osmNode);
            }
        }
    }

    public void handle(OsmWay osmWay) throws IOException {
        if (osmWay.getId() == 4868934L) {
            int n = 4;
        }
        this.wrapHandleOsmWay(osmWay, this::handleOsmWay);
    }

    protected Map<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> extractLinkSegmentTypes(OsmWay osmWay, Map<String, String> tags) {
        HashMap<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> linkSegmentTypesByLayerByDirection = new HashMap<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>>();
        Map<NetworkLayer, MacroscopicLinkSegmentType> linkSegmentTypesByLayer = this.getDefaultLinkSegmentTypeByOsmWayType(osmWay, tags);
        if (linkSegmentTypesByLayer != null) {
            for (Map.Entry<NetworkLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypesByLayer.entrySet()) {
                MacroscopicNetworkLayerImpl networkLayer = (MacroscopicNetworkLayerImpl)entry.getKey();
                MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> typesPerDirectionPair = this.getNetworkData().getLayerParser(networkLayer).updatedLinkSegmentTypeBasedOnOsmWay(osmWay, tags, linkSegmentType);
                if (typesPerDirectionPair == null) continue;
                linkSegmentTypesByLayerByDirection.put(networkLayer, typesPerDirectionPair);
            }
        }
        return linkSegmentTypesByLayerByDirection;
    }

    public void complete() throws IOException {
        this.processCircularWays();
        this.getNetworkData().getLayerParsers().entrySet().stream().sorted().forEach(entry -> {
            OsmNetworkLayerParser networkLayerHandler = (OsmNetworkLayerParser)entry.getValue();
            networkLayerHandler.complete();
        });
        LOGGER.info(" OSM basic network parsing...DONE");
    }

    @Override
    public void reset() {
        this.getNetworkData().reset();
    }
}

