/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.graph.directed.modifier.event.handler.SyncXmlIdToIdBreakEdgeSegmentHandler;
import org.goplanit.graph.modifier.event.handler.SyncXmlIdToIdBreakEdgeHandler;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesFactory;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkLayerModeConversion;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.ModifiedLinkSegmentTypes;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmLaneTags;
import org.goplanit.osm.tags.OsmOneWayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.osm.util.PlanitOsmUtils;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;

public class OsmNetworkLayerParser {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkLayerParser.class.getCanonicalName());
    private final OsmNetworkReaderLayerData layerData;
    private final ModifiedLinkSegmentTypes modifiedLinkSegmentTypes = new ModifiedLinkSegmentTypes();
    private final OsmNetworkReaderData networkData;
    private final OsmNetworkReaderSettings settings;
    private final MacroscopicNetworkLayer networkLayer;
    private final OsmNetworkLayerModeConversion modeParser;
    private final PlanitJtsCrsUtils geoUtils;
    private final SyncXmlIdToIdBreakEdgeHandler syncXmlIdToIdOnBreakLink = new SyncXmlIdToIdBreakEdgeHandler();
    private final SyncXmlIdToIdBreakEdgeSegmentHandler syncXmlIdToIdOnBreakLinkSegment = new SyncXmlIdToIdBreakEdgeSegmentHandler();

    private void initialiseEventListeners() {
        this.networkLayer.getLayerModifier().removeAllListeners();
        this.networkLayer.getLayerModifier().addListener((GraphModifierListener)this.syncXmlIdToIdOnBreakLink);
        this.networkLayer.getLayerModifier().addListener((GraphModifierListener)this.syncXmlIdToIdOnBreakLinkSegment);
    }

    private boolean isNearNetworkBoundingBox(Geometry geometry, PlanitJtsCrsUtils geoUtils) {
        return geoUtils.isGeometryNearBoundingBox(geometry, this.networkData.getBoundingBox(), 200.0);
    }

    private MacroscopicLinkSegmentType updateExistingLinkSegmentType(Set<Mode> toBeAddedModes, Set<Mode> toBeRemovedModes, Map<String, String> tags, MacroscopicLinkSegmentType linkSegmentType) {
        if (toBeAddedModes.isEmpty() && toBeRemovedModes.isEmpty()) {
            return linkSegmentType;
        }
        if (linkSegmentType.getAllowedModes().size() + toBeAddedModes.size() - toBeRemovedModes.size() <= 0) {
            return linkSegmentType;
        }
        MacroscopicLinkSegmentType finalLinkSegmentType = this.modifiedLinkSegmentTypes.getModifiedLinkSegmentType(linkSegmentType, toBeAddedModes, toBeRemovedModes);
        if (finalLinkSegmentType == null) {
            finalLinkSegmentType = (MacroscopicLinkSegmentType)this.networkLayer.getLinkSegmentTypes().getFactory().createUniqueDeepCopyOf((ManagedId)linkSegmentType);
            this.networkLayer.getLinkSegmentTypes().register((Object)finalLinkSegmentType);
            finalLinkSegmentType.setXmlId(Long.toString(finalLinkSegmentType.getId()));
            String MODIFIED = "_modified";
            if (finalLinkSegmentType.hasExternalId()) {
                finalLinkSegmentType.setExternalId(finalLinkSegmentType.getExternalId() + "_modified");
            }
            if (finalLinkSegmentType.hasName()) {
                finalLinkSegmentType.setExternalId(finalLinkSegmentType.getName() + "_modified");
            }
            if (!toBeAddedModes.isEmpty()) {
                double osmWayTypeMaxSpeed = this.settings.getDefaultSpeedLimitByOsmWayType(tags);
                for (Mode newMode : toBeAddedModes) {
                    double modeMaxSpeedOnLinkType = Math.min(newMode.getMaximumSpeedKmH(), osmWayTypeMaxSpeed);
                    AccessGroupProperties accessGroup = AccessGroupPropertiesFactory.create((double)modeMaxSpeedOnLinkType, (Mode[])new Mode[]{newMode});
                    AccessGroupProperties matchedGroup = linkSegmentType.findEqualAccessPropertiesForAnyMode(accessGroup);
                    if (matchedGroup != null) {
                        finalLinkSegmentType.registerModeOnAccessGroup(newMode, accessGroup);
                        continue;
                    }
                    AccessGroupPropertiesFactory.createOnLinkSegmentType((MacroscopicLinkSegmentType)finalLinkSegmentType, (Mode)newMode, (double)modeMaxSpeedOnLinkType);
                }
            }
            if (!toBeRemovedModes.isEmpty()) {
                finalLinkSegmentType.removeModeAccess(toBeRemovedModes);
            }
            this.modifiedLinkSegmentTypes.addModifiedLinkSegmentType(linkSegmentType, finalLinkSegmentType, toBeAddedModes, toBeRemovedModes);
        }
        return finalLinkSegmentType;
    }

    private void registerLinkInternalOsmNodes(MacroscopicLink link, int startIndex, int endIndex, OsmWay osmWay) {
        for (int internalLocationIndex = startIndex; internalLocationIndex <= endIndex; ++internalLocationIndex) {
            OsmNode osmnode = this.networkData.getOsmNodeData().getRegisteredOsmNode(osmWay.getNodeId(internalLocationIndex));
            if (osmnode != null) {
                this.layerData.registerOsmNodeAsInternalToPlanitLink(osmnode, link);
                continue;
            }
            LOGGER.fine(String.format("OSM node %d not available although internal to parseable OSM way %d, possibly outside bounding box", osmWay.getNodeId(internalLocationIndex), osmWay.getId()));
        }
    }

    private MacroscopicLink createAndPopulateLink(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean allowTruncationIfGeometryIncomplete) {
        if (startNodeIndex < 0 || startNodeIndex >= osmWay.getNumberOfNodes()) {
            throw new PlanItRunTimeException("Invalid start node index %d when extracting link from Osm way %s", new Object[]{startNodeIndex, osmWay.getId()});
        }
        if (endNodeIndex < 0 || endNodeIndex >= osmWay.getNumberOfNodes()) {
            throw new PlanItRunTimeException("Invalid end node index %d when extracting link from Osm way %s", new Object[]{startNodeIndex, osmWay.getId()});
        }
        Pair<Node, Integer> nodeFirstResult = this.extractFirstNode(osmWay, startNodeIndex, allowTruncationIfGeometryIncomplete);
        Pair<Node, Integer> nodeLastResult = null;
        int foundStartNodeIndex = startNodeIndex;
        if (nodeFirstResult != null && nodeFirstResult.first() != null) {
            foundStartNodeIndex = (Integer)nodeFirstResult.second();
            nodeLastResult = this.extractLastNode(osmWay, foundStartNodeIndex, endNodeIndex, allowTruncationIfGeometryIncomplete);
        }
        if (nodeLastResult == null && nodeFirstResult == null) {
            this.networkData.registerProcessedOsmWayAsUnavailable(osmWay.getId());
            return null;
        }
        if (nodeLastResult == null || nodeFirstResult == null || ((Node)nodeLastResult.first()).idEquals(nodeFirstResult.first())) {
            LOGGER.fine(String.format("DISCARD: OSM way %d truncated to single node, unable to create PLANit link for it", osmWay.getId()));
            this.networkData.registerProcessedOsmWayAsUnavailable(osmWay.getId());
            return null;
        }
        Node nodeFirst = (Node)nodeFirstResult.first();
        Node nodeLast = (Node)nodeLastResult.first();
        LineString lineString = null;
        try {
            lineString = this.extractPartialLinkGeometry(osmWay, (Integer)nodeFirstResult.second(), (Integer)nodeLastResult.second());
        }
        catch (PlanItException e) {
            LOGGER.fine(String.format("OSM way %s internal geometry incomplete, one or more internal nodes could not be created, likely outside bounding box", osmWay.getId()));
            return null;
        }
        MacroscopicLink link = null;
        if (nodeFirst != null) {
            Set potentialEdges = nodeFirst.getEdges((Vertex)nodeLast);
            for (Edge potentialEdge : potentialEdges) {
                MacroscopicLink potentialLink = (MacroscopicLink)potentialEdge;
                if (link == null || !potentialLink.getGeometry().equals((Geometry)lineString)) continue;
                link = potentialLink;
                break;
            }
        }
        if (link == null) {
            link = PlanitNetworkLayerUtils.createPopulateAndRegisterLink(nodeFirst, nodeLast, lineString, this.networkLayer, String.valueOf(osmWay.getId()), tags.get("name"), this.geoUtils);
            OsmNetworkHandlerHelper.setLinkOsmWayType((Link)link, OsmWayUtils.findWayTypeValueForEligibleKey(tags));
            OsmNetworkHandlerHelper.setLinkVerticalLayerIndex(link, tags);
        }
        return link;
    }

    private MacroscopicLinkSegmentType extractDirectionalLinkSegmentTypeByOsmWay(OsmWay osmWay, Map<String, String> tags, MacroscopicLinkSegmentType linkSegmentType, boolean forwardDirection) {
        Set toBeAddedModes = null;
        Set toBeRemovedModes = null;
        if (this.settings.isModeAccessOverwrittenByOsmWayId(osmWay.getId())) {
            Set<Mode> allowedPlanitModes = this.modeParser.getActivatedPlanitModes(this.settings.getModeAccessOverwrittenByOsmWayId(osmWay.getId()));
            if (!allowedPlanitModes.isEmpty()) {
                allowedPlanitModes.retainAll(this.networkLayer.getSupportedModes().stream().filter(m -> m.isPredefinedModeType()).collect(Collectors.toList()));
            }
            toBeAddedModes = linkSegmentType.getDisallowedModesFrom(allowedPlanitModes);
            toBeRemovedModes = linkSegmentType.getAllowedModesNotIn(allowedPlanitModes);
        } else {
            boolean accessTagAppliesToExploredDirection;
            Set<Mode> excludedModes = this.modeParser.getExplicitlyExcludedModes(tags, forwardDirection, this.settings);
            Set<Mode> includedModes = this.modeParser.getExplicitlyIncludedModes(tags, forwardDirection, this.settings);
            boolean isOneWay = OsmOneWayTags.isOneWay(tags);
            boolean bl = accessTagAppliesToExploredDirection = !isOneWay || forwardDirection || OsmOneWayTags.isReversedOneWay(tags);
            if (accessTagAppliesToExploredDirection && tags.containsKey("access")) {
                this.modeParser.updateAccessKeyBasedModeRestrictions(tags, includedModes, excludedModes);
            }
            if (!includedModes.isEmpty()) {
                includedModes.retainAll(this.networkLayer.getSupportedModes());
            }
            toBeAddedModes = linkSegmentType.getDisallowedModesFrom(includedModes);
            toBeRemovedModes = linkSegmentType.getAllowedModesFrom(excludedModes);
        }
        MacroscopicLinkSegmentType finalLinkSegmentType = this.updateExistingLinkSegmentType(toBeAddedModes, toBeRemovedModes, tags, linkSegmentType);
        return finalLinkSegmentType;
    }

    private LineString extractPartialLinkGeometry(OsmWay osmWay, int startNodeIndex, int endNodeIndex) throws PlanItException {
        LineString lineString = OsmWayUtils.extractLineStringNoThrow(osmWay, startNodeIndex, endNodeIndex, this.networkData.getOsmNodeData().getRegisteredOsmNodes());
        lineString = PlanitJtsUtils.createCopyWithoutAdjacentDuplicateCoordinates((LineString)lineString);
        return lineString;
    }

    private Pair<Double, Double> extractDirectionalSpeedLimits(Link link, Map<String, String> tags) {
        Double speedLimitForwardKmh = null;
        Double speedLimitBackwardKmh = null;
        Double nonDirectionalSpeedLimitKmh = null;
        boolean useNonDirectionalDefault = false;
        try {
            double[] maxSpeedLimitLanes;
            if (tags.containsKey("maxspeed:backward") || tags.containsKey("maxspeed:backward:lanes")) {
                if (tags.containsKey("maxspeed:backward")) {
                    speedLimitBackwardKmh = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(tags.get("maxspeed:backward"));
                }
                if (tags.containsKey("maxspeed:backward:lanes")) {
                    maxSpeedLimitLanes = PlanitOsmUtils.parseMaxSpeedValueLanesKmPerHour(tags.get("maxspeed:backward:lanes"));
                    speedLimitBackwardKmh = ArrayUtils.getMaximum((double[])maxSpeedLimitLanes);
                }
            }
            if (tags.containsKey("maxspeed:forward") || tags.containsKey("maxspeed:forward:lanes")) {
                if (tags.containsKey("maxspeed:forward")) {
                    speedLimitForwardKmh = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(tags.get("maxspeed:forward"));
                }
                if (tags.containsKey("maxspeed:forward:lanes")) {
                    maxSpeedLimitLanes = PlanitOsmUtils.parseMaxSpeedValueLanesKmPerHour(tags.get("maxspeed:forward:lanes"));
                    speedLimitForwardKmh = ArrayUtils.getMaximum((double[])maxSpeedLimitLanes);
                }
            }
            if (speedLimitBackwardKmh == null || speedLimitForwardKmh == null) {
                if (tags.containsKey("maxspeed")) {
                    nonDirectionalSpeedLimitKmh = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(tags.get("maxspeed"));
                } else if (tags.containsKey("maxspeed:lanes")) {
                    maxSpeedLimitLanes = PlanitOsmUtils.parseMaxSpeedValueLanesKmPerHour(tags.get("maxspeed:lanes"));
                    nonDirectionalSpeedLimitKmh = ArrayUtils.getMaximum((double[])maxSpeedLimitLanes);
                } else {
                    useNonDirectionalDefault = true;
                }
            }
        }
        catch (PlanItException e) {
            LOGGER.warning(e.getMessage());
            LOGGER.info(String.format("Reverting to default speed limit for OSM way (id:%s)", link.getExternalId()));
            useNonDirectionalDefault = true;
        }
        if (useNonDirectionalDefault) {
            nonDirectionalSpeedLimitKmh = this.settings.getDefaultSpeedLimitByOsmWayType(tags);
            this.layerData.getProfiler().incrementMissingSpeedLimitCounter();
        }
        if (nonDirectionalSpeedLimitKmh != null) {
            speedLimitForwardKmh = speedLimitForwardKmh == null ? nonDirectionalSpeedLimitKmh : speedLimitForwardKmh;
            speedLimitBackwardKmh = speedLimitBackwardKmh == null ? nonDirectionalSpeedLimitKmh : speedLimitBackwardKmh;
        } else if (speedLimitForwardKmh == null && speedLimitBackwardKmh == null) {
            throw new PlanItRunTimeException(String.format("no default speed limit available for OSM way %s", link.getExternalId()));
        }
        return Pair.of((Object)speedLimitForwardKmh, (Object)speedLimitBackwardKmh);
    }

    private Pair<Integer, Integer> extractDirectionalHighwayLanes(Map<String, String> tags) {
        Integer totalLanes = null;
        Integer lanesForward = null;
        Integer lanesBackward = null;
        if (tags.containsKey("lanes")) {
            totalLanes = Integer.parseInt(tags.get("lanes"));
        }
        if (tags.containsKey(OsmLaneTags.LANES_FORWARD)) {
            lanesForward = Integer.parseInt(tags.get(OsmLaneTags.LANES_FORWARD));
        }
        if (tags.containsKey(OsmLaneTags.LANES_BACKWARD)) {
            lanesBackward = Integer.parseInt(tags.get(OsmLaneTags.LANES_BACKWARD));
        }
        if (totalLanes != null && (lanesForward == null || lanesBackward == null) && OsmOneWayTags.isOneWay(tags)) {
            boolean isReversedOneWay = OsmOneWayTags.isReversedOneWay(tags);
            if (isReversedOneWay && lanesBackward == null) {
                lanesBackward = totalLanes;
            } else if (!isReversedOneWay && lanesForward == null) {
                lanesForward = totalLanes;
            } else if (lanesForward == null && lanesBackward == null && totalLanes % 2 == 0) {
                lanesForward = lanesBackward = Integer.valueOf(totalLanes / 2);
            }
        }
        return Pair.of((Object)lanesForward, lanesBackward);
    }

    private Pair<Integer, Integer> extractDirectionalRailwayLanes(Map<String, String> tags) {
        Integer lanesForward = null;
        Integer lanesBackward = null;
        if (tags.containsKey("tracks")) {
            lanesBackward = lanesForward = Integer.valueOf(Integer.parseInt(tags.get("tracks")));
        }
        return Pair.of(lanesForward, lanesBackward);
    }

    private Pair<Integer, Integer> extractDirectionalWaterwayLanes(Map<String, String> tags) {
        String usedKeyTag = OsmWaterwayTags.getUsedKeyTag(tags);
        Integer defaultLanes = this.settings.getDefaultDirectionalLanesByWayType(usedKeyTag, tags.get(usedKeyTag));
        this.layerData.getProfiler().incrementMissingLaneCounter();
        return Pair.of((Object)defaultLanes, (Object)defaultLanes);
    }

    private Pair<Integer, Integer> extractDirectionalLanes(Link link, Map<String, String> tags, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes) {
        Integer lanesForward;
        Pair result = null;
        String osmWayKey = null;
        try {
            if (tags.containsKey(OsmHighwayTags.getHighwayKeyTag())) {
                osmWayKey = OsmHighwayTags.getHighwayKeyTag();
                result = this.extractDirectionalHighwayLanes(tags);
            } else if (tags.containsKey(OsmRailwayTags.getRailwayKeyTag())) {
                osmWayKey = OsmRailwayTags.getRailwayKeyTag();
                result = this.extractDirectionalRailwayLanes(tags);
            } else if (OsmWaterwayTags.isWaterBasedWay(tags)) {
                osmWayKey = OsmWaterwayTags.getUsedKeyTag(tags);
                result = this.extractDirectionalWaterwayLanes(tags);
            }
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Something went wrong when parsing number of lanes for OSM way (id:%s), possible tagging error, reverting to default bi-direactional configuration", link.getExternalId()));
        }
        boolean missingLaneInformation = false;
        if (result == null || result.bothNull()) {
            lanesForward = this.settings.getDefaultDirectionalLanesByWayType(osmWayKey, tags.get(osmWayKey));
            result = Pair.of((Object)lanesForward, (Object)lanesForward);
            this.layerData.getProfiler().incrementMissingLaneCounter();
        }
        if (result.first() == null && linkSegmentTypes.first() != null) {
            lanesForward = this.settings.getDefaultDirectionalLanesByWayType(osmWayKey, tags.get(osmWayKey));
            result = Pair.of((Object)lanesForward, (Object)((Integer)result.second()));
            missingLaneInformation = true;
        }
        if (result.second() == null && linkSegmentTypes.second() != null) {
            Integer lanesBackward = this.settings.getDefaultDirectionalLanesByWayType(osmWayKey, tags.get(osmWayKey));
            result = Pair.of((Object)((Integer)result.first()), (Object)lanesBackward);
            missingLaneInformation = true;
        }
        if (missingLaneInformation) {
            this.layerData.getProfiler().incrementMissingLaneCounter();
        }
        return result;
    }

    private MacroscopicLinkSegment extractMacroscopicLinkSegment(OsmWay osmWay, Map<String, String> tags, MacroscopicLink link, MacroscopicLinkSegmentType linkSegmentType, boolean directionAb, Double speedLimit, Integer numLanes) {
        MacroscopicLinkSegment linkSegment = PlanitNetworkLayerUtils.createPopulateAndRegisterLinkSegment(link, directionAb, linkSegmentType, speedLimit, numLanes, this.networkLayer);
        this.layerData.getProfiler().logLinkSegmentStatus(this.networkLayer.getNumberOfLinkSegments());
        return linkSegment;
    }

    private void extractMacroscopicLinkSegments(OsmWay osmWay, Map<String, String> tags, MacroscopicLink link, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes) {
        MacroscopicLinkSegmentType linkSegmentTypeBa;
        MacroscopicLinkSegmentType linkSegmentTypeAb;
        boolean directionAbIsForward;
        boolean bl = directionAbIsForward = link.isGeometryInAbDirection();
        if (!directionAbIsForward) {
            LOGGER.warning("DirectionAB is not forward in geometry SHOULD NOT HAPPEN!");
        }
        Pair<Double, Double> speedLimits = this.extractDirectionalSpeedLimits((Link)link, tags);
        Pair<Integer, Integer> lanes = this.extractDirectionalLanes((Link)link, tags, linkSegmentTypes);
        MacroscopicLinkSegmentType macroscopicLinkSegmentType = linkSegmentTypeAb = directionAbIsForward ? (MacroscopicLinkSegmentType)linkSegmentTypes.first() : (MacroscopicLinkSegmentType)linkSegmentTypes.second();
        if (linkSegmentTypeAb != null) {
            Double speedLimit = directionAbIsForward ? (Double)speedLimits.first() : (Double)speedLimits.second();
            Integer numLanes = directionAbIsForward ? (Integer)lanes.first() : (Integer)lanes.second();
            this.extractMacroscopicLinkSegment(osmWay, tags, link, linkSegmentTypeAb, true, speedLimit, numLanes);
        }
        MacroscopicLinkSegmentType macroscopicLinkSegmentType2 = linkSegmentTypeBa = directionAbIsForward ? (MacroscopicLinkSegmentType)linkSegmentTypes.second() : (MacroscopicLinkSegmentType)linkSegmentTypes.first();
        if (linkSegmentTypeBa != null) {
            Double speedLimit = directionAbIsForward ? (Double)speedLimits.second() : (Double)speedLimits.first();
            Integer numLanes = directionAbIsForward ? (Integer)lanes.second() : (Integer)lanes.first();
            this.extractMacroscopicLinkSegment(osmWay, tags, link, linkSegmentTypeBa, false, speedLimit, numLanes);
        }
    }

    private Pair<Node, Integer> extractFirstNode(OsmWay osmWay, Integer startNodeIndex, boolean changeStartNodeIndexIfNotPresent) {
        Node nodeFirst = this.extractNode(osmWay.getNodeId(startNodeIndex.intValue()));
        if (nodeFirst == null && changeStartNodeIndexIfNotPresent) {
            if ((startNodeIndex = OsmWayUtils.findFirstAvailableOsmNodeIndexAfter(startNodeIndex, osmWay, this.networkData.getOsmNodeData().getRegisteredOsmNodes())) != null) {
                nodeFirst = this.extractNode(osmWay.getNodeId(startNodeIndex.intValue()));
                if (nodeFirst != null && !this.isNearNetworkBoundingBox((Geometry)nodeFirst.getPosition(), this.geoUtils)) {
                    LOGGER.warning(String.format("SALVAGED: OSM way %s geometry incomplete, likely cut-off by network bounding box, truncated at OSM node %s", osmWay.getId(), nodeFirst.getExternalId()));
                }
            } else {
                return null;
            }
        }
        return Pair.of((Object)nodeFirst, (Object)startNodeIndex);
    }

    private Pair<Node, Integer> extractLastNode(OsmWay osmWay, Integer startNodeIndex, Integer endNodeIndex, boolean changeEndNodeIndexIfNotPresent) {
        Node nodeLast = this.extractNode(osmWay.getNodeId(endNodeIndex.intValue()));
        if (nodeLast == null && changeEndNodeIndexIfNotPresent) {
            endNodeIndex = OsmWayUtils.findLastAvailableOsmNodeIndexAfter(startNodeIndex, osmWay, this.networkData.getOsmNodeData().getRegisteredOsmNodes());
            if (endNodeIndex != null) {
                nodeLast = this.extractNode(osmWay.getNodeId(endNodeIndex.intValue()));
                if (nodeLast != null && !this.isNearNetworkBoundingBox((Geometry)nodeLast.getPosition(), this.geoUtils)) {
                    LOGGER.fine(String.format("OSM way %s not fully available, likely due to network bounding box, please verify, truncated at osm node %s", osmWay.getId(), nodeLast.getExternalId()));
                }
            } else {
                return null;
            }
        }
        return Pair.of((Object)nodeLast, (Object)endNodeIndex);
    }

    private Node extractNode(long osmNodeId) {
        OsmNode osmNode = this.networkData.getOsmNodeData().getRegisteredOsmNode(osmNodeId);
        if (osmNode == null) {
            return null;
        }
        Node node = this.layerData.getPlanitNodeByOsmNode(osmNode);
        if (node == null) {
            node = PlanitNetworkLayerUtils.createPopulateAndRegisterNode(osmNode, this.networkLayer, this.layerData);
        }
        return node;
    }

    private MacroscopicLink extractLink(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean allowTruncationIfGeometryIncomplete) {
        MacroscopicLink link = this.createAndPopulateLink(osmWay, tags, startNodeIndex, endNodeIndex, allowTruncationIfGeometryIncomplete);
        if (link != null) {
            if (allowTruncationIfGeometryIncomplete) {
                startNodeIndex = OsmWayUtils.getOsmWayNodeIndexByLocation(osmWay, link.getNodeA().getPosition(), this.networkData);
                endNodeIndex = OsmWayUtils.getOsmWayNodeIndexByLocation(osmWay, link.getNodeB().getPosition(), this.networkData);
            }
            this.registerLinkInternalOsmNodes(link, startNodeIndex + 1, endNodeIndex - 1, osmWay);
            this.layerData.getProfiler().logLinkStatus(this.networkLayer.getNumberOfLinks());
        }
        return link;
    }

    protected Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> updatedLinkSegmentTypeBasedOnOsmWay(OsmWay osmWay, Map<String, String> tags, MacroscopicLinkSegmentType linkSegmentType) {
        boolean forwardDirection = true;
        MacroscopicLinkSegmentType forwardDirectionLinkSegmentType = this.extractDirectionalLinkSegmentTypeByOsmWay(osmWay, tags, linkSegmentType, forwardDirection);
        MacroscopicLinkSegmentType backwardDirectionLinkSegmentType = this.extractDirectionalLinkSegmentTypeByOsmWay(osmWay, tags, linkSegmentType, !forwardDirection);
        return Pair.of((Object)forwardDirectionLinkSegmentType, (Object)backwardDirectionLinkSegmentType);
    }

    protected OsmNetworkLayerParser(MacroscopicNetworkLayer networkLayer, OsmNetworkReaderData networkData, OsmNetworkReaderSettings settings, PlanitJtsCrsUtils geoUtils) {
        this.networkLayer = networkLayer;
        this.networkData = networkData;
        this.geoUtils = geoUtils;
        this.settings = settings;
        this.layerData = new OsmNetworkReaderLayerData();
        this.modeParser = new OsmNetworkLayerModeConversion(settings, networkLayer);
        this.initialiseEventListeners();
    }

    public MacroscopicLink extractPartialOsmWay(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean isPartOfCircularWay, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes) {
        boolean allowGeometryTruncation;
        MacroscopicLink link = null;
        if (linkSegmentTypes != null && linkSegmentTypes.anyIsNotNull() && (link = this.extractLink(osmWay, tags, startNodeIndex, endNodeIndex, allowGeometryTruncation = !isPartOfCircularWay)) != null) {
            if (isPartOfCircularWay) {
                linkSegmentTypes = OsmWayUtils.isCircularWayDefaultDirectionClockwise(this.settings.getCountryName()) ? Pair.of((Object)((MacroscopicLinkSegmentType)linkSegmentTypes.first()), null) : Pair.of(null, (Object)((MacroscopicLinkSegmentType)linkSegmentTypes.second()));
            }
            this.extractMacroscopicLinkSegments(osmWay, tags, link, linkSegmentTypes);
        }
        return link;
    }

    protected boolean breakLinksWithInternalNode(Node thePlanitNode) {
        if (this.layerData.isLocationInternalToAnyLink(thePlanitNode.getPosition())) {
            List<MacroscopicLink> linksToBreak = this.layerData.findPlanitLinksWithInternalLocation(thePlanitNode.getPosition());
            Map newOsmWaysWithMultipleLinks = this.networkLayer.getLayerModifier().breakAt(linksToBreak, (DirectedVertex)thePlanitNode, this.geoUtils.getCoordinateReferenceSystem(), l -> Long.parseLong(l.getExternalId()));
            this.layerData.updateOsmWaysWithMultiplePlanitLinks(newOsmWaysWithMultipleLinks);
            return true;
        }
        return false;
    }

    protected void breakLinksWithInternalConnections() {
        LOGGER.info("Breaking OSM ways with internal connections into multiple links ...");
        long nodeIndex = -1L;
        long originalNumberOfNodes = this.networkLayer.getNumberOfNodes();
        HashSet<Long> processedOsmNodeIds = new HashSet<Long>();
        while (++nodeIndex < originalNumberOfNodes) {
            Node node = (Node)this.networkLayer.getNodes().get(nodeIndex);
            boolean linksBroken = this.breakLinksWithInternalNode(node);
            if (!linksBroken) continue;
            processedOsmNodeIds.add(Long.valueOf(node.getExternalId()));
        }
        Set<OsmNode> osmNodesInternalToPlanitLinks = this.layerData.getRegisteredOsmNodesInternalToAnyPlanitLink(2);
        osmNodesInternalToPlanitLinks.stream().sorted(Comparator.comparing(OsmEntity::getId)).forEach(osmNode -> {
            if (!processedOsmNodeIds.contains(osmNode.getId())) {
                Node planitIntersectionNode = this.extractNode(osmNode.getId());
                if (planitIntersectionNode == null) {
                    LOGGER.severe(String.format("OSM node %d internal to one or more OSM ways could not be extracted as PLANit node when breaking links at its location, this should not happen", osmNode.getId()));
                }
                this.breakLinksWithInternalNode(planitIntersectionNode);
            }
        });
        LOGGER.info(String.format("Broke %d OSM ways into multiple links...DONE", this.getLayerData().getNumberOfOsmWaysWithMultiplePlanitLinks()));
    }

    public void logOsmProfileInformation() {
        this.layerData.getProfiler().logOsmProfileInformation(this.networkLayer);
    }

    public void logPlanitStatsInformation() {
        this.layerData.getProfiler().logPlanitStats(this.networkLayer);
    }

    public void reset() {
        this.layerData.reset();
        this.modifiedLinkSegmentTypes.reset();
        this.initialiseEventListeners();
    }

    public void complete() {
        this.logOsmProfileInformation();
        this.breakLinksWithInternalConnections();
        this.networkLayer.validate();
        this.logPlanitStatsInformation();
    }

    public OsmNetworkReaderLayerData getLayerData() {
        return this.layerData;
    }
}

