/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.converter.OsmModeConversionBase;
import org.goplanit.osm.converter.helper.OsmLanesModeTaggingSchemeHelper;
import org.goplanit.osm.converter.helper.OsmModeLanesTaggingSchemeHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.tags.OsmAccessTags;
import org.goplanit.osm.tags.OsmBicycleTags;
import org.goplanit.osm.tags.OsmBusWayTags;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmJunctionTags;
import org.goplanit.osm.tags.OsmLaneTags;
import org.goplanit.osm.tags.OsmPedestrianTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmRoadModeCategoryTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;

public class OsmNetworkLayerModeConversion
extends OsmModeConversionBase {
    private final MacroscopicNetworkLayer networkLayer;
    private OsmLanesModeTaggingSchemeHelper lanesModeSchemeHelper = null;
    private OsmModeLanesTaggingSchemeHelper modeLanesSchemeHelper = null;

    private Collection<? extends Mode> getModesForDirection(Map<String, String> tags, boolean isForwardDirection, boolean included) {
        String osmDirectionCondition = isForwardDirection ? "forward" : "backward";
        String[] accessValueTags = included ? OsmAccessTags.getPositiveAccessValueTags() : OsmAccessTags.getNegativeAccessValueTags();
        Set<Mode> foundModes = this.getActivatedPlanitModes(OsmModeUtils.getPostfixedOsmRoadModesWithValueTag(osmDirectionCondition, tags, accessValueTags));
        return foundModes;
    }

    private Collection<? extends Mode> getExplicitlyIncludedModesForDirection(Map<String, String> tags, boolean isForwardDirection) {
        return this.getModesForDirection(tags, isForwardDirection, true);
    }

    private Collection<? extends Mode> getExplicitlyExcludedModesForDirection(Map<String, String> tags, boolean isForwardDirection) {
        return this.getModesForDirection(tags, isForwardDirection, false);
    }

    private Set<Mode> getExplicitlyIncludedModesNonOneWay(Map<String, String> tags) {
        return this.getActivatedPlanitModes(OsmModeUtils.getPrefixedOsmRoadModesWithValueTag("oneway", tags, "no"));
    }

    private Set<Mode> getExplicitlyIncludedModesTwoWayForLocation(Map<String, String> tags, boolean isDrivingDirectionLocationLeft) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitModeType("bicycle")) {
            if (OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, "cycleway")) {
                includedModes.add(this.getActivatedPlanitMode("bicycle"));
            } else {
                String[] stringArray = new String[1];
                String string = stringArray[0] = isDrivingDirectionLocationLeft ? OsmBicycleTags.CYCLEWAY_LEFT : OsmBicycleTags.CYCLEWAY_RIGHT;
                if (OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, stringArray)) {
                    includedModes.add(this.getActivatedPlanitMode("bicycle"));
                } else if (OsmBicycleTags.isNoOneWayCyclewayInAnyLocation(tags)) {
                    includedModes.add(this.getActivatedPlanitMode("bicycle"));
                }
            }
        }
        if (this.getSettings().hasAnyMappedPlanitModeType("bus")) {
            String[] stringArray = new String[1];
            String string = stringArray[0] = isDrivingDirectionLocationLeft ? OsmBusWayTags.BUSWAY_LEFT : OsmBusWayTags.BUSWAY_LEFT;
            if (OsmLaneTags.isLaneIncludedForAnyOf(tags, stringArray)) {
                includedModes.add(this.getActivatedPlanitMode("bus"));
            }
        }
        return includedModes;
    }

    private Collection<? extends Mode> getExplicitlyExcludedModesTwoWayForLocation(Map<String, String> tags, boolean isDrivingDirectionLocationLeft) {
        HashSet<Mode> excludedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitModeType("bicycle")) {
            String[] stringArray = new String[1];
            String string = stringArray[0] = isDrivingDirectionLocationLeft ? OsmBicycleTags.CYCLEWAY_LEFT : OsmBicycleTags.CYCLEWAY_RIGHT;
            if (OsmBicycleTags.isCyclewayExcludedForAnyOf(tags, stringArray)) {
                excludedModes.add(this.getActivatedPlanitMode("bicycle"));
            }
        }
        return excludedModes;
    }

    private Collection<? extends Mode> getExplicitlyIncludedModesOneWayMainDirection(Map<String, String> tags) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        if (this.lanesModeSchemeHelper != null && this.lanesModeSchemeHelper.hasEligibleModes()) {
            this.lanesModeSchemeHelper.getModesWithLanesWithoutDirection(tags).forEach(osmMode -> includedModes.add(this.getActivatedPlanitMode((String)osmMode)));
        }
        if (this.modeLanesSchemeHelper != null && this.modeLanesSchemeHelper.hasEligibleModes()) {
            this.modeLanesSchemeHelper.getModesWithLanesWithoutDirection(tags).forEach(osmMode -> includedModes.add(this.getActivatedPlanitMode((String)osmMode)));
        }
        if (this.getSettings().hasAnyMappedPlanitModeType("bicycle") && OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, OsmBicycleTags.CYCLEWAY_LEFT, OsmBicycleTags.CYCLEWAY_RIGHT)) {
            includedModes.add(this.getActivatedPlanitMode("bicycle"));
        }
        if (this.getSettings().hasAnyMappedPlanitModeType("bus") && OsmLaneTags.isLaneIncludedForAnyOf(tags, OsmBusWayTags.BUSWAY_LEFT, OsmBusWayTags.BUSWAY_RIGHT)) {
            includedModes.add(this.getActivatedPlanitMode("bus"));
        }
        return includedModes;
    }

    private Set<Mode> getExplicitlyExcludedModesOneWayMainDirection(Map<String, String> tags) {
        HashSet<Mode> excludedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitModeType("bicycle") && OsmBicycleTags.isCyclewayExcludedForAnyOf(tags, OsmBicycleTags.CYCLEWAY_LEFT, OsmBicycleTags.CYCLEWAY_RIGHT)) {
            excludedModes.add(this.getActivatedPlanitMode("bicycle"));
        }
        return excludedModes;
    }

    private Set<Mode> getExplicitlyIncludedModesOneWayOppositeDirection(Map<String, String> tags) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        if (this.getSettings().hasAnyMappedPlanitModeType("bicycle") && OsmBicycleTags.isOppositeCyclewayIncludedForAnyOf(tags, OsmBicycleTags.getCycleWayKeyTags(false))) {
            includedModes.add(this.getActivatedPlanitMode("bicycle"));
        }
        if (this.getSettings().hasAnyMappedPlanitModeType("bus") && OsmLaneTags.isOppositeLaneIncludedForAnyOf(tags, OsmBusWayTags.getBuswaySchemeKeyTags())) {
            includedModes.add(this.getActivatedPlanitMode("bus"));
        }
        return includedModes;
    }

    private Collection<? extends Mode> getExplicitlyExcludedModesOneWayOppositeDirection() {
        Collection<String> excludedModes = OsmRoadModeCategoryTags.getRoadModesByCategory("vehicle");
        excludedModes.addAll(OsmRailModeTags.getSupportedRailModeTags());
        return this.getActivatedPlanitModes(excludedModes);
    }

    private Set<Mode> getExplicitlyIncludedModesOneWayAgnostic(Map<String, String> tags, boolean isForwardDirection) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        includedModes.addAll(this.getExplicitlyIncludedModesNonOneWay(tags));
        includedModes.addAll(this.getExplicitlyIncludedModesForDirection(tags, isForwardDirection));
        if (this.lanesModeSchemeHelper != null && this.lanesModeSchemeHelper.hasEligibleModes()) {
            this.lanesModeSchemeHelper.getModesWithLanesInDirection(tags, isForwardDirection).forEach(osmMode -> includedModes.add(this.getActivatedPlanitMode((String)osmMode)));
        }
        if (this.modeLanesSchemeHelper != null && this.modeLanesSchemeHelper.hasEligibleModes()) {
            this.modeLanesSchemeHelper.getModesWithLanesInDirection(tags, isForwardDirection).forEach(osmMode -> includedModes.add(this.getActivatedPlanitMode((String)osmMode)));
        }
        if (this.getSettings().hasAnyMappedPlanitModeType("bicycle") && OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, OsmBicycleTags.CYCLEWAY_BOTH)) {
            includedModes.add(this.getActivatedPlanitMode("bicycle"));
        }
        if (this.getSettings().hasMappedPlanitModeType("foot") && OsmPedestrianTags.hasExplicitlyIncludedSidewalkOrFootway(tags)) {
            includedModes.add(this.getActivatedPlanitMode("foot"));
        }
        return includedModes;
    }

    private Set<Mode> getExplicitlyExcludedModesOneWayAgnostic(Map<String, String> tags, boolean isForwardDirection, OsmNetworkReaderSettings settings) {
        Set<Object> excludedModes = new HashSet();
        if (OsmJunctionTags.isPartOfCircularWayJunction(tags) && OsmWayUtils.isCircularWayDirectionClosed(tags, isForwardDirection, settings.getCountryName())) {
            excludedModes.addAll(this.networkLayer.getSupportedModes());
        } else {
            excludedModes = this.getActivatedPlanitModes(OsmModeUtils.getOsmRoadModesWithValueTag(tags, OsmAccessTags.getNegativeAccessValueTags()));
            excludedModes.addAll(this.getExplicitlyExcludedModesForDirection(tags, isForwardDirection));
            if (settings.hasAnyMappedPlanitModeType("bicycle") && OsmBicycleTags.isCyclewayExcludedForAnyOf(tags, "cycleway", OsmBicycleTags.CYCLEWAY_BOTH)) {
                excludedModes.add(this.getActivatedPlanitMode("bicycle"));
            }
            if (settings.hasMappedPlanitModeType("foot") && OsmPedestrianTags.hasExplicitlyExcludedSidewalkOrFootway(tags)) {
                excludedModes.add(this.getActivatedPlanitMode("foot"));
            }
        }
        return excludedModes;
    }

    public OsmNetworkLayerModeConversion(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        super(settings, networkLayer.getSupportedModes());
        this.networkLayer = networkLayer;
        if (OsmLanesModeTaggingSchemeHelper.requireLanesModeSchemeHelper(settings, networkLayer)) {
            this.lanesModeSchemeHelper = new OsmLanesModeTaggingSchemeHelper(OsmLanesModeTaggingSchemeHelper.getEligibleLanesModeSchemeHelperModes(settings, networkLayer));
        }
        if (OsmModeLanesTaggingSchemeHelper.requireLanesModeSchemeHelper(settings, networkLayer)) {
            this.modeLanesSchemeHelper = new OsmModeLanesTaggingSchemeHelper(OsmModeLanesTaggingSchemeHelper.getEligibleModeLanesSchemeHelperModes(settings, networkLayer));
        }
    }

    public Set<Mode> getExplicitlyIncludedModes(Map<String, String> tags, boolean isForwardDirection, OsmNetworkReaderSettings settings) {
        HashSet<Mode> includedModes = new HashSet<Mode>();
        includedModes.addAll(this.getExplicitlyIncludedModesOneWayAgnostic(tags, isForwardDirection));
        boolean exploreOneWayOppositeDirection = false;
        if (tags.containsKey("oneway")) {
            String osmDirectionValue;
            String oneWayValueTag = tags.get("oneway");
            String string = osmDirectionValue = isForwardDirection ? "-1" : "yes";
            if (oneWayValueTag.equals(osmDirectionValue)) {
                exploreOneWayOppositeDirection = true;
                includedModes.addAll(this.getExplicitlyIncludedModesOneWayOppositeDirection(tags));
            } else if (OsmTagUtils.matchesAnyValueTag(oneWayValueTag, "-1", "yes")) {
                includedModes.addAll(this.getExplicitlyIncludedModesOneWayMainDirection(tags));
            }
        } else {
            boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive((String)settings.getCountryName());
            boolean isDrivingDirectionLocationLeft = isForwardDirection && isLeftHandDrive;
            includedModes.addAll(this.getExplicitlyIncludedModesTwoWayForLocation(tags, isDrivingDirectionLocationLeft));
        }
        if (!exploreOneWayOppositeDirection) {
            includedModes.addAll(this.getActivatedPlanitModes(OsmModeUtils.getOsmRoadModesWithValueTag(tags, OsmAccessTags.getPositiveAccessValueTags())));
            includedModes.addAll(this.getActivatedPlanitModes(OsmModeUtils.getPrefixedOsmRoadModesWithValueTag("access", tags, OsmAccessTags.getPositiveAccessValueTags())));
        }
        return includedModes;
    }

    public Set<Mode> getExplicitlyExcludedModes(Map<String, String> tags, boolean isForwardDirection, OsmNetworkReaderSettings settings) {
        HashSet<Mode> excludedModes = new HashSet<Mode>();
        excludedModes.addAll(this.getExplicitlyExcludedModesOneWayAgnostic(tags, isForwardDirection, settings));
        if (tags.containsKey("oneway")) {
            String osmDirectionValue;
            String oneWayValueTag = tags.get("oneway");
            String string = osmDirectionValue = isForwardDirection ? "-1" : "yes";
            if (oneWayValueTag.equals(osmDirectionValue)) {
                excludedModes.addAll(this.getExplicitlyExcludedModesOneWayOppositeDirection());
            } else if (OsmTagUtils.matchesAnyValueTag(oneWayValueTag, "-1", "yes")) {
                excludedModes.addAll(this.getExplicitlyExcludedModesOneWayMainDirection(tags));
            }
        } else {
            boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive((String)settings.getCountryName());
            boolean isDrivingDirectionLocationLeft = isForwardDirection && isLeftHandDrive;
            excludedModes.addAll(this.getExplicitlyExcludedModesTwoWayForLocation(tags, isDrivingDirectionLocationLeft));
        }
        return excludedModes;
    }

    public void updateAccessKeyBasedModeRestrictions(Map<String, String> tags, Set<Mode> includedModesToUpdate, Set<Mode> excludedModesToUpdate) {
        String accessValue = tags.get("access").replaceAll("[^\\w\\s]", "");
        if (OsmTagUtils.matchesAnyValueTag(accessValue, OsmAccessTags.getPositiveAccessValueTags())) {
            Collection<String> osmAllowedModesForWayType = null;
            if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
                osmAllowedModesForWayType = this.getSettings().getHighwaySettings().collectAllowedOsmHighwayModes(tags.get(OsmHighwayTags.getHighwayKeyTag()));
            } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
                osmAllowedModesForWayType = this.getSettings().getRailwaySettings().collectAllowedOsmRailwayModes(tags.get(OsmRailwayTags.getRailwayKeyTag()));
            } else if (OsmWaterwayTags.isWaterBasedWay(tags)) {
                String waterKey = OsmWaterwayTags.getUsedKeyTag(tags);
                osmAllowedModesForWayType = this.getSettings().getWaterwaySettings().collectAllowedOsmWaterwayModes(tags.get(waterKey));
            }
            if (osmAllowedModesForWayType != null) {
                Set<Mode> allowedModes = this.getActivatedPlanitModes(osmAllowedModesForWayType);
                allowedModes.retainAll(this.networkLayer.getSupportedModes());
                includedModesToUpdate.addAll(allowedModes);
            }
            includedModesToUpdate.removeAll(excludedModesToUpdate);
        } else if (OsmTagUtils.matchesAnyValueTag(accessValue, OsmRoadModeTags.getSupportedRoadModeTagsAsArray()) || OsmTagUtils.matchesAnyValueTag(accessValue, OsmRailModeTags.getSupportedRailModeTagsAsArray())) {
            includedModesToUpdate.add(this.getActivatedPlanitMode(accessValue));
            excludedModesToUpdate.addAll(this.networkLayer.getSupportedModes());
            excludedModesToUpdate.removeAll(includedModesToUpdate);
        } else if (OsmTagUtils.matchesAnyValueTag(accessValue, OsmAccessTags.getNegativeAccessValueTags())) {
            excludedModesToUpdate.addAll(this.networkLayer.getSupportedModes());
            excludedModesToUpdate.removeAll(includedModesToUpdate);
        }
    }
}

