/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.physical.Link;

public class OsmNetworkHandlerHelper {
    public static final Logger LOGGER = Logger.getLogger(OsmNetworkHandlerHelper.class.getCanonicalName());
    protected static final String LINK_OSMWAY_TYPE_PROPERTY_KEY = "osm_way_type";
    protected static final String LINK_OSM_LAYER_PROPERTY_KEY = "osm_vertical_layer_index";

    public static void setLinkOsmWayType(Link link, String osmWayType) {
        link.addInputProperty(LINK_OSMWAY_TYPE_PROPERTY_KEY, (Object)osmWayType);
    }

    public static String getLinkOsmWayType(Link link) {
        Object value = link.getInputProperty(LINK_OSMWAY_TYPE_PROPERTY_KEY);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public static int getLinkVerticalLayerIndex(Link link) {
        Object value = link.getInputProperty(LINK_OSM_LAYER_PROPERTY_KEY);
        return value == null ? 0 : (Integer)value;
    }

    public static int getMostFrequentVerticalLayerIndex(Collection<? extends Link> links) {
        Map<Integer, Long> valueCountPerLayerIndex = links.stream().collect(Collectors.groupingBy(l -> OsmNetworkHandlerHelper.getLinkVerticalLayerIndex(l), Collectors.counting()));
        Integer layerIdWithHighestCount = (Integer)((Map.Entry)valueCountPerLayerIndex.entrySet().stream().max((entry1, entry2) -> (Long)entry1.getValue() > (Long)entry2.getValue() ? 1 : -1).get()).getKey();
        return layerIdWithHighestCount;
    }

    public static void setLinkVerticalLayerIndex(MacroscopicLink link, Map<String, String> tags) {
        if (!OsmTagUtils.containsAnyKey(tags, "layer")) {
            return;
        }
        Integer layerValue = OsmTagUtils.getValueAsInt(tags, "layer");
        link.addInputProperty(LINK_OSM_LAYER_PROPERTY_KEY, (Object)layerValue);
    }

    public static void addAllTo(Map<Long, Set<MacroscopicLink>> addition, Map<Long, Set<MacroscopicLink>> destination) {
        addition.forEach((osmWayId, links) -> {
            destination.putIfAbsent((Long)osmWayId, new HashSet());
            ((Set)destination.get(osmWayId)).addAll(links);
        });
    }
}

