/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.access.DefaultOsmHandler;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmTags;
import org.goplanit.osm.tags.OsmWaterwayTags;
import org.goplanit.utils.exceptions.PlanItRunTimeException;

public abstract class OsmNetworkBaseHandler
extends DefaultOsmHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkBaseHandler.class.getCanonicalName());
    private final PlanitOsmNetwork networkToPopulate;
    private final OsmNetworkReaderData networkData;
    private final OsmNetworkReaderSettings settings;

    protected OsmNetworkBaseHandler(PlanitOsmNetwork networkToPopulate, OsmNetworkReaderData networkData, OsmNetworkReaderSettings settings) {
        this.networkToPopulate = networkToPopulate;
        this.settings = settings;
        this.networkData = networkData;
    }

    protected boolean isActivatedRoadRailOrWaterwayBasedInfrastructure(Map<String, String> tags) {
        if (!OsmTags.isArea(tags)) {
            if (this.settings.isHighwayParserActive() && OsmHighwayTags.hasHighwayKeyTag(tags)) {
                return this.settings.getHighwaySettings().isOsmHighwayTypeActivated(tags.get(OsmHighwayTags.getHighwayKeyTag()));
            }
            if (this.settings.isRailwayParserActive() && OsmRailwayTags.hasRailwayKeyTag(tags)) {
                return this.settings.getRailwaySettings().isOsmRailwayTypeActivated(tags.get(OsmRailwayTags.getRailwayKeyTag()));
            }
            if (this.settings.isWaterwayParserActive() && OsmWaterwayTags.isWaterBasedWay(tags)) {
                return this.settings.getWaterwaySettings().isOsmWaterwayTypeActivated(tags.get(OsmWaterwayTags.getUsedKeyTag(tags)));
            }
        }
        return false;
    }

    protected void wrapHandleOsmWay(OsmWay osmWay, BiConsumer<OsmWay, Map<String, String>> osmWayConsumer) {
        if (!this.settings.isOsmWayExcluded(osmWay.getId())) {
            Map tags = OsmModelUtil.getTagsAsMap((OsmEntity)osmWay);
            try {
                if (this.isActivatedRoadRailOrWaterwayBasedInfrastructure(tags)) {
                    osmWayConsumer.accept(osmWay, tags);
                }
            }
            catch (PlanItRunTimeException e) {
                LOGGER.severe(e.getMessage());
                LOGGER.severe(String.format("Error during parsing of OSM way (id:%d)", osmWay.getId()));
            }
        }
    }

    protected OsmNetworkReaderSettings getSettings() {
        return this.settings;
    }

    protected OsmNetworkReaderData getNetworkData() {
        return this.networkData;
    }

    protected PlanitOsmNetwork getNetwork() {
        return this.networkToPopulate;
    }

    public void reset() {
    }
}

