/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmWaySettings;
import org.goplanit.osm.defaults.OsmHighwayTypeConfiguration;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.PredefinedModeType;

public class OsmHighwaySettings
extends OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmHighwaySettings.class.getCanonicalName());
    OsmSpeedLimitDefaultsCategory nonUrbanSpeedLimitDefaults;
    protected final Map<String, Pair<Double, Double>> overwriteByOsmHighwayType = new HashMap<String, Pair<Double, Double>>();
    protected String defaultOsmHighwayTypeWhenUnsupported = DEFAULT_HIGHWAY_TYPE_WHEN_UNSUPPORTED;
    protected boolean speedLimitDefaultsBasedOnUrbanArea = DEFAULT_SPEEDLIMIT_BASED_ON_URBAN_AREA;
    public static String DEFAULT_HIGHWAY_TYPE_WHEN_UNSUPPORTED = "tertiary";
    public static boolean DEFAULT_SPEEDLIMIT_BASED_ON_URBAN_AREA = true;
    public static boolean DEFAULT_HIGHWAYS_PARSER_ACTIVE = true;

    protected void initialiseDefaultMappingFromOsmRoadModes2PlanitModes() {
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("foot", PredefinedModeType.PEDESTRIAN);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("bicycle", PredefinedModeType.BICYCLE);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("motorcycle", PredefinedModeType.MOTOR_BIKE);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("motorcar", PredefinedModeType.CAR);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("goods", PredefinedModeType.GOODS_VEHICLE);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("hgv", PredefinedModeType.HEAVY_GOODS_VEHICLE);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("hgv_articulated", PredefinedModeType.LARGE_HEAVY_GOODS_VEHICLE);
        this.addDefaultOsmMode2PlanitPredefinedModeTypeMapping("bus", PredefinedModeType.BUS);
        this.activateOsmMode("foot");
        this.activateOsmMode("bicycle");
        this.activateOsmMode("motorcycle");
        this.activateOsmMode("motorcar");
        this.activateOsmMode("goods");
        this.activateOsmMode("hgv");
        this.activateOsmMode("hgv_articulated");
        this.activateOsmMode("bus");
    }

    protected Collection<String> collectAllowedOsmWayModes(String osmWayValueType) {
        HashSet<String> allowedModes = null;
        if (OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayValueType)) {
            Set<String> allowedRoadModesOnRoad = this.collectAllowedOsmWayModes(OsmHighwayTags.getHighwayKeyTag(), osmWayValueType, OsmRoadModeTags.getSupportedRoadModeTags());
            Set<String> allowedRailModesOnRoad = this.collectAllowedOsmWayModes(OsmHighwayTags.getHighwayKeyTag(), osmWayValueType, OsmRailModeTags.getSupportedRailModeTags());
            allowedModes = new HashSet<String>();
            allowedModes.addAll(allowedRoadModesOnRoad);
            allowedModes.addAll(allowedRailModesOnRoad);
        } else {
            LOGGER.warning(String.format("Unrecognised osm highway key value type %s=%s, no allowed modes can be identified", OsmHighwayTags.getHighwayKeyTag(), osmWayValueType));
        }
        return allowedModes;
    }

    protected OsmHighwaySettings(OsmSpeedLimitDefaultsCategory urbanSpeedLimitDefaults, OsmSpeedLimitDefaultsCategory nonUrbanSpeedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessHighwayDefaults) {
        super(new OsmHighwayTypeConfiguration(), urbanSpeedLimitDefaults, osmModeAccessHighwayDefaults);
        this.activateParser(DEFAULT_HIGHWAYS_PARSER_ACTIVE);
        this.nonUrbanSpeedLimitDefaults = nonUrbanSpeedLimitDefaults;
    }

    public final String getDefaultOsmHighwayTypeWhenUnsupported() {
        return this.defaultOsmHighwayTypeWhenUnsupported;
    }

    public void setDefaultWhenOsmHighwayTypeUnsupported(String defaultOsmHighwayValueWhenUnsupported) {
        this.defaultOsmHighwayTypeWhenUnsupported = defaultOsmHighwayValueWhenUnsupported;
    }

    public final boolean isApplyDefaultWhenOsmHighwayTypeDeactivated() {
        return this.defaultOsmHighwayTypeWhenUnsupported == null;
    }

    public final void removeOsmHighwayTypeWhenUnsupported() {
        this.defaultOsmHighwayTypeWhenUnsupported = null;
    }

    public boolean isOsmHighwayTypeDeactivated(String osmHighwayValue) {
        return this.isOsmWayTypeDeactivated(osmHighwayValue);
    }

    public boolean isOsmHighwayTypeActivated(String osmWayValue) {
        return this.isOsmWayTypeActivated(osmWayValue);
    }

    public void deactivateOsmHighwayType(String osmWayValue) {
        this.deactivateOsmWayType(osmWayValue);
    }

    public void deactivateAllOsmHighwayTypes() {
        this.deactivateAllOsmWayTypes();
    }

    public void deactivateAllOsmHighwayTypesExcept(String ... osmHighwayTypes) {
        this.deactivateAllOsmHighwayTypesExcept(List.of(osmHighwayTypes));
    }

    public void deactivateAllOsmHighwayTypesExcept(List<String> osmHighwayTypes) {
        this.deactivateAllOsmHighwayTypes();
        for (String osmWayType : osmHighwayTypes) {
            if (!OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayType)) continue;
            this.activateOsmHighwayTypes(osmWayType);
        }
    }

    public void activateOsmHighwayType(String osmWayValue) {
        this.activateOsmWayType(osmWayValue);
    }

    public void activateOsmHighwayTypes(String ... osmHighwayValueTypes) {
        this.activateOsmHighwayTypes(Arrays.asList(osmHighwayValueTypes));
    }

    public void activateOsmHighwayTypes(List<String> osmHighwayValueTypes) {
        this.activateOsmWayTypes(osmHighwayValueTypes);
    }

    public void activateAllOsmHighwayTypes() {
        this.activateAllOsmWayTypes();
    }

    public void overwriteCapacityMaxDensityDefaults(String osmHighwayType, Number capacityPerLanePerHour, Number maxDensityPerLane) {
        this.overwriteOsmWayTypeDefaultCapacityMaxDensity("highway", osmHighwayType, capacityPerLanePerHour.doubleValue(), maxDensityPerLane.doubleValue());
    }

    public final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmHighwayType(String osmWayType) {
        return this.getOverwrittenCapacityMaxDensityByOsmWayType(osmWayType);
    }

    public boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmHighwayType(String osmWayType) {
        return this.isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(osmWayType);
    }

    public boolean isSpeedLimitDefaultsBasedOnUrbanArea() {
        return this.speedLimitDefaultsBasedOnUrbanArea;
    }

    public void setSpeedLimitDefaultsBasedOnUrbanArea(boolean speedLimitDefaultsBasedOnUrbanArea) {
        this.speedLimitDefaultsBasedOnUrbanArea = speedLimitDefaultsBasedOnUrbanArea;
    }

    public double getDefaultSpeedLimitByOsmHighwayType(String osmWayValue) {
        if (this.isSpeedLimitDefaultsBasedOnUrbanArea()) {
            return this.getDefaultSpeedLimitByOsmTypeValue(OsmHighwayTags.getHighwayKeyTag(), osmWayValue);
        }
        return this.nonUrbanSpeedLimitDefaults.getSpeedLimit(OsmHighwayTags.getHighwayKeyTag(), osmWayValue);
    }

    public void activateOsmRoadMode(String osmRoadMode) {
        if (!OsmRoadModeTags.isRoadModeTag(osmRoadMode)) {
            LOGGER.warning(String.format("OSM road mode %s is not recognised when adding it to OSM to PLANit mode mapping, ignored", osmRoadMode));
            return;
        }
        this.activateOsmMode(osmRoadMode);
    }

    public void deactivateOsmRoadMode(String osmRoadMode) {
        if (!OsmRoadModeTags.isRoadModeTag(osmRoadMode)) {
            LOGGER.warning(String.format("osm road mode %s is not recognised when removing it from OSM to PLANit mode mapping, ignored", osmRoadMode));
            return;
        }
        this.deactivateOsmMode(osmRoadMode);
    }

    public void deactivateOsmRoadModes(List<String> osmRoadModes) {
        if (osmRoadModes == null) {
            return;
        }
        osmRoadModes.forEach(osmRoadMode -> this.deactivateOsmRoadMode((String)osmRoadMode));
    }

    public void deactivateAllOsmRoadModesExcept(String ... deactivateAllRoadModesExcept) {
        List<String> exceptionList = null;
        exceptionList = deactivateAllRoadModesExcept == null ? new ArrayList<String>(0) : Arrays.asList(deactivateAllRoadModesExcept);
        this.deactivateAllOsmRoadModesExcept(exceptionList);
    }

    public void deactivateAllOsmRoadModesExcept(List<String> remainingOsmRoadModes) {
        Collection<String> toBeRemovedModes = OsmRoadModeTags.getSupportedRoadModeTags();
        this.deactivateAllModesExcept(toBeRemovedModes, remainingOsmRoadModes);
    }

    public void deactivateOsmRoadModes(String ... osmRoadModes) {
        this.deactivateOsmRoadModes(Arrays.asList(osmRoadModes));
    }

    public void removeAllRoadModes() {
        this.deactivateAllOsmRoadModesExcept((String[])null);
    }

    public PredefinedModeType getMappedPlanitRoadMode(String osmMode) {
        if (OsmRoadModeTags.isRoadModeTag(osmMode)) {
            return this.getPlanitModeTypeIfActivated(osmMode);
        }
        return null;
    }

    public final TreeSet<String> getMappedOsmRoadModes(PredefinedModeType planitModeType) {
        return this.getAcivatedOsmModes(planitModeType);
    }

    public Collection<String> collectAllowedOsmHighwayModes(String osmHighwayValueType) {
        return this.collectAllowedOsmWayModes(osmHighwayValueType);
    }

    public void addAllowedOsmHighwayModes(String osmHighwayType, String ... osmModes) {
        this.addAllowedOsmHighwayModes(osmHighwayType, Arrays.asList(osmModes));
    }

    public void addAllowedOsmHighwayModes(String osmHighwayType, List<String> osmModes) {
        this.addAllowedOsmWayModes(OsmHighwayTags.getHighwayKeyTag(), osmHighwayType, osmModes);
    }

    public void logUnsupportedOsmHighwayTypes() {
        this.logUnsupportedOsmWayTypes();
    }

    @Override
    public void logSettings() {
        LOGGER.info(String.format("Highway (road) parser activated: %s", this.isParserActive()));
    }
}

