/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.intermodal;

import java.net.URL;
import org.goplanit.converter.ConverterReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

public class OsmIntermodalReaderSettings
implements ConverterReaderSettings {
    protected final OsmNetworkReaderSettings networkSettings;
    protected final OsmPublicTransportReaderSettings zoningPtSettings;

    public OsmIntermodalReaderSettings(String countryName) {
        this((URL)null, countryName);
    }

    public OsmIntermodalReaderSettings(String inputSource, String countryName) {
        this(UrlUtils.createFrom((String)inputSource), countryName);
    }

    public OsmIntermodalReaderSettings(URL inputSource, String countryName) {
        this(new OsmNetworkReaderSettings(inputSource, countryName), new OsmPublicTransportReaderSettings(inputSource, countryName));
        this.getNetworkSettings().getRailwaySettings().activateParser(true);
        this.getNetworkSettings().getWaterwaySettings().activateParser(true);
    }

    public OsmIntermodalReaderSettings(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings zoningPtSettings) {
        this.networkSettings = networkSettings;
        this.zoningPtSettings = zoningPtSettings;
    }

    public void reset() {
        this.networkSettings.reset();
        this.zoningPtSettings.reset();
    }

    public void logSettings() {
        this.networkSettings.logSettings();
        this.zoningPtSettings.logSettings();
    }

    public OsmNetworkReaderSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public OsmPublicTransportReaderSettings getPublicTransportSettings() {
        return this.zoningPtSettings;
    }

    public void setInputSource(URL inputSource) {
        this.getNetworkSettings().setInputSource(inputSource);
        this.getPublicTransportSettings().setInputSource(inputSource);
    }

    public void setInputFile(String inputFile) {
        try {
            this.setInputSource(UrlUtils.createFromLocalPath((String)inputFile));
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to extract URL from input file location %s", new Object[]{inputFile});
        }
    }

    public final void setBoundingBox(Number x1, Number x2, Number y1, Number y2) {
        this.setBoundingBox(new Envelope(PlanitJtsUtils.createPoint((Number)x1, (Number)y1).getCoordinate(), PlanitJtsUtils.createPoint((Number)x2, (Number)y2).getCoordinate()));
    }

    public final void setBoundingBox(Envelope boundingBox) {
        this.setBoundingPolygon(PlanitJtsUtils.create2DPolygon((Envelope)boundingBox));
    }

    public final void setBoundingPolygon(Polygon boundingPolygon) {
        this.getNetworkSettings().setBoundingPolygon(boundingPolygon);
        this.getPublicTransportSettings().setBoundingPolygon(boundingPolygon);
    }
}

