/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.intermodal;

import java.net.URL;
import java.util.logging.Logger;
import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.osm.converter.intermodal.OsmIntermodalReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkReader;
import org.goplanit.osm.converter.network.OsmNetworkReaderFactory;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReader;
import org.goplanit.osm.converter.zoning.OsmZoningReaderFactory;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.PlanitZoningUtils;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.Quadruple;
import org.goplanit.zoning.Zoning;

public class OsmIntermodalReader
implements IntermodalReader<ServiceNetwork, RoutedServices> {
    private static final Logger LOGGER = Logger.getLogger(OsmIntermodalReader.class.getCanonicalName());
    private OsmIntermodalReaderSettings settings;
    private Zoning zoningToPopulate;
    private PlanitOsmNetwork osmNetworkToPopulate;

    private boolean isSettingsValid() {
        OsmNetworkReaderSettings networkSettings = this.getSettings().getNetworkSettings();
        OsmPublicTransportReaderSettings ptSettings = this.getSettings().getPublicTransportSettings();
        if (!networkSettings.getCountryName().equals(ptSettings.getCountryName())) {
            LOGGER.severe(String.format("OSM intermodal reader requires both the network and zoning (pt) to utilise the same source country upon parsing, found %s and %s respctively instead", networkSettings.getCountryName(), ptSettings.getCountryName()));
            return false;
        }
        if (!networkSettings.getInputSource().equals(ptSettings.getInputSource())) {
            LOGGER.warning(String.format("OSM intermodal reader requires both the network and zoning (pt) to utilise the same osm input file upon parsing, found %s and %s respctively instead", networkSettings.getInputSource(), ptSettings.getInputSource()));
            if (networkSettings.getInputSource() != null) {
                LOGGER.warning(String.format("SALVAGED: set zoning input file to network input file instead: %s", networkSettings.getInputSource()));
                ptSettings.setInputSource(networkSettings.getInputSource());
            } else if (ptSettings.getInputSource() != null) {
                LOGGER.warning(String.format("SALVAGED: set network input file to zoning input file instead: %s", ptSettings.getInputSource()));
                networkSettings.setInputSource(ptSettings.getInputSource());
            } else {
                return false;
            }
        }
        if (!(networkSettings.isHighwayParserActive() || networkSettings.isRailwayParserActive() || networkSettings.isWaterwayParserActive())) {
            LOGGER.warning("Not a single type of network is activated nor road, rail, or water");
            return false;
        }
        return true;
    }

    private void removeDanglingEntities(OsmNetworkReader osmNetworkReader, OsmZoningReader osmZoningReader, Zoning zoning) {
        if (osmNetworkReader.getSettings().isRemoveDanglingSubnetworks()) {
            osmNetworkReader.removeDanglingSubNetworks(zoning);
        }
        if (osmZoningReader.getSettings().isRemoveDanglingZones()) {
            PlanitZoningUtils.removeDanglingZones(zoning);
        }
        if (osmZoningReader.getSettings().isRemoveDanglingTransferZoneGroups()) {
            PlanitZoningUtils.removeDanglingTransferZoneGroups(zoning);
        }
    }

    protected OsmIntermodalReader(String countryName, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) {
        this(new OsmIntermodalReaderSettings(countryName), osmNetworkToPopulate, zoningToPopulate);
    }

    protected OsmIntermodalReader(URL inputSource, String countryName, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) {
        this(new OsmIntermodalReaderSettings(inputSource, countryName), osmNetworkToPopulate, zoningToPopulate);
    }

    protected OsmIntermodalReader(OsmIntermodalReaderSettings settings, PlanitOsmNetwork osmNetworkToPopulate, Zoning zoningToPopulate) {
        this.settings = settings;
        this.zoningToPopulate = zoningToPopulate;
        this.osmNetworkToPopulate = osmNetworkToPopulate;
    }

    public Pair<MacroscopicNetwork, Zoning> read() {
        if (!this.isSettingsValid()) {
            return null;
        }
        OsmNetworkReader osmNetworkReader = OsmNetworkReaderFactory.create(this.getSettings().getNetworkSettings());
        boolean originalRemoveDanglingSubNetworks = osmNetworkReader.getSettings().isRemoveDanglingSubnetworks();
        osmNetworkReader.getSettings().setRemoveDanglingSubnetworks(false);
        PlanitOsmNetwork network = (PlanitOsmNetwork)osmNetworkReader.read();
        this.zoningToPopulate.setCoordinateReferenceSystem(network.getCoordinateReferenceSystem());
        OsmPublicTransportReaderSettings ptSettings = this.getSettings().getPublicTransportSettings();
        OsmZoningReader osmZoningReader = OsmZoningReaderFactory.create(ptSettings, this.zoningToPopulate, network, osmNetworkReader.createNetworkToZoningReaderData());
        boolean originalRemoveDanglingZones = osmZoningReader.getSettings().isRemoveDanglingZones();
        boolean originalRemoveDanglingTransferZoneGroups = osmZoningReader.getSettings().isRemoveDanglingTransferZoneGroups();
        osmZoningReader.getSettings().activateParser(true);
        osmZoningReader.getSettings().setRemoveDanglingZones(false);
        osmZoningReader.getSettings().setRemoveDanglingTransferZoneGroups(false);
        Zoning zoning = osmZoningReader.read();
        osmNetworkReader.getSettings().setRemoveDanglingSubnetworks(originalRemoveDanglingSubNetworks);
        osmZoningReader.getSettings().setRemoveDanglingZones(originalRemoveDanglingZones);
        osmZoningReader.getSettings().setRemoveDanglingTransferZoneGroups(originalRemoveDanglingTransferZoneGroups);
        this.removeDanglingEntities(osmNetworkReader, osmZoningReader, zoning);
        return Pair.of((Object)((Object)network), (Object)zoning);
    }

    public void reset() {
    }

    public OsmIntermodalReaderSettings getSettings() {
        return this.settings;
    }

    public boolean supportServiceConversion() {
        return false;
    }

    public Quadruple<MacroscopicNetwork, Zoning, ServiceNetwork, RoutedServices> readWithServices() {
        if (!this.isSettingsValid()) {
            return null;
        }
        throw new PlanItRunTimeException("Support for service reader as part of Intermodal reader not yet supported in OSMIntermodalReader");
    }
}

