/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.converter.helper.OsmLaneTaggingSchemeHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;

public class OsmModeLanesTaggingSchemeHelper
extends OsmLaneTaggingSchemeHelper {
    protected final Map<String, String> modeLanesKeyTags = new HashMap<String, String>();
    protected final Map<String, String> modeLanesForwardKeyTags = new HashMap<String, String>();
    protected final Map<String, String> modeLanesBackwardKeyTags = new HashMap<String, String>();

    private void initialise() {
        if (this.hasEligibleModes()) {
            this.eligibleOsmModes.forEach(osmMode -> this.modeLanesKeyTags.put((String)osmMode, OsmTagUtils.createCompositeOsmKey(osmMode, "lanes")));
            this.modeLanesKeyTags.forEach((osmMode, modeLaneTag) -> this.modeLanesForwardKeyTags.put((String)osmMode, OsmTagUtils.createCompositeOsmKey(modeLaneTag, "forward")));
            this.modeLanesKeyTags.forEach((osmMode, modeLaneTag) -> this.modeLanesBackwardKeyTags.put((String)osmMode, OsmTagUtils.createCompositeOsmKey(modeLaneTag, "backward")));
        }
    }

    public static boolean requireLanesModeSchemeHelper(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        return OsmLaneTaggingSchemeHelper.requireTaggingSchemeHelper(settings, networkLayer);
    }

    public static Set<String> getEligibleModeLanesSchemeHelperModes(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        return OsmLaneTaggingSchemeHelper.getEligibleTaggingSchemeHelperModes(settings, networkLayer);
    }

    public OsmModeLanesTaggingSchemeHelper(Set<String> theEligibleOsmModes) {
        super(theEligibleOsmModes);
        this.initialise();
    }

    public Set<String> getModesWithLanesWithoutDirection(Map<String, String> tags) {
        return this.getMappedModesForAvailableKeys(tags, this.modeLanesKeyTags);
    }

    public Set<String> getModesWithLanesInDirection(Map<String, String> tags, boolean isForwardDirection) {
        Map<String, String> directionalKeyTags = isForwardDirection ? this.modeLanesForwardKeyTags : this.modeLanesBackwardKeyTags;
        return this.getMappedModesForAvailableKeys(tags, directionalKeyTags);
    }
}

