/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter;

import java.net.URL;
import org.goplanit.converter.ConverterReaderSettings;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

public abstract class OsmReaderSettings
implements ConverterReaderSettings {
    private URL inputSource;
    private final String countryName;
    private Polygon boundingPolygon = null;

    public OsmReaderSettings() {
        this((URL)null, "global");
    }

    public OsmReaderSettings(String countryName) {
        this((URL)null, countryName);
    }

    public OsmReaderSettings(String inputSource, String countryName) {
        this.setInputSource(inputSource);
        this.countryName = countryName;
    }

    public OsmReaderSettings(URL inputSource, String countryName) {
        this.inputSource = inputSource;
        this.countryName = countryName;
    }

    public final URL getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(URL inputSource) {
        this.inputSource = inputSource;
    }

    public void setInputSource(String inputSource) {
        try {
            this.setInputSource(UrlUtils.createFrom((String)inputSource));
        }
        catch (Exception e) {
            throw new PlanItRunTimeException("Unable to extract URL from input source %s", new Object[]{inputSource});
        }
    }

    public void setInputFile(String inputFile) throws PlanItException {
        try {
            this.setInputSource(UrlUtils.createFromLocalPath((String)inputFile));
        }
        catch (Exception e) {
            throw new PlanItException("Unable to extract URL from input file location %s", new Object[]{inputFile});
        }
    }

    public final String getCountryName() {
        return this.countryName;
    }

    public final void setBoundingBox(Number x1, Number x2, Number y1, Number y2) throws PlanItException {
        this.setBoundingBox(new Envelope(PlanitJtsUtils.createPoint((Number)x1, (Number)y1).getCoordinate(), PlanitJtsUtils.createPoint((Number)x2, (Number)y2).getCoordinate()));
    }

    public final void setBoundingBox(Envelope boundingBox) {
        this.setBoundingPolygon(PlanitJtsUtils.create2DPolygon((Envelope)boundingBox));
    }

    public final void setBoundingPolygon(Polygon boundingPolygon) {
        this.boundingPolygon = boundingPolygon;
    }

    public final Polygon getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public final boolean hasBoundingPolygon() {
        return this.boundingPolygon != null;
    }
}

