/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class OsmNodeData {
    private static final Logger LOGGER = Logger.getLogger(OsmNodeData.class.getCanonicalName());
    private final Map<Long, OsmNode> osmNodes = new HashMap<Long, OsmNode>();

    public Map<Long, OsmNode> getRegisteredOsmNodes() {
        return Collections.unmodifiableMap(this.osmNodes);
    }

    public void registerEligibleOsmNode(OsmNode osmNode) {
        if (!this.osmNodes.containsKey(osmNode.getId())) {
            LOGGER.severe("Only OSM nodes that have already been marked as eligible can be complemented with the actual OSM node contents");
        }
        this.osmNodes.put(osmNode.getId(), osmNode);
    }

    public void preRegisterEligibleOsmNode(long osmNodeId) {
        this.osmNodes.put(osmNodeId, null);
    }

    public OsmNode getRegisteredOsmNode(long osmNodeId) {
        return this.osmNodes.get(osmNodeId);
    }

    public boolean containsOsmNode(long osmNodeId) {
        return this.getRegisteredOsmNode(osmNodeId) != null;
    }

    public boolean containsPreregisteredOsmNode(long osmNodeId) {
        return this.osmNodes.containsKey(osmNodeId);
    }

    public void removeRegisteredOsmNodesIf(Predicate<Map.Entry<Long, OsmNode>> predicate) {
        this.osmNodes.entrySet().removeIf(predicate);
    }

    public void reset() {
        this.osmNodes.clear();
    }
}

