/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;

public class OsmModeConversionBase {
    private static final Logger LOGGER = Logger.getLogger(OsmModeConversionBase.class.getCanonicalName());
    private final OsmNetworkReaderSettings settings;
    private final Collection<String> osmLinkModes;
    private final Consumer<Mode> addMappedOsmLinkModesByPlanitMode;
    private Map<PredefinedModeType, Mode> predefinedModeTypeToModeMap;

    protected OsmNetworkReaderSettings getSettings() {
        return this.settings;
    }

    public OsmModeConversionBase(OsmNetworkReaderSettings settings, Iterable<Mode> layerModes) {
        this.settings = settings;
        this.predefinedModeTypeToModeMap = new HashMap<PredefinedModeType, Mode>();
        this.osmLinkModes = new HashSet<String>();
        this.addMappedOsmLinkModesByPlanitMode = planitMode -> {
            if (planitMode.isPredefinedModeType()) {
                this.osmLinkModes.addAll(settings.getMappedOsmModes(planitMode.getPredefinedModeType()));
            }
        };
        for (Mode mode : layerModes) {
            Mode old;
            if (!mode.isPredefinedModeType() || (old = this.predefinedModeTypeToModeMap.put(mode.getPredefinedModeType(), mode)) == null) continue;
            LOGGER.severe(String.format("found multiple modes with same predifined mode type %s, shouldn't happen", old.getPredefinedModeType()));
        }
    }

    public Set<Mode> getActivatedPlanitModes(Collection<String> osmModes) {
        HashSet<Mode> mappedPlanitModes = new HashSet<Mode>();
        if (osmModes == null) {
            return mappedPlanitModes;
        }
        for (String osmMode : osmModes) {
            Mode theMode;
            PredefinedModeType theModeType = this.settings.getMappedPlanitModeType(osmMode);
            if (theModeType == null || (theMode = this.predefinedModeTypeToModeMap.get(theModeType)) == null) continue;
            mappedPlanitModes.add(theMode);
        }
        return mappedPlanitModes;
    }

    public Mode getActivatedPlanitMode(String osmMode) {
        if (osmMode == null) {
            return null;
        }
        PredefinedModeType theModeType = this.settings.getMappedPlanitModeType(osmMode);
        if (theModeType == null) {
            return null;
        }
        Mode theMode = this.predefinedModeTypeToModeMap.get(theModeType);
        if (theMode == null) {
            return null;
        }
        return theMode;
    }

    public boolean isModeCompatible(Collection<String> osmModesToCheck, Collection<String> referenceOsmModes, boolean allowPseudoMatches) {
        Collection<String> overlappingOsmModes = OsmModeUtils.extractCompatibleOsmModes(osmModesToCheck, referenceOsmModes, allowPseudoMatches);
        return this.settings.hasAnyMappedPlanitModeType(overlappingOsmModes);
    }

    public boolean isLinkModeCompatible(Link link, Collection<String> referenceOsmModes, boolean allowPseudoMatches) {
        Set planitModes;
        this.osmLinkModes.clear();
        if (link.hasEdgeSegmentAb()) {
            planitModes = ((MacroscopicLinkSegment)link.getEdgeSegmentAb()).getLinkSegmentType().getAllowedModes();
            planitModes.forEach(planitMode -> this.addMappedOsmLinkModesByPlanitMode.accept((Mode)planitMode));
        }
        if (link.hasEdgeSegmentBa()) {
            planitModes = ((MacroscopicLinkSegment)link.getEdgeSegmentBa()).getLinkSegmentType().getAllowedModes();
            planitModes.forEach(planitMode -> this.addMappedOsmLinkModesByPlanitMode.accept((Mode)planitMode));
        }
        if (this.osmLinkModes == null || this.osmLinkModes.isEmpty()) {
            return false;
        }
        return this.isModeCompatible(this.osmLinkModes, referenceOsmModes, allowPseudoMatches);
    }

    public Collection<MacroscopicLink> filterModeCompatibleLinks(Collection<String> referenceOsmModes, Collection<MacroscopicLink> potentialLinks, boolean allowPseudoModeMatches) {
        HashSet<MacroscopicLink> modeCompatibleLinks = new HashSet<MacroscopicLink>();
        for (MacroscopicLink link : potentialLinks) {
            if (!this.isLinkModeCompatible((Link)link, referenceOsmModes, allowPseudoModeMatches)) continue;
            modeCompatibleLinks.add(link);
        }
        return modeCompatibleLinks;
    }
}

