/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.xml.network.physical.macroscopic;

import java.util.List;
import java.util.logging.Logger;
import net.opengis.gml.DirectPositionListType;
import net.opengis.gml.LineStringType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.xml.generated.LengthUnit;
import org.goplanit.xml.generated.XMLElementLayerConfiguration;
import org.goplanit.xml.generated.XMLElementLinkLengthType;
import org.goplanit.xml.generated.XMLElementLinkSegmentType;
import org.goplanit.xml.generated.XMLElementLinkSegmentTypes;
import org.goplanit.xml.generated.XMLElementLinks;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class XmlMacroscopicNetworkLayerHelper {
    private static final Logger LOGGER = Logger.getLogger(XmlMacroscopicNetworkLayerHelper.class.getCanonicalName());

    public static Double parseLengthElementFromLink(XMLElementLinks.Link generatedLink) {
        Double length = null;
        XMLElementLinkLengthType linkLengthType = generatedLink.getLength();
        if (linkLengthType != null) {
            LengthUnit lengthUnit = linkLengthType.getUnit();
            length = lengthUnit != null && lengthUnit.equals((Object)LengthUnit.M) ? Double.valueOf(linkLengthType.getValue() / 1000.0) : Double.valueOf(linkLengthType.getValue());
        }
        return length;
    }

    public static Double parseLengthFromLineString(XMLElementLinks.Link generatedLink, PlanitJtsCrsUtils jtsUtils) throws PlanItException {
        Double length = 0.0;
        LineStringType lineStringType = generatedLink.getLineString();
        if (lineStringType != null) {
            DirectPositionListType positionList = lineStringType.getPosList();
            if (positionList == null) {
                LOGGER.severe(String.format("Link %s has a line string without any positions, this should not happen, consider specifying a length instead, setting length to 0.0", generatedLink.getId()));
                return length;
            }
            List posList = lineStringType.getPosList().getValue();
            Point startPosition = null;
            Point endPosition = null;
            for (int i = 0; i < posList.size(); i += 2) {
                endPosition = PlanitJtsUtils.createPoint((Number)((Number)posList.get(i)), (Number)((Number)posList.get(i + 1)));
                if (startPosition != null) {
                    length = length + jtsUtils.getDistanceInKilometres(startPosition, endPosition);
                }
                startPosition = endPosition;
            }
        }
        return length;
    }

    public static LineString parseLinkGeometry(XMLElementLinks.Link generatedLink) {
        if (generatedLink.getLineString() != null) {
            LineStringType lst = generatedLink.getLineString();
            if (lst.getCoordinates() != null) {
                return PlanitJtsUtils.createLineStringFromCsvString((String)lst.getCoordinates().getValue(), (String)lst.getCoordinates().getTs(), (String)lst.getCoordinates().getCs());
            }
            if (lst.getPosList() != null) {
                return PlanitJtsUtils.createLineString((List)lst.getPosList().getValue());
            }
        }
        return null;
    }

    public static double parseLength(XMLElementLinks.Link xmlLink, LineString theLineString, PlanitJtsCrsUtils jtsUtils) {
        Double length = XmlMacroscopicNetworkLayerHelper.parseLengthElementFromLink(xmlLink);
        if (length == null && theLineString != null) {
            length = jtsUtils.getDistanceInKilometres(theLineString);
        }
        if (length == null) {
            LOGGER.severe(String.format("Must define either a length or GML LineString for link %s, setting length to 0.0 instead", xmlLink.getId()));
            length = 0.0;
        }
        return length;
    }

    public static void injectDefaultLinkSegmentType(XMLElementLayerConfiguration xmlLayerConfiguration) {
        if (xmlLayerConfiguration.getLinksegmenttypes() == null) {
            xmlLayerConfiguration.setLinksegmenttypes(new XMLElementLinkSegmentTypes());
            XMLElementLinkSegmentType xmlLinkSegmentType = new XMLElementLinkSegmentType();
            xmlLinkSegmentType.setName("");
            xmlLinkSegmentType.setId("default");
            xmlLayerConfiguration.getLinksegmenttypes().getLinksegmenttype().add(xmlLinkSegmentType);
        }
    }
}

