/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.xml.converter;

import java.util.logging.Logger;
import org.goplanit.output.enums.DataType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.unit.Unit;
import org.goplanit.xml.generated.Typevalues;
import org.goplanit.xml.generated.Unitsvalues;

public interface XmlEnumConverter {
    public static final Logger LOGGER = Logger.getLogger(XmlEnumConverter.class.getCanonicalName());

    public static Typevalues convertFromPlanItToXmlGeneratedType(DataType type) {
        switch (type) {
            case DOUBLE: {
                return Typevalues.DOUBLE;
            }
            case FLOAT: {
                return Typevalues.FLOAT;
            }
            case INTEGER: {
                return Typevalues.INTEGER;
            }
            case LONG: {
                return Typevalues.INTEGER;
            }
            case BOOLEAN: {
                return Typevalues.BOOLEAN;
            }
            case SRSNAME: {
                return Typevalues.SRSNAME;
            }
            case STRING: {
                return Typevalues.STRING;
            }
        }
        throw new PlanItRunTimeException("Data type " + type.value() + " has not been defined in the type values simple type in the output XSD file");
    }

    public static Unitsvalues convertFromPlanItToXmlGeneratedUnits(OutputProperty outputProperty) throws PlanItException {
        Unit outputPropertyUnit = outputProperty.getDefaultUnit();
        if (outputProperty.supportsUnitOverride() && outputProperty.isUnitOverride()) {
            outputPropertyUnit = outputProperty.getOverrideUnit();
        }
        if (outputPropertyUnit.equals(Unit.VEH_KM)) {
            return Unitsvalues.VEH_KM;
        }
        if (outputPropertyUnit.equals(Unit.PCU_KM)) {
            return Unitsvalues.PCU_KM;
        }
        if (outputPropertyUnit.equals(Unit.NONE)) {
            return Unitsvalues.NONE;
        }
        if (outputPropertyUnit.equals(Unit.VEH_HOUR)) {
            return Unitsvalues.VEH_H;
        }
        if (outputPropertyUnit.equals(Unit.PCU_HOUR)) {
            return Unitsvalues.PCU_H;
        }
        if (outputPropertyUnit.equals(Unit.KM_HOUR)) {
            return Unitsvalues.KM_H;
        }
        if (outputPropertyUnit.equals(Unit.HOUR)) {
            return Unitsvalues.H;
        }
        if (outputPropertyUnit.equals(Unit.KM)) {
            return Unitsvalues.KM;
        }
        if (outputPropertyUnit.equals(Unit.SRS)) {
            return Unitsvalues.SRS;
        }
        throw new PlanItException("Units type " + outputProperty.toString() + " has not been defined in the units values simple type in the output XSD file.");
    }
}

