/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.test;

import java.io.IOException;
import java.nio.file.Path;
import org.goplanit.utils.misc.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.xmlunit.matchers.CompareMatcher;

public class PlanitAssertionUtils {
    private static Path pathOfNetworkFile(String theDir) {
        return Path.of(theDir, "network.xml").toAbsolutePath();
    }

    private static Path pathOfZoningFile(String theDir) {
        return Path.of(theDir, "zoning.xml").toAbsolutePath();
    }

    private static Path pathOfServiceNetworkFile(String theDir) {
        return Path.of(theDir, "service_network.xml").toAbsolutePath();
    }

    private static Path pathOfRoutedServicesFile(String theDir) {
        return Path.of(theDir, "routed_services.xml").toAbsolutePath();
    }

    private static Path pathOfDemandsFile(String theDir) {
        return Path.of(theDir, "demands.xml").toAbsolutePath();
    }

    private static void assertXmlFileContentSimilar(String file1, String file2) throws IOException {
        MatcherAssert.assertThat((Object)FileUtils.parseUtf8FileContentAsString((String)file1), (Matcher)CompareMatcher.isSimilarTo((Object)FileUtils.parseUtf8FileContentAsString((String)file2)));
    }

    public static void assertNetworkFilesSimilar(String resultDir, String referenceDir) throws IOException {
        String resultFile = PlanitAssertionUtils.pathOfNetworkFile(resultDir).toString();
        String referenceFile = PlanitAssertionUtils.pathOfNetworkFile(referenceDir).toString();
        PlanitAssertionUtils.assertXmlFileContentSimilar(resultFile, referenceFile);
    }

    public static void assertNetworkFilesSimilar(Path resultDir, Path referenceDir) throws IOException {
        PlanitAssertionUtils.assertNetworkFilesSimilar(resultDir.toAbsolutePath().toString(), referenceDir.toAbsolutePath().toString());
    }

    public static void assertZoningFilesSimilar(String resultDir, String referenceDir) throws IOException {
        String resultFile = PlanitAssertionUtils.pathOfZoningFile(resultDir).toString();
        String referenceFile = PlanitAssertionUtils.pathOfZoningFile(referenceDir).toString();
        PlanitAssertionUtils.assertXmlFileContentSimilar(resultFile, referenceFile);
    }

    public static void assertZoningFilesSimilar(Path resultDir, Path referenceDir) throws IOException {
        PlanitAssertionUtils.assertZoningFilesSimilar(resultDir.toAbsolutePath().toString(), referenceDir.toAbsolutePath().toString());
    }

    public static void assertServiceNetworkFilesSimilar(String resultDir, String referenceDir) throws IOException {
        String resultFile = PlanitAssertionUtils.pathOfServiceNetworkFile(resultDir).toString();
        String referenceFile = PlanitAssertionUtils.pathOfServiceNetworkFile(referenceDir).toString();
        PlanitAssertionUtils.assertXmlFileContentSimilar(resultFile, referenceFile);
    }

    public static void assertServiceNetworkFilesSimilar(Path resultDir, Path referenceDir) throws IOException {
        PlanitAssertionUtils.assertServiceNetworkFilesSimilar(resultDir.toAbsolutePath().toString(), referenceDir.toAbsolutePath().toString());
    }

    public static void assertRoutedServicesFilesSimilar(String resultDir, String referenceDir) throws IOException {
        String resultFile = PlanitAssertionUtils.pathOfRoutedServicesFile(resultDir).toString();
        String referenceFile = PlanitAssertionUtils.pathOfRoutedServicesFile(referenceDir).toString();
        PlanitAssertionUtils.assertXmlFileContentSimilar(resultFile, referenceFile);
    }

    public static void assertRoutedServicesFilesSimilar(Path resultDir, Path referenceDir) throws IOException {
        PlanitAssertionUtils.assertRoutedServicesFilesSimilar(resultDir.toAbsolutePath().toString(), referenceDir.toAbsolutePath().toString());
    }

    public static void assertDemandsFilesSimilar(String resultDir, String referenceDir) throws IOException {
        String resultFile = PlanitAssertionUtils.pathOfDemandsFile(resultDir).toString();
        String referenceFile = PlanitAssertionUtils.pathOfDemandsFile(referenceDir).toString();
        PlanitAssertionUtils.assertXmlFileContentSimilar(resultFile, referenceFile);
    }

    public static void assertDemandsFilesSimilar(Path resultDir, Path referenceDir) throws IOException {
        PlanitAssertionUtils.assertDemandsFilesSimilar(resultDir.toAbsolutePath().toString(), referenceDir.toAbsolutePath().toString());
    }
}

