/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.geo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.geometry.GeometryBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Vertex;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;

public class PlanitOpenGisUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitOpenGisUtils.class.getCanonicalName());
    public static final DefaultGeographicCRS DEFAULT_GEOGRAPHIC_CRS = PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS;
    public static final CoordinateReferenceSystem CARTESIANCRS = PlanitJtsCrsUtils.CARTESIANCRS;
    private GeodeticCalculator geodeticDistanceCalculator;
    private GeometryBuilder geometryBuilder;
    private GeometryFactory geometryFactory;
    private PositionFactory positionFactory;

    public PlanitOpenGisUtils() {
        DefaultGeographicCRS coordinateReferenceSystem = new DefaultGeographicCRS((GeographicCRS)DEFAULT_GEOGRAPHIC_CRS);
        this.geometryBuilder = new GeometryBuilder((CoordinateReferenceSystem)coordinateReferenceSystem);
        this.geodeticDistanceCalculator = new GeodeticCalculator((CoordinateReferenceSystem)coordinateReferenceSystem);
        this.geometryFactory = this.geometryBuilder.getGeometryFactory();
        this.positionFactory = this.geometryBuilder.getPositionFactory();
    }

    public PlanitOpenGisUtils(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.geometryBuilder = new GeometryBuilder(coordinateReferenceSystem);
        this.geometryFactory = this.geometryBuilder.getGeometryFactory();
        this.positionFactory = this.geometryBuilder.getPositionFactory();
        if (!coordinateReferenceSystem.equals(CARTESIANCRS)) {
            this.geodeticDistanceCalculator = new GeodeticCalculator(coordinateReferenceSystem);
        }
    }

    public double getDistanceInMetres(Position startPosition, Position endPosition) throws PlanItException {
        try {
            if (this.geodeticDistanceCalculator != null) {
                this.geodeticDistanceCalculator.setStartingGeographicPoint(startPosition.getDirectPosition().getOrdinate(0), startPosition.getDirectPosition().getOrdinate(1));
                this.geodeticDistanceCalculator.setDestinationGeographicPoint(endPosition.getDirectPosition().getOrdinate(0), endPosition.getDirectPosition().getOrdinate(1));
                return this.geodeticDistanceCalculator.getOrthodromicDistance();
            }
            double deltaCoordinate0 = startPosition.getDirectPosition().getOrdinate(0) - endPosition.getDirectPosition().getOrdinate(0);
            double deltaCoordinate1 = startPosition.getDirectPosition().getOrdinate(1) - endPosition.getDirectPosition().getOrdinate(1);
            double distanceInMeters = Math.sqrt(Math.pow(deltaCoordinate0, 2.0) + Math.pow(deltaCoordinate1, 2.0));
            return distanceInMeters;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when computing distance in meters between two Positions in GeoUtils", (Throwable)e);
        }
    }

    public double getDistanceInKilometres(Position startPosition, Position endPosition) throws PlanItException {
        return this.getDistanceInMetres(startPosition, endPosition) / 1000.0;
    }

    public double getDistanceInKilometres(Vertex vertexA, Vertex vertexB) throws PlanItException {
        DirectPosition positionA = JTS.toDirectPosition((Coordinate)vertexA.getPosition().getCoordinate(), (CoordinateReferenceSystem)this.geometryBuilder.getCoordinateReferenceSystem());
        DirectPosition positionB = JTS.toDirectPosition((Coordinate)vertexB.getPosition().getCoordinate(), (CoordinateReferenceSystem)this.geometryBuilder.getCoordinateReferenceSystem());
        return this.getDistanceInMetres((Position)positionA, (Position)positionB) / 1000.0;
    }

    public DirectPosition createDirectPosition(double xCoordinate, double yCoordinate) throws PlanItException {
        Coordinate coordinate = new Coordinate(xCoordinate, yCoordinate);
        DirectPosition newPosition = this.positionFactory.createDirectPosition(new double[]{coordinate.x, coordinate.y});
        return newPosition;
    }

    public org.opengis.geometry.coordinate.LineString convertToOpenGisLineString(LineString jtsLineString) throws PlanItException {
        Coordinate[] coordinates = jtsLineString.getCoordinates();
        List<DirectPosition> positionList = this.convertToDirectPositions(coordinates);
        return this.geometryFactory.createLineString(positionList);
    }

    public org.opengis.geometry.coordinate.LineString convertToOpenGisLineString(MultiLineString jtsMultiLineString) throws PlanItException {
        PlanItException.throwIf((jtsMultiLineString.getNumGeometries() > 1 ? 1 : 0) != 0, (String)"MultiLineString contains multiple LineStrings", (Object[])new Object[0]);
        return this.convertToOpenGisLineString((LineString)jtsMultiLineString.getGeometryN(0));
    }

    public org.opengis.geometry.coordinate.LineString createLineString(List<Double> coordinateList) throws PlanItException {
        PlanItException.throwIf((coordinateList.size() % 2 != 0 ? 1 : 0) != 0, (String)"coordinate list must contain an even number of entries to correctly identify (x,y) pairs", (Object[])new Object[0]);
        Iterator<Double> iter = coordinateList.iterator();
        ArrayList<DirectPosition> positionList = new ArrayList<DirectPosition>(coordinateList.size() / 2);
        while (iter.hasNext()) {
            positionList.add(this.createDirectPosition(iter.next(), iter.next()));
        }
        return this.geometryFactory.createLineString(positionList);
    }

    public org.opengis.geometry.coordinate.LineString createLineString(String value, char ts, char cs) throws PlanItException {
        ArrayList<Double> coordinateDoubleList = new ArrayList<Double>();
        String[] tupleString = value.split("[" + ts + "]");
        for (int index = 0; index < tupleString.length; ++index) {
            String xyCoordinateString = tupleString[index];
            String[] coordinateString = xyCoordinateString.split("[" + cs + "]");
            if (coordinateString.length != 2) {
                throw new PlanItException(String.format("invalid coordinate encountered, expected two coordinates in tuple, but found %d", coordinateString.length));
            }
            coordinateDoubleList.add(Double.parseDouble(coordinateString[0]));
            coordinateDoubleList.add(Double.parseDouble(coordinateString[1]));
        }
        return this.createLineString(coordinateDoubleList);
    }

    public org.opengis.geometry.coordinate.LineString createLineStringFromPositions(List<Position> positionList) throws PlanItException {
        return this.geometryFactory.createLineString(positionList);
    }

    public org.opengis.geometry.coordinate.LineString createLineStringFromCsvString(String value, String ts, String cs) throws PlanItException {
        if (ts.length() > 1 || cs.length() > 1) {
            PlanItException.throwIf((ts.length() > 1 ? 1 : 0) != 0, (String)String.format("tuple separating string to create LineString is not a single character but %s", ts), (Object[])new Object[0]);
            PlanItException.throwIf((cs.length() > 1 ? 1 : 0) != 0, (String)String.format("comma separating string to create LineString is not a single character but %s", cs), (Object[])new Object[0]);
        }
        return this.createLineString(value, ts.charAt(0), cs.charAt(0));
    }

    public List<DirectPosition> convertToDirectPositions(Coordinate[] coordinates) throws PlanItException {
        ArrayList<DirectPosition> positionList = new ArrayList<DirectPosition>(coordinates.length);
        for (Coordinate coordinate : coordinates) {
            positionList.add(this.createDirectPosition(coordinate.x, coordinate.y));
        }
        return positionList;
    }

    public double getDistanceInKilometres(org.opengis.geometry.coordinate.LineString geometry) throws PlanItException {
        PointArray pointArray = geometry.getControlPoints();
        int numberOfPoints = pointArray.size();
        if (numberOfPoints > 1) {
            double computedLengthInKm = 0.0;
            Position previousPoint = (Position)pointArray.get(0);
            for (int index = 1; index < numberOfPoints; ++index) {
                Position currentPoint = (Position)pointArray.get(index);
                computedLengthInKm += this.getDistanceInKilometres(previousPoint, currentPoint);
                previousPoint = currentPoint;
            }
            return computedLengthInKm;
        }
        throw new PlanItException("unable to compute distance for less than two points");
    }

    public Position getClosestSamplePointOnLineString(Position toMatch, org.opengis.geometry.coordinate.LineString lineString) throws PlanItException {
        if (lineString != null && toMatch != null) {
            double minDistance = Double.POSITIVE_INFINITY;
            Position minDistancePosition = null;
            for (Position samplePoint : lineString.getSamplePoints()) {
                double currDistance = this.getDistanceInMetres(toMatch, samplePoint);
                if (!(this.getDistanceInMetres(toMatch, samplePoint) < minDistance)) continue;
                minDistance = currDistance;
                minDistancePosition = samplePoint;
            }
            return minDistancePosition;
        }
        throw new PlanItException(" closest orindate position to lines tring could not be computed since either the line string or reference position is null");
    }
}

