/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.zoning;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.ZoningIdMapper;
import org.goplanit.converter.zoning.ZoningWriter;
import org.goplanit.io.converter.network.UnTypedPlanitCrsWriterImpl;
import org.goplanit.io.converter.zoning.PlanitZoningWriterSettings;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.ConnectoidType;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.xml.generated.Connectoidnodelocationtype;
import org.goplanit.xml.generated.Connectoidtype;
import org.goplanit.xml.generated.Connectoidtypetype;
import org.goplanit.xml.generated.Intermodaltype;
import org.goplanit.xml.generated.Transferzonetype;
import org.goplanit.xml.generated.XMLElementCentroid;
import org.goplanit.xml.generated.XMLElementConnectoid;
import org.goplanit.xml.generated.XMLElementConnectoids;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementTransferGroup;
import org.goplanit.xml.generated.XMLElementTransferZoneAccess;
import org.goplanit.xml.generated.XMLElementTransferZoneGroups;
import org.goplanit.xml.generated.XMLElementTransferZones;
import org.goplanit.xml.generated.XMLElementZones;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitZoningWriter
extends UnTypedPlanitCrsWriterImpl<Zoning>
implements ZoningWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitZoningWriter.class.getCanonicalName());
    private final XMLElementMacroscopicZoning xmlRawZoning;
    private final Map<Zone, List<Connectoid>> zoneToConnectoidMap = new HashMap<Zone, List<Connectoid>>();
    private final PlanitZoningWriterSettings settings;

    private static Connectoidtypetype createXmlConnectoidType(ConnectoidType connectoidType) {
        switch (connectoidType) {
            case UNKNOWN: {
                return Connectoidtypetype.UNKNOWN;
            }
            case PT_VEHICLE_STOP: {
                return Connectoidtypetype.PT_VEH_STOP;
            }
            case TRAVELLER_ACCESS: {
                return Connectoidtypetype.TRAVELLER_ACCESS;
            }
            case NONE: {
                return Connectoidtypetype.NONE;
            }
        }
        LOGGER.warning(String.format("Unsupported connectoid type %s found, changed to `unknown`", connectoidType.value()));
        return Connectoidtypetype.UNKNOWN;
    }

    private static Transferzonetype createXmlTransferZoneType(TransferZoneType transferZoneType) {
        switch (transferZoneType) {
            case UNKNOWN: {
                return Transferzonetype.UNKNOWN;
            }
            case PLATFORM: {
                return Transferzonetype.PLATFORM;
            }
            case POLE: {
                return Transferzonetype.STOP_POLE;
            }
            case SMALL_STATION: {
                return Transferzonetype.SMALL_STATION;
            }
            case STATION: {
                return Transferzonetype.STATION;
            }
        }
        LOGGER.warning(String.format("Unsupported transfer zone type %s found, changed to `unknown`", transferZoneType.value()));
        return Transferzonetype.UNKNOWN;
    }

    private void createZoneToConnectoidIndices(Zoning zoning) {
        for (UndirectedConnectoid connectoid : zoning.getOdConnectoids()) {
            for (Zone zone : connectoid.getAccessZones()) {
                this.zoneToConnectoidMap.putIfAbsent(zone, new ArrayList(1));
                this.zoneToConnectoidMap.get(zone).add((Connectoid)connectoid);
            }
        }
        for (UndirectedConnectoid connectoid : zoning.getTransferConnectoids()) {
            for (Zone zone : connectoid.getAccessZones()) {
                this.zoneToConnectoidMap.putIfAbsent(zone, new ArrayList(1));
                this.zoneToConnectoidMap.get(zone).add((Connectoid)connectoid);
            }
        }
    }

    private void populateXmlTransferGroup(XMLElementTransferGroup xmlTransferGroup, TransferZoneGroup transferGroup) {
        if (xmlTransferGroup == null) {
            LOGGER.severe(String.format("Unable to add transfer zone group %s (id:%d) to xml element, xml element is null", transferGroup.getXmlId(), transferGroup.getId()));
            return;
        }
        if (!transferGroup.hasTransferZones()) {
            LOGGER.warning(String.format("DISCARD: transfer zone group %s (id:%d) has no transfer zones, it will not be populated", transferGroup.getXmlId(), transferGroup.getId()));
            return;
        }
        xmlTransferGroup.setId((String)this.getPrimaryIdMapper().getTransferZoneGroupIdMapper().apply(transferGroup));
        if (StringUtils.isNullOrBlank((String)xmlTransferGroup.getId())) {
            LOGGER.severe(String.format("Transfer zone group id for XML not set successfully for planit transfer zone group %s (id:%d)", transferGroup.getXmlId(), transferGroup.getId()));
        }
        if (transferGroup.hasExternalId()) {
            xmlTransferGroup.setExternalid(transferGroup.getExternalId());
        }
        if (transferGroup.hasName()) {
            xmlTransferGroup.setName(transferGroup.getName());
        }
        xmlTransferGroup.setTzrefs(transferGroup.getTransferZones().stream().map(transferZone -> (String)this.getPrimaryIdMapper().getZoneIdMapper().apply(transferZone)).sorted().collect(Collectors.joining(this.getSettings().getCommaSeparator().toString())));
    }

    private void populateXmlTransferZoneGroups(Zoning zoning, XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal) {
        if (zoning == null || zoning.getTransferZoneGroups().isEmpty()) {
            return;
        }
        LOGGER.info("Transfer zone groups: " + zoning.getTransferZoneGroups().size());
        if (((Intermodaltype)xmlIntermodal.getValue()).getTransferzonegroups() == null) {
            ((Intermodaltype)xmlIntermodal.getValue()).setTransferzonegroups(new XMLElementTransferZoneGroups());
        }
        XMLElementTransferZoneGroups xmlTransferZoneGroups = ((Intermodaltype)xmlIntermodal.getValue()).getTransferzonegroups();
        zoning.getTransferZoneGroups().streamSortedBy(this.getPrimaryIdMapper().getTransferZoneGroupIdMapper()).forEach(transferGroup -> {
            if (!transferGroup.hasTransferZones()) {
                LOGGER.warning(String.format("DISCARD: transfer zone group %s (id:%d) is dangling", transferGroup.getXmlId(), transferGroup.getId()));
                return;
            }
            XMLElementTransferGroup xmlTransferGroup = new XMLElementTransferGroup();
            this.populateXmlTransferGroup(xmlTransferGroup, (TransferZoneGroup)transferGroup);
            xmlTransferZoneGroups.getTransfergroup().add(xmlTransferGroup);
        });
    }

    private void populateXmlTransferConnectoid(XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid, DirectedConnectoid transferConnectoid) {
        if (!transferConnectoid.hasAccessZones()) {
            LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) is dangling", transferConnectoid.getXmlId(), transferConnectoid.getId()));
            return;
        }
        if (!transferConnectoid.hasAccessLinkSegment()) {
            LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) has no access link segment", transferConnectoid.getXmlId(), transferConnectoid.getId()));
            return;
        }
        Zone firstAccessZone = transferConnectoid.getFirstAccessZone();
        if (transferConnectoid.getAccessZones().size() > 1) {
            Double lengthKm = null;
            for (Zone zone2 : transferConnectoid.getAccessZones()) {
                Optional currLengthKm = transferConnectoid.getLengthKm(zone2);
                if (lengthKm == null) {
                    lengthKm = (Double)currLengthKm.get();
                    continue;
                }
                if (!currLengthKm.isPresent() || Precision.equal((double)lengthKm, (double)((Double)currLengthKm.get()), (double)1.0E-6)) continue;
                LOGGER.warning(String.format("Transfer connectoid %s (id:%d) has different lengths specified for different access zones it services, this is not yet supported in the Planit XML format, choosing first available length %.2f", transferConnectoid.getXmlId(), transferConnectoid.getId(), transferConnectoid.getLengthKm(transferConnectoid.getFirstAccessZone()).get()));
                break;
            }
        }
        Collection explicitAllowedModes = transferConnectoid.getExplicitlyAllowedModes(firstAccessZone);
        if (transferConnectoid.getAccessZones().size() > 1) {
            boolean valid = true;
            Zone prevZone = firstAccessZone;
            for (Zone zone3 : transferConnectoid.getAccessZones()) {
                if (transferConnectoid.isAllModesAllowed(prevZone) == transferConnectoid.isAllModesAllowed(zone3)) {
                    prevZone = zone3;
                }
                if (!valid || transferConnectoid.isAllModesAllowed(zone3) || !(valid = explicitAllowedModes != null) || (valid = (valid = transferConnectoid.getExplicitlyAllowedModes(zone3).containsAll(explicitAllowedModes)) || explicitAllowedModes.containsAll(transferConnectoid.getExplicitlyAllowedModes(zone3)))) continue;
                explicitAllowedModes.addAll(transferConnectoid.getExplicitlyAllowedModes(zone3));
            }
            if (!valid) {
                LOGGER.warning(String.format("Transfer connectoid has different supported modes for different access zones it services, this is not yet supported in the Planit XML format: Allowing all modes across all access zones of connectoid instead", transferConnectoid.getXmlId(), transferConnectoid.getId()));
            }
        }
        this.populateXmlConnectoidBase((Connectoidtype)xmlTransferConnectoid, (Connectoid)transferConnectoid, transferConnectoid.getLengthKm(firstAccessZone), explicitAllowedModes);
        String xmlTzRefs = transferConnectoid.getAccessZones().stream().map(zone -> (String)this.getPrimaryIdMapper().getZoneIdMapper().apply(zone)).sorted().collect(Collectors.joining(","));
        xmlTransferConnectoid.setTzrefs(xmlTzRefs);
        xmlTransferConnectoid.setLsref((String)this.getComponentIdMappers().getNetworkIdMappers().getLinkSegmentIdMapper().apply((MacroscopicLinkSegment)transferConnectoid.getAccessLinkSegment()));
        if (!transferConnectoid.isNodeAccessDownstream()) {
            xmlTransferConnectoid.setLoc(Connectoidnodelocationtype.UPSTREAM);
        }
        if (transferConnectoid.isNodeAccessDownstream() && !transferConnectoid.getAccessNode().idEquals((Object)transferConnectoid.getAccessLinkSegment().getDownstreamVertex()) || !transferConnectoid.isNodeAccessDownstream() && !transferConnectoid.getAccessNode().idEquals((Object)transferConnectoid.getAccessLinkSegment().getUpstreamVertex())) {
            LOGGER.warning(String.format("Transfer connectoid %s (id:%d) access node location is in conflict with the registered access node", transferConnectoid.getXmlId(), transferConnectoid.getId()));
        }
    }

    private void populateXmlTransferZone(TransferZone transferZone, XMLElementTransferZones xmlTransferZones) {
        XMLElementTransferZones.XMLElementTransferZone xmlTransferZone = new XMLElementTransferZones.XMLElementTransferZone();
        xmlTransferZones.getZone().add(xmlTransferZone);
        xmlTransferZone.setId((String)this.getPrimaryIdMapper().getZoneIdMapper().apply(transferZone));
        if (transferZone.hasExternalId()) {
            xmlTransferZone.setExternalid(transferZone.getExternalId());
        }
        if (transferZone.hasName()) {
            xmlTransferZone.setName(transferZone.getName());
        }
        if (transferZone.hasPlatformNames()) {
            xmlTransferZone.setPlatforms(transferZone.getTransferZonePlatformNames().stream().sorted().collect(Collectors.joining(CharacterUtils.COMMA.toString())));
        }
        if (!transferZone.getTransferZoneType().equals((Object)TransferZoneType.NONE)) {
            xmlTransferZone.setType(PlanitZoningWriter.createXmlTransferZoneType(transferZone.getTransferZoneType()));
        }
        boolean geometryIsPoint = false;
        Function<Zone, Point> getCentroidLocation = z -> z.getCentroid().getPosition();
        if (transferZone.hasGeometry()) {
            if (transferZone.getGeometry() instanceof Polygon) {
                xmlTransferZone.setPolygon(this.createGmlPolygonType((Polygon)transferZone.getGeometry()));
            } else if (transferZone.getGeometry() instanceof LineString) {
                xmlTransferZone.setLineString(this.createGmlLineStringType((LineString)transferZone.getGeometry()));
            } else if (transferZone.getGeometry() instanceof Point) {
                getCentroidLocation = z -> (Point)z.getGeometry();
                geometryIsPoint = true;
            }
        }
        if (transferZone.hasCentroid() && transferZone.getCentroid().hasPosition() || geometryIsPoint) {
            XMLElementCentroid xmlCentroid = new XMLElementCentroid();
            Centroid centroid = transferZone.getCentroid();
            this.populateXmlCentroid(xmlCentroid, centroid != null ? transferZone.getCentroid().getName() : "", getCentroidLocation.apply((Zone)transferZone));
            xmlTransferZone.setCentroid(xmlCentroid);
        }
    }

    private void populateXmlTransferZoneAccess(Zoning zoning, XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal) {
        if (zoning == null || zoning.getTransferConnectoids().isEmpty()) {
            LOGGER.severe("transfer zone access should not be persisted when no transfer connectoids exist on the zoning");
            return;
        }
        if (((Intermodaltype)xmlIntermodal.getValue()).getTransferzoneaccess() == null) {
            ((Intermodaltype)xmlIntermodal.getValue()).setTransferzoneaccess(new XMLElementTransferZoneAccess());
        }
        XMLElementTransferZoneAccess xmlTransferZoneAccess = ((Intermodaltype)xmlIntermodal.getValue()).getTransferzoneaccess();
        zoning.getTransferConnectoids().streamSortedBy(this.getPrimaryIdMapper().getConnectoidIdMapper()).forEach(transferConnectoid -> {
            if (!transferConnectoid.hasAccessZones()) {
                LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) is dangling", transferConnectoid.getXmlId(), transferConnectoid.getId()));
                return;
            }
            if (!transferConnectoid.hasAccessLinkSegment()) {
                LOGGER.warning(String.format("DISCARD: transfer connectoid %s (id:%d) has no access link segment", transferConnectoid.getXmlId(), transferConnectoid.getId()));
                return;
            }
            XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoidBase = new XMLElementTransferZoneAccess.XMLElementTransferConnectoid();
            this.populateXmlTransferConnectoid(xmlTransferConnectoidBase, (DirectedConnectoid)transferConnectoid);
            xmlTransferZoneAccess.getConnectoid().add(xmlTransferConnectoidBase);
        });
        LOGGER.info("Transfer connectoids: " + zoning.getTransferConnectoids().size());
    }

    private void populateXmlTransferZones(Zoning zoning, XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal) {
        if (zoning == null || zoning.getTransferConnectoids().isEmpty()) {
            LOGGER.severe("Transfer zones should not be persisted when no transfer zones exist on the zoning");
            return;
        }
        LOGGER.info("TransferZones: " + zoning.getTransferZones().size());
        if (((Intermodaltype)xmlIntermodal.getValue()).getTransferzones() == null) {
            ((Intermodaltype)xmlIntermodal.getValue()).setTransferzones(new XMLElementTransferZones());
        }
        XMLElementTransferZones xmlTransferZones = ((Intermodaltype)xmlIntermodal.getValue()).getTransferzones();
        zoning.getTransferZones().streamSortedBy(this.getPrimaryIdMapper().getZoneIdMapper()).forEach(transferZone -> this.populateXmlTransferZone((TransferZone)transferZone, xmlTransferZones));
    }

    private void populateXmlCentroid(XMLElementCentroid xmlCentroid, String name, Point centroidLocation) {
        if (!StringUtils.isNullOrBlank((String)name)) {
            xmlCentroid.setName(name);
        }
        if (centroidLocation != null) {
            xmlCentroid.setPoint(this.createGmlPointType(centroidLocation));
        }
    }

    private void populateXmlConnectoidBase(Connectoidtype xmlConnectoidBase, Connectoid connectoid, Optional<Double> lengthKm, Collection<Mode> accessModes) {
        xmlConnectoidBase.setId((String)this.getPrimaryIdMapper().getConnectoidIdMapper().apply(connectoid));
        if (StringUtils.isNullOrBlank((String)xmlConnectoidBase.getId())) {
            LOGGER.severe(String.format("Connectoid id for xml remains null for connectoid (id:%d), this is not allowed", connectoid.getId()));
        }
        if (connectoid.hasExternalId()) {
            xmlConnectoidBase.setExternalid(connectoid.getExternalId());
        }
        if (connectoid.hasName()) {
            xmlConnectoidBase.setName(connectoid.getName());
        }
        if (!connectoid.getType().equals((Object)ConnectoidType.NONE)) {
            xmlConnectoidBase.setType(PlanitZoningWriter.createXmlConnectoidType(connectoid.getType()));
        }
        if (lengthKm.isPresent()) {
            xmlConnectoidBase.setLength(lengthKm.get());
        }
        if (accessModes != null) {
            String csvModeIdString = accessModes.stream().map(mode -> (String)this.getComponentIdMappers().getNetworkIdMappers().getModeIdMapper().apply(mode)).sorted().collect(Collectors.joining(String.valueOf(this.getSettings().getCommaSeparator())));
            xmlConnectoidBase.setModes(csvModeIdString);
        }
    }

    private void populateXmlOdConnectoid(XMLElementConnectoid xmlConnectoid, UndirectedConnectoid odConnectoid, Zone accessZone) {
        if (!odConnectoid.hasAccessZone(accessZone)) {
            LOGGER.severe(String.format("od conectoid %s (id:%d) is expected to support od zone %s (id:%d), but zone is not registered as access zone", odConnectoid.getXmlId(), odConnectoid.getId(), accessZone.getXmlId(), accessZone.getId()));
        }
        xmlConnectoid.setType(Connectoidtypetype.TRAVELLER_ACCESS);
        xmlConnectoid.setNoderef((String)this.getComponentIdMappers().getNetworkIdMappers().getVertexIdMapper().apply(odConnectoid.getAccessVertex()));
        this.populateXmlConnectoidBase((Connectoidtype)xmlConnectoid, (Connectoid)odConnectoid, odConnectoid.getLengthKm(accessZone), odConnectoid.getExplicitlyAllowedModes(accessZone));
    }

    private void populateXmlOdZone(Zoning zoning, OdZone odZone) {
        if (!this.zoneToConnectoidMap.containsKey(odZone)) {
            LOGGER.warning(String.format("DISCARD: od zone %s (id: %d) without connectoids found; dangling", odZone.getXmlId(), odZone.getId()));
            return;
        }
        XMLElementZones.Zone xmlOdZone = new XMLElementZones.Zone();
        this.xmlRawZoning.getZones().getZone().add(xmlOdZone);
        xmlOdZone.setId((String)this.getPrimaryIdMapper().getZoneIdMapper().apply(odZone));
        if (odZone.hasExternalId()) {
            xmlOdZone.setExternalid(odZone.getExternalId());
        }
        if (odZone.hasName()) {
            xmlOdZone.setName(odZone.getName());
        }
        boolean geometryIsPoint = false;
        Function<Zone, Point> getCentroidLocation = z -> z.getCentroid().getPosition();
        if (odZone.hasGeometry()) {
            if (odZone.getGeometry() instanceof Polygon) {
                xmlOdZone.setPolygon(this.createGmlPolygonType((Polygon)odZone.getGeometry()));
            } else if (odZone.getGeometry() instanceof Point) {
                getCentroidLocation = z -> (Point)z.getGeometry();
                geometryIsPoint = true;
            }
        }
        if (odZone.hasCentroid() && odZone.getCentroid().hasPosition() || geometryIsPoint) {
            XMLElementCentroid xmlCentroid = new XMLElementCentroid();
            Centroid centroid = odZone.getCentroid();
            this.populateXmlCentroid(xmlCentroid, centroid != null ? odZone.getCentroid().getName() : "", getCentroidLocation.apply((Zone)odZone));
            xmlOdZone.setCentroid(xmlCentroid);
        }
        XMLElementConnectoids xmlConnectoids = new XMLElementConnectoids();
        xmlOdZone.setConnectoids(xmlConnectoids);
        this.zoneToConnectoidMap.get(odZone).stream().sorted(Comparator.comparing(this.getPrimaryIdMapper().getConnectoidIdMapper())).forEach(connectoid -> {
            if (connectoid instanceof UndirectedConnectoid) {
                UndirectedConnectoid odConnectoid = (UndirectedConnectoid)connectoid;
                if (!odConnectoid.hasAccessZone((Zone)odZone)) {
                    LOGGER.severe(String.format("OD conectoid %s (id:%d) is expected to support od zone %s (id:%d), but zone is not registered as access zone", odConnectoid.getXmlId(), odConnectoid.getId(), odZone.getXmlId(), odZone.getId()));
                }
                XMLElementConnectoid xmlOdConnectoidBase = new XMLElementConnectoid();
                this.populateXmlOdConnectoid(xmlOdConnectoidBase, odConnectoid, (Zone)odZone);
                xmlConnectoids.getConnectoid().add(xmlOdConnectoidBase);
            }
        });
        LOGGER.info("Od connectoids: " + zoning.getOdConnectoids().size());
    }

    private void populateXmlId(Zoning zoning) {
        String xmlId = (String)this.getPrimaryIdMapper().getZoningIdMapper().apply(zoning);
        if (StringUtils.isNullOrBlank((String)xmlId)) {
            LOGGER.warning(String.format("Zoning has no XML id defined, adopting internally generated id %d instead", zoning.getId()));
            xmlId = String.valueOf(zoning.getId());
            zoning.setXmlId(xmlId);
        }
        this.xmlRawZoning.setId(xmlId);
    }

    private void populateXmlZoningSrsName() {
        this.xmlRawZoning.setSrsname(PlanitZoningWriter.extractSrsName((CoordinateReferenceSystem)this.getDestinationCoordinateReferenceSystem()));
    }

    private void populateXmlOdZones(Zoning zoning) {
        if (zoning.getOdZones().isEmpty()) {
            LOGGER.severe("No OD zones present when creating zoning XML elements");
            return;
        }
        LOGGER.info("OD Zones: " + zoning.getOdZones().size());
        XMLElementZones xmlOdZones = this.xmlRawZoning.getZones();
        if (xmlOdZones == null) {
            xmlOdZones = new XMLElementZones();
            this.xmlRawZoning.setZones(xmlOdZones);
        }
        zoning.getOdZones().streamSortedBy(this.getPrimaryIdMapper().getZoneIdMapper()).forEach(odZone -> this.populateXmlOdZone(zoning, (OdZone)odZone));
    }

    private void populateXmlIntermodal(Zoning zoning) {
        if (zoning.getTransferZones().isEmpty() && zoning.getTransferConnectoids().isEmpty()) {
            LOGGER.severe("Transfer zones and/or connectoids should be present when creating intermodal XML elements, but they are empty, abort");
            return;
        }
        XMLElementMacroscopicZoning.XMLElementIntermodal xmlIntermodal = this.xmlRawZoning.getIntermodal();
        if (xmlIntermodal == null) {
            xmlIntermodal = new XMLElementMacroscopicZoning.XMLElementIntermodal(new Intermodaltype());
            this.xmlRawZoning.setIntermodal(xmlIntermodal);
        }
        this.populateXmlTransferZones(zoning, xmlIntermodal);
        this.populateXmlTransferZoneAccess(zoning, xmlIntermodal);
        this.populateXmlTransferZoneGroups(zoning, xmlIntermodal);
    }

    protected PlanitZoningWriter(String zoningPath, String countryName, XMLElementMacroscopicZoning xmlRawZoning) {
        this(new PlanitZoningWriterSettings(zoningPath, "zoning.xml", countryName), xmlRawZoning);
    }

    protected PlanitZoningWriter(PlanitZoningWriterSettings settings, XMLElementMacroscopicZoning xmlRawZoning) {
        super(IdMapperType.XML);
        this.settings = settings;
        this.xmlRawZoning = xmlRawZoning;
    }

    public ZoningIdMapper getPrimaryIdMapper() {
        return this.getComponentIdMappers().getZoningIdMappers();
    }

    public void write(Zoning zoning) {
        PlanItRunTimeException.throwIfNull((Object)zoning, (String)"Zoning is null cannot write to Planit native format");
        this.getComponentIdMappers().populateMissingIdMappers(this.getIdMapperType());
        this.prepareCoordinateReferenceSystem(zoning.getCoordinateReferenceSystem(), this.getSettings().getDestinationCoordinateReferenceSystem(), this.getSettings().getCountry());
        LOGGER.info(String.format("Persisting PLANit zoning to: %s", Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getFileName())));
        this.createZoneToConnectoidIndices(zoning);
        this.getSettings().logSettings();
        this.populateXmlId(zoning);
        this.populateXmlZoningSrsName();
        this.populateXmlOdZones(zoning);
        if (!zoning.getTransferZones().isEmpty() || !zoning.getTransferConnectoids().isEmpty()) {
            this.populateXmlIntermodal(zoning);
        }
        super.persist(this.xmlRawZoning, XMLElementMacroscopicZoning.class, "macroscopiczoninginput.xsd");
    }

    public void reset() {
        this.xmlRawZoning.setZones(null);
        this.xmlRawZoning.setIntermodal(null);
        this.xmlRawZoning.setSrsname(null);
        this.zoneToConnectoidMap.clear();
    }

    public PlanitZoningWriterSettings getSettings() {
        return this.settings;
    }
}

