/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.zoning;

import org.goplanit.converter.network.NetworkReader;
import org.goplanit.io.converter.zoning.PlanitZoningReader;
import org.goplanit.io.converter.zoning.PlanitZoningReaderSettings;
import org.goplanit.io.xml.util.PlanitXmlReaderSettings;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.zoning.Zoning;

public class PlanitZoningReaderFactory {
    public static PlanitZoningReader create(String pathDirectory, LayeredNetwork<?, ?> network) {
        return PlanitZoningReaderFactory.create(pathDirectory, PlanitXmlReaderSettings.DEFAULT_XML_EXTENSION, network, new Zoning(network.getIdGroupingToken(), network.getNetworkGroupingTokenId()));
    }

    public static PlanitZoningReader create(String pathDirectory, String xmlFileExtension, LayeredNetwork<?, ?> network, Zoning zoning) {
        return PlanitZoningReaderFactory.create(new PlanitZoningReaderSettings(pathDirectory, xmlFileExtension), network, zoning);
    }

    public static PlanitZoningReader create(PlanitZoningReaderSettings zoningSettings, LayeredNetwork<?, ?> referenceNetwork) {
        return new PlanitZoningReader(zoningSettings, referenceNetwork, new Zoning(referenceNetwork.getIdGroupingToken(), referenceNetwork.getNetworkGroupingTokenId()));
    }

    public static PlanitZoningReader create(PlanitZoningReaderSettings zoningSettings, LayeredNetwork<?, ?> referenceNetwork, Zoning zoningToPopulate) {
        return new PlanitZoningReader(zoningSettings, referenceNetwork, zoningToPopulate);
    }

    public static PlanitZoningReader create(XMLElementMacroscopicZoning xmlRawZoning, LayeredNetwork<?, ?> network, Zoning zoning) {
        return new PlanitZoningReader(xmlRawZoning, network, zoning);
    }

    public static PlanitZoningReader create(XMLElementMacroscopicZoning xmlRawZoning, PlanitZoningReaderSettings zoningSettings, LayeredNetwork<?, ?> network, Zoning zoning) {
        return new PlanitZoningReader(xmlRawZoning, zoningSettings, network, zoning);
    }

    public static PlanitZoningReader create(NetworkReader networkReader) {
        return PlanitZoningReaderFactory.create(new PlanitZoningReaderSettings(), networkReader);
    }

    public static PlanitZoningReader create(PlanitZoningReaderSettings settings, NetworkReader networkReader) {
        return new PlanitZoningReader(settings, networkReader);
    }
}

