/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.zoning;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import net.opengis.gml.AbstractRingPropertyType;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.PolygonType;
import org.goplanit.converter.BaseReaderImpl;
import org.goplanit.converter.network.NetworkReader;
import org.goplanit.converter.zoning.ZoningReader;
import org.goplanit.io.converter.zoning.PlanitZoningReaderSettings;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.ConnectoidType;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.xml.generated.Connectoidnodelocationtype;
import org.goplanit.xml.generated.Connectoidtype;
import org.goplanit.xml.generated.Connectoidtypetype;
import org.goplanit.xml.generated.Intermodaltype;
import org.goplanit.xml.generated.Transferzonetype;
import org.goplanit.xml.generated.XMLElementCentroid;
import org.goplanit.xml.generated.XMLElementConnectoid;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementTransferGroup;
import org.goplanit.xml.generated.XMLElementTransferZoneAccess;
import org.goplanit.xml.generated.XMLElementTransferZoneGroups;
import org.goplanit.xml.generated.XMLElementTransferZones;
import org.goplanit.xml.generated.XMLElementZones;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.ZoningModifierUtils;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitZoningReader
extends BaseReaderImpl<Zoning>
implements ZoningReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitZoningReader.class.getCanonicalName());
    private final PlanitXmlJaxbParser<XMLElementMacroscopicZoning> xmlParser;
    private PlanitJtsCrsUtils jtsUtils = null;
    protected final PlanitZoningReaderSettings settings;
    private final NetworkReader networkReader;
    protected Zoning zoning;
    protected LayeredNetwork<?, ?> network;
    public static final String ZONING_XSD_FILE = "https://www.goplanit.org/xsd/macroscopiczoninginput.xsd";

    private void syncXmlIdsToIds() {
        LOGGER.info("Syncing PLANit zoning XML ids to internally generated ids, overwriting original XML ids");
        ZoningModifierUtils.syncManagedIdEntitiesContainerXmlIdsToIds((Zoning)this.zoning);
    }

    private void initialiseParentNetworkXmlIdTrackers(MacroscopicNetwork network) {
        this.initialiseSourceIdMap(Node.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(Node.class).addAll((Iterable)layer.getNodes()));
        this.initialiseSourceIdMap(MacroscopicLinkSegment.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(MacroscopicLinkSegment.class).addAll((Iterable)layer.getLinkSegments()));
    }

    private void initialiseXmlIdTrackers() {
        this.initialiseSourceIdMap(Zone.class, ExternalIdAble::getXmlId);
        this.initialiseSourceIdMap(Connectoid.class, ExternalIdAble::getXmlId);
    }

    private static TransferZoneType parseTransferZoneType(Transferzonetype xmlTransferZone) {
        if (xmlTransferZone == null) {
            return TransferZoneType.NONE;
        }
        switch (xmlTransferZone) {
            case PLATFORM: {
                return TransferZoneType.PLATFORM;
            }
            case STOP_POLE: {
                return TransferZoneType.POLE;
            }
            case UNKNOWN: {
                return TransferZoneType.UNKNOWN;
            }
            case NONE: {
                return TransferZoneType.NONE;
            }
        }
        LOGGER.warning(String.format("Unsupported transfer stop type %s found, changed to `unknown`", xmlTransferZone.value()));
        return TransferZoneType.UNKNOWN;
    }

    private static ConnectoidType parseConnectoidType(Connectoidtypetype xmlConnectoidType) {
        if (xmlConnectoidType == null) {
            return ConnectoidType.NONE;
        }
        switch (xmlConnectoidType) {
            case PT_VEH_STOP: {
                return ConnectoidType.PT_VEHICLE_STOP;
            }
            case TRAVELLER_ACCESS: {
                return ConnectoidType.TRAVELLER_ACCESS;
            }
            case NONE: {
                return ConnectoidType.NONE;
            }
        }
        LOGGER.warning(String.format("Unknown connectoid type %s found, changed to `unknown`", xmlConnectoidType.value()));
        return ConnectoidType.UNKNOWN;
    }

    private static void populateZoneGeometry(Zone zone, PolygonType xmlPolygon, LineStringType xmlLineString) {
        LineString geometry = null;
        if (xmlPolygon != null) {
            if (xmlPolygon.getExterior() == null) {
                LOGGER.warning(String.format("zones only support polygon geometries with an outer exterior, however this is missing for zone %s", zone.getXmlId()));
            } else if (((AbstractRingPropertyType)xmlPolygon.getExterior().getValue()).getRing() == null) {
                LOGGER.warning(String.format("expected ring element missing within polygon exterior element for zone %s", zone.getXmlId()));
            } else if (((AbstractRingPropertyType)xmlPolygon.getExterior().getValue()).getRing().getValue() instanceof LinearRingType) {
                LinearRingType xmlLinearRing = (LinearRingType)((AbstractRingPropertyType)xmlPolygon.getExterior().getValue()).getRing().getValue();
                geometry = PlanitJtsUtils.create2DPolygon((List)xmlLinearRing.getPosList().getValue());
            } else {
                LOGGER.warning(String.format("expected linear ring within polygon exterior element for zone %s, but different ring type was encountered", zone.getXmlId()));
            }
        } else if (xmlLineString != null) {
            if (xmlLineString.getCoordinates() != null) {
                CoordinatesType ct = xmlLineString.getCoordinates();
                geometry = PlanitJtsUtils.createLineStringFromCsvString((String)ct.getValue(), (String)ct.getTs(), (String)ct.getCs());
            } else if (xmlLineString.getPosList() != null) {
                geometry = PlanitJtsUtils.createLineString((List)xmlLineString.getPosList().getValue());
            }
        }
        zone.setGeometry(geometry);
    }

    private static void populateZoneGeometry(Zone zone, PolygonType xmlPolygon) {
        PlanitZoningReader.populateZoneGeometry(zone, xmlPolygon, null);
    }

    private static void populateConnectoidToZoneLengths(Connectoid connectoid, Connectoidtype xmlConnectoid, Point position, PlanitJtsCrsUtils jtsUtils) {
        block5: {
            Double connectoidLength;
            block4: {
                connectoidLength = null;
                if (xmlConnectoid.getLength() == null) break block4;
                connectoidLength = (double)xmlConnectoid.getLength();
                if (connectoid.getNumberOfAccessZones() > 1) {
                    LOGGER.fine(String.format("connectoid %s has explicitly set length, yet has multiple access zones that now all receive equal lengths", connectoid.getXmlId()));
                }
                for (Zone accessZone : connectoid) {
                    connectoid.setLength(accessZone, connectoidLength.doubleValue());
                }
                break block5;
            }
            if (position == null) break block5;
            for (Zone accessZone : connectoid) {
                if (accessZone.getCentroid() == null || accessZone.getCentroid().getPosition() != null) {
                    LOGGER.warning(String.format("access zone of connectoid %s is null", connectoid.getXmlId()));
                    continue;
                }
                if (accessZone.getCentroid().getPosition() == null) continue;
                connectoidLength = jtsUtils.getDistanceInKilometres(accessZone.getCentroid().getPosition(), position);
                connectoid.setLength(accessZone, connectoidLength.doubleValue());
            }
        }
    }

    private void parseBaseZone(Zone zone, String xmlId, String externalId, String name, XMLElementCentroid xmlCentroid) {
        if (StringUtils.isNullOrBlank((String)xmlId)) {
            throw new PlanItRunTimeException("Zone cannot be parsed, its (XML) id is not set");
        }
        zone.setXmlId(xmlId);
        this.registerBySourceId(Zone.class, zone);
        if (externalId != null && !externalId.isBlank()) {
            zone.setExternalId(externalId);
        }
        if (!StringUtils.isNullOrBlank((String)name)) {
            zone.setName(name);
        }
        Centroid centroid = zone.getCentroid();
        if (xmlCentroid != null) {
            if (xmlCentroid.getName() != null) {
                centroid.setName(xmlCentroid.getName());
            }
            if (xmlCentroid.getPoint() != null) {
                List value = xmlCentroid.getPoint().getPos().getValue();
                centroid.setPosition(PlanitJtsUtils.createPoint((Number)((Number)value.get(0)), (Number)((Number)value.get(1))));
            }
        }
    }

    private Connectoid parseBaseConnectoid(Connectoidtype xmlConnectoid) {
        UndirectedConnectoid theConnectoid = null;
        String xmlId = null;
        if (StringUtils.isNullOrBlank((String)xmlConnectoid.getId())) {
            LOGGER.severe("DISCARD: Parsed connectoid has no (XML) id");
            return null;
        }
        xmlId = xmlConnectoid.getId();
        if (xmlConnectoid instanceof XMLElementConnectoid) {
            XMLElementConnectoid xmlOdConnectoid = (XMLElementConnectoid)xmlConnectoid;
            Node accessNode = (Node)this.getBySourceId(Node.class, xmlOdConnectoid.getNoderef());
            if (accessNode == null) {
                throw new PlanItRunTimeException(String.format("Provided accessNode XML id %s is invalid given available nodes in network when parsing transfer connectoid %s", xmlOdConnectoid.getNoderef(), xmlConnectoid.getId()));
            }
            theConnectoid = this.zoning.getOdConnectoids().getFactory().registerNew(accessNode);
        } else if (xmlConnectoid instanceof XMLElementTransferZoneAccess.XMLElementTransferConnectoid) {
            XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid = (XMLElementTransferZoneAccess.XMLElementTransferConnectoid)xmlConnectoid;
            String xmlLinkSegmentRef = xmlTransferConnectoid.getLsref();
            MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)this.getBySourceId(MacroscopicLinkSegment.class, xmlLinkSegmentRef);
            if (linkSegment == null) {
                throw new PlanItRunTimeException(String.format("Provided access link segment XML id %s is invalid given available link segments in network when parsing transfer connectoid %s", xmlLinkSegmentRef, xmlConnectoid.getId()));
            }
            boolean nodeAccessDownstream = true;
            if (xmlTransferConnectoid.getLoc() != null && xmlTransferConnectoid.getLoc() == Connectoidnodelocationtype.UPSTREAM) {
                nodeAccessDownstream = false;
            }
            theConnectoid = this.zoning.getTransferConnectoids().getFactory().registerNew(nodeAccessDownstream, (LinkSegment)linkSegment);
        }
        theConnectoid.setXmlId(xmlId);
        if (xmlConnectoid.getExternalid() != null && !xmlConnectoid.getExternalid().isBlank()) {
            theConnectoid.setExternalId(xmlConnectoid.getExternalid());
        }
        if (xmlConnectoid.getName() != null && !xmlConnectoid.getName().isBlank()) {
            theConnectoid.setName(xmlConnectoid.getName());
        }
        theConnectoid.setType(PlanitZoningReader.parseConnectoidType(xmlConnectoid.getType()));
        return theConnectoid;
    }

    private TransferZoneGroup parseTransferGroup(XMLElementTransferGroup xmlTransferGroup) {
        TransferZoneGroup transferGroup = this.zoning.getTransferZoneGroups().getFactory().registerNew();
        transferGroup.setXmlId(xmlTransferGroup.getId());
        if (xmlTransferGroup.getExternalid() != null && !xmlTransferGroup.getExternalid().isBlank()) {
            transferGroup.setExternalId(xmlTransferGroup.getExternalid());
        }
        if (xmlTransferGroup.getName() != null && !xmlTransferGroup.getName().isBlank()) {
            transferGroup.setName(xmlTransferGroup.getName());
        }
        String[] transferZoneRefsByXmlId = StringUtils.splitByAnythingExceptAlphaNumeric((String)xmlTransferGroup.getTzrefs());
        for (int index = 0; index < transferZoneRefsByXmlId.length; ++index) {
            String transferZoneXmlId = transferZoneRefsByXmlId[index];
            TransferZone transferZone = (TransferZone)this.getBySourceId(Zone.class, transferZoneXmlId);
            if (transferZone == null) {
                LOGGER.warning(String.format("Transfer zone group %s (id:%d) references transfer zone %s that is not available in the parser, transfer zone ignored", transferGroup.getXmlId(), transferGroup.getId(), transferZoneRefsByXmlId));
            }
            transferGroup.addTransferZone(transferZone);
        }
        return transferGroup;
    }

    private void populateTransferZones(XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal) throws PlanItException {
        if (((Intermodaltype)xmlInterModal.getValue()).getTransferzones() == null) {
            return;
        }
        XMLElementTransferZones xmlTransferZones = ((Intermodaltype)xmlInterModal.getValue()).getTransferzones();
        List xmlTransferZonesList = xmlTransferZones.getZone();
        for (XMLElementTransferZones.XMLElementTransferZone xmlTransferzone : xmlTransferZonesList) {
            TransferZone transferZone = this.zoning.getTransferZones().getFactory().registerNew();
            this.parseBaseZone((Zone)transferZone, xmlTransferzone.getId(), xmlTransferzone.getExternalid(), xmlTransferzone.getName(), xmlTransferzone.getCentroid());
            if (xmlTransferzone.getType() != null) {
                transferZone.setType(PlanitZoningReader.parseTransferZoneType(xmlTransferzone.getType()));
            }
            if (xmlTransferzone.getPlatforms() != null) {
                transferZone.addTransferZonePlatformNames(xmlTransferzone.getPlatforms().split(CharacterUtils.COMMA.toString()));
            }
            PlanitZoningReader.populateZoneGeometry((Zone)transferZone, xmlTransferzone.getPolygon(), xmlTransferzone.getLineString());
        }
    }

    private void populateTransferZoneAccess(Modes modes, XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal) throws PlanItException {
        if (((Intermodaltype)xmlInterModal.getValue()).getTransferzoneaccess() == null) {
            return;
        }
        XMLElementTransferZoneAccess xmlTransferZoneAccess = ((Intermodaltype)xmlInterModal.getValue()).getTransferzoneaccess();
        HashMap modesByXmlId = new HashMap();
        modes.forEach(mode -> modesByXmlId.put(mode.getXmlId(), mode));
        List xmlTransferConnectoids = xmlTransferZoneAccess.getConnectoid();
        for (XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid : xmlTransferConnectoids) {
            DirectedConnectoid connectoid = (DirectedConnectoid)this.parseBaseConnectoid((Connectoidtype)xmlTransferConnectoid);
            String modesRef = xmlTransferConnectoid.getModes();
            HashSet<Mode> allowedModes = null;
            boolean implicitAllModesAllowed = true;
            if (!StringUtils.isNullOrBlank((String)modesRef)) {
                implicitAllModesAllowed = false;
                allowedModes = new HashSet<Mode>();
                for (String xmlModeRef : List.of(modesRef.split(","))) {
                    Mode mode2 = (Mode)modesByXmlId.get(xmlModeRef);
                    if (mode2 == null) {
                        LOGGER.warning(String.format("invalid mode %s referenced by transfer connectoid %s", xmlModeRef, connectoid.getXmlId()));
                        continue;
                    }
                    allowedModes.add(mode2);
                }
            }
            String TransferZoneRefs = xmlTransferConnectoid.getTzrefs();
            for (String xmlAccessZoneRef : List.of(TransferZoneRefs.split(","))) {
                Zone accessZone = (Zone)this.getBySourceId(Zone.class, xmlAccessZoneRef);
                if (accessZone == null) {
                    LOGGER.warning(String.format("invalid transfer zone %s referenced by transfer connectoid %s", xmlAccessZoneRef, connectoid.getXmlId()));
                    continue;
                }
                connectoid.addAccessZone(accessZone);
                if (implicitAllModesAllowed) continue;
                allowedModes.forEach(allowedMode -> connectoid.addAllowedMode(accessZone, allowedMode));
            }
            PlanitZoningReader.populateConnectoidToZoneLengths((Connectoid)connectoid, (Connectoidtype)xmlTransferConnectoid, connectoid.getAccessNode().getPosition(), this.jtsUtils);
            this.registerBySourceId(Connectoid.class, connectoid);
        }
    }

    private void populateTransferZoneGroups(XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal) {
        if (((Intermodaltype)xmlInterModal.getValue()).getTransferzonegroups() == null) {
            return;
        }
        XMLElementTransferZoneGroups xmlTransferZoneGroups = ((Intermodaltype)xmlInterModal.getValue()).getTransferzonegroups();
        if (xmlTransferZoneGroups.getTransfergroup().isEmpty()) {
            LOGGER.warning("Dangling transfer zone groups element, no transfer zone groups can be parsed");
            return;
        }
        List xmlTransferGroups = xmlTransferZoneGroups.getTransfergroup();
        for (XMLElementTransferGroup xmlTransferGroup : xmlTransferGroups) {
            this.parseTransferGroup(xmlTransferGroup);
        }
    }

    protected void populateIntermodal(Modes modes) throws PlanItException {
        if (this.xmlParser.getXmlRootElement().getIntermodal() == null) {
            LOGGER.info("No Transfer zones present, skip");
            return;
        }
        LOGGER.info("Parsing transfer zones...");
        XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal = this.xmlParser.getXmlRootElement().getIntermodal();
        this.populateTransferZones(xmlInterModal);
        this.populateTransferZoneAccess(modes, xmlInterModal);
        this.populateTransferZoneGroups(xmlInterModal);
    }

    private void parseCoordinateReferenceSystem(MacroscopicNetwork macroscopicNetwork) {
        CoordinateReferenceSystem crs;
        String srsName = this.xmlParser.getXmlRootElement().getSrsname();
        if (StringUtils.isNullOrBlank((String)srsName)) {
            LOGGER.severe("Zoning crs not defined on XML root element, compulsory since v0.4.0 using network fallback instead if possible");
            crs = macroscopicNetwork.getCoordinateReferenceSystem();
        } else {
            crs = PlanitXmlJaxbParser.createPlanitCrs(this.xmlParser.getXmlRootElement().getSrsname());
        }
        this.zoning.setCoordinateReferenceSystem(crs);
        if (!this.zoning.getCoordinateReferenceSystem().equals(macroscopicNetwork.getCoordinateReferenceSystem())) {
            LOGGER.severe(String.format("Zoning crs (%s) and network crs (%s) are not compatible", crs.getName(), macroscopicNetwork.getCoordinateReferenceSystem().getName()));
        }
        this.jtsUtils = new PlanitJtsCrsUtils(crs);
    }

    protected void setZoning(Zoning zoning) {
        this.zoning = zoning;
    }

    protected void setReferenceNetwork(LayeredNetwork<?, ?> network) {
        this.network = network;
    }

    protected void populateODZones() {
        if (this.xmlParser.getXmlRootElement().getZones() == null) {
            LOGGER.info("No OD zones found in zoning, skip");
            return;
        }
        LOGGER.info("Parsing OD zones...");
        for (XMLElementZones.Zone xmlZone : this.xmlParser.getXmlRootElement().getZones().getZone()) {
            OdZone zone = this.zoning.getOdZones().getFactory().registerNew();
            this.parseBaseZone((Zone)zone, xmlZone.getId(), xmlZone.getExternalid(), xmlZone.getId(), xmlZone.getCentroid());
            PlanitZoningReader.populateZoneGeometry((Zone)zone, xmlZone.getPolygon());
            List xmlConnectoids = xmlZone.getConnectoids().getConnectoid();
            for (XMLElementConnectoid xmlOdConnectoid : xmlConnectoids) {
                UndirectedConnectoid planitOdConnectoid = (UndirectedConnectoid)this.parseBaseConnectoid((Connectoidtype)xmlOdConnectoid);
                planitOdConnectoid.addAccessZone((Zone)zone);
                PlanitZoningReader.populateConnectoidToZoneLengths((Connectoid)planitOdConnectoid, (Connectoidtype)xmlOdConnectoid, planitOdConnectoid.getAccessVertex().getPosition(), this.jtsUtils);
            }
        }
    }

    protected PlanitZoningReader(PlanitZoningReaderSettings settings, NetworkReader networkReader) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicZoning>>(XMLElementMacroscopicZoning.class);
        this.settings = settings;
        this.networkReader = networkReader;
        this.setZoning(null);
        this.setReferenceNetwork(null);
    }

    protected PlanitZoningReader(PlanitZoningReaderSettings settings, LayeredNetwork<?, ?> network, Zoning zoning) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicZoning>>(XMLElementMacroscopicZoning.class);
        this.settings = settings;
        this.networkReader = null;
        this.setZoning(zoning);
        this.setReferenceNetwork(network);
    }

    protected PlanitZoningReader(String pathDirectory, String xmlFileExtension, LayeredNetwork<?, ?> network, Zoning zoning) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicZoning>>(XMLElementMacroscopicZoning.class);
        this.settings = new PlanitZoningReaderSettings(pathDirectory, xmlFileExtension);
        this.networkReader = null;
        this.setZoning(zoning);
        this.setReferenceNetwork(network);
    }

    protected PlanitZoningReader(XMLElementMacroscopicZoning xmlMacroscopicZoning, LayeredNetwork<?, ?> network, Zoning zoning) {
        this(xmlMacroscopicZoning, new PlanitZoningReaderSettings(), network, zoning);
    }

    protected PlanitZoningReader(XMLElementMacroscopicZoning xmlMacroscopicZoning, PlanitZoningReaderSettings settings, LayeredNetwork<?, ?> network, Zoning zoning) {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementMacroscopicZoning>(xmlMacroscopicZoning);
        this.settings = settings;
        this.networkReader = null;
        this.setZoning(zoning);
        this.setReferenceNetwork(network);
    }

    public Zoning read() {
        if (this.networkReader != null && this.network == null) {
            LayeredNetwork readNetwork = (LayeredNetwork)this.networkReader.read();
            if (readNetwork == null || !(readNetwork instanceof MacroscopicNetwork)) {
                throw new PlanItRunTimeException("No reference network available after parsing from provided network reader unable to read zoning");
            }
            this.setReferenceNetwork(readNetwork);
            this.setZoning(new Zoning(this.network.getIdGroupingToken(), this.network.getNetworkGroupingTokenId()));
        } else if (!(this.network instanceof MacroscopicNetwork)) {
            throw new PlanItRunTimeException("Unable to read zoning, provided network is not compatible with Macroscopic network");
        }
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)this.network;
        this.initialiseXmlIdTrackers();
        this.initialiseParentNetworkXmlIdTrackers(macroscopicNetwork);
        try {
            this.xmlParser.initialiseAndParseXmlRootElement(this.getSettings().getInputDirectory(), this.getSettings().getXmlFileExtension());
            PlanItRunTimeException.throwIfNull((Object)this.xmlParser.getXmlRootElement(), (String)"No valid PLANit XML zoning could be parsed into memory, abort");
            String zoningXmlId = this.xmlParser.getXmlRootElement().getId();
            if (StringUtils.isNullOrBlank((String)zoningXmlId)) {
                LOGGER.warning(String.format("Zoning has no XML id defined, adopting internally generated id %d instead", this.zoning.getId()));
                zoningXmlId = String.valueOf(this.zoning.getId());
            }
            this.zoning.setXmlId(zoningXmlId);
            this.parseCoordinateReferenceSystem(macroscopicNetwork);
            this.populateODZones();
            this.populateIntermodal(macroscopicNetwork.getModes());
            if (this.getSettings().isSyncXmlIdsToIds()) {
                this.syncXmlIdsToIds();
            }
            this.zoning.logInfo(LoggingUtils.zoningPrefix((long)this.zoning.getId()));
            this.reset();
        }
        catch (PlanItException e) {
            throw new PlanItRunTimeException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Error when populating zoning in PLANitIO", (Throwable)e);
        }
        return this.zoning;
    }

    public PlanitZoningReaderSettings getSettings() {
        return this.settings;
    }

    public LayeredNetwork<?, ?> getReferenceNetwork() {
        return this.network;
    }

    public void reset() {
        super.reset();
        this.xmlParser.clearXmlContent();
    }
}

