/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.ServiceNetworkIdMapper;
import org.goplanit.converter.service.ServiceNetworkWriter;
import org.goplanit.io.converter.network.UnTypedPlanitCrsWriterImpl;
import org.goplanit.io.converter.service.PlanitServiceNetworkWriterSettings;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceLegs;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layer.service.ServiceNodes;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.xml.generated.Direction;
import org.goplanit.xml.generated.XMLElementServiceLeg;
import org.goplanit.xml.generated.XMLElementServiceLegs;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.xml.generated.XMLElementServiceNetworkLayer;
import org.goplanit.xml.generated.XMLElementServiceNodes;

public class PlanitServiceNetworkWriter
extends UnTypedPlanitCrsWriterImpl<ServiceNetwork>
implements ServiceNetworkWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitServiceNetworkWriter.class.getCanonicalName());
    private final XMLElementServiceNetwork xmlRawServiceNetwork;
    private final PlanitServiceNetworkWriterSettings settings;
    private String currLayerLogPrefix;

    private void populateServiceLegSegments(XMLElementServiceLeg xmlLeg, ServiceLeg leg, ServiceLegSegment serviceLegSegment) {
        List legSegmentsList = xmlLeg.getLegsegment();
        XMLElementServiceLeg.Legsegment xmlElementLegSegment = new XMLElementServiceLeg.Legsegment();
        xmlElementLegSegment.setId((String)this.getPrimaryIdMapper().getServiceLegSegmentIdMapper().apply(serviceLegSegment));
        if (serviceLegSegment.hasExternalId()) {
            xmlElementLegSegment.setExternalid(serviceLegSegment.getExternalId());
        }
        xmlElementLegSegment.setDir(serviceLegSegment.isDirectionAb() ? Direction.A_B : Direction.B_A);
        if (!serviceLegSegment.hasPhysicalParentSegments()) {
            LOGGER.warning(String.format("IGNORED: Service leg segment %s has no physical link segments referenced", xmlElementLegSegment.getId()));
            return;
        }
        String csvPhysicalLegSegmentRefs = serviceLegSegment.getPhysicalParentSegments().stream().map(ls -> (String)this.getComponentIdMappers().getNetworkIdMappers().getLinkSegmentIdMapper().apply((MacroscopicLinkSegment)MacroscopicLinkSegment.class.cast(ls))).collect(Collectors.joining(","));
        xmlElementLegSegment.setLsrefs(csvPhysicalLegSegmentRefs);
        legSegmentsList.add(xmlElementLegSegment);
    }

    private void populateXmlServiceLeg(List<XMLElementServiceLeg> xmlServiceLegList, ServiceLeg leg) {
        XMLElementServiceLeg xmlLeg = new XMLElementServiceLeg();
        xmlLeg.setId((String)this.getPrimaryIdMapper().getServiceLegIdMapper().apply(leg));
        if (leg.hasExternalId()) {
            xmlLeg.setExternalid(leg.getExternalId());
        }
        xmlLeg.setNodearef((String)this.getPrimaryIdMapper().getServiceNodeIdMapper().apply(leg.getServiceNodeA()));
        xmlLeg.setNodebref((String)this.getPrimaryIdMapper().getServiceNodeIdMapper().apply(leg.getServiceNodeB()));
        leg.forEachSegment(ls -> this.populateServiceLegSegments(xmlLeg, leg, (ServiceLegSegment)ls));
        xmlServiceLegList.add(xmlLeg);
    }

    private void populateXmlServiceLegsAndLegSegments(XMLElementServiceNetworkLayer xmlServiceNetworkLayer, ServiceLegs legs) {
        XMLElementServiceLegs xmlServiceLegs = xmlServiceNetworkLayer.getServicelegs();
        if (xmlServiceLegs == null) {
            xmlServiceLegs = new XMLElementServiceLegs();
            xmlServiceNetworkLayer.setServicelegs(xmlServiceLegs);
        }
        List xmlServiceLegList = xmlServiceLegs.getLeg();
        legs.streamSortedBy(this.getPrimaryIdMapper().getServiceLegIdMapper()).forEach(leg -> {
            leg.validate();
            this.populateXmlServiceLeg(xmlServiceLegList, (ServiceLeg)leg);
        });
    }

    private void populateXmlServiceNode(List<XMLElementServiceNodes.Servicenode> xmlServiceNodeList, ServiceNode serviceNode) {
        XMLElementServiceNodes.Servicenode xmlServiceNode = new XMLElementServiceNodes.Servicenode();
        xmlServiceNode.setId((String)this.getPrimaryIdMapper().getServiceNodeIdMapper().apply(serviceNode));
        if (serviceNode.hasExternalId()) {
            xmlServiceNode.setExternalid(serviceNode.getExternalId());
        }
        xmlServiceNodeList.add(xmlServiceNode);
    }

    private void populateXmlServiceNodes(XMLElementServiceNetworkLayer xmlServiceNetworkLayer, ServiceNodes serviceNodes) {
        XMLElementServiceNodes xmlServiceNodes = xmlServiceNetworkLayer.getServicenodes();
        if (xmlServiceNodes == null) {
            xmlServiceNodes = new XMLElementServiceNodes();
            xmlServiceNetworkLayer.setServicenodes(xmlServiceNodes);
        }
        List xmlServiceNodeList = xmlServiceNodes.getServicenode();
        serviceNodes.streamSortedBy(this.getPrimaryIdMapper().getServiceNodeIdMapper()).forEach(serviceNode -> this.populateXmlServiceNode(xmlServiceNodeList, (ServiceNode)serviceNode));
    }

    protected XMLElementServiceNetworkLayer createAndPopulateXmlNetworkLayer(ServiceNetworkLayer serviceNetworkLayer, ServiceNetwork serviceNetwork) {
        XMLElementServiceNetworkLayer xmlServiceNetworkLayer = new XMLElementServiceNetworkLayer();
        xmlServiceNetworkLayer.setId((String)this.getPrimaryIdMapper().getServiceNetworkLayerIdMapper().apply(serviceNetworkLayer));
        if (serviceNetworkLayer.hasExternalId()) {
            xmlServiceNetworkLayer.setExternalid(serviceNetworkLayer.getExternalId());
        }
        if (!serviceNetworkLayer.hasSupportedModes()) {
            LOGGER.severe(String.format("%s Network layer has no supported modes, skip persistence", this.currLayerLogPrefix));
            return null;
        }
        String parentLayerXmlId = (String)this.getComponentIdMappers().getNetworkIdMappers().getNetworkLayerIdMapper().apply(serviceNetworkLayer.getParentNetworkLayer());
        if (StringUtils.isNullOrBlank((String)parentLayerXmlId)) {
            throw new PlanItRunTimeException("Parent layer referenced by service network layer %s is required to have its (XML) id set, aborting", new Object[]{serviceNetworkLayer.getXmlId()});
        }
        xmlServiceNetworkLayer.setParentlayerref(parentLayerXmlId);
        LOGGER.info(String.format("%s Supported modes : %s", this.currLayerLogPrefix, serviceNetworkLayer.getSupportedModes().stream().map(m -> m.toString()).sorted().collect(Collectors.joining(","))));
        LOGGER.info(String.format("%s Service nodes : %d", this.currLayerLogPrefix, serviceNetworkLayer.getServiceNodes().size()));
        this.populateXmlServiceNodes(xmlServiceNetworkLayer, serviceNetworkLayer.getServiceNodes());
        LOGGER.info(String.format("%s Service legs: %d", this.currLayerLogPrefix, serviceNetworkLayer.getLegs().size()));
        LOGGER.info(String.format("%s Service leg segments: %d", this.currLayerLogPrefix, serviceNetworkLayer.getLegSegments().size()));
        this.populateXmlServiceLegsAndLegSegments(xmlServiceNetworkLayer, serviceNetworkLayer.getLegs());
        return xmlServiceNetworkLayer;
    }

    protected void populateXmlServiceNetworkLayers(ServiceNetwork serviceNetwork) {
        List xmlServiceNetworkLayers = this.xmlRawServiceNetwork.getServicenetworklayer();
        LOGGER.info("Service network layers:" + ((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).size());
        ((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).streamSortedBy(this.getPrimaryIdMapper().getServiceNetworkLayerIdMapper()).forEach(serviceNetworkLayer -> {
            String xmlId = (String)this.getPrimaryIdMapper().getServiceNetworkLayerIdMapper().apply(serviceNetworkLayer);
            if (StringUtils.isNullOrBlank((String)xmlId)) {
                LOGGER.warning(String.format("Service network layer has no XML id defined, adopting internally generated id %d instead", serviceNetworkLayer.getId()));
                xmlId = String.valueOf(serviceNetworkLayer.getId());
                serviceNetworkLayer.setXmlId(xmlId);
            }
            this.currLayerLogPrefix = LoggingUtils.surroundwithBrackets((String)("sn-layer: " + xmlId));
            XMLElementServiceNetworkLayer xmlServiceNetworkLayer = this.createAndPopulateXmlNetworkLayer((ServiceNetworkLayer)serviceNetworkLayer, serviceNetwork);
            if (xmlServiceNetworkLayer != null) {
                xmlServiceNetworkLayers.add(xmlServiceNetworkLayer);
            }
        });
    }

    protected void populateTopLevelElement(ServiceNetwork serviceNetwork) {
        String xmlId = (String)this.getPrimaryIdMapper().getServiceNetworkIdMapper().apply(serviceNetwork);
        if (StringUtils.isNullOrBlank((String)xmlId)) {
            LOGGER.warning(String.format("Service network has no XML id defined, adopting internally generated id %d instead", serviceNetwork.getId()));
            xmlId = String.valueOf(serviceNetwork.getId());
            serviceNetwork.setXmlId(xmlId);
        }
        this.xmlRawServiceNetwork.setId(xmlId);
        String parentNetworkXmlId = (String)this.getComponentIdMappers().getNetworkIdMappers().getNetworkIdMapper().apply(serviceNetwork.getParentNetwork());
        if (StringUtils.isNullOrBlank((String)parentNetworkXmlId)) {
            LOGGER.severe(String.format("Service network's parent network has no XML id defined, assuming internally generated id %d as reference id instead, please verify this matches persisted parent network id", serviceNetwork.getParentNetwork().getId()));
            parentNetworkXmlId = String.valueOf(serviceNetwork.getParentNetwork().getId());
        }
        this.xmlRawServiceNetwork.setParentnetwork(parentNetworkXmlId);
    }

    protected PlanitServiceNetworkWriter(XMLElementServiceNetwork xmlRawServiceNetwork) {
        this(null, "global", xmlRawServiceNetwork);
    }

    protected PlanitServiceNetworkWriter(String networkPath, XMLElementServiceNetwork xmlRawServiceNetwork) {
        this(networkPath, "global", xmlRawServiceNetwork);
    }

    protected PlanitServiceNetworkWriter(String networkPath, String countryName, XMLElementServiceNetwork xmlRawServiceNetwork) {
        super(IdMapperType.XML);
        this.settings = new PlanitServiceNetworkWriterSettings(networkPath, "service_network.xml", countryName);
        this.xmlRawServiceNetwork = xmlRawServiceNetwork;
    }

    public ServiceNetworkIdMapper getPrimaryIdMapper() {
        return this.getComponentIdMappers().getServiceNetworkIdMapper();
    }

    public void write(ServiceNetwork serviceNetwork) throws PlanItException {
        this.getComponentIdMappers().populateMissingIdMappers(this.getIdMapperType());
        this.prepareCoordinateReferenceSystem(serviceNetwork.getCoordinateReferenceSystem(), this.getSettings().getDestinationCoordinateReferenceSystem(), this.getCountryName());
        LOGGER.info(String.format("Persisting PLANit service network to: %s", Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getFileName())));
        this.getSettings().logSettings();
        this.populateTopLevelElement(serviceNetwork);
        this.populateXmlServiceNetworkLayers(serviceNetwork);
        super.persist(this.xmlRawServiceNetwork, XMLElementServiceNetwork.class, "servicenetworkinput.xsd");
    }

    public void reset() {
        this.currLayerLogPrefix = null;
        this.xmlRawServiceNetwork.getServicenetworklayer().clear();
    }

    public PlanitServiceNetworkWriterSettings getSettings() {
        return this.settings;
    }

    public String getCountryName() {
        return this.getSettings().getCountry();
    }
}

