/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.goplanit.converter.BaseReaderImpl;
import org.goplanit.converter.service.ServiceNetworkReader;
import org.goplanit.io.converter.service.PlanitServiceNetworkReaderSettings;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.network.ServiceNetworkModifierUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.wrapper.MapWrapper;
import org.goplanit.utils.wrapper.MapWrapperImpl;
import org.goplanit.xml.generated.Direction;
import org.goplanit.xml.generated.XMLElementServiceLeg;
import org.goplanit.xml.generated.XMLElementServiceLegs;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.xml.generated.XMLElementServiceNetworkLayer;
import org.goplanit.xml.generated.XMLElementServiceNodes;

public class PlanitServiceNetworkReader
extends BaseReaderImpl<ServiceNetwork>
implements ServiceNetworkReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitServiceNetworkReader.class.getCanonicalName());
    private final PlanitServiceNetworkReaderSettings settings;
    private final PlanitXmlJaxbParser<XMLElementServiceNetwork> xmlParser;
    private final ServiceNetwork serviceNetwork;
    public static final String SERVICE_NETWORK_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/servicenetworkinput.xsd";

    private void syncXmlIdsToIds() {
        LOGGER.info("Syncing PLANit service network XML ids to internally generated ids, overwriting original XML ids");
        ServiceNetworkModifierUtils.syncManagedIdEntitiesContainerXmlIdsToIds((ServiceNetwork)this.serviceNetwork);
    }

    private void parseServiceLegs(ServiceNetworkLayer routedServiceLayer, XMLElementServiceLegs xmlServicelegs) throws PlanItException {
        PlanItException.throwIfNull((Object)xmlServicelegs, (String)"No service legs element available on service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        List xmlServiceLegList = xmlServicelegs.getLeg();
        PlanItException.throwIf((xmlServiceLegList == null || xmlServiceLegList.isEmpty() ? 1 : 0) != 0, (String)"No service leg available on service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        MapWrapperImpl serviceNodesByXmlId = new MapWrapperImpl(new HashMap(), ExternalIdAble::getXmlId, (MapWrapper)routedServiceLayer.getServiceNodes());
        boolean registerLegsOnServiceNodes = true;
        for (XMLElementServiceLeg xmlServiceLeg : xmlServiceLegList) {
            String xmlId = xmlServiceLeg.getId();
            if (StringUtils.isNullOrBlank((String)xmlId)) {
                LOGGER.warning(String.format("IGNORE: Service leg in service layer %s has no XML id defined", routedServiceLayer.getXmlId()));
                continue;
            }
            if (StringUtils.isNullOrBlank((String)xmlServiceLeg.getNodearef())) {
                LOGGER.warning(String.format("IGNORE: No service node a reference present on service leg %s", xmlId));
                continue;
            }
            ServiceNode startNode = (ServiceNode)serviceNodesByXmlId.get((Object)xmlServiceLeg.getNodearef());
            if (StringUtils.isNullOrBlank((String)xmlServiceLeg.getNodebref())) {
                LOGGER.warning(String.format("IGNORE: No service node b reference present on service leg %s", xmlId));
                continue;
            }
            ServiceNode endNode = (ServiceNode)serviceNodesByXmlId.get((Object)xmlServiceLeg.getNodebref());
            ServiceLeg serviceLeg = routedServiceLayer.getLegs().getFactory().registerNew(startNode, endNode, true);
            serviceLeg.setXmlId(xmlId);
            if (!StringUtils.isNullOrBlank((String)xmlServiceLeg.getExternalid())) {
                serviceLeg.setExternalId(xmlServiceLeg.getExternalid());
            }
            this.parseLegSegmentsOfLeg(routedServiceLayer, serviceLeg, xmlServiceLeg);
            if (serviceLeg.validate()) continue;
            throw new PlanItException("Invalid service network file, inconsistency detected in service leg (%s) definition", new Object[]{serviceLeg.getXmlId()});
        }
    }

    private void parseLegSegmentsOfLeg(ServiceNetworkLayer routedServiceLayer, ServiceLeg serviceLeg, XMLElementServiceLeg xmlServiceLeg) throws PlanItException {
        PlanItException.throwIfNull((Object)xmlServiceLeg, (String)"No service leg element available to extract leg segments from");
        List xmlLegSegments = xmlServiceLeg.getLegsegment();
        PlanItException.throwIf((xmlLegSegments == null || xmlLegSegments.isEmpty() ? 1 : 0) != 0, (String)"No service leg segments available on service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        PlanItException.throwIf((xmlLegSegments.size() > 2 ? 1 : 0) != 0, (String)"No more than two service leg segments allowed per service leg (one per direction) on service leg %s on service layer %s", (Object[])new Object[]{serviceLeg.getXmlId(), routedServiceLayer.getXmlId()});
        boolean registerLegSegmentsOnLegAndNode = true;
        for (XMLElementServiceLeg.Legsegment xmlLegSegment : xmlLegSegments) {
            String parentLinkRefs;
            String xmlId = xmlLegSegment.getId();
            if (StringUtils.isNullOrBlank((String)xmlId)) {
                LOGGER.warning(String.format("IGNORE: Service leg segment for leg %s has no XML id defined", serviceLeg.getXmlId()));
                continue;
            }
            Direction xmlDirection = xmlLegSegment.getDir();
            if (xmlDirection == null) {
                LOGGER.warning(String.format("IGNORE: Service leg segment for leg %s has no direction defined", serviceLeg.getXmlId()));
                continue;
            }
            boolean isDirectionAb = xmlDirection.equals((Object)Direction.A_B);
            ServiceLegSegment serviceLegSegment = routedServiceLayer.getLegSegments().getFactory().registerNew(serviceLeg, isDirectionAb, registerLegSegmentsOnLegAndNode);
            serviceLegSegment.setXmlId(xmlId);
            if (!StringUtils.isNullOrBlank((String)xmlLegSegment.getExternalid())) {
                serviceLegSegment.setExternalId(xmlLegSegment.getExternalid());
            }
            if (StringUtils.isNullOrBlank((String)(parentLinkRefs = xmlLegSegment.getLsrefs()))) {
                LOGGER.warning(String.format("IGNORE: Service leg segment %s in service layer %s has no parent link segments that define the leg segment", xmlId, routedServiceLayer.getXmlId()));
                continue;
            }
            String[] parentLinkSegmentsRefsArray = parentLinkRefs.split(CharacterUtils.COMMA.toString());
            boolean valid = true;
            ArrayList<LinkSegment> parentLinkSegmentsInOrder = new ArrayList<LinkSegment>(parentLinkSegmentsRefsArray.length);
            for (int index = 0; index < parentLinkSegmentsRefsArray.length; ++index) {
                String xmlParentLinkSegmentRef = parentLinkSegmentsRefsArray[index].trim();
                LinkSegment linkSegmentInLeg = (LinkSegment)this.getBySourceId(LinkSegment.class, xmlParentLinkSegmentRef);
                if (linkSegmentInLeg == null) {
                    LOGGER.warning(String.format("Service leg segment %s in service layer %s references unknown parent link segment %s", xmlId, routedServiceLayer.getXmlId(), xmlParentLinkSegmentRef));
                    valid = false;
                    continue;
                }
                parentLinkSegmentsInOrder.add(linkSegmentInLeg);
            }
            if (!valid) {
                LOGGER.warning(String.format("IGNORE: Service leg segment %s in service layer %s invalid", xmlId, routedServiceLayer.getXmlId()));
                continue;
            }
            if (parentLinkSegmentsInOrder.isEmpty()) continue;
            serviceLegSegment.setPhysicalParentSegments(parentLinkSegmentsInOrder);
        }
    }

    private void parseServiceNodes(ServiceNetworkLayer routedServiceLayer, XMLElementServiceNodes xmlServicenodes) throws PlanItException {
        PlanItException.throwIfNull((Object)xmlServicenodes, (String)"No service nodes element available on service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        List xmlServiceNodeList = xmlServicenodes.getServicenode();
        PlanItException.throwIf((xmlServiceNodeList == null || xmlServiceNodeList.isEmpty() ? 1 : 0) != 0, (String)"No service node available on service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        MacroscopicNetworkLayer parentLayer = routedServiceLayer.getParentNetworkLayer();
        PlanItException.throwIf((parentLayer == null || parentLayer.isEmpty() ? 1 : 0) != 0, (String)"No parent layer or empty parent layer for service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        Nodes parentNodes = parentLayer.getNodes();
        PlanItException.throwIf((parentNodes == null || parentNodes.isEmpty() ? 1 : 0) != 0, (String)"No parent nodes or empty parent nodes for service network layer %s", (Object[])new Object[]{routedServiceLayer.getXmlId()});
        for (XMLElementServiceNodes.Servicenode xmlServiceNode : xmlServiceNodeList) {
            String xmlId = xmlServiceNode.getId();
            if (StringUtils.isNullOrBlank((String)xmlId)) {
                LOGGER.warning(String.format("IGNORE: Service node in service layer %s has no XML id defined", routedServiceLayer.getXmlId()));
                continue;
            }
            ServiceNode serviceNode = routedServiceLayer.getServiceNodes().getFactory().registerNew();
            serviceNode.setXmlId(xmlId);
            if (StringUtils.isNullOrBlank((String)xmlServiceNode.getExternalid())) continue;
            serviceNode.setExternalId(xmlServiceNode.getExternalid());
        }
    }

    private ServiceNetworkLayer parseServiceNetworkLayer(XMLElementServiceNetworkLayer xmlLayer) throws PlanItException {
        String parentLayerXmlId = xmlLayer.getParentlayerref();
        if (StringUtils.isNullOrBlank((String)parentLayerXmlId)) {
            throw new PlanItException("Service network layer %s has no parent layer XML id defined", new Object[]{xmlLayer.getId()});
        }
        MacroscopicNetworkLayer parentNetworkLayer = (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)this.serviceNetwork.getParentNetwork().getTransportLayers()).getByXmlId(parentLayerXmlId);
        if (parentNetworkLayer == null || parentNetworkLayer.isEmpty()) {
            throw new PlanItException("Service network layer %s its parent layer %s does not exist in the parent network or is empty", new Object[]{xmlLayer.getId(), parentLayerXmlId});
        }
        ServiceNetworkLayer routedServiceLayer = ((ServiceNetworkLayers)this.serviceNetwork.getTransportLayers()).getFactory().registerNew(parentNetworkLayer);
        String xmlId = xmlLayer.getId();
        if (StringUtils.isNullOrBlank((String)xmlId)) {
            LOGGER.warning(String.format("Service network layer has no XML id defined, adopting internally generated id %d instead", this.serviceNetwork.getId()));
            xmlId = String.valueOf(routedServiceLayer.getId());
        }
        routedServiceLayer.setXmlId(xmlId);
        if (!StringUtils.isNullOrBlank((String)xmlLayer.getExternalid())) {
            routedServiceLayer.setExternalId(xmlLayer.getExternalid());
        }
        this.parseServiceNodes(routedServiceLayer, xmlLayer.getServicenodes());
        this.parseServiceLegs(routedServiceLayer, xmlLayer.getServicelegs());
        return routedServiceLayer;
    }

    private void parseServiceNetworkLayers() throws PlanItException {
        List xmlLayers = this.xmlParser.getXmlRootElement().getServicenetworklayer();
        if (xmlLayers == null || xmlLayers.isEmpty()) {
            LOGGER.warning(String.format("IGNORE: No service layers present in service network file", new Object[0]));
            return;
        }
        for (XMLElementServiceNetworkLayer xmlLayer : xmlLayers) {
            this.parseServiceNetworkLayer(xmlLayer);
        }
    }

    private void initialiseParentXmlIdTrackers(MacroscopicNetwork network) {
        this.initialiseSourceIdMap(Node.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(Node.class).addAll((Iterable)layer.getNodes()));
        this.initialiseSourceIdMap(LinkSegment.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(LinkSegment.class).addAll((Iterable)layer.getLinkSegments()));
    }

    protected PlanitServiceNetworkReader(PlanitServiceNetworkReaderSettings settings, ServiceNetwork serviceNetwork) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementServiceNetwork>>(XMLElementServiceNetwork.class);
        this.settings = settings;
        this.serviceNetwork = serviceNetwork;
        if (serviceNetwork.getParentNetwork() == null) {
            LOGGER.severe("No parent network available for PLANit service network that we seek to populate");
        }
    }

    protected PlanitServiceNetworkReader(XMLElementServiceNetwork populatedXmlRawServiceNetwork, ServiceNetwork serviceNetwork) {
        this(populatedXmlRawServiceNetwork, new PlanitServiceNetworkReaderSettings(), serviceNetwork);
    }

    protected PlanitServiceNetworkReader(XMLElementServiceNetwork populatedXmlRawServiceNetwork, PlanitServiceNetworkReaderSettings settings, ServiceNetwork serviceNetwork) {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementServiceNetwork>(populatedXmlRawServiceNetwork);
        this.settings = settings;
        this.serviceNetwork = serviceNetwork;
    }

    protected PlanitServiceNetworkReader(String networkPathDirectory, String xmlFileExtension, ServiceNetwork serviceNetwork) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementServiceNetwork>>(XMLElementServiceNetwork.class);
        this.settings = new PlanitServiceNetworkReaderSettings(networkPathDirectory, xmlFileExtension);
        this.serviceNetwork = serviceNetwork;
    }

    public ServiceNetwork read() {
        this.xmlParser.initialiseAndParseXmlRootElement(this.getSettings().getInputDirectory(), this.getSettings().getXmlFileExtension());
        PlanItRunTimeException.throwIfNull((Object)this.xmlParser.getXmlRootElement(), (String)"No valid PLANit XML service network could be parsed into memory, abort");
        String xmlId = this.xmlParser.getXmlRootElement().getId();
        if (StringUtils.isNullOrBlank((String)xmlId)) {
            LOGGER.warning(String.format("Service network has no XML id defined, adopting internally generated id %d instead", this.serviceNetwork.getId()));
            xmlId = String.valueOf(this.serviceNetwork.getId());
        }
        this.serviceNetwork.setXmlId(xmlId);
        String parentNetworkXmlId = this.xmlParser.getXmlRootElement().getParentnetwork();
        if (StringUtils.isNullOrBlank((String)parentNetworkXmlId)) {
            throw new PlanItRunTimeException("Service network %s has no parent network defined", new Object[]{this.serviceNetwork.getXmlId()});
        }
        if (!this.serviceNetwork.getParentNetwork().getXmlId().equals(parentNetworkXmlId)) {
            throw new PlanItRunTimeException("Service network %s parent network (%s) in memory does not correspond to the parent network id on file (%s)", new Object[]{this.serviceNetwork.getXmlId(), this.serviceNetwork.getParentNetwork().getXmlId(), parentNetworkXmlId});
        }
        try {
            this.initialiseParentXmlIdTrackers(this.serviceNetwork.getParentNetwork());
            this.parseServiceNetworkLayers();
            if (this.getSettings().isSyncXmlIdsToIds()) {
                this.syncXmlIdsToIds();
            }
            this.serviceNetwork.logInfo(LoggingUtils.serviceNetworkPrefix((long)this.serviceNetwork.getId()));
            this.xmlParser.clearXmlContent();
        }
        catch (PlanItException e) {
            throw new PlanItRunTimeException((Exception)((Object)e));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException(String.format("Error while populating service network %s in PLANitIO", this.serviceNetwork.getXmlId()), (Throwable)e);
        }
        return this.serviceNetwork;
    }

    public PlanitServiceNetworkReaderSettings getSettings() {
        return this.settings;
    }

    public void reset() {
    }
}

