/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.util.logging.Logger;
import org.goplanit.converter.ConverterWriterSettings;
import org.goplanit.io.xml.util.PlanitXmlWriterSettings;
import org.goplanit.utils.unit.TimeUnit;

public class PlanitRoutedServicesWriterSettings
extends PlanitXmlWriterSettings
implements ConverterWriterSettings {
    private static final Logger LOGGER = Logger.getLogger(PlanitRoutedServicesWriterSettings.class.getCanonicalName());
    private TimeUnit frequencyTimeUnit = DEFAULT_FREQUENCY_TIME_UNIT;
    private boolean logServicesWithoutTrips = false;
    public static final TimeUnit DEFAULT_FREQUENCY_TIME_UNIT = TimeUnit.HOUR;
    public static final boolean DEFAULT_LOG_SERVICES_WITHOUT_TRIPS = false;
    public static final String DEFAULT_ROUTED_SERVICES_XML = "routed_services.xml";

    public PlanitRoutedServicesWriterSettings() {
    }

    public PlanitRoutedServicesWriterSettings(String outputPathDirectory, String countryName) {
        super(outputPathDirectory, countryName);
    }

    public PlanitRoutedServicesWriterSettings(String outputPathDirectory, String fileName, String countryName) {
        super(outputPathDirectory, fileName, countryName);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void logSettings() {
        super.logSettings();
        LOGGER.info(String.format("Trip frequency time unit set to %s", this.getTripFrequencyTimeUnit()));
    }

    public TimeUnit getTripFrequencyTimeUnit() {
        return this.frequencyTimeUnit;
    }

    public void setTripFrequencyTimeUnit(TimeUnit frequencyTimeUnit) {
        this.frequencyTimeUnit = frequencyTimeUnit;
    }

    public boolean isLogServicesWithoutTrips() {
        return this.logServicesWithoutTrips;
    }

    public void setLogServicesWithoutTrips(boolean logServicesWithoutTrips) {
        this.logServicesWithoutTrips = logServicesWithoutTrips;
    }
}

