/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.nio.file.Paths;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.RoutedServicesIdMapper;
import org.goplanit.converter.service.RoutedServicesWriter;
import org.goplanit.io.converter.PlanitWriterImpl;
import org.goplanit.io.converter.service.PlanitRoutedServicesWriterSettings;
import org.goplanit.io.xml.util.xmlEnumConversionUtil;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.service.routed.RelativeLegTiming;
import org.goplanit.utils.service.routed.RoutedModeServices;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.RoutedTrip;
import org.goplanit.utils.service.routed.RoutedTripFrequency;
import org.goplanit.utils.service.routed.RoutedTripSchedule;
import org.goplanit.utils.unit.Unit;
import org.goplanit.xml.generated.XMLElementDepartures;
import org.goplanit.xml.generated.XMLElementRelativeTimings;
import org.goplanit.xml.generated.XMLElementRoutedServices;
import org.goplanit.xml.generated.XMLElementRoutedServicesLayer;
import org.goplanit.xml.generated.XMLElementRoutedTrip;
import org.goplanit.xml.generated.XMLElementRoutedTrips;
import org.goplanit.xml.generated.XMLElementService;
import org.goplanit.xml.generated.XMLElementServices;

public class PlanitRoutedServicesWriter
extends PlanitWriterImpl<RoutedServices>
implements RoutedServicesWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitRoutedServicesWriter.class.getCanonicalName());
    private final XMLElementRoutedServices xmlRawRoutedServices;
    private static DatatypeFactory xmlDataTypeFactory;
    private final PlanitRoutedServicesWriterSettings settings;
    private String currLayerLogPrefix;

    private void populateXmlTripIds(XMLElementRoutedTrip xmlTrip, RoutedTrip trip) {
        xmlTrip.setId((String)this.getPrimaryIdMapper().getRoutedTripRefIdMapper().apply(trip));
        if (trip.hasExternalId()) {
            xmlTrip.setExternalid(trip.getExternalId());
        }
    }

    private void createAndPopulateXmlRoutedServiceTrip(XMLElementRoutedTrips xmlTrips, RoutedTripFrequency frequencyBasedTrip) {
        XMLElementRoutedTrip xmlRoutedTripFrequency = new XMLElementRoutedTrip();
        this.populateXmlTripIds(xmlRoutedTripFrequency, (RoutedTrip)frequencyBasedTrip);
        if (!frequencyBasedTrip.hasPositiveFrequency()) {
            LOGGER.warning(String.format("Frequency based routed trip %s has no positive frequency specified, discarded", xmlRoutedTripFrequency.getId()));
        }
        XMLElementRoutedTrip.Frequency frequency = new XMLElementRoutedTrip.Frequency();
        frequency.setUnit(xmlEnumConversionUtil.planitToXml((Unit)this.getSettings().getTripFrequencyTimeUnit()));
        frequency.setValue((float)Unit.HOUR.convertTo((Unit)this.getSettings().getTripFrequencyTimeUnit(), frequencyBasedTrip.getFrequencyPerHour()));
        ArrayList<String> lsRefsList = new ArrayList<String>(frequencyBasedTrip.getNumberOfLegSegments());
        for (int index = 0; index < frequencyBasedTrip.getNumberOfLegSegments(); ++index) {
            lsRefsList.add((String)this.getComponentIdMappers().getServiceNetworkIdMapper().getServiceLegSegmentIdMapper().apply(frequencyBasedTrip.getLegSegment(index)));
        }
        if (lsRefsList.isEmpty()) {
            LOGGER.warning(String.format("No service leg segments present on frequency based trip (%s), discarded", xmlRoutedTripFrequency.getId()));
        }
        frequency.setLsrefs(lsRefsList.stream().sorted().collect(Collectors.joining(CharacterUtils.COMMA.toString())));
        xmlRoutedTripFrequency.setFrequency(frequency);
        xmlTrips.getTrip().add(xmlRoutedTripFrequency);
    }

    private void createAndPopulateXmlRoutedServiceTrip(XMLElementRoutedTrips xmlTrips, RoutedTripSchedule scheduleBasedTrip) {
        XMLElementRoutedTrip xmlRoutedTripSchedule = new XMLElementRoutedTrip();
        this.populateXmlTripIds(xmlRoutedTripSchedule, (RoutedTrip)scheduleBasedTrip);
        XMLElementRoutedTrip.Schedule xmlSchedule = new XMLElementRoutedTrip.Schedule();
        if (!scheduleBasedTrip.hasDepartures()) {
            LOGGER.warning(String.format("No departures present on schedule based trip (%s), discarded", scheduleBasedTrip.getXmlId()));
            return;
        }
        XMLElementDepartures xmlDepartures = new XMLElementDepartures();
        xmlSchedule.setDepartures(xmlDepartures);
        List xmlDepartureList = xmlDepartures.getDeparture();
        scheduleBasedTrip.getDepartures().streamAscDepartureTime().forEach(departure -> {
            XMLElementDepartures.Departure xmlDeparture = new XMLElementDepartures.Departure();
            xmlDeparture.setId((String)this.getPrimaryIdMapper().getRoutedTripDepartureRefIdMapper().apply(departure));
            if (departure.hasExternalId()) {
                xmlDeparture.setExternalid(departure.getExternalId());
            }
            xmlDeparture.setTime(departure.getDepartureTime().toString());
            xmlDepartureList.add(xmlDeparture);
        });
        if (!scheduleBasedTrip.hasRelativeLegTimings()) {
            LOGGER.warning(String.format("No relative leg timings present on schedule based trip (%s), discarded", scheduleBasedTrip.getXmlId()));
            return;
        }
        XMLElementRelativeTimings xmlRelTimings = new XMLElementRelativeTimings();
        xmlSchedule.setReltimings(xmlRelTimings);
        scheduleBasedTrip.updateDefaultDwellTimeToMostCommon();
        LocalTime defaultDwellTime = scheduleBasedTrip.getDefaultDwellTime();
        List xmlRelTimingLegList = xmlRelTimings.getLeg();
        for (RelativeLegTiming relLegTiming : scheduleBasedTrip) {
            XMLElementRelativeTimings.Leg xmlReltimingLeg = new XMLElementRelativeTimings.Leg();
            xmlReltimingLeg.setDuration(relLegTiming.getDuration());
            if (!relLegTiming.getDwellTime().equals(defaultDwellTime)) {
                xmlReltimingLeg.setDwelltime(relLegTiming.getDwellTime());
            }
            if (!relLegTiming.hasParentLegSegment()) {
                LOGGER.warning(String.format("No service leg segment present on relative leg timing, discarded this trip (%s)", scheduleBasedTrip.getXmlId()));
                return;
            }
            xmlReltimingLeg.setLsref((String)this.getComponentIdMappers().getServiceNetworkIdMapper().getServiceLegSegmentIdMapper().apply(relLegTiming.getParentLegSegment()));
            xmlRelTimingLegList.add(xmlReltimingLeg);
        }
        if (defaultDwellTime != null) {
            xmlRelTimings.setDwelltime(defaultDwellTime);
        }
        xmlRoutedTripSchedule.setSchedule(xmlSchedule);
        xmlTrips.getTrip().add(xmlRoutedTripSchedule);
    }

    private void createAndPopulateXmlRoutedServices(XMLElementServices xmlServices, RoutedService routedService) {
        XMLElementService xmlRoutedService = new XMLElementService();
        xmlRoutedService.setId((String)this.getPrimaryIdMapper().getRoutedServiceRefIdMapper().apply(routedService));
        if (routedService.hasExternalId()) {
            xmlRoutedService.setExternalid(routedService.getExternalId());
        }
        if (routedService.hasName()) {
            xmlRoutedService.setName(routedService.getName());
        }
        if (routedService.hasNameDescription()) {
            xmlRoutedService.setNamedescription(routedService.getNameDescription());
        }
        if (routedService.hasServiceDescription()) {
            xmlRoutedService.setServicedescription(routedService.getServiceDescription());
        }
        if (!routedService.getTripInfo().hasFrequencyBasedTrips() && !routedService.getTripInfo().hasScheduleBasedTrips()) {
            if (this.getSettings().isLogServicesWithoutTrips()) {
                LOGGER.warning(String.format("Routed service (%s, name: %s - %s) without trips found, discarding", xmlRoutedService.getId(), routedService.getName(), routedService.getNameDescription()));
            }
            return;
        }
        XMLElementRoutedTrips xmlTrips = new XMLElementRoutedTrips();
        xmlRoutedService.setTrips(xmlTrips);
        if (routedService.getTripInfo().hasFrequencyBasedTrips()) {
            routedService.getTripInfo().getFrequencyBasedTrips().streamSortedBy(this.getPrimaryIdMapper().getRoutedTripRefIdMapper()).forEach(freqTrip -> this.createAndPopulateXmlRoutedServiceTrip(xmlTrips, (RoutedTripFrequency)freqTrip));
        }
        if (routedService.getTripInfo().hasScheduleBasedTrips()) {
            routedService.getTripInfo().getScheduleBasedTrips().streamSortedBy(this.getPrimaryIdMapper().getRoutedTripRefIdMapper()).forEach(schedTrip -> this.createAndPopulateXmlRoutedServiceTrip(xmlTrips, (RoutedTripSchedule)schedTrip));
        }
        xmlServices.getService().add(xmlRoutedService);
    }

    private void createAndPopulateXmlRoutedServicesByMode(XMLElementRoutedServicesLayer xmlLayer, RoutedModeServices servicesForMode) {
        if (servicesForMode.isEmpty()) {
            return;
        }
        XMLElementServices xmlServices = new XMLElementServices();
        xmlLayer.getServices().add(xmlServices);
        xmlServices.setModeref((String)this.getComponentIdMappers().getNetworkIdMappers().getModeIdMapper().apply(servicesForMode.getMode()));
        servicesForMode.streamSortedBy(this.getPrimaryIdMapper().getRoutedServiceRefIdMapper()).forEach(service -> this.createAndPopulateXmlRoutedServices(xmlServices, (RoutedService)service));
        String modePrefix = LoggingUtils.surroundwithBrackets((String)String.format("mode: %s", servicesForMode.getMode()));
        LOGGER.info(String.format("%s%s Routed services : %d", this.currLayerLogPrefix, modePrefix, servicesForMode.size()));
        LOGGER.info(String.format("%s%s (scheduled) trips : %d", this.currLayerLogPrefix, modePrefix, servicesForMode.stream().mapToInt(rs -> rs.getTripInfo().getScheduleBasedTrips().size()).sum()));
        LOGGER.info(String.format("%s%s (scheduled) trips departures: %d", this.currLayerLogPrefix, modePrefix, servicesForMode.stream().mapToInt(rs -> rs.getTripInfo().getScheduleBasedTrips().stream().mapToInt(t -> t.getDepartures().size()).sum()).sum()));
        LOGGER.info(String.format("%s%s (frequency) trips : %d", this.currLayerLogPrefix, modePrefix, servicesForMode.stream().mapToInt(rs -> rs.getTripInfo().getFrequencyBasedTrips().size()).sum()));
        LOGGER.info(String.format("%s%s (frequency) trips * freq : %.2f", this.currLayerLogPrefix, modePrefix, servicesForMode.stream().mapToDouble(rs -> rs.getTripInfo().getFrequencyBasedTrips().stream().mapToDouble(t -> t.getFrequencyPerHour()).sum()).sum()));
    }

    private void populateXmlRoutedServiceLayer(XMLElementRoutedServicesLayer xmlLayer, RoutedServicesLayer layer, RoutedServices routedServices) {
        String parentLayerXmlId;
        String xmlId = layer.getXmlId();
        if (layer.getXmlId() == null) {
            LOGGER.warning(String.format("Routed services layer has no XML id defined, adopting internally generated id %d instead", layer.getId()));
            xmlId = String.valueOf(layer.getId());
        }
        xmlLayer.setId(xmlId);
        this.currLayerLogPrefix = LoggingUtils.surroundwithBrackets((String)("rs-layer: " + xmlLayer.getId()));
        if (layer.hasExternalId()) {
            xmlLayer.setExternalid(layer.getExternalId());
        }
        if (StringUtils.isNullOrBlank((String)(parentLayerXmlId = (String)this.getComponentIdMappers().getServiceNetworkIdMapper().getServiceNetworkLayerIdMapper().apply(layer.getParentLayer())))) {
            LOGGER.severe(String.format("Routed services layer's parent service layer has no ref id defined, assuming internally generated id %d as reference id instead, please verify this matches persisted parent network id", layer.getParentLayer().getId()));
            parentLayerXmlId = String.valueOf(layer.getParentLayer().getId());
        }
        xmlLayer.setServicelayerref(parentLayerXmlId);
        Collection supportedModes = layer.getSupportedModes();
        supportedModes.stream().sorted(Comparator.comparing(this.getComponentIdMappers().getNetworkIdMappers().getModeIdMapper())).forEach(mode -> this.createAndPopulateXmlRoutedServicesByMode(xmlLayer, layer.getServicesByMode(mode)));
    }

    protected void populateXmlRoutedServicesLayers(RoutedServices routedServices) {
        String parentNetworkRefId;
        XMLElementRoutedServices.Servicelayers xmlServiceLayers = this.xmlRawRoutedServices.getServicelayers();
        if (xmlServiceLayers == null) {
            xmlServiceLayers = new XMLElementRoutedServices.Servicelayers();
            this.xmlRawRoutedServices.setServicelayers(xmlServiceLayers);
        }
        if (StringUtils.isNullOrBlank((String)(parentNetworkRefId = (String)this.getComponentIdMappers().getServiceNetworkIdMapper().getServiceNetworkIdMapper().apply(routedServices.getParentNetwork())))) {
            LOGGER.severe(String.format("Routed services' parent network has no ref id defined, assuming internally generated id %d as reference id instead, please verify this matches persisted parent network id", routedServices.getParentNetwork().getId()));
            parentNetworkRefId = String.valueOf(routedServices.getParentNetwork().getId());
        }
        xmlServiceLayers.setServicenetworkref(parentNetworkRefId);
        LOGGER.info(String.format("Found %d routed services layers", routedServices.getLayers().size()));
        List xmlLayers = xmlServiceLayers.getServicelayer();
        routedServices.getLayers().streamSortedBy(this.getPrimaryIdMapper().getRoutedServiceLayerIdMapper()).forEach(layer -> {
            XMLElementRoutedServicesLayer xmlLayer = new XMLElementRoutedServicesLayer();
            this.currLayerLogPrefix = LoggingUtils.surroundwithBrackets((String)("rs-layer: " + (String)this.getPrimaryIdMapper().getRoutedServiceLayerIdMapper().apply(layer)));
            this.populateXmlRoutedServiceLayer(xmlLayer, (RoutedServicesLayer)layer, routedServices);
            if (!xmlLayer.getServices().isEmpty()) {
                xmlLayers.add(xmlLayer);
            }
        });
    }

    private void populateTopLevelElement(RoutedServices routedServices) {
        if (!routedServices.hasXmlId()) {
            LOGGER.warning(String.format("Routed services has no XML id defined, adopting internally generated id %d instead", routedServices.getId()));
            routedServices.setXmlId(String.valueOf(routedServices.getId()));
        }
        this.xmlRawRoutedServices.setId(routedServices.getXmlId());
        if (routedServices.hasExternalId()) {
            this.xmlRawRoutedServices.setExternalid(routedServices.getExternalId());
        }
    }

    protected PlanitRoutedServicesWriter(XMLElementRoutedServices xmlRawRoutedServices) {
        this(null, "global", xmlRawRoutedServices);
    }

    protected PlanitRoutedServicesWriter(String outputPath, XMLElementRoutedServices xmlRawRoutedServices) {
        this(outputPath, "global", xmlRawRoutedServices);
    }

    protected PlanitRoutedServicesWriter(String outputPath, String countryName, XMLElementRoutedServices xmlRawRoutedServices) {
        super(IdMapperType.XML);
        this.settings = new PlanitRoutedServicesWriterSettings(outputPath, "routed_services.xml", countryName);
        this.xmlRawRoutedServices = xmlRawRoutedServices;
    }

    public RoutedServicesIdMapper getPrimaryIdMapper() {
        return this.getComponentIdMappers().getRoutedServicesIdMapper();
    }

    public void write(RoutedServices routedServices) throws PlanItException {
        this.getComponentIdMappers().populateMissingIdMappers(this.getIdMapperType());
        LOGGER.info(String.format("Persisting PLANit routed services to: %s", Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getFileName())));
        this.getSettings().logSettings();
        this.populateTopLevelElement(routedServices);
        this.populateXmlRoutedServicesLayers(routedServices);
        super.persist(this.xmlRawRoutedServices, XMLElementRoutedServices.class, "routedservicesinput.xsd");
    }

    public void reset() {
        this.currLayerLogPrefix = null;
        this.xmlRawRoutedServices.getServicelayers().getServicelayer().clear();
        this.xmlRawRoutedServices.setServicelayers(null);
        this.xmlRawRoutedServices.setId(null);
        this.xmlRawRoutedServices.setExternalid(null);
    }

    public PlanitRoutedServicesWriterSettings getSettings() {
        return this.settings;
    }

    static {
        try {
            xmlDataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Exception while creating DatatypeFactory", e);
        }
    }
}

