/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.util.logging.Logger;
import org.goplanit.io.converter.service.PlanitRoutedServicesReader;
import org.goplanit.io.converter.service.PlanitRoutedServicesReaderSettings;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.xml.generated.XMLElementRoutedServices;

public class PlanitRoutedServicesReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(PlanitRoutedServicesReaderFactory.class.getCanonicalName());

    public static PlanitRoutedServicesReader create(ServiceNetwork parentNetwork) {
        return PlanitRoutedServicesReaderFactory.create(IdGroupingToken.collectGlobalToken(), parentNetwork);
    }

    public static PlanitRoutedServicesReader create(IdGroupingToken idToken, ServiceNetwork parentNetwork) {
        return PlanitRoutedServicesReaderFactory.create(new PlanitRoutedServicesReaderSettings(), new RoutedServices(idToken, parentNetwork));
    }

    public static PlanitRoutedServicesReader create(String inputDirectory, ServiceNetwork parentNetwork) {
        PlanitRoutedServicesReader serviceNetworkReader = PlanitRoutedServicesReaderFactory.create(parentNetwork);
        serviceNetworkReader.getSettings().setInputDirectory(inputDirectory);
        return serviceNetworkReader;
    }

    public static PlanitRoutedServicesReader create(PlanitRoutedServicesReaderSettings settings, ServiceNetwork parentNetwork) {
        return PlanitRoutedServicesReaderFactory.create(settings, new RoutedServices(IdGroupingToken.collectGlobalToken(), parentNetwork));
    }

    public static PlanitRoutedServicesReader create(PlanitRoutedServicesReaderSettings settings, RoutedServices routedServices) {
        return new PlanitRoutedServicesReader(settings, routedServices);
    }

    public static PlanitRoutedServicesReader create(String inputDirectory, String xmlFileExtension, RoutedServices routedServices) {
        return new PlanitRoutedServicesReader(inputDirectory, xmlFileExtension, routedServices);
    }

    public static PlanitRoutedServicesReader create(XMLElementRoutedServices xmlRawRoutedServices, RoutedServices routedServices) {
        return new PlanitRoutedServicesReader(xmlRawRoutedServices, routedServices);
    }

    public static PlanitRoutedServicesReader create(XMLElementRoutedServices xmlRawRoutedServices, PlanitRoutedServicesReaderSettings settings, RoutedServices routedServices) {
        return new PlanitRoutedServicesReader(xmlRawRoutedServices, settings, routedServices);
    }
}

