/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.network;

import java.util.logging.Logger;
import net.opengis.gml.CoordType;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.PointType;
import net.opengis.gml.PolygonType;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.io.converter.PlanitWriterImpl;
import org.goplanit.io.geo.PlanitGmlUtils;
import org.goplanit.io.xml.util.PlanitXmlWriterSettings;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public abstract class UnTypedPlanitCrsWriterImpl<T>
extends PlanitWriterImpl<T> {
    private static final Logger LOGGER = Logger.getLogger(UnTypedPlanitCrsWriterImpl.class.getCanonicalName());

    protected DirectPositionType createGmlDirectPositionType(Point position) {
        Coordinate positioncoordinate = this.createTransformedCoordinate(position.getCoordinate());
        return PlanitGmlUtils.createGmlDirectPositionType(positioncoordinate);
    }

    protected CoordType createGmlCoordType(Coordinate coordinate) {
        Coordinate nodeCoordinate = this.createTransformedCoordinate(coordinate);
        return PlanitGmlUtils.createGmlCoordType(nodeCoordinate);
    }

    protected PointType createGmlPointType(Point position) {
        Coordinate pointCoordinate = this.createTransformedCoordinate(position.getCoordinate());
        return PlanitGmlUtils.createGmlPointType(pointCoordinate);
    }

    protected PolygonType createGmlPolygonType(Polygon polygon) {
        Coordinate[] transformedCoordinates = this.getTransformedCoordinates(polygon.getCoordinates());
        return PlanitGmlUtils.createGmlPolygonType(transformedCoordinates);
    }

    protected LineStringType createGmlLineStringType(LineString lineString) {
        Coordinate[] transformedCoordinates = this.getTransformedCoordinates(lineString.getCoordinates());
        PlanitXmlWriterSettings xmlSettings = null;
        xmlSettings = this.getSettingsAsXmlWriterSettings();
        CoordinatesType coordsType = PlanitGmlUtils.createGmlCoordinatesType(transformedCoordinates, xmlSettings.getCommaSeparator(), xmlSettings.getDecimalSeparator(), xmlSettings.getDecimalFormat(), xmlSettings.getTupleSeparator());
        return PlanitGmlUtils.createGmlLineStringType(coordsType);
    }

    protected UnTypedPlanitCrsWriterImpl(IdMapperType idMapperType) {
        super(idMapperType);
    }
}

