/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.network;

import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.NetworkIdMapper;
import org.goplanit.converter.network.NetworkWriter;
import org.goplanit.io.converter.network.PlanitNetworkWriterSettings;
import org.goplanit.io.converter.network.UnTypedPlanitCrsWriterImpl;
import org.goplanit.io.xml.util.xmlEnumConversionUtil;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.layer.macroscopic.MacroscopicNetworkLayerImpl;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PhysicalModeFeatures;
import org.goplanit.utils.mode.UsabilityModeFeatures;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentTypes;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinks;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.xml.generated.Direction;
import org.goplanit.xml.generated.LengthUnit;
import org.goplanit.xml.generated.XMLElementAccessGroup;
import org.goplanit.xml.generated.XMLElementConfiguration;
import org.goplanit.xml.generated.XMLElementInfrastructureLayer;
import org.goplanit.xml.generated.XMLElementInfrastructureLayers;
import org.goplanit.xml.generated.XMLElementLayerConfiguration;
import org.goplanit.xml.generated.XMLElementLinkLengthType;
import org.goplanit.xml.generated.XMLElementLinkSegment;
import org.goplanit.xml.generated.XMLElementLinkSegmentType;
import org.goplanit.xml.generated.XMLElementLinkSegmentTypes;
import org.goplanit.xml.generated.XMLElementLinks;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementModes;
import org.goplanit.xml.generated.XMLElementNodes;
import org.goplanit.xml.generated.XMLElementPhysicalFeatures;
import org.goplanit.xml.generated.XMLElementUsabilityFeatures;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitNetworkWriter
extends UnTypedPlanitCrsWriterImpl<LayeredNetwork<?, ?>>
implements NetworkWriter {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkWriter.class.getCanonicalName());
    private final XMLElementMacroscopicNetwork xmlRawNetwork;
    private final PlanitNetworkWriterSettings settings;
    private String currLayerLogPrefix;

    private void populateLinkSegment(XMLElementLinkSegment xmlLinkSegment, MacroscopicLinkSegment linkSegment) {
        xmlLinkSegment.setId((String)this.getPrimaryIdMapper().getLinkSegmentIdMapper().apply(linkSegment));
        xmlLinkSegment.setMaxspeed(Double.valueOf(linkSegment.getPhysicalSpeedLimitKmH()));
        xmlLinkSegment.setNumberoflanes(BigInteger.valueOf(linkSegment.getNumberOfLanes()));
        if (!linkSegment.hasLinkSegmentType()) {
            LOGGER.severe(String.format("missing link segment type on link segment %s (id:%d)", linkSegment.getExternalId(), linkSegment.getId()));
        } else {
            xmlLinkSegment.setTyperef((String)this.getPrimaryIdMapper().getLinkSegmentTypeIdMapper().apply(linkSegment.getLinkSegmentType()));
        }
    }

    private void populateLinkSegments(XMLElementLinks.Link xmlLink, MacroscopicLink link) {
        XMLElementLinkSegment xmlLinkSegment;
        List xmlLinkSegments = xmlLink.getLinksegment();
        if (link.hasLinkSegmentAb()) {
            link.getLinkSegmentAb().validate();
            xmlLinkSegment = new XMLElementLinkSegment();
            xmlLinkSegment.setDir(Direction.A_B);
            this.populateLinkSegment(xmlLinkSegment, link.getLinkSegmentAb());
            xmlLinkSegments.add(xmlLinkSegment);
        }
        if (link.hasLinkSegmentBa()) {
            link.getLinkSegmentBa().validate();
            xmlLinkSegment = new XMLElementLinkSegment();
            xmlLinkSegment.setDir(Direction.B_A);
            this.populateLinkSegment(xmlLinkSegment, link.getLinkSegmentBa());
            xmlLinkSegments.add(xmlLinkSegment);
        }
        if (xmlLinkSegments == null && (link.hasLinkSegmentAb() || link.hasLinkSegmentBa())) {
            LOGGER.severe(String.format("link %s (id:%d) has no xm Link segment element, but does have link segments", link.getExternalId(), link.getId()));
        }
    }

    private void populateXmlLink(List<XMLElementLinks.Link> xmlLinkList, MacroscopicLink link) {
        double geographicLength;
        XMLElementLinks.Link xmlLink = new XMLElementLinks.Link();
        xmlLink.setId((String)this.getPrimaryIdMapper().getLinkIdMapper().apply(link));
        if (link.hasExternalId()) {
            xmlLink.setExternalid(link.getExternalId());
        }
        boolean useOverrideLength = true;
        if (this.getGeoUtils() != null && link.hasGeometry() && Precision.equal((double)(geographicLength = this.getGeoUtils().getDistanceInKilometres(link.getGeometry())), (double)link.getLengthKm(), (double)1.0E-6)) {
            useOverrideLength = false;
        }
        if (useOverrideLength) {
            XMLElementLinkLengthType xmlLinkLength = new XMLElementLinkLengthType();
            xmlLinkLength.setUnit(LengthUnit.KM);
            xmlLinkLength.setValue(link.getLengthKm());
            xmlLink.setLength(xmlLinkLength);
        }
        if (link.hasName()) {
            xmlLink.setName(link.getName());
        }
        xmlLink.setNodearef((String)this.getPrimaryIdMapper().getVertexIdMapper().apply(link.getNodeA()));
        xmlLink.setNodebref((String)this.getPrimaryIdMapper().getVertexIdMapper().apply(link.getNodeB()));
        if (link.hasGeometry()) {
            xmlLink.setLineString(this.createGmlLineStringType(link.getGeometry()));
        }
        this.populateLinkSegments(xmlLink, link);
        xmlLinkList.add(xmlLink);
    }

    private void populateXmlLinks(XMLElementInfrastructureLayer xmlNetworkLayer, MacroscopicLinks links) {
        XMLElementLinks xmlLinks = xmlNetworkLayer.getLinks();
        if (xmlLinks == null) {
            xmlLinks = new XMLElementLinks();
            xmlNetworkLayer.setLinks(xmlLinks);
        }
        List xmlLinkList = xmlLinks.getLink();
        links.streamSortedBy(this.getPrimaryIdMapper().getLinkIdMapper()).forEach(link -> {
            link.validate();
            this.populateXmlLink(xmlLinkList, (MacroscopicLink)link);
        });
    }

    private void populateXmlNode(List<XMLElementNodes.Node> xmlNodeList, Node node) {
        XMLElementNodes.Node xmlNode = new XMLElementNodes.Node();
        xmlNodeList.add(xmlNode);
        xmlNode.setId((String)this.getPrimaryIdMapper().getVertexIdMapper().apply(node));
        if (node.hasExternalId()) {
            xmlNode.setExternalid(node.getExternalId());
        }
        xmlNode.setName(node.getName());
        xmlNode.setPoint(this.createGmlPointType(node.getPosition()));
    }

    private void populateXmlNodes(XMLElementInfrastructureLayer xmlNetworkLayer, Nodes nodes) {
        XMLElementNodes xmlNodes = xmlNetworkLayer.getNodes();
        if (xmlNodes == null) {
            xmlNodes = new XMLElementNodes();
            xmlNetworkLayer.setNodes(xmlNodes);
        }
        List xmlNodeList = xmlNodes.getNode();
        nodes.streamSortedBy(this.getPrimaryIdMapper().getVertexIdMapper()).forEach(node -> this.populateXmlNode(xmlNodeList, (Node)node));
    }

    private void populateLinkSegmentTypeAccessGroupProperties(XMLElementLinkSegmentType.Access xmlAccess, AccessGroupProperties accessGroupProperties) {
        List accessGroupList = xmlAccess.getAccessgroup();
        XMLElementAccessGroup xmlAccessGroup = new XMLElementAccessGroup();
        Set accessModes = accessGroupProperties.getAccessModes();
        String modeRefs = accessModes.stream().map(mode -> this.getXmlModeReference((Mode)mode, this.getPrimaryIdMapper().getModeIdMapper())).sorted().collect(Collectors.joining(","));
        xmlAccessGroup.setModerefs(modeRefs);
        if (accessGroupProperties.isCriticalSpeedKmHSet()) {
            xmlAccessGroup.setCritspeed(accessGroupProperties.getCriticalSpeedKmH());
        }
        if (accessGroupProperties.isMaximumSpeedKmHSet()) {
            xmlAccessGroup.setMaxspeed(accessGroupProperties.getMaximumSpeedKmH());
        }
        accessGroupList.add(xmlAccessGroup);
    }

    private void populateXmlLinkSegmentType(List<XMLElementLinkSegmentType> xmlLinkSegmentTypeList, MacroscopicLinkSegmentType linkSegmentType) {
        XMLElementLinkSegmentType xmlLinkSegmentType = new XMLElementLinkSegmentType();
        xmlLinkSegmentType.setId((String)this.getPrimaryIdMapper().getLinkSegmentTypeIdMapper().apply(linkSegmentType));
        if (linkSegmentType.hasExternalId()) {
            xmlLinkSegmentType.setExternalid(linkSegmentType.getExternalId());
        }
        if (linkSegmentType.isExplicitCapacityPerLaneSet()) {
            xmlLinkSegmentType.setCapacitylane(linkSegmentType.getExplicitCapacityPerLane());
        }
        if (linkSegmentType.isExplicitMaximumDensityPerLaneSet()) {
            xmlLinkSegmentType.setMaxdensitylane(linkSegmentType.getExplicitMaximumDensityPerLane());
        }
        xmlLinkSegmentType.setName(linkSegmentType.getName());
        XMLElementLinkSegmentType.Access xmlTypeAccess = xmlLinkSegmentType.getAccess();
        if (xmlTypeAccess == null) {
            xmlTypeAccess = new XMLElementLinkSegmentType.Access();
            xmlLinkSegmentType.setAccess(xmlTypeAccess);
        }
        TreeSet processedModes = new TreeSet();
        XMLElementLinkSegmentType.Access finalXmlTypeAccess = xmlTypeAccess;
        linkSegmentType.getAllowedModes().stream().sorted(Comparator.comparing(ExternalIdAble::getXmlId)).forEach(accessMode -> {
            if (!processedModes.contains(accessMode)) {
                AccessGroupProperties accessProperties = linkSegmentType.getAccessProperties(accessMode);
                processedModes.addAll(accessProperties.getAccessModes());
                this.populateLinkSegmentTypeAccessGroupProperties(finalXmlTypeAccess, accessProperties);
            }
        });
        xmlLinkSegmentTypeList.add(xmlLinkSegmentType);
    }

    private void populateXmlLinkSegmentTypes(XMLElementLayerConfiguration xmlLayerConfiguration, MacroscopicLinkSegmentTypes linkSegmentTypes) {
        XMLElementLinkSegmentTypes xmlLinkSegmentTypes = xmlLayerConfiguration.getLinksegmenttypes();
        if (xmlLinkSegmentTypes == null) {
            xmlLinkSegmentTypes = new XMLElementLinkSegmentTypes();
            xmlLayerConfiguration.setLinksegmenttypes(xmlLinkSegmentTypes);
        }
        List xmlLinkSegmentTypeList = xmlLinkSegmentTypes.getLinksegmenttype();
        linkSegmentTypes.streamSortedBy(this.getPrimaryIdMapper().getLinkSegmentTypeIdMapper()).forEach(linkSegmentType -> this.populateXmlLinkSegmentType(xmlLinkSegmentTypeList, (MacroscopicLinkSegmentType)linkSegmentType));
    }

    private void populateModePhysicalFeatures(XMLElementModes.Mode xmlMode, PhysicalModeFeatures physicalModeFeatures) {
        XMLElementPhysicalFeatures xmlPhysicalFeatures = xmlMode.getPhysicalfeatures();
        if (xmlPhysicalFeatures == null) {
            xmlPhysicalFeatures = new XMLElementPhysicalFeatures();
            xmlMode.setPhysicalfeatures(xmlPhysicalFeatures);
        }
        try {
            xmlPhysicalFeatures.setMotorisationtype(xmlEnumConversionUtil.planitToXml(physicalModeFeatures.getMotorisationType()));
            xmlPhysicalFeatures.setTracktype(xmlEnumConversionUtil.planitToXml(physicalModeFeatures.getTrackType()));
            xmlPhysicalFeatures.setVehicletype(xmlEnumConversionUtil.planitToXml(physicalModeFeatures.getVehicularType()));
        }
        catch (PlanItRunTimeException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to set physical features on mode properties");
        }
    }

    private void populateModeUsabilityFeatures(XMLElementModes.Mode xmlMode, UsabilityModeFeatures usabilityModeFeatures) {
        XMLElementUsabilityFeatures xmlUseFeatures = xmlMode.getUsabilityfeatures();
        if (xmlUseFeatures == null) {
            xmlUseFeatures = new XMLElementUsabilityFeatures();
            xmlMode.setUsabilityfeatures(xmlUseFeatures);
        }
        try {
            xmlUseFeatures.setUsedtotype(xmlEnumConversionUtil.planitToXml(usabilityModeFeatures.getUseOfType()));
        }
        catch (PlanItRunTimeException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to set physical features on mode properties");
        }
    }

    private void populateXmlMode(List<XMLElementModes.Mode> xmlModesList, Mode mode) {
        XMLElementModes.Mode xmlMode = new XMLElementModes.Mode();
        xmlMode.setId(this.getXmlModeReference(mode, this.getPrimaryIdMapper().getModeIdMapper()));
        if (mode.hasExternalId()) {
            xmlMode.setExternalid(mode.getExternalId());
        }
        xmlMode.setMaxspeed(Double.valueOf(mode.getMaximumSpeedKmH()));
        if (mode.hasName()) {
            xmlMode.setName(mode.getName());
        }
        xmlMode.setPcu(Double.valueOf(mode.getPcu()));
        xmlMode.setPredefined(Boolean.valueOf(mode.isPredefinedModeType()));
        if (mode.hasPhysicalFeatures()) {
            this.populateModePhysicalFeatures(xmlMode, mode.getPhysicalFeatures());
        }
        if (mode.hasUseFeatures()) {
            this.populateModeUsabilityFeatures(xmlMode, mode.getUseFeatures());
        }
        xmlModesList.add(xmlMode);
    }

    private void populateXmlModes(Modes modes) {
        XMLElementModes xmlModes = this.xmlRawNetwork.getConfiguration().getModes();
        if (xmlModes == null) {
            xmlModes = new XMLElementModes();
            this.xmlRawNetwork.getConfiguration().setModes(xmlModes);
        }
        List xmlModesList = xmlModes.getMode();
        modes.stream().sorted(Comparator.comparing(this.getPrimaryIdMapper().getModeIdMapper())).forEach(mode -> this.populateXmlMode(xmlModesList, (Mode)mode));
    }

    private void populateXmlId(MacroscopicNetwork network) {
        if (!network.hasXmlId()) {
            LOGGER.warning(String.format("Network has no XML id defined, adopting internally generated id %d instead", network.getId()));
            network.setXmlId(String.valueOf(network.getId()));
        }
        this.xmlRawNetwork.setId(network.getXmlId());
    }

    protected void populateXmlConfiguration(Modes modes) {
        XMLElementConfiguration xmlConfiguration = this.xmlRawNetwork.getConfiguration();
        if (xmlConfiguration == null) {
            xmlConfiguration = new XMLElementConfiguration();
            this.xmlRawNetwork.setConfiguration(xmlConfiguration);
        }
        this.populateXmlModes(modes);
    }

    protected void populateXmlLayerConfiguration(XMLElementInfrastructureLayer xmlNetworkLayer, MacroscopicLinkSegmentTypes linkSegmentTypes) {
        XMLElementLayerConfiguration xmlLayerConfiguration = xmlNetworkLayer.getLayerconfiguration();
        if (xmlLayerConfiguration == null) {
            xmlLayerConfiguration = new XMLElementLayerConfiguration();
            xmlNetworkLayer.setLayerconfiguration(xmlLayerConfiguration);
        }
        this.populateXmlLinkSegmentTypes(xmlLayerConfiguration, linkSegmentTypes);
    }

    protected void populateXmlNetworkLayer(XMLElementInfrastructureLayers xmlInfrastructureLayers, MacroscopicNetworkLayerImpl physicalNetworkLayer, MacroscopicNetwork network) {
        XMLElementInfrastructureLayer xmlNetworkLayer = new XMLElementInfrastructureLayer();
        xmlInfrastructureLayers.getLayer().add(xmlNetworkLayer);
        xmlNetworkLayer.setId(physicalNetworkLayer.getXmlId());
        if (physicalNetworkLayer.hasExternalId()) {
            xmlNetworkLayer.setExternalid(physicalNetworkLayer.getExternalId());
        }
        if (!physicalNetworkLayer.hasSupportedModes()) {
            LOGGER.severe(String.format("%s Network layer has no supported modes, skip persistence", this.currLayerLogPrefix));
            return;
        }
        String xmlModesStr = physicalNetworkLayer.getSupportedModes().stream().map(m -> (String)this.getPrimaryIdMapper().getModeIdMapper().apply(m)).sorted().collect(Collectors.joining(","));
        LOGGER.info(String.format("%s Supported modes: %s", this.currLayerLogPrefix, xmlModesStr));
        if (((MacroscopicNetworkLayers)network.getTransportLayers()).size() > 1) {
            xmlNetworkLayer.setModes(xmlModesStr);
        }
        LOGGER.info(String.format("%s Link segment types: %d", this.currLayerLogPrefix, physicalNetworkLayer.linkSegmentTypes.size()));
        this.populateXmlLayerConfiguration(xmlNetworkLayer, physicalNetworkLayer.linkSegmentTypes);
        LOGGER.info(String.format("%s Links: %d", this.currLayerLogPrefix, physicalNetworkLayer.getLinks().size()));
        LOGGER.info(String.format("%s Link segments: %d", this.currLayerLogPrefix, physicalNetworkLayer.getLinkSegments().size()));
        this.populateXmlLinks(xmlNetworkLayer, physicalNetworkLayer.getLinks());
        LOGGER.info(String.format("%s Nodes: %d", this.currLayerLogPrefix, physicalNetworkLayer.getNodes().size()));
        this.populateXmlNodes(xmlNetworkLayer, physicalNetworkLayer.getNodes());
    }

    protected void populateXmlNetworkLayers(MacroscopicNetwork network) {
        XMLElementInfrastructureLayers xmlInfrastructureLayers = this.xmlRawNetwork.getInfrastructurelayers();
        if (xmlInfrastructureLayers == null) {
            this.xmlRawNetwork.setInfrastructurelayers(new XMLElementInfrastructureLayers());
            xmlInfrastructureLayers = this.xmlRawNetwork.getInfrastructurelayers();
        }
        xmlInfrastructureLayers.setSrsname(PlanitNetworkWriter.extractSrsName((CoordinateReferenceSystem)this.getDestinationCoordinateReferenceSystem()));
        LOGGER.info("Network layers:" + ((MacroscopicNetworkLayers)network.getTransportLayers()).size());
        XMLElementInfrastructureLayers finalXmlInfrastructureLayers = xmlInfrastructureLayers;
        ((MacroscopicNetworkLayers)network.getTransportLayers()).streamSortedBy(this.getPrimaryIdMapper().getNetworkLayerIdMapper()).forEach(layer -> {
            if (layer instanceof MacroscopicNetworkLayerImpl) {
                MacroscopicNetworkLayerImpl physicalNetworkLayer = (MacroscopicNetworkLayerImpl)layer;
                if (physicalNetworkLayer.getXmlId() == null) {
                    LOGGER.warning(String.format("Network layer has no XML id defined, adopting internally generated id %d instead", physicalNetworkLayer.getId()));
                    physicalNetworkLayer.setXmlId(String.valueOf(physicalNetworkLayer.getId()));
                }
                this.currLayerLogPrefix = LoggingUtils.surroundwithBrackets((String)("layer: " + (String)this.getPrimaryIdMapper().getNetworkLayerIdMapper().apply(physicalNetworkLayer)));
                this.populateXmlNetworkLayer(finalXmlInfrastructureLayers, physicalNetworkLayer, network);
            } else {
                LOGGER.severe(String.format("Unsupported macroscopic infrastructure layer %s encountered", this.getPrimaryIdMapper().getNetworkLayerIdMapper().apply(layer)));
            }
        });
    }

    protected PlanitNetworkWriter(XMLElementMacroscopicNetwork xmlRawNetwork) {
        this(null, "global", xmlRawNetwork);
    }

    protected PlanitNetworkWriter(String networkPath, XMLElementMacroscopicNetwork xmlRawNetwork) {
        this(networkPath, "global", xmlRawNetwork);
    }

    protected PlanitNetworkWriter(String networkPath, String countryName, XMLElementMacroscopicNetwork xmlRawNetwork) {
        super(IdMapperType.XML);
        this.settings = new PlanitNetworkWriterSettings(networkPath, "network.xml", countryName);
        this.xmlRawNetwork = xmlRawNetwork;
    }

    public NetworkIdMapper getPrimaryIdMapper() {
        return this.getComponentIdMappers().getNetworkIdMappers();
    }

    public void write(LayeredNetwork<?, ?> network) {
        if (!(network instanceof MacroscopicNetwork)) {
            throw new PlanItRunTimeException("Currently the PLANit network writer only supports macroscopic infrastructure networks, the provided network is not of this type");
        }
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        this.getComponentIdMappers().populateMissingIdMappers(this.getIdMapperType());
        this.prepareCoordinateReferenceSystem(macroscopicNetwork.getCoordinateReferenceSystem(), this.getSettings().getDestinationCoordinateReferenceSystem(), this.getSettings().getCountry());
        LOGGER.info(String.format("Persisting PLANit network to: %s", Paths.get(this.getSettings().getOutputDirectory(), this.getSettings().getFileName()).toString()));
        this.getSettings().logSettings();
        this.populateXmlId(macroscopicNetwork);
        this.populateXmlConfiguration(network.getModes());
        this.populateXmlNetworkLayers(macroscopicNetwork);
        super.persist(this.xmlRawNetwork, XMLElementMacroscopicNetwork.class, "macroscopicnetworkinput.xsd");
    }

    public void reset() {
        this.currLayerLogPrefix = null;
        this.xmlRawNetwork.setConfiguration(null);
        this.xmlRawNetwork.setInfrastructurelayers(null);
    }

    public PlanitNetworkWriterSettings getSettings() {
        return this.settings;
    }
}

