/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.network;

import java.util.logging.Logger;
import org.goplanit.io.converter.network.PlanitNetworkReader;
import org.goplanit.io.converter.network.PlanitNetworkReaderSettings;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;

public class PlanitNetworkReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkReaderFactory.class.getCanonicalName());

    public static PlanitNetworkReader create() {
        return PlanitNetworkReaderFactory.create(IdGroupingToken.collectGlobalToken());
    }

    public static PlanitNetworkReader create(IdGroupingToken idToken) {
        return PlanitNetworkReaderFactory.create(new PlanitNetworkReaderSettings(), new MacroscopicNetwork(idToken));
    }

    public static PlanitNetworkReader create(String inputDirectory) {
        PlanitNetworkReader networkReader = PlanitNetworkReaderFactory.create();
        networkReader.getSettings().setInputDirectory(inputDirectory);
        return networkReader;
    }

    public static PlanitNetworkReader create(PlanitNetworkReaderSettings settings) {
        return PlanitNetworkReaderFactory.create(settings, new MacroscopicNetwork(IdGroupingToken.collectGlobalToken()));
    }

    public static PlanitNetworkReader create(PlanitNetworkReaderSettings settings, LayeredNetwork<?, ?> network) {
        try {
            return new PlanitNetworkReader(settings, network);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public static PlanitNetworkReader create(String inputDirectory, String xmlFileExtension, LayeredNetwork<?, ?> network) {
        try {
            return new PlanitNetworkReader(inputDirectory, xmlFileExtension, network);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public static PlanitNetworkReader create(XMLElementMacroscopicNetwork xmlRawNetwork, LayeredNetwork<?, ?> network) {
        try {
            return new PlanitNetworkReader(xmlRawNetwork, network);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }

    public static PlanitNetworkReader create(XMLElementMacroscopicNetwork xmlRawNetwork, PlanitNetworkReaderSettings settings, LayeredNetwork<?, ?> network) {
        try {
            return new PlanitNetworkReader(xmlRawNetwork, settings, network);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            return null;
        }
    }
}

