/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.opengis.gml.PointType;
import org.goplanit.converter.network.NetworkReaderImpl;
import org.goplanit.io.converter.network.PlanitNetworkReaderSettings;
import org.goplanit.io.xml.network.physical.macroscopic.XmlMacroscopicNetworkLayerHelper;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.io.xml.util.xmlEnumConversionUtil;
import org.goplanit.mode.ModeFeaturesFactory;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.MacroscopicNetworkModifierUtils;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesFactory;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.MotorisationModeType;
import org.goplanit.utils.mode.PhysicalModeFeatures;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.mode.UsabilityModeFeatures;
import org.goplanit.utils.mode.UseOfModeType;
import org.goplanit.utils.mode.VehicularModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.xml.generated.Direction;
import org.goplanit.xml.generated.XMLElementAccessGroup;
import org.goplanit.xml.generated.XMLElementConfiguration;
import org.goplanit.xml.generated.XMLElementInfrastructureLayer;
import org.goplanit.xml.generated.XMLElementInfrastructureLayers;
import org.goplanit.xml.generated.XMLElementLayerConfiguration;
import org.goplanit.xml.generated.XMLElementLinkSegment;
import org.goplanit.xml.generated.XMLElementLinkSegmentType;
import org.goplanit.xml.generated.XMLElementLinks;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementModes;
import org.goplanit.xml.generated.XMLElementNodes;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitNetworkReader
extends NetworkReaderImpl {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkReader.class.getCanonicalName());
    private final PlanitNetworkReaderSettings settings;
    private final PlanitXmlJaxbParser<XMLElementMacroscopicNetwork> xmlParser;
    private MacroscopicNetwork network;
    public static final String NETWORK_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicnetworkinput.xsd";

    private void initialiseXmlIdTrackers() {
        this.initialiseSourceIdMap(Mode.class, ExternalIdAble::getXmlId);
        this.initialiseSourceIdMap(Link.class, ExternalIdAble::getXmlId);
        this.initialiseSourceIdMap(MacroscopicLinkSegment.class, ExternalIdAble::getXmlId);
        this.initialiseSourceIdMap(MacroscopicLinkSegmentType.class, ExternalIdAble::getXmlId);
        this.initialiseSourceIdMap(Node.class, ExternalIdAble::getXmlId);
    }

    private void syncXmlIdsToIds() {
        LOGGER.info("Syncing PLANit physical network XML ids to internally generated ids, overwriting original XML ids");
        MacroscopicNetworkModifierUtils.syncManagedIdEntitiesContainerXmlIdsToIds((MacroscopicNetwork)this.network);
    }

    private void injectMissingDefaultsToRawXmlNetwork() {
        XMLElementMacroscopicNetwork rootElement = this.xmlParser.getXmlRootElement();
        if (this.xmlParser.getXmlRootElement().getConfiguration() == null) {
            rootElement.setConfiguration(new XMLElementConfiguration());
        }
        if (rootElement.getConfiguration().getModes() == null) {
            rootElement.getConfiguration().setModes(new XMLElementModes());
            XMLElementModes.Mode xmlElementMode = new XMLElementModes.Mode();
            xmlElementMode.setPredefined(Boolean.valueOf(true));
            xmlElementMode.setName(PredefinedModeType.CAR.value());
            xmlElementMode.setId("1");
            rootElement.getConfiguration().getModes().getMode().add(xmlElementMode);
        }
    }

    private UsabilityModeFeatures parseUsabilityModeFeatures(XMLElementModes.Mode generatedMode) {
        if (generatedMode.getUsabilityfeatures() == null) {
            return ModeFeaturesFactory.createDefaultUsabilityFeatures();
        }
        UseOfModeType useOfModeType = xmlEnumConversionUtil.xmlToPlanit(generatedMode.getUsabilityfeatures().getUsedtotype());
        return ModeFeaturesFactory.createUsabilityFeatures((UseOfModeType)useOfModeType);
    }

    private PhysicalModeFeatures parsePhysicalModeFeatures(XMLElementModes.Mode generatedMode) {
        if (generatedMode.getPhysicalfeatures() == null) {
            return ModeFeaturesFactory.createDefaultPhysicalFeatures();
        }
        VehicularModeType vehicleType = xmlEnumConversionUtil.xmlToPlanit(generatedMode.getPhysicalfeatures().getVehicletype());
        MotorisationModeType motorisationType = xmlEnumConversionUtil.xmlToPlanit(generatedMode.getPhysicalfeatures().getMotorisationtype());
        TrackModeType trackType = xmlEnumConversionUtil.xmlToPlanit(generatedMode.getPhysicalfeatures().getTracktype());
        return ModeFeaturesFactory.createPhysicalFeatures((VehicularModeType)vehicleType, (MotorisationModeType)motorisationType, (TrackModeType)trackType);
    }

    private void parseModes() {
        XMLElementConfiguration xmlGeneralConfiguration = this.xmlParser.getXmlRootElement().getConfiguration();
        for (XMLElementModes.Mode xmlMode : xmlGeneralConfiguration.getModes().getMode()) {
            String name;
            String potentialPredefinedModeType;
            String modeXmlId = null;
            if (xmlMode.getId() != null && !xmlMode.getId().isBlank()) {
                modeXmlId = xmlMode.getId();
            }
            if ((potentialPredefinedModeType = (name = xmlMode.getName())) == null) {
                potentialPredefinedModeType = modeXmlId;
            }
            PredefinedModeType modeType = PredefinedModeType.create((String)potentialPredefinedModeType);
            if (!xmlMode.isPredefined() && modeType != PredefinedModeType.CUSTOM) {
                LOGGER.warning(String.format("Mode is not registered as predefined mode but name or xmlid corresponds to PLANit predefined mode, reverting to PLANit predefined mode %s", modeType.name()));
            }
            if (xmlMode.isPredefined() && modeType == PredefinedModeType.CUSTOM) {
                LOGGER.warning(String.format("Mode is known as predefined mode but XML flag indicates it should be a PLANit predefined mode, reverting to PLANit custom mode %s", modeType.name()));
            }
            if (name == null && modeType == PredefinedModeType.CUSTOM) {
                name = PredefinedModeType.CUSTOM.value().concat(String.valueOf(this.network.getModes().size()));
            }
            PredefinedMode mode = null;
            if (modeType != PredefinedModeType.CUSTOM) {
                mode = this.network.getModes().getFactory().registerNew(modeType);
            } else {
                double maxSpeed = xmlMode.getMaxspeed() == null ? 80.0 : xmlMode.getMaxspeed();
                double pcu = xmlMode.getPcu() == null ? 1.0 : xmlMode.getPcu();
                PhysicalModeFeatures physicalFeatures = this.parsePhysicalModeFeatures(xmlMode);
                UsabilityModeFeatures usabilityFeatures = this.parseUsabilityModeFeatures(xmlMode);
                mode = this.network.getModes().getFactory().registerNewCustomMode(name, maxSpeed, pcu, physicalFeatures, usabilityFeatures);
            }
            if (xmlMode.getExternalid() != null && !xmlMode.getExternalid().isBlank()) {
                mode.setExternalId(xmlMode.getExternalid());
            }
            mode.setXmlId(modeXmlId);
            this.registerBySourceId(Mode.class, mode);
        }
    }

    private CoordinateReferenceSystem parseCoordinateRerefenceSystem(XMLElementInfrastructureLayers xmlLayers) throws PlanItException {
        CoordinateReferenceSystem crs = null;
        crs = PlanitXmlJaxbParser.createPlanitCrs(xmlLayers.getSrsname());
        return crs;
    }

    private void parseNetworkLayers() throws PlanItException {
        XMLElementInfrastructureLayers xmlLayers = this.xmlParser.getXmlRootElement().getInfrastructurelayers();
        PlanItException.throwIfNull((Object)xmlLayers, (String)"infrastructurelayers element not present in network file");
        CoordinateReferenceSystem crs = this.parseCoordinateRerefenceSystem(xmlLayers);
        this.network.setCoordinateReferenceSystem(crs);
        PlanitJtsCrsUtils jtsUtils = new PlanitJtsCrsUtils(this.network.getCoordinateReferenceSystem());
        List xmlLayerList = xmlLayers.getLayer();
        TreeSet usedModes = new TreeSet();
        for (XMLElementInfrastructureLayer xmlLayer : xmlLayerList) {
            NetworkLayer layer = this.parseNetworkLayer(xmlLayer, jtsUtils);
            int prevSize = usedModes.size();
            usedModes.addAll(layer.getSupportedModes());
            if (usedModes.size() == prevSize + layer.getSupportedModes().size()) continue;
            throw new PlanItException("modes are only allowed to be used in a single network layer, not multiple, please check your network inputs");
        }
    }

    private NetworkLayer parseNetworkLayer(XMLElementInfrastructureLayer xmlLayer, PlanitJtsCrsUtils jtsUtils) throws PlanItException {
        MacroscopicNetworkLayer networkLayer = ((MacroscopicNetworkLayers)this.network.getTransportLayers()).getFactory().registerNew();
        if (xmlLayer.getId() != null && !xmlLayer.getId().isBlank()) {
            networkLayer.setXmlId(xmlLayer.getId());
        } else {
            LOGGER.warning("infrastructure layer id missing in xml, use generated id instead");
            networkLayer.setXmlId(Long.toString(networkLayer.getId()));
        }
        if (xmlLayer.getExternalid() != null && !xmlLayer.getExternalid().isBlank()) {
            networkLayer.setExternalId(xmlLayer.getExternalid());
        }
        if (xmlLayer.getModes() != null && !xmlLayer.getModes().isBlank()) {
            String xmlSupportedModes = xmlLayer.getModes();
            String[] modeRefs = xmlSupportedModes.split(CharacterUtils.COMMA.toString());
            for (String mode : Arrays.asList(modeRefs)) {
                Mode planitMode = (Mode)this.getBySourceId(Mode.class, mode);
                if (planitMode != null) {
                    networkLayer.registerSupportedMode(planitMode);
                    continue;
                }
                LOGGER.severe(String.format("mode %s is not present on the network, ignored on network layer", mode));
            }
        } else {
            networkLayer.registerSupportedModes((Collection)this.network.getModes().valuesAsNewSet());
        }
        XMLElementLayerConfiguration xmlLayerconfiguration = xmlLayer.getLayerconfiguration();
        if (xmlLayerconfiguration == null) {
            xmlLayer.setLayerconfiguration(new XMLElementLayerConfiguration());
            xmlLayerconfiguration = xmlLayer.getLayerconfiguration();
        }
        this.parseLinkSegmentTypes(xmlLayerconfiguration, networkLayer);
        this.parseNodes(xmlLayer, networkLayer);
        this.parseLinkAndLinkSegments(xmlLayer, networkLayer, jtsUtils);
        return networkLayer;
    }

    public void parseLinkSegmentTypes(XMLElementLayerConfiguration xmlLayerconfiguration, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        if (xmlLayerconfiguration.getLinksegmenttypes() == null) {
            XmlMacroscopicNetworkLayerHelper.injectDefaultLinkSegmentType(xmlLayerconfiguration);
        }
        double defaultMaxSpeedKph = Double.MAX_VALUE;
        for (Mode mode2 : networkLayer.getSupportedModes()) {
            defaultMaxSpeedKph = Math.max(defaultMaxSpeedKph, mode2.getMaximumSpeedKmH());
        }
        List xmlLinkSegmentTypes = xmlLayerconfiguration.getLinksegmenttypes().getLinksegmenttype();
        for (XMLElementLinkSegmentType xmlLinkSegmentType : xmlLinkSegmentTypes) {
            String xmlId = xmlLinkSegmentType.getId();
            String externalId = null;
            if (xmlLinkSegmentType.getExternalid() != null && !xmlLinkSegmentType.getExternalid().isBlank()) {
                externalId = xmlLinkSegmentType.getExternalid();
            }
            String name = xmlLinkSegmentType.getName();
            Double capacityPcuPerHour = xmlLinkSegmentType.getCapacitylane();
            Double maximumDensityPcuPerKm = xmlLinkSegmentType.getMaxdensitylane();
            MacroscopicLinkSegmentType linkSegmentType = null;
            linkSegmentType = xmlLinkSegmentType.getCapacitylane() != null && xmlLinkSegmentType.getMaxdensitylane() != null ? networkLayer.getLinkSegmentTypes().getFactory().registerNew(name, capacityPcuPerHour.doubleValue(), maximumDensityPcuPerKm.doubleValue()) : (xmlLinkSegmentType.getCapacitylane() != null ? networkLayer.getLinkSegmentTypes().getFactory().registerNewWithCapacity(name, capacityPcuPerHour.doubleValue()) : (xmlLinkSegmentType.getMaxdensitylane() != null ? networkLayer.getLinkSegmentTypes().getFactory().registerNewWithMaxDensity(name, maximumDensityPcuPerKm.doubleValue()) : networkLayer.getLinkSegmentTypes().getFactory().registerNew(name)));
            linkSegmentType.setXmlId(xmlId);
            linkSegmentType.setExternalId(externalId);
            this.registerBySourceId(MacroscopicLinkSegmentType.class, linkSegmentType);
            Collection supportedDefaultRoadModes = networkLayer.getSupportedModes().stream().filter(mode -> mode.getPhysicalFeatures().getTrackType() == TrackModeType.ROAD).collect(Collectors.toSet());
            if (xmlLinkSegmentType.getAccess() != null) {
                List xmlAccessGroups = xmlLinkSegmentType.getAccess().getAccessgroup();
                for (XMLElementAccessGroup xmlAccessGroup : xmlAccessGroups) {
                    this.parseLinkSegmentTypeAccessProperties(xmlAccessGroup, linkSegmentType, supportedDefaultRoadModes);
                }
                continue;
            }
            this.parseLinkSegmentTypeAccessProperties(null, linkSegmentType, supportedDefaultRoadModes);
        }
    }

    public void parseLinkSegmentTypeAccessProperties(XMLElementAccessGroup xmlAccessGroupProperties, MacroscopicLinkSegmentType linkSegmentType, Collection<Mode> defaultModes) throws PlanItException {
        Collection<Mode> accessModes = null;
        if (xmlAccessGroupProperties == null || xmlAccessGroupProperties.getModerefs() == null) {
            accessModes = defaultModes;
        } else {
            String[] xmlModesRefArray = xmlAccessGroupProperties.getModerefs().split(",");
            accessModes = new TreeSet<Mode>();
            for (int index = 0; index < xmlModesRefArray.length; ++index) {
                Mode thePlanitMode = (Mode)this.getBySourceId(Mode.class, xmlModesRefArray[index]);
                PlanItException.throwIfNull((Object)thePlanitMode, (String)String.format("Referenced mode (xml id:%s) does not exist in PLANit parser", xmlModesRefArray[index]));
                accessModes.add(thePlanitMode);
            }
        }
        Set alreadyAllowedModes = linkSegmentType.getAllowedModes();
        if (!Collections.disjoint(alreadyAllowedModes, accessModes)) {
            LOGGER.warning(String.format("Access (mode) groups for link segment type %s have overlapping modes, undefined behaviour of which properties prevail for duplicate modes", linkSegmentType.getXmlId()));
        }
        AccessGroupProperties groupProperties = null;
        if (xmlAccessGroupProperties != null) {
            if (xmlAccessGroupProperties.getMaxspeed() != null && xmlAccessGroupProperties.getCritspeed() != null) {
                groupProperties = AccessGroupPropertiesFactory.create((double)xmlAccessGroupProperties.getMaxspeed(), (double)xmlAccessGroupProperties.getCritspeed(), accessModes);
            } else if (xmlAccessGroupProperties.getMaxspeed() != null) {
                groupProperties = AccessGroupPropertiesFactory.create((double)xmlAccessGroupProperties.getMaxspeed(), accessModes);
            } else if (xmlAccessGroupProperties.getCritspeed() != null) {
                LOGGER.warning(String.format("IGNORE: Not allowed to only set a critical speed for an access group (link segment type %s)", linkSegmentType.getXmlId()));
            }
        }
        if (groupProperties == null) {
            groupProperties = AccessGroupPropertiesFactory.create(accessModes);
        }
        linkSegmentType.setAccessGroupProperties(groupProperties);
    }

    public void parseNodes(XMLElementInfrastructureLayer xmlLayer, MacroscopicNetworkLayer networkLayer) throws PlanItException {
        for (XMLElementNodes.Node xmlNode : xmlLayer.getNodes().getNode()) {
            PointType pointType;
            Node node = networkLayer.getNodes().getFactory().registerNew();
            if (xmlNode.getId() != null && !xmlNode.getId().isBlank()) {
                node.setXmlId(xmlNode.getId());
            }
            if (xmlNode.getExternalid() != null && !xmlNode.getExternalid().isBlank()) {
                node.setExternalId(xmlNode.getExternalid());
            }
            if ((pointType = xmlNode.getPoint()) != null) {
                List posValues = pointType.getPos().getValue();
                Point centrePointGeometry = PlanitJtsUtils.createPoint((Number)((Number)posValues.get(0)), (Number)((Number)posValues.get(1)));
                node.setPosition(centrePointGeometry);
            }
            this.registerBySourceId(Node.class, node);
        }
    }

    public void parseLinkAndLinkSegments(XMLElementInfrastructureLayer xmlLayer, MacroscopicNetworkLayer networkLayer, PlanitJtsCrsUtils jtsUtils) throws PlanItException {
        XMLElementLinks xmlLinks = xmlLayer.getLinks();
        PlanItException.throwIfNull((Object)xmlLinks, (String)"links xml element missing");
        for (XMLElementLinks.Link xmlLink : xmlLinks.getLink()) {
            MacroscopicLink link = null;
            if (StringUtils.isNullOrBlank((String)xmlLink.getId())) {
                LOGGER.severe("IGNORE: Link has no (XML) id, unable to include link");
                continue;
            }
            String xmlId = xmlLink.getId();
            if (StringUtils.isNullOrBlank((String)xmlLink.getNodearef())) {
                LOGGER.warning(String.format("IGNORE: No node A reference present on link %s", xmlId));
                continue;
            }
            Node startNode = (Node)this.getBySourceId(Node.class, xmlLink.getNodearef());
            if (StringUtils.isNullOrBlank((String)xmlLink.getNodebref())) {
                LOGGER.warning(String.format("IGNORE: No node B reference present on link %s", xmlId));
                continue;
            }
            Node endNode = (Node)this.getBySourceId(Node.class, xmlLink.getNodebref());
            LineString theLineString = XmlMacroscopicNetworkLayerHelper.parseLinkGeometry(xmlLink);
            double length = XmlMacroscopicNetworkLayerHelper.parseLength(xmlLink, theLineString, jtsUtils);
            link = networkLayer.getLinks().getFactory().registerNew(startNode, endNode, length, true);
            link.setXmlId(xmlLink.getId());
            link.setGeometry(theLineString);
            if (xmlLink.getExternalid() != null && !xmlLink.getExternalid().isBlank()) {
                link.setExternalId(xmlLink.getExternalid());
            }
            if (!StringUtils.isNullOrBlank((String)xmlLink.getName())) {
                link.setName(xmlLink.getName());
            }
            link.validate();
            this.registerBySourceId(Link.class, link);
            boolean isFirstLinkSegment = true;
            boolean firstLinkDirection = true;
            for (XMLElementLinkSegment xmlLinkSegment : xmlLink.getLinksegment()) {
                boolean abDirection = xmlLinkSegment.getDir().equals((Object)Direction.A_B);
                if (!isFirstLinkSegment && abDirection == firstLinkDirection) {
                    throw new PlanItException("Both link segments for the same link are in the same direction.  Link segment external Id is " + xmlLinkSegment.getId());
                }
                MacroscopicLinkSegment linkSegment = networkLayer.getLinkSegments().getFactory().registerNew(link, abDirection, true);
                if (xmlLinkSegment.getId() == null || xmlLinkSegment.getId().isBlank()) {
                    LOGGER.severe("DISCARD: Link segment has no (XML) id, unable to include link segment");
                    continue;
                }
                linkSegment.setXmlId(xmlLinkSegment.getId());
                if (xmlLinkSegment.getExternalid() != null && !xmlLinkSegment.getExternalid().isBlank()) {
                    linkSegment.setExternalId(xmlLinkSegment.getExternalid());
                }
                double maxSpeed = xmlLinkSegment.getMaxspeed() == null ? Double.POSITIVE_INFINITY : xmlLinkSegment.getMaxspeed();
                linkSegment.setPhysicalSpeedLimitKmH(maxSpeed);
                int noLanes = xmlLinkSegment.getNumberoflanes() == null ? 1 : xmlLinkSegment.getNumberoflanes().intValue();
                linkSegment.setNumberOfLanes(noLanes);
                this.registerBySourceId(MacroscopicLinkSegment.class, linkSegment);
                String linkSegmentTypeXmlId = null;
                if (xmlLinkSegment.getTyperef() == null) {
                    if (networkLayer.getLinkSegmentTypes().size() > 1) {
                        throw new PlanItException("Link Segment " + xmlLinkSegment.getId() + " has no link segment type defined, but there is more than one possible link segment type");
                    }
                    linkSegmentTypeXmlId = ((MacroscopicLinkSegmentType)networkLayer.getLinkSegmentTypes().getFirst()).getXmlId();
                } else {
                    linkSegmentTypeXmlId = xmlLinkSegment.getTyperef();
                }
                MacroscopicLinkSegmentType linkSegmentType = (MacroscopicLinkSegmentType)this.getBySourceId(MacroscopicLinkSegmentType.class, linkSegmentTypeXmlId);
                if (linkSegmentType == null) {
                    throw new PlanItException(String.format("Link segment type %s, unknown, cannot be registered on link segment %s", linkSegmentTypeXmlId, linkSegment));
                }
                linkSegment.setLinkSegmentType(linkSegmentType);
                isFirstLinkSegment = false;
                firstLinkDirection = abDirection;
            }
        }
    }

    protected void setNetwork(LayeredNetwork<?, ?> network) throws PlanItException {
        if (!(network instanceof MacroscopicNetwork)) {
            throw new PlanItException("currently the PLANit network reader only supports macroscopic infrastructure networks, the provided network is not of this type");
        }
        this.network = (MacroscopicNetwork)network;
    }

    protected PlanitNetworkReader(PlanitNetworkReaderSettings settings, IdGroupingToken idToken) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicNetwork>>(XMLElementMacroscopicNetwork.class);
        this.settings = settings;
        this.setNetwork((LayeredNetwork<?, ?>)new MacroscopicNetwork(idToken));
    }

    protected PlanitNetworkReader(PlanitNetworkReaderSettings settings, LayeredNetwork<?, ?> network) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicNetwork>>(XMLElementMacroscopicNetwork.class);
        this.settings = settings;
        this.setNetwork(network);
    }

    protected PlanitNetworkReader(XMLElementMacroscopicNetwork externalXmlRawNetwork, LayeredNetwork<?, ?> network) throws PlanItException {
        this(externalXmlRawNetwork, new PlanitNetworkReaderSettings(), network);
    }

    protected PlanitNetworkReader(XMLElementMacroscopicNetwork externalXmlRawNetwork, PlanitNetworkReaderSettings settings, LayeredNetwork<?, ?> network) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementMacroscopicNetwork>(externalXmlRawNetwork);
        this.settings = settings;
        this.setNetwork(network);
    }

    protected PlanitNetworkReader(String networkPathDirectory, String xmlFileExtension, LayeredNetwork<?, ?> network) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicNetwork>>(XMLElementMacroscopicNetwork.class);
        this.settings = new PlanitNetworkReaderSettings(networkPathDirectory, xmlFileExtension);
        this.setNetwork(network);
    }

    public MacroscopicNetwork read() {
        this.xmlParser.initialiseAndParseXmlRootElement(this.getSettings().getInputDirectory(), this.getSettings().getXmlFileExtension());
        PlanItRunTimeException.throwIfNull((Object)this.xmlParser.getXmlRootElement(), (String)"No valid PLANit XML network could be parsed into memory, abort");
        String networkXmlId = this.xmlParser.getXmlRootElement().getId();
        if (StringUtils.isNullOrBlank((String)networkXmlId)) {
            LOGGER.warning(String.format("Network has no XML id defined, adopting internally generated id %d instead", this.network.getId()));
            networkXmlId = String.valueOf(this.network.getId());
        }
        this.network.setXmlId(networkXmlId);
        this.initialiseXmlIdTrackers();
        this.injectMissingDefaultsToRawXmlNetwork();
        try {
            this.parseModes();
            this.parseNetworkLayers();
            if (this.getSettings().isSyncXmlIdsToIds()) {
                this.syncXmlIdsToIds();
            }
            this.network.logInfo(LoggingUtils.networkPrefix((long)this.network.getId()));
            this.xmlParser.clearXmlContent();
        }
        catch (PlanItException e) {
            throw new PlanItRunTimeException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
            throw new PlanItRunTimeException("Error while populating physical network in PLANitIO", (Throwable)e);
        }
        return this.network;
    }

    public PlanitNetworkReaderSettings getSettings() {
        return this.settings;
    }

    public MacroscopicLinkSegment getLinkSegmentByExternalId(MacroscopicNetwork network, String externalId) {
        for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)network.getTransportLayers()) {
            MacroscopicLinkSegment firstMatch = (MacroscopicLinkSegment)layer.getLinkSegments().firstMatch(ls -> externalId.equals(ls.getExternalId()));
            if (firstMatch == null) continue;
            return firstMatch;
        }
        return null;
    }

    public void reset() {
    }
}

