/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.ConverterWriterSettings;
import org.goplanit.io.converter.network.PlanitNetworkWriterSettings;
import org.goplanit.io.converter.service.PlanitRoutedServicesWriterSettings;
import org.goplanit.io.converter.service.PlanitServiceNetworkWriterSettings;
import org.goplanit.io.converter.zoning.PlanitZoningWriterSettings;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitIntermodalWriterSettings
implements ConverterWriterSettings {
    protected final PlanitNetworkWriterSettings networkSettings;
    protected final PlanitZoningWriterSettings zoningSettings;
    protected final PlanitServiceNetworkWriterSettings serviceNetworkSettings;
    protected final PlanitRoutedServicesWriterSettings routedServicesSettings;

    public PlanitIntermodalWriterSettings() {
        this(new PlanitNetworkWriterSettings(), new PlanitZoningWriterSettings(), new PlanitServiceNetworkWriterSettings(), new PlanitRoutedServicesWriterSettings());
    }

    public PlanitIntermodalWriterSettings(String outputDirectory, String countryName) {
        this(new PlanitNetworkWriterSettings(outputDirectory, countryName), new PlanitZoningWriterSettings(outputDirectory, countryName), new PlanitServiceNetworkWriterSettings(outputDirectory, countryName), new PlanitRoutedServicesWriterSettings(outputDirectory, countryName));
    }

    public PlanitIntermodalWriterSettings(PlanitNetworkWriterSettings networkSettings, PlanitZoningWriterSettings zoningSettings, PlanitServiceNetworkWriterSettings serviceNetworkSettings, PlanitRoutedServicesWriterSettings routedServicesSettings) {
        this.networkSettings = networkSettings;
        this.zoningSettings = zoningSettings;
        this.serviceNetworkSettings = serviceNetworkSettings;
        this.routedServicesSettings = routedServicesSettings;
    }

    public void reset() {
        this.getNetworkSettings().reset();
        this.getZoningSettings().reset();
        this.getServiceNetworkSettings().reset();
        this.getRoutedServicesSettings().reset();
    }

    public PlanitZoningWriterSettings getZoningSettings() {
        return this.zoningSettings;
    }

    public PlanitNetworkWriterSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public PlanitServiceNetworkWriterSettings getServiceNetworkSettings() {
        return this.serviceNetworkSettings;
    }

    public PlanitRoutedServicesWriterSettings getRoutedServicesSettings() {
        return this.routedServicesSettings;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.getZoningSettings().setOutputDirectory(outputDirectory);
        this.getNetworkSettings().setOutputDirectory(outputDirectory);
        this.getServiceNetworkSettings().setOutputDirectory(outputDirectory);
        this.getRoutedServicesSettings().setOutputDirectory(outputDirectory);
    }

    public void setCountry(String countryName) {
        this.getZoningSettings().setCountry(countryName);
        this.getNetworkSettings().setCountry(countryName);
        this.getServiceNetworkSettings().setCountry(countryName);
        this.getRoutedServicesSettings().setCountry(countryName);
    }

    public void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCoordinateReferenceSystem) {
        this.getZoningSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
        this.getNetworkSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
        this.getServiceNetworkSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
        this.getRoutedServicesSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
    }
}

