/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.idmapping.IdMapperType;
import org.goplanit.converter.idmapping.NetworkIdMapper;
import org.goplanit.converter.idmapping.PlanitComponentIdMapper;
import org.goplanit.converter.idmapping.ZoningIdMapper;
import org.goplanit.converter.intermodal.IntermodalWriter;
import org.goplanit.io.converter.intermodal.PlanitIntermodalWriterSettings;
import org.goplanit.io.converter.network.PlanitNetworkWriter;
import org.goplanit.io.converter.network.PlanitNetworkWriterFactory;
import org.goplanit.io.converter.network.PlanitNetworkWriterSettings;
import org.goplanit.io.converter.service.PlanitRoutedServicesWriter;
import org.goplanit.io.converter.service.PlanitRoutedServicesWriterFactory;
import org.goplanit.io.converter.service.PlanitRoutedServicesWriterSettings;
import org.goplanit.io.converter.service.PlanitServiceNetworkWriter;
import org.goplanit.io.converter.service.PlanitServiceNetworkWriterFactory;
import org.goplanit.io.converter.service.PlanitServiceNetworkWriterSettings;
import org.goplanit.io.converter.zoning.PlanitZoningWriter;
import org.goplanit.io.converter.zoning.PlanitZoningWriterFactory;
import org.goplanit.io.converter.zoning.PlanitZoningWriterSettings;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementRoutedServices;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.zoning.Zoning;

public class PlanitIntermodalWriter
implements IntermodalWriter<ServiceNetwork, RoutedServices> {
    protected final PlanitIntermodalWriterSettings settings;
    protected final XMLElementMacroscopicNetwork xmlRawNetwork;
    protected final XMLElementMacroscopicZoning xmlRawZoning;
    protected final XMLElementServiceNetwork xmlRawServiceNetwork;
    protected final XMLElementRoutedServices xmlRawRoutedServices;
    protected IdMapperType idMapper = IdMapperType.XML;

    protected Pair<PlanitNetworkWriter, PlanitZoningWriter> writeNetworkAndZoning(MacroscopicNetwork macroscopicNetwork, Zoning zoning) {
        PlanitNetworkWriterSettings networkSettings = this.getSettings().getNetworkSettings();
        PlanitNetworkWriter networkWriter = PlanitNetworkWriterFactory.create(networkSettings.getOutputDirectory(), networkSettings.getCountry(), this.xmlRawNetwork);
        networkWriter.setIdMapperType(this.getIdMapperType());
        networkWriter.write((LayeredNetwork<?, ?>)macroscopicNetwork);
        PlanitZoningWriterSettings zoningSettings = this.getSettings().getZoningSettings();
        PlanitZoningWriter zoningWriter = PlanitZoningWriterFactory.create(zoningSettings.getOutputDirectory(), zoningSettings.getCountry());
        zoningWriter.setParentIdMappers(new PlanitComponentIdMapper[]{networkWriter.getPrimaryIdMapper()});
        zoningWriter.setIdMapperType(this.getIdMapperType());
        zoningWriter.write(zoning);
        return Pair.of((Object)((Object)networkWriter), (Object)((Object)zoningWriter));
    }

    protected PlanitIntermodalWriter(String outputDirectory, String countryName, XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning, XMLElementServiceNetwork xmlRawServiceNetwork, XMLElementRoutedServices xmlRawRoutedServices) {
        this.settings = new PlanitIntermodalWriterSettings(outputDirectory, countryName);
        this.xmlRawNetwork = xmlRawNetwork;
        this.xmlRawZoning = xmlRawZoning;
        this.xmlRawServiceNetwork = xmlRawServiceNetwork;
        this.xmlRawRoutedServices = xmlRawRoutedServices;
    }

    protected PlanitIntermodalWriter(PlanitIntermodalWriterSettings settings) {
        this.settings = settings;
        this.xmlRawNetwork = new XMLElementMacroscopicNetwork();
        this.xmlRawZoning = new XMLElementMacroscopicZoning();
        this.xmlRawServiceNetwork = new XMLElementServiceNetwork();
        this.xmlRawRoutedServices = new XMLElementRoutedServices();
    }

    public void write(MacroscopicNetwork macroscopicNetwork, Zoning zoning) throws PlanItException {
        this.writeNetworkAndZoning(macroscopicNetwork, zoning);
    }

    public void writeWithServices(MacroscopicNetwork macroscopicNetwork, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices) throws PlanItException {
        Pair<PlanitNetworkWriter, PlanitZoningWriter> networkAndZoningWriter = this.writeNetworkAndZoning(macroscopicNetwork, zoning);
        PlanitServiceNetworkWriterSettings serviceNetworkSettings = this.getSettings().getServiceNetworkSettings();
        PlanitServiceNetworkWriter serviceNetworkWriter = PlanitServiceNetworkWriterFactory.create(serviceNetworkSettings.getOutputDirectory(), serviceNetworkSettings.getCountry(), this.xmlRawServiceNetwork);
        NetworkIdMapper networkIdMapper = ((PlanitNetworkWriter)((Object)networkAndZoningWriter.first())).getPrimaryIdMapper();
        ZoningIdMapper zoningIdMapper = ((PlanitZoningWriter)((Object)networkAndZoningWriter.second())).getPrimaryIdMapper();
        serviceNetworkWriter.setParentIdMappers(new PlanitComponentIdMapper[]{networkIdMapper, zoningIdMapper});
        serviceNetworkWriter.setIdMapperType(this.getIdMapperType());
        serviceNetworkWriter.write(serviceNetwork);
        PlanitRoutedServicesWriterSettings routedServicesSettings = this.getSettings().getRoutedServicesSettings();
        PlanitRoutedServicesWriter routedServicesWriter = PlanitRoutedServicesWriterFactory.create(routedServicesSettings.getOutputDirectory(), routedServicesSettings.getCountry(), this.xmlRawRoutedServices);
        routedServicesWriter.setParentIdMappers(new PlanitComponentIdMapper[]{networkIdMapper, zoningIdMapper, serviceNetworkWriter.getPrimaryIdMapper()});
        routedServicesWriter.setIdMapperType(this.getIdMapperType());
        routedServicesWriter.write(routedServices);
    }

    public IdMapperType getIdMapperType() {
        return this.idMapper;
    }

    public void setIdMapperType(IdMapperType idMapper) {
        this.idMapper = idMapper;
    }

    public void reset() {
    }

    public PlanitIntermodalWriterSettings getSettings() {
        return this.settings;
    }
}

