/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.ConverterReaderSettings;
import org.goplanit.io.converter.network.PlanitNetworkReaderSettings;
import org.goplanit.io.converter.service.PlanitRoutedServicesReaderSettings;
import org.goplanit.io.converter.service.PlanitServiceNetworkReaderSettings;
import org.goplanit.io.converter.zoning.PlanitZoningReaderSettings;

public class PlanitIntermodalReaderSettings
implements ConverterReaderSettings {
    protected final PlanitNetworkReaderSettings networkSettings;
    protected final PlanitZoningReaderSettings zoningSettings;
    protected final PlanitServiceNetworkReaderSettings serviceNetworkSettings;
    protected final PlanitRoutedServicesReaderSettings routedServicesSettings;

    public PlanitIntermodalReaderSettings() {
        this(new PlanitNetworkReaderSettings(), new PlanitZoningReaderSettings());
    }

    public PlanitIntermodalReaderSettings(String inputPathDirectory) {
        this(new PlanitNetworkReaderSettings(inputPathDirectory), new PlanitZoningReaderSettings(inputPathDirectory));
    }

    public PlanitIntermodalReaderSettings(String inputPathDirectory, String xmlFileExtension) {
        this(new PlanitNetworkReaderSettings(inputPathDirectory, xmlFileExtension), new PlanitZoningReaderSettings(inputPathDirectory, xmlFileExtension));
    }

    public PlanitIntermodalReaderSettings(PlanitNetworkReaderSettings networkSettings, PlanitZoningReaderSettings zoningSettings) {
        this(networkSettings, zoningSettings, new PlanitServiceNetworkReaderSettings(networkSettings.getInputDirectory(), networkSettings.getXmlFileExtension()), new PlanitRoutedServicesReaderSettings(networkSettings.getInputDirectory(), networkSettings.getXmlFileExtension()));
    }

    public PlanitIntermodalReaderSettings(PlanitNetworkReaderSettings networkSettings, PlanitZoningReaderSettings zoningSettings, PlanitServiceNetworkReaderSettings serviceNetworkSettings, PlanitRoutedServicesReaderSettings routedServicesSettings) {
        this.networkSettings = networkSettings;
        this.zoningSettings = zoningSettings;
        this.serviceNetworkSettings = serviceNetworkSettings;
        this.routedServicesSettings = routedServicesSettings;
    }

    public void reset() {
        this.getNetworkSettings().reset();
        this.getZoningSettings().reset();
        this.getServiceNetworkSettings().reset();
        this.getRoutedServicesSettings().reset();
    }

    public void logSettings() {
        this.getNetworkSettings().logSettings();
        this.getZoningSettings().logSettings();
        this.getServiceNetworkSettings().logSettings();
        this.getRoutedServicesSettings().logSettings();
    }

    public PlanitNetworkReaderSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public PlanitZoningReaderSettings getZoningSettings() {
        return this.zoningSettings;
    }

    public PlanitRoutedServicesReaderSettings getRoutedServicesSettings() {
        return this.routedServicesSettings;
    }

    public PlanitServiceNetworkReaderSettings getServiceNetworkSettings() {
        return this.serviceNetworkSettings;
    }

    public void setInputDirectory(String inputDirectory) {
        this.getNetworkSettings().setInputDirectory(inputDirectory);
        this.getZoningSettings().setInputDirectory(inputDirectory);
        this.getServiceNetworkSettings().setInputDirectory(inputDirectory);
        this.getRoutedServicesSettings().setInputDirectory(inputDirectory);
    }
}

