/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.io.converter.intermodal.PlanitIntermodalReader;
import org.goplanit.io.converter.intermodal.PlanitIntermodalReaderSettings;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementRoutedServices;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.zoning.Zoning;

public class PlanitIntermodalReaderFactory {
    public static PlanitIntermodalReader create() {
        return PlanitIntermodalReaderFactory.create(IdGroupingToken.collectGlobalToken());
    }

    public static PlanitIntermodalReader create(String pathDirectory) {
        PlanitIntermodalReader reader = PlanitIntermodalReaderFactory.create();
        reader.getSettings().setInputDirectory(pathDirectory);
        return reader;
    }

    public static PlanitIntermodalReader create(IdGroupingToken idGroupingToken) {
        return PlanitIntermodalReaderFactory.create(idGroupingToken, new PlanitIntermodalReaderSettings());
    }

    public static PlanitIntermodalReader create(PlanitIntermodalReaderSettings intermodalSettings) {
        return PlanitIntermodalReaderFactory.create(IdGroupingToken.collectGlobalToken(), intermodalSettings);
    }

    public static PlanitIntermodalReader create(IdGroupingToken idGroupingToken, PlanitIntermodalReaderSettings intermodalSettings) {
        MacroscopicNetwork network = new MacroscopicNetwork(idGroupingToken);
        ServiceNetwork serviceNetwork = new ServiceNetwork(idGroupingToken, network);
        Zoning zoning = new Zoning(idGroupingToken, network.getNetworkGroupingTokenId());
        RoutedServices routedServices = new RoutedServices(idGroupingToken, serviceNetwork);
        return new PlanitIntermodalReader(intermodalSettings, network, zoning, serviceNetwork, routedServices);
    }

    public static PlanitIntermodalReader create(String pathDirectory, String xmlFileExtension, MacroscopicNetwork network, Zoning zoning) {
        return PlanitIntermodalReaderFactory.create(pathDirectory, xmlFileExtension, network, zoning, null, null);
    }

    public static PlanitIntermodalReader create(String pathDirectory, String xmlFileExtension, MacroscopicNetwork network, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices) {
        return new PlanitIntermodalReader(pathDirectory, xmlFileExtension, network, zoning, serviceNetwork, routedServices);
    }

    public static PlanitIntermodalReader create(XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning, XMLElementServiceNetwork xmlRawServiceNetwork, XMLElementRoutedServices xmlRawRoutedServices, MacroscopicNetwork network, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices) {
        return new PlanitIntermodalReader(new PlanitIntermodalReaderSettings(), xmlRawNetwork, xmlRawZoning, xmlRawServiceNetwork, xmlRawRoutedServices, network, zoning, serviceNetwork, routedServices);
    }
}

