/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.intermodal;

import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.io.converter.intermodal.PlanitIntermodalReaderSettings;
import org.goplanit.io.converter.network.PlanitNetworkReader;
import org.goplanit.io.converter.network.PlanitNetworkReaderFactory;
import org.goplanit.io.converter.service.PlanitRoutedServicesReader;
import org.goplanit.io.converter.service.PlanitRoutedServicesReaderFactory;
import org.goplanit.io.converter.service.PlanitServiceNetworkReader;
import org.goplanit.io.converter.service.PlanitServiceNetworkReaderFactory;
import org.goplanit.io.converter.zoning.PlanitZoningReader;
import org.goplanit.io.converter.zoning.PlanitZoningReaderFactory;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.misc.Quadruple;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementRoutedServices;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.zoning.Zoning;

public class PlanitIntermodalReader
implements IntermodalReader<ServiceNetwork, RoutedServices> {
    protected final PlanitIntermodalReaderSettings intermodalReaderSettings;
    protected final MacroscopicNetwork networkToPopulate;
    protected final Zoning zoningToPopulate;
    protected final ServiceNetwork serviceNetworkToPopulate;
    protected final RoutedServices routedServicesToPopulate;
    protected final XMLElementMacroscopicNetwork xmlRawNetwork;
    protected final XMLElementMacroscopicZoning xmlRawZoning;
    protected final XMLElementServiceNetwork xmlRawServiceNetwork;
    protected final XMLElementRoutedServices xmlRawRoutedServices;

    private void validate(boolean withRoutedServices) {
        PlanItRunTimeException.throwIf((this.networkToPopulate == null ? 1 : 0) != 0, (String)"physical network to populate is null", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf((this.zoningToPopulate == null ? 1 : 0) != 0, (String)"zoning to populate is null", (Object[])new Object[0]);
        if (withRoutedServices) {
            PlanItRunTimeException.throwIf((this.serviceNetworkToPopulate == null ? 1 : 0) != 0, (String)"service network to populate is null", (Object[])new Object[0]);
            PlanItRunTimeException.throwIf((!this.networkToPopulate.equals((Object)this.serviceNetworkToPopulate.getParentNetwork()) ? 1 : 0) != 0, (String)"network to populate differs from service network parent network", (Object[])new Object[0]);
            PlanItRunTimeException.throwIf((this.routedServicesToPopulate == null ? 1 : 0) != 0, (String)"routed services to populate is null", (Object[])new Object[0]);
            PlanItRunTimeException.throwIf((!this.serviceNetworkToPopulate.equals((Object)this.routedServicesToPopulate.getParentNetwork()) ? 1 : 0) != 0, (String)"service network to populate differs from routed services parent service network", (Object[])new Object[0]);
        }
    }

    protected PlanitIntermodalReader(String inputPathDirectory, String xmlFileExtension, IdGroupingToken idToken) {
        this(new PlanitIntermodalReaderSettings(inputPathDirectory, xmlFileExtension), idToken);
    }

    protected PlanitIntermodalReader(PlanitIntermodalReaderSettings settings, IdGroupingToken idToken) {
        this.intermodalReaderSettings = settings;
        this.networkToPopulate = new MacroscopicNetwork(idToken);
        this.xmlRawNetwork = null;
        this.zoningToPopulate = new Zoning(idToken, this.networkToPopulate.getNetworkGroupingTokenId());
        this.xmlRawZoning = null;
        this.serviceNetworkToPopulate = null;
        this.xmlRawServiceNetwork = null;
        this.routedServicesToPopulate = null;
        this.xmlRawRoutedServices = null;
    }

    protected PlanitIntermodalReader(String inputPathDirectory, String xmlFileExtension, MacroscopicNetwork network, Zoning zoning) {
        this(inputPathDirectory, xmlFileExtension, network, zoning, null, null);
    }

    protected PlanitIntermodalReader(String inputPathDirectory, String xmlFileExtension, MacroscopicNetwork network, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices) {
        this(new PlanitIntermodalReaderSettings(inputPathDirectory, xmlFileExtension), null, null, null, null, network, zoning, serviceNetwork, routedServices);
    }

    public PlanitIntermodalReader(XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning, MacroscopicNetwork network, Zoning zoning) {
        this(new PlanitIntermodalReaderSettings(), xmlRawNetwork, xmlRawZoning, null, null, network, zoning, null, null);
    }

    public PlanitIntermodalReader(PlanitIntermodalReaderSettings settings, MacroscopicNetwork network, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices) {
        this(settings, null, null, null, null, network, zoning, serviceNetwork, routedServices);
    }

    public PlanitIntermodalReader(PlanitIntermodalReaderSettings settings, XMLElementMacroscopicNetwork xmlRawNetwork, XMLElementMacroscopicZoning xmlRawZoning, XMLElementServiceNetwork xmlRawServiceNetwork, XMLElementRoutedServices xmlRawRoutedServices, MacroscopicNetwork network, Zoning zoning, ServiceNetwork serviceNetwork, RoutedServices routedServices) {
        this.intermodalReaderSettings = settings;
        this.networkToPopulate = network;
        this.xmlRawNetwork = xmlRawNetwork;
        this.zoningToPopulate = zoning;
        this.xmlRawZoning = xmlRawZoning;
        this.serviceNetworkToPopulate = serviceNetwork;
        this.xmlRawServiceNetwork = xmlRawServiceNetwork;
        this.routedServicesToPopulate = routedServices;
        this.xmlRawRoutedServices = xmlRawRoutedServices;
    }

    public Pair<MacroscopicNetwork, Zoning> read() {
        this.validate(false);
        PlanitNetworkReader networkReader = this.xmlRawNetwork == null ? PlanitNetworkReaderFactory.create(this.getSettings().getNetworkSettings(), this.networkToPopulate) : PlanitNetworkReaderFactory.create(this.xmlRawNetwork, this.getSettings().getNetworkSettings(), this.networkToPopulate);
        MacroscopicNetwork referenceNetwork = networkReader.read();
        PlanitZoningReader zoningReader = this.xmlRawZoning == null ? PlanitZoningReaderFactory.create(this.getSettings().getZoningSettings(), referenceNetwork, this.zoningToPopulate) : PlanitZoningReaderFactory.create(this.xmlRawZoning, this.getSettings().getZoningSettings(), referenceNetwork, this.zoningToPopulate);
        Zoning zoning = zoningReader.read();
        return Pair.of((Object)referenceNetwork, (Object)zoning);
    }

    public Quadruple<MacroscopicNetwork, Zoning, ServiceNetwork, RoutedServices> readWithServices() {
        this.validate(true);
        Pair<MacroscopicNetwork, Zoning> networkZoning = this.read();
        PlanitServiceNetworkReader serviceNetworkReader = this.xmlRawServiceNetwork == null ? PlanitServiceNetworkReaderFactory.create(this.getSettings().getServiceNetworkSettings(), this.serviceNetworkToPopulate) : PlanitServiceNetworkReaderFactory.create(this.xmlRawServiceNetwork, this.getSettings().getServiceNetworkSettings(), this.serviceNetworkToPopulate);
        ServiceNetwork serviceNetwork = serviceNetworkReader.read();
        PlanitRoutedServicesReader routedServicesReader = this.xmlRawRoutedServices == null ? PlanitRoutedServicesReaderFactory.create(this.getSettings().getRoutedServicesSettings(), this.routedServicesToPopulate) : PlanitRoutedServicesReaderFactory.create(this.xmlRawRoutedServices, this.getSettings().getRoutedServicesSettings(), this.routedServicesToPopulate);
        RoutedServices routedServices = routedServicesReader.read();
        return Quadruple.of((Object)((MacroscopicNetwork)networkZoning.first()), (Object)((Zoning)networkZoning.second()), (Object)serviceNetwork, (Object)routedServices);
    }

    public void reset() {
    }

    public PlanitIntermodalReaderSettings getSettings() {
        return this.intermodalReaderSettings;
    }

    public boolean supportServiceConversion() {
        return false;
    }
}

